/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.keymap;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.KeyboardGestureAction;
import com.intellij.openapi.actionSystem.KeyboardModifierGestureShortcut;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.MouseShortcut;
import com.intellij.openapi.actionSystem.PressureShortcut;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.keymap.KeyMapBundle;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.MacKeymapUtil;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.openapi.util.registry.RegistryValueListener;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.awt.AWTEvent;
import java.awt.AWTKeyStroke;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class KeymapUtil {
    @NonNls
    private static final String CANCEL_KEY_TEXT = "Cancel";
    @NonNls
    private static final String BREAK_KEY_TEXT = "Break";
    @NonNls
    private static final String SHIFT = "shift";
    @NonNls
    private static final String CONTROL = "control";
    @NonNls
    private static final String CTRL = "ctrl";
    @NonNls
    private static final String META = "meta";
    @NonNls
    private static final String ALT = "alt";
    @NonNls
    private static final String ALT_GRAPH = "altGraph";
    @NonNls
    private static final String DOUBLE_CLICK = "doubleClick";
    private static final Set<Integer> ourTooltipKeys = new HashSet<Integer>();
    private static final Set<Integer> ourOtherTooltipKeys = new HashSet<Integer>();
    private static RegistryValue ourTooltipKeysProperty;

    private KeymapUtil() {
    }

    @NotNull
    public static String getShortcutText(@NotNull String actionId) {
        KeyboardShortcut shortcut;
        if (actionId == null) {
            KeymapUtil.$$$reportNull$$$0(0);
        }
        if ((shortcut = ActionManager.getInstance().getKeyboardShortcut(actionId)) == null) {
            if ("<no shortcut>" == null) {
                KeymapUtil.$$$reportNull$$$0(1);
            }
            return "<no shortcut>";
        }
        String string = KeymapUtil.getShortcutText(shortcut);
        if (string == null) {
            KeymapUtil.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public static String getShortcutText(@NotNull Shortcut shortcut) {
        if (shortcut == null) {
            KeymapUtil.$$$reportNull$$$0(3);
        }
        String s = "";
        if (shortcut instanceof KeyboardShortcut) {
            KeyboardShortcut keyboardShortcut = (KeyboardShortcut)shortcut;
            String acceleratorText = KeymapUtil.getKeystrokeText(keyboardShortcut.getFirstKeyStroke());
            if (!acceleratorText.isEmpty()) {
                s = acceleratorText;
            }
            if (!(acceleratorText = KeymapUtil.getKeystrokeText(keyboardShortcut.getSecondKeyStroke())).isEmpty()) {
                s = s + ", " + acceleratorText;
            }
        } else if (shortcut instanceof MouseShortcut) {
            s = KeymapUtil.getMouseShortcutText((MouseShortcut)shortcut);
        } else if (shortcut instanceof KeyboardModifierGestureShortcut) {
            KeyboardModifierGestureShortcut gestureShortcut = (KeyboardModifierGestureShortcut)shortcut;
            s = gestureShortcut.getType() == KeyboardGestureAction.ModifierType.dblClick ? "Press, release and hold " : "Hold ";
            s = s + KeymapUtil.getKeystrokeText(gestureShortcut.getStroke());
        } else {
            throw new IllegalArgumentException("unknown shortcut class: " + shortcut.getClass().getCanonicalName());
        }
        String string = s;
        if (string == null) {
            KeymapUtil.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Deprecated
    @NotNull
    @ApiStatus.ScheduledForRemoval(inVersion="2020.1")
    public static Icon getShortcutIcon(@NotNull Shortcut shortcut) {
        if (shortcut == null) {
            KeymapUtil.$$$reportNull$$$0(5);
        }
        if (shortcut instanceof KeyboardShortcut) {
            Icon icon = AllIcons.General.KeyboardShortcut;
            if (icon == null) {
                KeymapUtil.$$$reportNull$$$0(6);
            }
            return icon;
        }
        if (shortcut instanceof MouseShortcut) {
            Icon icon = AllIcons.General.MouseShortcut;
            if (icon == null) {
                KeymapUtil.$$$reportNull$$$0(7);
            }
            return icon;
        }
        throw new IllegalArgumentException("unknown shortcut class: " + shortcut);
    }

    @NotNull
    public static String getMouseShortcutText(@NotNull MouseShortcut shortcut) {
        if (shortcut == null) {
            KeymapUtil.$$$reportNull$$$0(8);
        }
        if (shortcut instanceof PressureShortcut) {
            String string = shortcut.toString();
            if (string == null) {
                KeymapUtil.$$$reportNull$$$0(9);
            }
            return string;
        }
        String string = KeymapUtil.getMouseShortcutText(shortcut.getButton(), shortcut.getModifiers(), shortcut.getClickCount());
        if (string == null) {
            KeymapUtil.$$$reportNull$$$0(10);
        }
        return string;
    }

    @NotNull
    private static String getMouseShortcutText(int button, @JdkConstants.InputEventMask int modifiers, int clickCount) {
        String resource;
        if (button == 143) {
            resource = "mouse.wheel.rotate.up.shortcut.text";
        } else if (button == 142) {
            resource = "mouse.wheel.rotate.down.shortcut.text";
        } else if (clickCount < 2) {
            resource = "mouse.click.shortcut.text";
        } else if (clickCount < 3) {
            resource = "mouse.double.click.shortcut.text";
        } else {
            throw new IllegalStateException("unknown clickCount: " + clickCount);
        }
        String string = KeyMapBundle.message(resource, KeymapUtil.getModifiersText(KeymapUtil.mapNewModifiers(modifiers)), button);
        if (string == null) {
            KeymapUtil.$$$reportNull$$$0(11);
        }
        return string;
    }

    @JdkConstants.InputEventMask
    private static int mapNewModifiers(@JdkConstants.InputEventMask int modifiers) {
        if ((modifiers & 0x40) != 0) {
            modifiers |= 1;
        }
        if ((modifiers & 0x200) != 0) {
            modifiers |= 8;
        }
        if ((modifiers & 0x2000) != 0) {
            modifiers |= 0x20;
        }
        if ((modifiers & 0x80) != 0) {
            modifiers |= 2;
        }
        if ((modifiers & 0x100) != 0) {
            modifiers |= 4;
        }
        return modifiers;
    }

    @NotNull
    public static String getKeystrokeText(KeyStroke accelerator) {
        if (accelerator == null) {
            if ("" == null) {
                KeymapUtil.$$$reportNull$$$0(12);
            }
            return "";
        }
        if (SystemInfo.isMac) {
            String string = MacKeymapUtil.getKeyStrokeText(accelerator);
            if (string == null) {
                KeymapUtil.$$$reportNull$$$0(13);
            }
            return string;
        }
        String acceleratorText = "";
        int modifiers = accelerator.getModifiers();
        if (modifiers > 0) {
            acceleratorText = KeymapUtil.getModifiersText(modifiers);
        }
        acceleratorText = acceleratorText + KeymapUtil.getKeyText(accelerator.getKeyCode());
        String string = acceleratorText.trim();
        if (string == null) {
            KeymapUtil.$$$reportNull$$$0(14);
        }
        return string;
    }

    @NotNull
    public static String getKeyText(int code) {
        switch (code) {
            case 192: {
                if ("`" == null) {
                    KeymapUtil.$$$reportNull$$$0(15);
                }
                return "`";
            }
            case 108: {
                if ("," == null) {
                    KeymapUtil.$$$reportNull$$$0(16);
                }
                return ",";
            }
            case 110: {
                if ("." == null) {
                    KeymapUtil.$$$reportNull$$$0(17);
                }
                return ".";
            }
            case 47: {
                if ("/" == null) {
                    KeymapUtil.$$$reportNull$$$0(18);
                }
                return "/";
            }
            case 92: {
                if ("\\" == null) {
                    KeymapUtil.$$$reportNull$$$0(19);
                }
                return "\\";
            }
            case 46: {
                if ("." == null) {
                    KeymapUtil.$$$reportNull$$$0(20);
                }
                return ".";
            }
            case 59: {
                if (";" == null) {
                    KeymapUtil.$$$reportNull$$$0(21);
                }
                return ";";
            }
            case 93: {
                if ("]" == null) {
                    KeymapUtil.$$$reportNull$$$0(22);
                }
                return "]";
            }
            case 91: {
                if ("[" == null) {
                    KeymapUtil.$$$reportNull$$$0(23);
                }
                return "[";
            }
            case 61: {
                if ("=" == null) {
                    KeymapUtil.$$$reportNull$$$0(24);
                }
                return "=";
            }
        }
        String result = SystemInfo.isMac ? MacKeymapUtil.getKeyText(code) : KeyEvent.getKeyText(code);
        String string = CANCEL_KEY_TEXT.equals(result) ? BREAK_KEY_TEXT : result;
        if (string == null) {
            KeymapUtil.$$$reportNull$$$0(25);
        }
        return string;
    }

    @NotNull
    private static String getModifiersText(@JdkConstants.InputEventMask int modifiers) {
        if (SystemInfo.isMac) {
            String string = MacKeymapUtil.getModifiersText(modifiers);
            if (string == null) {
                KeymapUtil.$$$reportNull$$$0(26);
            }
            return string;
        }
        String keyModifiersText = KeyEvent.getKeyModifiersText(modifiers);
        String string = keyModifiersText.isEmpty() ? keyModifiersText : keyModifiersText + "+";
        if (string == null) {
            KeymapUtil.$$$reportNull$$$0(27);
        }
        return string;
    }

    @NotNull
    public static ShortcutSet getActiveKeymapShortcuts(@Nullable String actionId) {
        KeymapManager keymapManager;
        Application application = ApplicationManager.getApplication();
        KeymapManager keymapManager2 = keymapManager = application == null ? null : application.getComponent(KeymapManager.class);
        if (keymapManager == null || actionId == null) {
            CustomShortcutSet customShortcutSet = new CustomShortcutSet(Shortcut.EMPTY_ARRAY);
            if (customShortcutSet == null) {
                KeymapUtil.$$$reportNull$$$0(28);
            }
            return customShortcutSet;
        }
        CustomShortcutSet customShortcutSet = new CustomShortcutSet(keymapManager.getActiveKeymap().getShortcuts(actionId));
        if (customShortcutSet == null) {
            KeymapUtil.$$$reportNull$$$0(29);
        }
        return customShortcutSet;
    }

    @NotNull
    public static String getFirstKeyboardShortcutText(@NotNull String actionId) {
        Object[] shortcuts;
        KeyboardShortcut shortcut;
        if (actionId == null) {
            KeymapUtil.$$$reportNull$$$0(30);
        }
        String string = (shortcut = (KeyboardShortcut)ContainerUtil.findInstance((Object[])(shortcuts = KeymapUtil.getActiveKeymapShortcuts(actionId).getShortcuts()), KeyboardShortcut.class)) == null ? "" : KeymapUtil.getShortcutText(shortcut);
        if (string == null) {
            KeymapUtil.$$$reportNull$$$0(31);
        }
        return string;
    }

    public static boolean isEventForAction(@NotNull KeyEvent keyEvent, @NotNull String actionId) {
        if (keyEvent == null) {
            KeymapUtil.$$$reportNull$$$0(32);
        }
        if (actionId == null) {
            KeymapUtil.$$$reportNull$$$0(33);
        }
        for (KeyboardShortcut shortcut : ContainerUtil.findAll((Object[])KeymapUtil.getActiveKeymapShortcuts(actionId).getShortcuts(), KeyboardShortcut.class)) {
            if (AWTKeyStroke.getAWTKeyStrokeForEvent(keyEvent) != shortcut.getFirstKeyStroke()) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static String getFirstKeyboardShortcutText(@NotNull AnAction action) {
        if (action == null) {
            KeymapUtil.$$$reportNull$$$0(34);
        }
        String string = KeymapUtil.getFirstKeyboardShortcutText(action.getShortcutSet());
        if (string == null) {
            KeymapUtil.$$$reportNull$$$0(35);
        }
        return string;
    }

    @NotNull
    public static String getFirstKeyboardShortcutText(@NotNull ShortcutSet set) {
        Object[] shortcuts;
        KeyboardShortcut shortcut;
        if (set == null) {
            KeymapUtil.$$$reportNull$$$0(36);
        }
        String string = (shortcut = (KeyboardShortcut)ContainerUtil.findInstance((Object[])(shortcuts = set.getShortcuts()), KeyboardShortcut.class)) == null ? "" : KeymapUtil.getShortcutText(shortcut);
        if (string == null) {
            KeymapUtil.$$$reportNull$$$0(37);
        }
        return string;
    }

    @NotNull
    public static String getPreferredShortcutText(@NotNull Shortcut[] shortcuts) {
        KeyboardShortcut shortcut;
        if (shortcuts == null) {
            KeymapUtil.$$$reportNull$$$0(38);
        }
        String string = (shortcut = (KeyboardShortcut)ContainerUtil.findInstance((Object[])shortcuts, KeyboardShortcut.class)) != null ? KeymapUtil.getShortcutText(shortcut) : (shortcuts.length > 0 ? KeymapUtil.getShortcutText(shortcuts[0]) : "");
        if (string == null) {
            KeymapUtil.$$$reportNull$$$0(39);
        }
        return string;
    }

    @NotNull
    public static String getShortcutsText(@NotNull Shortcut[] shortcuts) {
        if (shortcuts == null) {
            KeymapUtil.$$$reportNull$$$0(40);
        }
        if (shortcuts.length == 0) {
            if ("" == null) {
                KeymapUtil.$$$reportNull$$$0(41);
            }
            return "";
        }
        String string = Arrays.stream(shortcuts).map(KeymapUtil::getShortcutText).collect(Collectors.joining(" "));
        if (string == null) {
            KeymapUtil.$$$reportNull$$$0(42);
        }
        return string;
    }

    @NotNull
    public static MouseShortcut parseMouseShortcut(@NotNull String keystrokeString) throws InvalidDataException {
        if (keystrokeString == null) {
            KeymapUtil.$$$reportNull$$$0(43);
        }
        if (Registry.is((String)"ide.mac.forceTouch") && keystrokeString.startsWith("Force touch")) {
            PressureShortcut pressureShortcut = new PressureShortcut(2.0);
            if (pressureShortcut == null) {
                KeymapUtil.$$$reportNull$$$0(44);
            }
            return pressureShortcut;
        }
        int button = -1;
        int modifiers = 0;
        int clickCount = 1;
        StringTokenizer tokenizer = new StringTokenizer(keystrokeString);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (SHIFT.equals(token)) {
                modifiers |= 0x40;
                continue;
            }
            if (CONTROL.equals(token) || CTRL.equals(token)) {
                modifiers |= 0x80;
                continue;
            }
            if (META.equals(token)) {
                modifiers |= 0x100;
                continue;
            }
            if (ALT.equals(token)) {
                modifiers |= 0x200;
                continue;
            }
            if (ALT_GRAPH.equals(token)) {
                modifiers |= 0x2000;
                continue;
            }
            if (token.startsWith("button") && token.length() > 6) {
                try {
                    button = Integer.parseInt(token.substring(6));
                    continue;
                }
                catch (NumberFormatException e) {
                    throw new InvalidDataException("unparsable token: " + token);
                }
            }
            if (DOUBLE_CLICK.equals(token)) {
                clickCount = 2;
                continue;
            }
            throw new InvalidDataException("unknown token: " + token);
        }
        MouseShortcut mouseShortcut = new MouseShortcut(button, modifiers, clickCount);
        if (mouseShortcut == null) {
            KeymapUtil.$$$reportNull$$$0(45);
        }
        return mouseShortcut;
    }

    @NotNull
    public static String getMouseShortcutString(@NotNull MouseShortcut shortcut) {
        if (shortcut == null) {
            KeymapUtil.$$$reportNull$$$0(46);
        }
        if (Registry.is((String)"ide.mac.forceTouch") && shortcut instanceof PressureShortcut) {
            if ("Force touch" == null) {
                KeymapUtil.$$$reportNull$$$0(47);
            }
            return "Force touch";
        }
        StringBuilder buffer = new StringBuilder();
        int modifiers = shortcut.getModifiers();
        if ((0x40 & modifiers) > 0) {
            buffer.append(SHIFT);
            buffer.append(' ');
        }
        if ((0x80 & modifiers) > 0) {
            buffer.append(CONTROL);
            buffer.append(' ');
        }
        if ((0x100 & modifiers) > 0) {
            buffer.append(META);
            buffer.append(' ');
        }
        if ((0x200 & modifiers) > 0) {
            buffer.append(ALT);
            buffer.append(' ');
        }
        if ((0x2000 & modifiers) > 0) {
            buffer.append(ALT_GRAPH);
            buffer.append(' ');
        }
        buffer.append("button").append(shortcut.getButton()).append(' ');
        if (shortcut.getClickCount() > 1) {
            buffer.append(DOUBLE_CLICK);
        }
        String string = buffer.toString().trim();
        if (string == null) {
            KeymapUtil.$$$reportNull$$$0(48);
        }
        return string;
    }

    @NotNull
    public static String getKeyModifiersTextForMacOSLeopard(@JdkConstants.InputEventMask int modifiers) {
        StringBuilder buf = new StringBuilder();
        if ((modifiers & 4) != 0) {
            buf.append("\u2318");
        }
        if ((modifiers & 2) != 0) {
            buf.append(Toolkit.getProperty("AWT.control", "Ctrl"));
        }
        if ((modifiers & 8) != 0) {
            buf.append("\u2325");
        }
        if ((modifiers & 1) != 0) {
            buf.append(Toolkit.getProperty("AWT.shift", "Shift"));
        }
        if ((modifiers & 0x20) != 0) {
            buf.append(Toolkit.getProperty("AWT.altGraph", "Alt Graph"));
        }
        if ((modifiers & 0x10) != 0) {
            buf.append(Toolkit.getProperty("AWT.button1", "Button1"));
        }
        String string = buf.toString();
        if (string == null) {
            KeymapUtil.$$$reportNull$$$0(49);
        }
        return string;
    }

    public static boolean isTooltipRequest(@NotNull KeyEvent keyEvent) {
        if (keyEvent == null) {
            KeymapUtil.$$$reportNull$$$0(50);
        }
        if (ourTooltipKeysProperty == null) {
            ourTooltipKeysProperty = Registry.get((String)"ide.forcedShowTooltip");
            ourTooltipKeysProperty.addListener((RegistryValueListener)new RegistryValueListener.Adapter(){

                public void afterValueChanged(@NotNull RegistryValue value) {
                    if (value == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    KeymapUtil.updateTooltipRequestKey(value);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/openapi/keymap/KeymapUtil$1", "afterValueChanged"));
                }
            }, Disposer.get((String)"ui"));
            KeymapUtil.updateTooltipRequestKey(ourTooltipKeysProperty);
        }
        if (keyEvent.getID() != 401) {
            return false;
        }
        for (Integer each : ourTooltipKeys) {
            if ((keyEvent.getModifiers() & each) != 0) continue;
            return false;
        }
        for (Integer each : ourOtherTooltipKeys) {
            if ((keyEvent.getModifiers() & each) <= 0) continue;
            return false;
        }
        int code = keyEvent.getKeyCode();
        return code == 157 || code == 17 || code == 16 || code == 18;
    }

    private static void updateTooltipRequestKey(@NotNull RegistryValue value) {
        if (value == null) {
            KeymapUtil.$$$reportNull$$$0(51);
        }
        String text = value.asString();
        ourTooltipKeys.clear();
        ourOtherTooltipKeys.clear();
        KeymapUtil.processKey(text.contains(META), 4);
        KeymapUtil.processKey(text.contains(CONTROL) || text.contains(CTRL), 2);
        KeymapUtil.processKey(text.contains(SHIFT), 1);
        KeymapUtil.processKey(text.contains(ALT), 8);
    }

    private static void processKey(boolean condition, int value) {
        if (condition) {
            ourTooltipKeys.add(value);
        } else {
            ourOtherTooltipKeys.add(value);
        }
    }

    public static boolean isEmacsKeymap() {
        return KeymapUtil.isEmacsKeymap(KeymapManager.getInstance().getActiveKeymap());
    }

    public static boolean isEmacsKeymap(@Nullable Keymap keymap) {
        while (keymap != null) {
            if ("Emacs".equalsIgnoreCase(keymap.getName())) {
                return true;
            }
            keymap = keymap.getParent();
        }
        return false;
    }

    @Nullable
    public static KeyStroke getKeyStroke(@NotNull ShortcutSet shortcutSet) {
        Shortcut[] shortcuts;
        if (shortcutSet == null) {
            KeymapUtil.$$$reportNull$$$0(52);
        }
        if ((shortcuts = shortcutSet.getShortcuts()).length == 0 || !(shortcuts[0] instanceof KeyboardShortcut)) {
            return null;
        }
        KeyboardShortcut shortcut = (KeyboardShortcut)shortcuts[0];
        if (shortcut.getSecondKeyStroke() != null) {
            return null;
        }
        return shortcut.getFirstKeyStroke();
    }

    @NotNull
    public static String createTooltipText(@NotNull String name, @NotNull String actionId) {
        String text;
        if (name == null) {
            KeymapUtil.$$$reportNull$$$0(53);
        }
        if (actionId == null) {
            KeymapUtil.$$$reportNull$$$0(54);
        }
        String string = (text = KeymapUtil.getFirstKeyboardShortcutText(actionId)).isEmpty() ? name : name + " (" + text + ")";
        if (string == null) {
            KeymapUtil.$$$reportNull$$$0(55);
        }
        return string;
    }

    @NotNull
    public static String createTooltipText(@Nullable String name, @NotNull AnAction action) {
        String toolTipText;
        if (action == null) {
            KeymapUtil.$$$reportNull$$$0(56);
        }
        String string = toolTipText = name == null ? "" : name;
        while (StringUtil.endsWithChar((CharSequence)toolTipText, (char)'.')) {
            toolTipText = toolTipText.substring(0, toolTipText.length() - 1);
        }
        String shortcutsText = KeymapUtil.getFirstKeyboardShortcutText(action);
        if (!shortcutsText.isEmpty()) {
            toolTipText = toolTipText + " (" + shortcutsText + ")";
        }
        String string2 = toolTipText;
        if (string2 == null) {
            KeymapUtil.$$$reportNull$$$0(57);
        }
        return string2;
    }

    public static boolean matchActionMouseShortcutsModifiers(@NotNull Keymap activeKeymap, @JdkConstants.InputEventMask int modifiers, @NotNull String actionId) {
        if (activeKeymap == null) {
            KeymapUtil.$$$reportNull$$$0(58);
        }
        if (actionId == null) {
            KeymapUtil.$$$reportNull$$$0(59);
        }
        MouseShortcut syntheticShortcut = new MouseShortcut(1, modifiers, 1);
        for (Shortcut shortcut : activeKeymap.getShortcuts(actionId)) {
            MouseShortcut mouseShortcut;
            if (!(shortcut instanceof MouseShortcut) || (mouseShortcut = (MouseShortcut)shortcut).getModifiers() != syntheticShortcut.getModifiers()) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static MouseShortcut createMouseShortcut(@NotNull MouseEvent e) {
        if (e == null) {
            KeymapUtil.$$$reportNull$$$0(60);
        }
        int button = MouseShortcut.getButton(e);
        int modifiers = e.getModifiersEx();
        if (button == 0 && e.getID() == 506) {
            if ((modifiers & 0x400) != 0) {
                button = 1;
            } else if ((modifiers & 0x800) != 0) {
                button = 2;
            }
        }
        MouseShortcut mouseShortcut = new MouseShortcut(button, modifiers, 1);
        if (mouseShortcut == null) {
            KeymapUtil.$$$reportNull$$$0(61);
        }
        return mouseShortcut;
    }

    public static boolean reassignAction(@NotNull JComponent component, @NotNull KeyStroke oldKeyStroke, @Nullable KeyStroke newKeyStroke, int condition) {
        if (component == null) {
            KeymapUtil.$$$reportNull$$$0(62);
        }
        if (oldKeyStroke == null) {
            KeymapUtil.$$$reportNull$$$0(63);
        }
        return KeymapUtil.reassignAction(component, oldKeyStroke, newKeyStroke, condition, true);
    }

    public static boolean reassignAction(@NotNull JComponent component, @NotNull KeyStroke oldKeyStroke, @Nullable KeyStroke newKeyStroke, int condition, boolean muteOldKeystroke) {
        ActionListener action;
        if (component == null) {
            KeymapUtil.$$$reportNull$$$0(64);
        }
        if (oldKeyStroke == null) {
            KeymapUtil.$$$reportNull$$$0(65);
        }
        if ((action = component.getActionForKeyStroke(oldKeyStroke)) == null) {
            return false;
        }
        if (newKeyStroke != null) {
            component.registerKeyboardAction(action, newKeyStroke, condition);
        }
        if (muteOldKeystroke) {
            component.registerKeyboardAction(new RedispatchEventAction(component), oldKeyStroke, condition);
        }
        return true;
    }

    @Nullable
    public static ShortcutSet filterKeyStrokes(@NotNull ShortcutSet source, KeyStroke ... toLeaveOut) {
        if (source == null) {
            KeymapUtil.$$$reportNull$$$0(66);
        }
        ArrayList<Shortcut> filtered = new ArrayList<Shortcut>(Arrays.asList(source.getShortcuts()));
        for (Shortcut shortcut : source.getShortcuts()) {
            if (!(shortcut instanceof KeyboardShortcut) || ArrayUtil.find((Object[])toLeaveOut, (Object)((KeyboardShortcut)shortcut).getFirstKeyStroke()) == -1) continue;
            filtered.remove(shortcut);
        }
        return filtered.isEmpty() ? null : new CustomShortcutSet(filtered.toArray(Shortcut.EMPTY_ARRAY));
    }

    @Nullable
    public static String getEventCallerKeystrokeText(@NotNull AnActionEvent event) {
        if (event == null) {
            KeymapUtil.$$$reportNull$$$0(67);
        }
        if (event.getInputEvent() instanceof KeyEvent) {
            KeyEvent ke = (KeyEvent)event.getInputEvent();
            return KeymapUtil.getKeystrokeText(KeyStroke.getKeyStroke(ke.getKeyCode(), ke.getModifiers()));
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 35: 
            case 37: 
            case 39: 
            case 41: 
            case 42: 
            case 44: 
            case 45: 
            case 47: 
            case 48: 
            case 49: 
            case 55: 
            case 57: 
            case 61: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 35: 
            case 37: 
            case 39: 
            case 41: 
            case 42: 
            case 44: 
            case 45: 
            case 47: 
            case 48: 
            case 49: 
            case 55: 
            case 57: 
            case 61: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionId";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 35: 
            case 37: 
            case 39: 
            case 41: 
            case 42: 
            case 44: 
            case 45: 
            case 47: 
            case 48: 
            case 49: 
            case 55: 
            case 57: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/keymap/KeymapUtil";
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shortcut";
                break;
            }
            case 32: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyEvent";
                break;
            }
            case 34: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "set";
                break;
            }
            case 38: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shortcuts";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keystrokeString";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shortcutSet";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "activeKeymap";
                break;
            }
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 62: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 63: 
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldKeyStroke";
                break;
            }
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/keymap/KeymapUtil";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortcutText";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortcutIcon";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getMouseShortcutText";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeystrokeText";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyText";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getModifiersText";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getActiveKeymapShortcuts";
                break;
            }
            case 31: 
            case 35: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getFirstKeyboardShortcutText";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreferredShortcutText";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortcutsText";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "parseMouseShortcut";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "getMouseShortcutString";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyModifiersTextForMacOSLeopard";
                break;
            }
            case 55: 
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "createTooltipText";
                break;
            }
            case 61: {
                objectArray = objectArray2;
                objectArray2[1] = "createMouseShortcut";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getShortcutText";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 35: 
            case 37: 
            case 39: 
            case 41: 
            case 42: 
            case 44: 
            case 45: 
            case 47: 
            case 48: 
            case 49: 
            case 55: 
            case 57: 
            case 61: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getShortcutIcon";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getMouseShortcutText";
                break;
            }
            case 30: 
            case 34: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getFirstKeyboardShortcutText";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "isEventForAction";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getPreferredShortcutText";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getShortcutsText";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "parseMouseShortcut";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "getMouseShortcutString";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "isTooltipRequest";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "updateTooltipRequestKey";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "getKeyStroke";
                break;
            }
            case 53: 
            case 54: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "createTooltipText";
                break;
            }
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "matchActionMouseShortcutsModifiers";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "createMouseShortcut";
                break;
            }
            case 62: 
            case 63: 
            case 64: 
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "reassignAction";
                break;
            }
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "filterKeyStrokes";
                break;
            }
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "getEventCallerKeystrokeText";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 35: 
            case 37: 
            case 39: 
            case 41: 
            case 42: 
            case 44: 
            case 45: 
            case 47: 
            case 48: 
            case 49: 
            case 55: 
            case 57: 
            case 61: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class RedispatchEventAction
    extends AbstractAction {
        private final Component myComponent;

        RedispatchEventAction(@NotNull Component component) {
            if (component == null) {
                RedispatchEventAction.$$$reportNull$$$0(0);
            }
            this.myComponent = component;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Container parent;
            AWTEvent event = EventQueue.getCurrentEvent();
            if (event instanceof KeyEvent && event.getSource() == this.myComponent && (parent = this.myComponent.getParent()) != null) {
                KeyEvent keyEvent = (KeyEvent)event;
                parent.dispatchEvent(new KeyEvent(parent, event.getID(), ((KeyEvent)event).getWhen(), keyEvent.getModifiers(), keyEvent.getKeyCode(), keyEvent.getKeyChar(), keyEvent.getKeyLocation()));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/openapi/keymap/KeymapUtil$RedispatchEventAction", "<init>"));
        }
    }
}

