/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.projectImport;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ProjectOpenProcessor {
    public static final ExtensionPointName<ProjectOpenProcessor> EXTENSION_POINT_NAME = new ExtensionPointName("com.intellij.projectOpenProcessor");

    @NotNull
    public abstract String getName();

    @Nullable
    public abstract Icon getIcon();

    @Nullable
    public Icon getIcon(@NotNull VirtualFile file) {
        if (file == null) {
            ProjectOpenProcessor.$$$reportNull$$$0(0);
        }
        return this.getIcon();
    }

    public abstract boolean canOpenProject(@NotNull VirtualFile var1);

    public boolean isProjectFile(@NotNull VirtualFile file) {
        if (file == null) {
            ProjectOpenProcessor.$$$reportNull$$$0(1);
        }
        return this.canOpenProject(file);
    }

    @Nullable
    public abstract Project doOpenProject(@NotNull VirtualFile var1, @Nullable Project var2, boolean var3);

    public boolean lookForProjectsInDirectory() {
        return true;
    }

    @Nullable
    public static ProjectOpenProcessor getImportProvider(@NotNull VirtualFile file) {
        if (file == null) {
            ProjectOpenProcessor.$$$reportNull$$$0(2);
        }
        return ProjectOpenProcessor.getImportProvider(file, false);
    }

    @Nullable
    public static ProjectOpenProcessor getImportProvider(@NotNull VirtualFile file, boolean onlyIfExistingProjectFile) {
        if (file == null) {
            ProjectOpenProcessor.$$$reportNull$$$0(3);
        }
        for (ProjectOpenProcessor provider : EXTENSION_POINT_NAME.getExtensionList()) {
            if (!provider.canOpenProject(file) || onlyIfExistingProjectFile && !provider.isProjectFile(file)) continue;
            return provider;
        }
        return null;
    }

    @Nullable
    public static ProjectOpenProcessor getStrongImportProvider(@NotNull VirtualFile file) {
        if (file == null) {
            ProjectOpenProcessor.$$$reportNull$$$0(4);
        }
        for (ProjectOpenProcessor provider : EXTENSION_POINT_NAME.getExtensionList()) {
            if (!provider.isStrongProjectInfoHolder() || !provider.canOpenProject(file)) continue;
            return provider;
        }
        return null;
    }

    public boolean isStrongProjectInfoHolder() {
        return false;
    }

    public void refreshProjectFiles(@NotNull VirtualFile baseDir) {
        if (baseDir == null) {
            ProjectOpenProcessor.$$$reportNull$$$0(5);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDir";
                break;
            }
        }
        objectArray2[1] = "com/intellij/projectImport/ProjectOpenProcessor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getIcon";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isProjectFile";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getImportProvider";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getStrongImportProvider";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "refreshProjectFiles";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

