/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usageView;

import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiQualifiedReferenceElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.SmartPsiFileRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UsageInfo {
    public static final UsageInfo[] EMPTY_ARRAY = new UsageInfo[0];
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.usageView.UsageInfo");
    private final SmartPsiElementPointer<?> mySmartPointer;
    private final SmartPsiFileRange myPsiFileRange;
    public final boolean isNonCodeUsage;
    protected boolean myDynamicUsage;

    public UsageInfo(@NotNull PsiElement originalElement, int startOffset, int endOffset, boolean isNonCodeUsage) {
        int effectiveStart;
        int effectiveEnd;
        TextRange elementRange;
        if (originalElement == null) {
            UsageInfo.$$$reportNull$$$0(0);
        }
        PsiElement element = originalElement.getNavigationElement();
        PsiFile file = element.getContainingFile();
        PsiElement topElement = file == null ? element : file;
        LOG.assertTrue(topElement.isValid(), (Object)element);
        boolean isNullOrBinary = file == null || file.getFileType().isBinary();
        TextRange textRange = elementRange = isNullOrBinary ? TextRange.EMPTY_RANGE : element.getTextRange();
        if (elementRange == null) {
            throw new IllegalArgumentException("text range null for " + element + "; " + element.getClass());
        }
        if (startOffset == -1 && endOffset == -1) {
            if (isNullOrBinary) {
                effectiveEnd = 0;
                effectiveStart = 0;
            } else {
                effectiveStart = Math.max(0, element.getTextOffset() - elementRange.getStartOffset());
                effectiveEnd = Math.max(effectiveStart, elementRange.getLength());
            }
        } else {
            effectiveStart = startOffset;
            effectiveEnd = endOffset;
            if (element != originalElement) {
                PsiFile originalFile = originalElement.getContainingFile();
                if (originalFile == file) {
                    int delta = originalElement.getTextRange().getStartOffset() - elementRange.getStartOffset();
                    effectiveStart += delta;
                    effectiveEnd += delta;
                } else {
                    throw new IllegalArgumentException("element.getNavigationElement() for element " + originalElement + "(" + startOffset + ", " + endOffset + ") from " + originalFile + " led to different file " + file + ", thus making passed offsets invalid. Specify -1 for start/end offsets to calculate correct offsets for navigation.");
                }
            }
        }
        if (effectiveStart < 0 || effectiveStart > effectiveEnd) {
            throw new IllegalArgumentException("element " + element + "; startOffset " + startOffset + "; endOffset=" + endOffset + "; effectiveStart=" + effectiveStart + "; effectiveEnd=" + effectiveEnd + "; elementRange=" + elementRange + "; element.getTextOffset()=" + element.getTextOffset());
        }
        Project project = topElement.getProject();
        SmartPointerManager smartPointerManager = SmartPointerManager.getInstance(project);
        this.mySmartPointer = smartPointerManager.createSmartPsiElementPointer(element, file);
        if (!(file == null || isNullOrBinary || effectiveStart == element.getTextOffset() - elementRange.getStartOffset() && effectiveEnd == elementRange.getLength())) {
            TextRange rangeToStore = InjectedLanguageManager.getInstance(project).isInjectedFragment(file) ? elementRange : TextRange.create((int)effectiveStart, (int)effectiveEnd).shiftRight(elementRange.getStartOffset());
            this.myPsiFileRange = smartPointerManager.createSmartPsiFileRangePointer(file, rangeToStore);
        } else {
            this.myPsiFileRange = null;
        }
        this.isNonCodeUsage = isNonCodeUsage;
    }

    public UsageInfo(@NotNull SmartPsiElementPointer<?> smartPointer, @Nullable SmartPsiFileRange psiFileRange, boolean dynamicUsage, boolean nonCodeUsage) {
        if (smartPointer == null) {
            UsageInfo.$$$reportNull$$$0(1);
        }
        this.myDynamicUsage = dynamicUsage;
        this.isNonCodeUsage = nonCodeUsage;
        this.myPsiFileRange = psiFileRange;
        this.mySmartPointer = smartPointer;
    }

    public UsageInfo(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            UsageInfo.$$$reportNull$$$0(2);
        }
        Project project = psiFile.getProject();
        SmartPointerManager smartPointerManager = SmartPointerManager.getInstance(project);
        this.mySmartPointer = smartPointerManager.createSmartPsiElementPointer(psiFile);
        this.myPsiFileRange = null;
        this.isNonCodeUsage = true;
    }

    public UsageInfo(@NotNull PsiElement element, boolean isNonCodeUsage) {
        if (element == null) {
            UsageInfo.$$$reportNull$$$0(3);
        }
        this(element, -1, -1, isNonCodeUsage);
    }

    public UsageInfo(@NotNull PsiElement element, int startOffset, int endOffset) {
        if (element == null) {
            UsageInfo.$$$reportNull$$$0(4);
        }
        this(element, startOffset, endOffset, false);
    }

    public UsageInfo(@NotNull PsiReference reference) {
        if (reference == null) {
            UsageInfo.$$$reportNull$$$0(5);
        }
        this(reference.getElement(), reference.getRangeInElement().getStartOffset(), reference.getRangeInElement().getEndOffset());
        this.myDynamicUsage = reference instanceof PsiPolyVariantReference ? ((PsiPolyVariantReference)reference).multiResolve(false).length == 0 : reference.resolve() == null;
    }

    public UsageInfo(@NotNull PsiQualifiedReferenceElement reference) {
        if (reference == null) {
            UsageInfo.$$$reportNull$$$0(6);
        }
        this((PsiElement)reference);
    }

    public UsageInfo(@NotNull PsiElement element) {
        if (element == null) {
            UsageInfo.$$$reportNull$$$0(7);
        }
        this(element, false);
    }

    @NotNull
    public SmartPsiElementPointer<?> getSmartPointer() {
        SmartPsiElementPointer<?> smartPsiElementPointer = this.mySmartPointer;
        if (smartPsiElementPointer == null) {
            UsageInfo.$$$reportNull$$$0(8);
        }
        return smartPsiElementPointer;
    }

    public SmartPsiFileRange getPsiFileRange() {
        return this.myPsiFileRange;
    }

    public boolean isNonCodeUsage() {
        return this.isNonCodeUsage;
    }

    public void setDynamicUsage(boolean dynamicUsage) {
        this.myDynamicUsage = dynamicUsage;
    }

    @Nullable
    public PsiElement getElement() {
        return this.mySmartPointer.getElement();
    }

    @Nullable
    public PsiReference getReference() {
        PsiElement element = this.getElement();
        return element == null ? null : element.getReference();
    }

    @Nullable(value="null means range is invalid")
    public ProperTextRange getRangeInElement() {
        ProperTextRange result;
        boolean isNullOrBinary;
        PsiElement element = this.getElement();
        if (element == null) {
            return null;
        }
        PsiFile psiFile = this.getFile();
        boolean bl = isNullOrBinary = psiFile == null || psiFile.getFileType().isBinary();
        if (isNullOrBinary) {
            return new ProperTextRange(0, 0);
        }
        TextRange elementRange = element.getTextRange();
        if (this.myPsiFileRange == null) {
            int startOffset = element.getTextOffset();
            result = ProperTextRange.create((int)startOffset, (int)elementRange.getEndOffset());
        } else {
            Segment rangeInFile = this.myPsiFileRange.getRange();
            if (rangeInFile == null) {
                return null;
            }
            result = ProperTextRange.create((Segment)rangeInFile);
        }
        int delta = elementRange.getStartOffset();
        return result.getStartOffset() < delta ? null : result.shiftRight(-delta);
    }

    public String getTooltipText() {
        return null;
    }

    public int getNavigationOffset() {
        boolean isNullOrBinary;
        Segment range;
        if (this.myPsiFileRange != null && (range = this.myPsiFileRange.getRange()) != null) {
            return range.getStartOffset();
        }
        PsiElement element = this.getElement();
        if (element == null) {
            return -1;
        }
        PsiFile psiFile = this.getFile();
        boolean bl = isNullOrBinary = psiFile == null || psiFile.getFileType().isBinary();
        if (isNullOrBinary) {
            return 0;
        }
        TextRange range2 = element.getTextRange();
        ProperTextRange rangeInElement = this.getRangeInElement();
        if (rangeInElement == null) {
            return -1;
        }
        return range2.getStartOffset() + rangeInElement.getStartOffset();
    }

    public Segment getNavigationRange() {
        Segment range;
        if (this.myPsiFileRange != null && (range = this.myPsiFileRange.getRange()) != null) {
            return range;
        }
        PsiElement element = this.getElement();
        if (element == null) {
            return null;
        }
        TextRange range2 = element.getTextRange();
        ProperTextRange rangeInElement = this.getRangeInElement();
        if (rangeInElement == null) {
            return null;
        }
        return rangeInElement.shiftRight(range2.getStartOffset());
    }

    public boolean isValid() {
        if (this.isFileOrBinary()) {
            return true;
        }
        return this.getSegment() != null;
    }

    protected boolean isFileOrBinary() {
        PsiElement element = this.getElement();
        if (this.myPsiFileRange == null && element instanceof PsiFile) {
            return true;
        }
        PsiFile psiFile = this.getFile();
        return psiFile != null && psiFile.getFileType().isBinary();
    }

    @Nullable
    public Segment getSegment() {
        ProperTextRange rangeInElement;
        Document document;
        PsiElement element = this.getElement();
        if (element == null || this.myPsiFileRange == null && element instanceof PsiFile) {
            return null;
        }
        TextRange range = element.getTextRange();
        TextRange.assertProperRange((Segment)range, (Object)element);
        if (element instanceof PsiFile && (document = PsiDocumentManager.getInstance(this.getProject()).getDocument((PsiFile)element)) != null) {
            range = new ProperTextRange(0, document.getTextLength());
        }
        if ((rangeInElement = this.getRangeInElement()) == null) {
            return null;
        }
        return new ProperTextRange(Math.min(range.getEndOffset(), range.getStartOffset() + rangeInElement.getStartOffset()), Math.min(range.getEndOffset(), range.getStartOffset() + rangeInElement.getEndOffset()));
    }

    private Pair<VirtualFile, Integer> offset() {
        Segment range;
        VirtualFile containingFile0 = this.getVirtualFile();
        int shift0 = 0;
        if (containingFile0 instanceof VirtualFileWindow) {
            shift0 = ((VirtualFileWindow)((Object)containingFile0)).getDocumentWindow().injectedToHost(0);
            containingFile0 = ((VirtualFileWindow)((Object)containingFile0)).getDelegate();
        }
        Segment segment = range = this.myPsiFileRange == null ? this.mySmartPointer.getPsiRange() : this.myPsiFileRange.getPsiRange();
        if (range == null) {
            return null;
        }
        return Pair.create((Object)containingFile0, (Object)(range.getStartOffset() + shift0));
    }

    public int compareToByStartOffset(@NotNull UsageInfo info) {
        if (info == null) {
            UsageInfo.$$$reportNull$$$0(9);
        }
        Pair<VirtualFile, Integer> offset0 = this.offset();
        Pair<VirtualFile, Integer> offset1 = info.offset();
        if (offset0 == null || offset1 == null) {
            return (offset0 == null ? 0 : 1) - (offset1 == null ? 0 : 1);
        }
        VirtualFile file0 = (VirtualFile)offset0.first;
        VirtualFile file1 = (VirtualFile)offset1.first;
        if (file0 == null || file1 == null) {
            return (file0 == null ? 0 : 1) - (file1 == null ? 0 : 1);
        }
        if (Comparing.equal((Object)file0, (Object)file1)) {
            return (Integer)offset0.second - (Integer)offset1.second;
        }
        return file0.getPath().compareTo(file1.getPath());
    }

    @NotNull
    public Project getProject() {
        Project project = this.mySmartPointer.getProject();
        if (project == null) {
            UsageInfo.$$$reportNull$$$0(10);
        }
        return project;
    }

    public final boolean isWritable() {
        PsiElement element = this.getElement();
        return element == null || element.isWritable();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!this.getClass().equals(o.getClass())) {
            return false;
        }
        UsageInfo usageInfo = (UsageInfo)o;
        if (this.isNonCodeUsage != usageInfo.isNonCodeUsage) {
            return false;
        }
        SmartPointerManager smartPointerManager = SmartPointerManager.getInstance(this.getProject());
        return smartPointerManager.pointToTheSameElement(this.mySmartPointer, usageInfo.mySmartPointer) && (this.myPsiFileRange == null || usageInfo.myPsiFileRange != null && smartPointerManager.pointToTheSameElement(this.myPsiFileRange, usageInfo.myPsiFileRange));
    }

    public int hashCode() {
        int result = this.mySmartPointer != null ? this.mySmartPointer.hashCode() : 0;
        result = 29 * result + (this.myPsiFileRange == null ? 0 : this.myPsiFileRange.hashCode());
        result = 29 * result + (this.isNonCodeUsage ? 1 : 0);
        return result;
    }

    public String toString() {
        PsiReference reference = this.getReference();
        if (reference == null) {
            return super.toString();
        }
        return reference.getCanonicalText() + " (" + reference.getClass() + ")";
    }

    @Nullable
    public PsiFile getFile() {
        return this.mySmartPointer.getContainingFile();
    }

    @Nullable
    public VirtualFile getVirtualFile() {
        return this.mySmartPointer.getVirtualFile();
    }

    public boolean isDynamicUsage() {
        return this.myDynamicUsage;
    }

    @Nullable(value="null means could not copy because info is no longer valid")
    public UsageInfo copy() {
        Object element = this.mySmartPointer.getElement();
        SmartPointerManager smartPointerManager = SmartPointerManager.getInstance(this.getProject());
        PsiFile containingFile = this.myPsiFileRange == null ? null : this.myPsiFileRange.getContainingFile();
        Segment segment = containingFile == null ? null : this.myPsiFileRange.getRange();
        TextRange range = segment == null ? null : TextRange.create((Segment)segment);
        SmartPsiFileRange psiFileRange = range == null ? null : smartPointerManager.createSmartPsiFileRangePointer(containingFile, range);
        SmartPsiElementPointer<?> pointer = element == null || !this.isValid() ? null : smartPointerManager.createSmartPsiElementPointer(element);
        return pointer == null ? null : new UsageInfo(pointer, psiFileRange, this.isDynamicUsage(), this.isNonCodeUsage());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalElement";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "smartPointer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 3: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/usageView/UsageInfo";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/usageView/UsageInfo";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getSmartPointer";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 8: 
            case 10: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "compareToByStartOffset";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

