/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.meta.impl;

import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import java.util.Optional;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.yaml.meta.model.YamlMetaType;

@ApiStatus.Experimental
public abstract class YamlKeyInsertHandler
implements InsertHandler<LookupElement> {
    private final boolean myNeedsSequenceItem;

    public YamlKeyInsertHandler(boolean needsSequenceItem) {
        this.myNeedsSequenceItem = needsSequenceItem;
    }

    public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
        String lookupString;
        if (context == null) {
            YamlKeyInsertHandler.$$$reportNull$$$0(0);
        }
        if (item == null) {
            YamlKeyInsertHandler.$$$reportNull$$$0(1);
        }
        if (!YamlKeyInsertHandler.needsColon(context)) {
            return;
        }
        YamlMetaType.ForcedCompletionPath path = Optional.of(item.getObject()).filter(YamlMetaType.ForcedCompletionPath.class::isInstance).map(YamlMetaType.ForcedCompletionPath.class::cast).orElse(null);
        if (path != null) {
            lookupString = this.getReplacement();
            context.getDocument().replaceString(context.getStartOffset(), context.getTailOffset(), (CharSequence)lookupString);
        } else {
            lookupString = item.getLookupString();
        }
        String commonPadding = YamlKeyInsertHandler.getIndentation(context, lookupString);
        YamlMetaType.YamlInsertionMarkup insertionMarkup = this.computeInsertionMarkup(path != null ? path : YamlMetaType.ForcedCompletionPath.nullPath());
        commonPadding = this.insertBeforeItem(context, lookupString, commonPadding, insertionMarkup);
        insertionMarkup.insertStringAndCaret(context.getEditor(), commonPadding);
    }

    @NotNull
    protected abstract YamlMetaType.YamlInsertionMarkup computeInsertionMarkup(@NotNull YamlMetaType.ForcedCompletionPath var1);

    @NotNull
    protected abstract String getReplacement();

    private static boolean needsColon(@NotNull InsertionContext context) {
        if (context == null) {
            YamlKeyInsertHandler.$$$reportNull$$$0(2);
        }
        String tail = YamlKeyInsertHandler.getTailString(context);
        for (int i = 0; i < tail.length(); ++i) {
            char next = tail.charAt(i);
            if (next == ':') {
                return false;
            }
            if (!YamlKeyInsertHandler.isCRLF(next)) continue;
            return true;
        }
        return true;
    }

    protected String insertBeforeItem(@NotNull InsertionContext context, @NotNull String lookupString, @NotNull String commonPadding_, @NotNull YamlMetaType.YamlInsertionMarkup markup) {
        if (context == null) {
            YamlKeyInsertHandler.$$$reportNull$$$0(3);
        }
        if (lookupString == null) {
            YamlKeyInsertHandler.$$$reportNull$$$0(4);
        }
        if (commonPadding_ == null) {
            YamlKeyInsertHandler.$$$reportNull$$$0(5);
        }
        if (markup == null) {
            YamlKeyInsertHandler.$$$reportNull$$$0(6);
        }
        String COLON = ":";
        String ITEM_MARK = "- ";
        String sameLineBeforeItem = YamlKeyInsertHandler.getHeadStringOnCurrentLine(context, lookupString);
        StringBuilder toBeInserted = new StringBuilder();
        StringBuilder toBeRemoved = new StringBuilder();
        StringBuilder totalPadding = new StringBuilder(commonPadding_);
        if (sameLineBeforeItem.contains(":")) {
            String afterColonBeforeItem = StringUtil.substringAfterLast((String)sameLineBeforeItem, (String)":");
            if (StringUtil.isEmptyOrSpaces((String)afterColonBeforeItem)) {
                toBeRemoved.append(afterColonBeforeItem);
            }
            totalPadding.append(markup.getTabSymbol());
            toBeInserted.append('\n').append((CharSequence)totalPadding);
            sameLineBeforeItem = totalPadding.toString();
        }
        if (this.myNeedsSequenceItem && !sameLineBeforeItem.endsWith("- ")) {
            toBeInserted.append("- ");
            totalPadding.append(StringUtil.repeat((String)" ", (int)"- ".length()));
        }
        if (toBeInserted.length() != 0) {
            Editor editor = context.getEditor();
            int currentOffset = editor.getCaretModel().getOffset();
            int insertedItemStart = currentOffset - lookupString.length();
            ApplicationManager.getApplication().runWriteAction(() -> CommandProcessor.getInstance().runUndoTransparentAction(() -> {
                Document document = editor.getDocument();
                document.replaceString(insertedItemStart - toBeRemoved.length(), insertedItemStart, (CharSequence)toBeInserted);
                editor.getCaretModel().moveToOffset(currentOffset + toBeInserted.length() - toBeRemoved.length());
                PsiDocumentManager.getInstance((Project)context.getProject()).commitDocument(document);
            }));
        }
        return totalPadding.toString();
    }

    @NotNull
    private static String getTailString(@NotNull InsertionContext context) {
        if (context == null) {
            YamlKeyInsertHandler.$$$reportNull$$$0(7);
        }
        String string = context.getDocument().getText().substring(context.getTailOffset());
        if (string == null) {
            YamlKeyInsertHandler.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    private static String getHeadString(@NotNull InsertionContext context, @NotNull String lookupString) {
        if (context == null) {
            YamlKeyInsertHandler.$$$reportNull$$$0(9);
        }
        if (lookupString == null) {
            YamlKeyInsertHandler.$$$reportNull$$$0(10);
        }
        String string = context.getDocument().getText().substring(0, context.getTailOffset() - lookupString.length());
        if (string == null) {
            YamlKeyInsertHandler.$$$reportNull$$$0(11);
        }
        return string;
    }

    @NotNull
    private static String getHeadStringOnCurrentLine(InsertionContext context, @NotNull String lookupString) {
        if (lookupString == null) {
            YamlKeyInsertHandler.$$$reportNull$$$0(12);
        }
        String head = YamlKeyInsertHandler.getHeadString(context, lookupString);
        int lineStart = -1;
        for (int idx = head.length() - 1; idx >= 0; --idx) {
            char next = head.charAt(idx);
            if (!YamlKeyInsertHandler.isCRLF(next)) continue;
            lineStart = idx;
            break;
        }
        String string = head.substring(lineStart + 1);
        if (string == null) {
            YamlKeyInsertHandler.$$$reportNull$$$0(13);
        }
        return string;
    }

    @NotNull
    private static String getIndentation(InsertionContext context, @NotNull String lookupString) {
        String currentLineHead;
        String spaces;
        int spacesLength;
        if (lookupString == null) {
            YamlKeyInsertHandler.$$$reportNull$$$0(14);
        }
        if ((spacesLength = (spaces = YamlKeyInsertHandler.getLeadingSpacesStartingFrom(currentLineHead = YamlKeyInsertHandler.getHeadStringOnCurrentLine(context, lookupString), 0)).length()) < currentLineHead.length() && currentLineHead.charAt(spacesLength) == '-') {
            spaces = spaces + " " + YamlKeyInsertHandler.getLeadingSpacesStartingFrom(currentLineHead, spacesLength + "-".length());
        }
        String string = spaces;
        if (string == null) {
            YamlKeyInsertHandler.$$$reportNull$$$0(15);
        }
        return string;
    }

    @NotNull
    private static String getLeadingSpacesStartingFrom(String text, int startIdx) {
        int firstNotSpace = text.length();
        for (int idx = startIdx; idx < text.length(); ++idx) {
            char next = text.charAt(idx);
            if (Character.isWhitespace(next)) continue;
            firstNotSpace = idx;
            break;
        }
        String string = text.substring(startIdx, firstNotSpace);
        if (string == null) {
            YamlKeyInsertHandler.$$$reportNull$$$0(16);
        }
        return string;
    }

    private static boolean isCRLF(char c) {
        return c == '\n' || c == '\r';
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 11: 
            case 13: 
            case 15: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 11: 
            case 13: 
            case 15: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 4: 
            case 10: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lookupString";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commonPadding_";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "markup";
                break;
            }
            case 8: 
            case 11: 
            case 13: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/yaml/meta/impl/YamlKeyInsertHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/yaml/meta/impl/YamlKeyInsertHandler";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getTailString";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getHeadString";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getHeadStringOnCurrentLine";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndentation";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getLeadingSpacesStartingFrom";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "handleInsert";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "needsColon";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "insertBeforeItem";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getTailString";
                break;
            }
            case 8: 
            case 11: 
            case 13: 
            case 15: 
            case 16: {
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getHeadString";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getHeadStringOnCurrentLine";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getIndentation";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 11: 
            case 13: 
            case 15: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

