/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.schema;

import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.jsonSchema.extension.adapters.JsonArrayValueAdapter;
import com.jetbrains.jsonSchema.extension.adapters.JsonObjectValueAdapter;
import com.jetbrains.jsonSchema.extension.adapters.JsonValueAdapter;
import java.util.Set;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.psi.YAMLAnchor;
import org.jetbrains.yaml.psi.YAMLValue;

public class YamlGenericValueAdapter
implements JsonValueAdapter {
    @NotNull
    private static final Set<String> NULLS = ContainerUtil.set((Object[])new String[]{"null", "Null", "NULL", "~"});
    @NotNull
    private static final Set<String> BOOLS = ContainerUtil.set((Object[])new String[]{"true", "True", "TRUE", "false", "False", "FALSE"});
    @NotNull
    private static final Set<String> INFS = ContainerUtil.set((Object[])new String[]{".inf", ".Inf", ".INF"});
    @NotNull
    private static final Set<String> NANS = ContainerUtil.set((Object[])new String[]{".nan", ".NaN", ".NAN"});
    @NotNull
    private final YAMLValue myValue;

    public YamlGenericValueAdapter(@NotNull YAMLValue value) {
        if (value == null) {
            YamlGenericValueAdapter.$$$reportNull$$$0(0);
        }
        this.myValue = value;
    }

    public boolean isShouldBeIgnored() {
        return true;
    }

    public boolean isObject() {
        return false;
    }

    public boolean isArray() {
        return false;
    }

    public boolean isStringLiteral() {
        return !this.isNumberLiteral() && !this.isBooleanLiteral() && !this.isNull();
    }

    private String getTextWithoutRefs() {
        YAMLAnchor[] anchors = (YAMLAnchor[])PsiTreeUtil.getChildrenOfType((PsiElement)this.myValue, YAMLAnchor.class);
        if (anchors == null || anchors.length == 0) {
            return this.myValue.getText();
        }
        int endOffset = anchors[anchors.length - 1].getTextRange().getEndOffset();
        TextRange valueTextRange = this.myValue.getTextRange();
        int offset = valueTextRange.getEndOffset();
        TextRange range = new TextRange(endOffset, offset);
        range = range.shiftLeft(valueTextRange.getStartOffset());
        String text = this.myValue.getText();
        return text.substring(range.getStartOffset()).trim();
    }

    private static boolean hasTag(@NotNull String text, @NotNull String tagName) {
        if (text == null) {
            YamlGenericValueAdapter.$$$reportNull$$$0(1);
        }
        if (tagName == null) {
            YamlGenericValueAdapter.$$$reportNull$$$0(2);
        }
        return StringUtil.startsWith((CharSequence)text, (CharSequence)("!!" + tagName));
    }

    public boolean isNumberLiteral() {
        String text = this.getTextWithoutRefs();
        return YamlGenericValueAdapter.isNumber(text);
    }

    public boolean isBooleanLiteral() {
        String text = this.getTextWithoutRefs();
        return BOOLS.contains(text) || YamlGenericValueAdapter.hasTag(text, "bool");
    }

    public boolean isNull() {
        String text = this.getTextWithoutRefs();
        return NULLS.contains(text) || YamlGenericValueAdapter.hasTag(text, "null");
    }

    @NotNull
    public PsiElement getDelegate() {
        YAMLValue yAMLValue = this.myValue;
        if (yAMLValue == null) {
            YamlGenericValueAdapter.$$$reportNull$$$0(3);
        }
        return yAMLValue;
    }

    @Nullable
    public JsonObjectValueAdapter getAsObject() {
        return null;
    }

    @Nullable
    public JsonArrayValueAdapter getAsArray() {
        return null;
    }

    public boolean shouldCheckIntegralRequirements() {
        return false;
    }

    private static boolean isNumber(@Nullable String s) {
        if (s == null) {
            return false;
        }
        return YamlGenericValueAdapter.isInteger(s) || YamlGenericValueAdapter.isFloat(s);
    }

    private static boolean isInteger(@NotNull String s) {
        if (s == null) {
            YamlGenericValueAdapter.$$$reportNull$$$0(4);
        }
        if (s.length() == 0) {
            return false;
        }
        if ("0".equals(s) || "-0".equals(s) || "+0".equals(s)) {
            return true;
        }
        if (YamlGenericValueAdapter.hasTag(s, "int")) {
            return true;
        }
        return YamlGenericValueAdapter.matchesInt(s);
    }

    private static boolean matchesInt(@NotNull String s) {
        char charZero;
        if (s == null) {
            YamlGenericValueAdapter.$$$reportNull$$$0(5);
        }
        int startIndex = (charZero = s.charAt(0)) == '-' || charZero == '+' ? 1 : 0;
        int baseSign = 32;
        boolean expectBase = false;
        for (int i = startIndex; i < s.length(); ++i) {
            if (i == startIndex && s.charAt(i) == '0') {
                if (startIndex != 0) {
                    return false;
                }
                expectBase = true;
                continue;
            }
            if (i == startIndex + 1 && expectBase) {
                char c = s.charAt(i);
                if (c != 'o' && c != 'x') {
                    return false;
                }
                baseSign = c;
            }
            if (baseSign == 32 && !Character.isDigit(s.charAt(i))) {
                return false;
            }
            if (baseSign == 111 && !StringUtil.isOctalDigit((char)s.charAt(i))) {
                return false;
            }
            if (baseSign != 120 || StringUtil.isHexDigit((char)s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean isFloat(@NotNull String s) {
        if (s == null) {
            YamlGenericValueAdapter.$$$reportNull$$$0(6);
        }
        if (INFS.contains(YamlGenericValueAdapter.trimSign(s)) || NANS.contains(s)) {
            return true;
        }
        if (YamlGenericValueAdapter.hasTag(s, "float")) {
            return true;
        }
        return Pattern.matches("[-+]?(\\.[0-9]+|[0-9]+(\\.[0-9]*)?)([eE][-+]?[0-9]+)?", s);
    }

    @NotNull
    private static String trimSign(@NotNull String s) {
        if (s == null) {
            YamlGenericValueAdapter.$$$reportNull$$$0(7);
        }
        if (s.isEmpty()) {
            String string = s;
            if (string == null) {
                YamlGenericValueAdapter.$$$reportNull$$$0(8);
            }
            return string;
        }
        char c = s.charAt(0);
        String string = c == '+' || c == '-' ? s.substring(1) : s;
        if (string == null) {
            YamlGenericValueAdapter.$$$reportNull$$$0(9);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tagName";
                break;
            }
            case 3: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/yaml/schema/YamlGenericValueAdapter";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/yaml/schema/YamlGenericValueAdapter";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDelegate";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "trimSign";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "hasTag";
                break;
            }
            case 3: 
            case 8: 
            case 9: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isInteger";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "matchesInt";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isFloat";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "trimSign";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

