/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandEvent;
import com.intellij.openapi.command.CommandListener;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectLocator;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsShowConfirmationOption;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vfs.LocalFileOperationsHandler;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.util.Function;
import com.intellij.util.Functions;
import com.intellij.util.ThrowableConsumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.vcsUtil.ActionWithTempFile;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.RepeatSvnActionThroughBusy;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnChangelistListener;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.WorkingCopyFormat;
import org.jetbrains.idea.svn.api.Depth;
import org.jetbrains.idea.svn.api.ErrorCode;
import org.jetbrains.idea.svn.api.NodeKind;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.info.Info;
import org.jetbrains.idea.svn.status.Status;
import org.jetbrains.idea.svn.status.StatusType;

public class SvnFileSystemListener
implements LocalFileOperationsHandler,
Disposable,
CommandListener {
    private static final Logger LOG = Logger.getInstance(SvnFileSystemListener.class);
    private final LocalFileSystem myLfs;
    private final MultiMap<Project, AddedFileInfo> myAddedFiles = new MultiMap();
    private final MultiMap<Project, File> myDeletedFiles = new MultiMap();
    private final List<MovedFileInfo> myMovedFiles = new ArrayList<MovedFileInfo>();
    private final Map<Project, List<VcsException>> myMoveExceptions = new HashMap<Project, List<VcsException>>();
    private final List<VirtualFile> myFilesToRefresh = new ArrayList<VirtualFile>();
    @Nullable
    private File myStorageForUndo;
    private final List<Couple<File>> myUndoStorageContents = new ArrayList<Couple<File>>();
    private boolean myUndoingMove = false;
    private boolean myIsInCommand;
    @Nullable
    private Project myGuessedProject;

    public SvnFileSystemListener() {
        this.myLfs = LocalFileSystem.getInstance();
        this.myLfs.registerAuxiliaryFileOperationsHandler((LocalFileOperationsHandler)this);
        ApplicationManager.getApplication().getMessageBus().connect((Disposable)this).subscribe(CommandListener.TOPIC, (Object)this);
    }

    public void dispose() {
        this.myLfs.unregisterAuxiliaryFileOperationsHandler((LocalFileOperationsHandler)this);
    }

    private void addToMoveExceptions(@NotNull Project project, @NotNull VcsException e) {
        List<VcsException> exceptionList;
        if (project == null) {
            SvnFileSystemListener.$$$reportNull$$$0(0);
        }
        if (e == null) {
            SvnFileSystemListener.$$$reportNull$$$0(1);
        }
        if ((exceptionList = this.myMoveExceptions.get(project)) == null) {
            exceptionList = new ArrayList<VcsException>();
            this.myMoveExceptions.put(project, exceptionList);
        }
        exceptionList.add(SvnFileSystemListener.handleMoveException(e));
    }

    @NotNull
    private static VcsException handleMoveException(@NotNull VcsException e) {
        if (e == null) {
            SvnFileSystemListener.$$$reportNull$$$0(2);
        }
        VcsException vcsException = e instanceof SvnBindException && ((SvnBindException)e).contains(ErrorCode.ENTRY_EXISTS) ? SvnFileSystemListener.createMoveTargetExistsError((Exception)((Object)e)) : e;
        if (vcsException == null) {
            SvnFileSystemListener.$$$reportNull$$$0(3);
        }
        return vcsException;
    }

    @NotNull
    private static VcsException createMoveTargetExistsError(@NotNull Exception e) {
        if (e == null) {
            SvnFileSystemListener.$$$reportNull$$$0(4);
        }
        VcsException vcsException = new VcsException(Arrays.asList("Target of move operation is already under version control.", "Subversion move had not been performed. ", e.getMessage()));
        if (vcsException == null) {
            SvnFileSystemListener.$$$reportNull$$$0(5);
        }
        return vcsException;
    }

    @Nullable
    public File copy(@NotNull VirtualFile file, @NotNull VirtualFile toDir, @NotNull String copyName) {
        if (file == null) {
            SvnFileSystemListener.$$$reportNull$$$0(6);
        }
        if (toDir == null) {
            SvnFileSystemListener.$$$reportNull$$$0(7);
        }
        if (copyName == null) {
            SvnFileSystemListener.$$$reportNull$$$0(8);
        }
        this.startOperation(file);
        SvnVcs vcs = SvnFileSystemListener.getVCS(toDir);
        if (vcs == null) {
            vcs = SvnFileSystemListener.getVCS(file);
        }
        if (vcs == null) {
            return null;
        }
        File srcFile = VfsUtilCore.virtualToIoFile((VirtualFile)file);
        File destFile = new File(VfsUtilCore.virtualToIoFile((VirtualFile)toDir), copyName);
        if (!SvnUtil.isSvnVersioned(vcs, destFile.getParentFile()) && !this.isPendingAdd(vcs.getProject(), toDir)) {
            return null;
        }
        if (!SvnUtil.isSvnVersioned(vcs, srcFile.getParentFile())) {
            this.myAddedFiles.putValue((Object)vcs.getProject(), (Object)new AddedFileInfo(toDir, copyName, null, false));
            return null;
        }
        Status fileStatus = SvnFileSystemListener.getFileStatus(vcs, srcFile);
        if (fileStatus != null && fileStatus.is(StatusType.STATUS_ADDED)) {
            this.myAddedFiles.putValue((Object)vcs.getProject(), (Object)new AddedFileInfo(toDir, copyName, null, false));
            return null;
        }
        if (this.sameRoot(vcs, file.getParent(), toDir)) {
            this.myAddedFiles.putValue((Object)vcs.getProject(), (Object)new AddedFileInfo(toDir, copyName, srcFile, false));
            return null;
        }
        this.myAddedFiles.putValue((Object)vcs.getProject(), (Object)new AddedFileInfo(toDir, copyName, null, false));
        return null;
    }

    private boolean sameRoot(@NotNull SvnVcs vcs, @NotNull VirtualFile srcDir, @NotNull VirtualFile dstDir) {
        if (vcs == null) {
            SvnFileSystemListener.$$$reportNull$$$0(9);
        }
        if (srcDir == null) {
            SvnFileSystemListener.$$$reportNull$$$0(10);
        }
        if (dstDir == null) {
            SvnFileSystemListener.$$$reportNull$$$0(11);
        }
        UUIDHelper helper = new UUIDHelper(vcs);
        String srcUUID = helper.getRepositoryUUID(vcs.getProject(), srcDir);
        String dstUUID = helper.getRepositoryUUID(vcs.getProject(), dstDir);
        return srcUUID != null && dstUUID != null && srcUUID.equals(dstUUID);
    }

    public boolean move(@NotNull VirtualFile file, @NotNull VirtualFile toDir) {
        if (file == null) {
            SvnFileSystemListener.$$$reportNull$$$0(12);
        }
        if (toDir == null) {
            SvnFileSystemListener.$$$reportNull$$$0(13);
        }
        this.startOperation(file);
        File srcFile = SvnFileSystemListener.getIOFile(file);
        File dstFile = new File(SvnFileSystemListener.getIOFile(toDir), file.getName());
        SvnVcs vcs = SvnFileSystemListener.getVCS(toDir);
        SvnVcs sourceVcs = SvnFileSystemListener.getVCS(file);
        if (vcs == null) {
            return false;
        }
        if (sourceVcs == null) {
            return this.createItem(toDir, file.getName(), file.isDirectory(), true);
        }
        if (this.isPendingAdd(vcs.getProject(), toDir)) {
            this.myMovedFiles.add(new MovedFileInfo(sourceVcs.getProject(), srcFile, dstFile));
            return true;
        }
        this.myFilesToRefresh.add(file.getParent());
        this.myFilesToRefresh.add(toDir);
        return this.doMove(sourceVcs, srcFile, dstFile);
    }

    public boolean rename(@NotNull VirtualFile file, @NotNull String newName) {
        if (file == null) {
            SvnFileSystemListener.$$$reportNull$$$0(14);
        }
        if (newName == null) {
            SvnFileSystemListener.$$$reportNull$$$0(15);
        }
        this.startOperation(file);
        File srcFile = SvnFileSystemListener.getIOFile(file);
        File dstFile = new File(srcFile.getParentFile(), newName);
        SvnVcs vcs = SvnFileSystemListener.getVCS(file);
        if (vcs != null) {
            this.myFilesToRefresh.add(file.getParent());
            return this.doMove(vcs, srcFile, dstFile);
        }
        return false;
    }

    private boolean doMove(@NotNull SvnVcs vcs, @NotNull File src, @NotNull File dst) {
        if (vcs == null) {
            SvnFileSystemListener.$$$reportNull$$$0(16);
        }
        if (src == null) {
            SvnFileSystemListener.$$$reportNull$$$0(17);
        }
        if (dst == null) {
            SvnFileSystemListener.$$$reportNull$$$0(18);
        }
        try {
            Status srcStatus;
            boolean isUndo = SvnFileSystemListener.isUndo(vcs);
            String list = isUndo ? null : SvnChangelistListener.getCurrentMapping(vcs, src);
            WorkingCopyFormat format = vcs.getWorkingCopyFormat(src);
            boolean is17OrLater = format.isOrGreater(WorkingCopyFormat.ONE_DOT_SEVEN);
            if (is17OrLater ? SvnFileSystemListener.isUnversioned(srcStatus = SvnFileSystemListener.getFileStatus(vcs, src)) && (SvnFileSystemListener.isUnversioned(vcs, dst.getParentFile()) || SvnFileSystemListener.isUnversioned(vcs, dst)) || this.for17move(vcs, src, dst, isUndo, srcStatus) : this.for16move(dst, isUndo)) {
                return false;
            }
            if (!isUndo && list != null) {
                SvnChangelistListener.putUnderList(vcs, list, dst);
            }
        }
        catch (VcsException e) {
            this.addToMoveExceptions(vcs.getProject(), e);
            return false;
        }
        return true;
    }

    private static boolean isUnversioned(@Nullable Status status) {
        return status == null || status.is(StatusType.STATUS_UNVERSIONED);
    }

    private static boolean isUnversioned(@NotNull SvnVcs vcs, @NotNull File file) {
        if (vcs == null) {
            SvnFileSystemListener.$$$reportNull$$$0(19);
        }
        if (file == null) {
            SvnFileSystemListener.$$$reportNull$$$0(20);
        }
        return SvnFileSystemListener.isUnversioned(SvnFileSystemListener.getFileStatus(vcs, file));
    }

    private boolean for17move(SvnVcs vcs, File src, File dst, boolean undo, Status srcStatus) throws VcsException {
        if (srcStatus != null && srcStatus.getCopyFromUrl() == null) {
            undo = false;
        }
        if (undo) {
            this.myUndoingMove = true;
            boolean isCaseOnlyMove = FileUtil.filesEqual((File)src, (File)dst);
            SvnFileSystemListener.createRevertAction(vcs, isCaseOnlyMove ? src : dst, true).execute();
            SvnFileSystemListener.copyUnversionedMembersOfDirectory(src, dst);
            if (SvnFileSystemListener.isUnversioned(srcStatus)) {
                FileUtil.delete((File)src);
            } else {
                SvnFileSystemListener.createRevertAction(vcs, isCaseOnlyMove ? dst : src, true).execute();
            }
            this.restoreFromUndoStorage(dst);
        } else {
            if (SvnFileSystemListener.doUsualMove(vcs, src)) {
                return true;
            }
            if (SvnFileSystemListener.isUnversioned(vcs, dst.getParentFile())) {
                try {
                    FileUtil.copyFileOrDir((File)src, (File)dst);
                }
                catch (IOException e) {
                    throw new SvnBindException(e);
                }
                SvnFileSystemListener.createDeleteAction(vcs, src, true).execute();
                return false;
            }
            SvnFileSystemListener.moveFileWithSvn(vcs, src, dst);
        }
        return false;
    }

    public static void moveFileWithSvn(final SvnVcs vcs, final File src, final File dst) throws VcsException {
        new RepeatSvnActionThroughBusy(){

            @Override
            protected void executeImpl() throws VcsException {
                vcs.getFactory(src).createCopyMoveClient().copy(src, dst, false, true);
            }
        }.execute();
    }

    private static void copyUnversionedMembersOfDirectory(File src, File dst) throws SvnBindException {
        if (src.isDirectory()) {
            SvnBindException[] exc = new SvnBindException[1];
            FileUtil.processFilesRecursively((File)src, file -> {
                String relativePath = FileUtil.getRelativePath((File)src, (File)file);
                File newFile = new File(dst, relativePath);
                if (!newFile.exists()) {
                    try {
                        FileUtil.copyFileOrDir((File)src, (File)dst);
                    }
                    catch (IOException e) {
                        exc[0] = new SvnBindException(e);
                        return false;
                    }
                }
                return true;
            });
            if (exc[0] != null) {
                throw exc[0];
            }
        }
    }

    private static boolean doUsualMove(SvnVcs vcs, File src) {
        Status srcStatus = SvnFileSystemListener.getFileStatus(vcs, src);
        return srcStatus == null || srcStatus.is(StatusType.STATUS_UNVERSIONED, StatusType.STATUS_OBSTRUCTED, StatusType.STATUS_MISSING, StatusType.STATUS_EXTERNAL);
    }

    private boolean for16move(File dst, boolean undo) {
        if (undo) {
            this.myUndoingMove = true;
            this.restoreFromUndoStorage(dst);
        }
        return true;
    }

    private void restoreFromUndoStorage(File dst) {
        File[] files;
        String normPath = FileUtil.toSystemIndependentName((String)dst.getPath());
        Iterator<Couple<File>> it = this.myUndoStorageContents.iterator();
        while (it.hasNext()) {
            Couple<File> e = it.next();
            String p = FileUtil.toSystemIndependentName((String)((File)e.first).getPath());
            if (!p.startsWith(normPath)) continue;
            try {
                FileUtil.rename((File)((File)e.second), (File)((File)e.first));
            }
            catch (IOException ex) {
                LOG.error((Throwable)ex);
                FileUtil.asyncDelete((File)((File)e.second));
            }
            it.remove();
        }
        if (this.myStorageForUndo != null && ((files = this.myStorageForUndo.listFiles()) == null || files.length == 0)) {
            FileUtil.asyncDelete((File)this.myStorageForUndo);
            this.myStorageForUndo = null;
        }
    }

    public boolean createFile(@NotNull VirtualFile dir, @NotNull String name) {
        if (dir == null) {
            SvnFileSystemListener.$$$reportNull$$$0(21);
        }
        if (name == null) {
            SvnFileSystemListener.$$$reportNull$$$0(22);
        }
        this.startOperation(dir);
        return this.createItem(dir, name, false, false);
    }

    public boolean createDirectory(@NotNull VirtualFile dir, @NotNull String name) {
        if (dir == null) {
            SvnFileSystemListener.$$$reportNull$$$0(23);
        }
        if (name == null) {
            SvnFileSystemListener.$$$reportNull$$$0(24);
        }
        this.startOperation(dir);
        return this.createItem(dir, name, true, false);
    }

    public boolean delete(@NotNull VirtualFile file) {
        if (file == null) {
            SvnFileSystemListener.$$$reportNull$$$0(25);
        }
        this.startOperation(file);
        SvnVcs vcs = SvnFileSystemListener.getVCS(file);
        if (vcs != null && SvnUtil.isAdminDirectory(file)) {
            return true;
        }
        if (vcs == null) {
            return false;
        }
        VcsShowConfirmationOption.Value value = vcs.getDeleteConfirmation().getValue();
        if (VcsShowConfirmationOption.Value.DO_NOTHING_SILENTLY.equals((Object)value)) {
            return false;
        }
        File ioFile = SvnFileSystemListener.getIOFile(file);
        if (!SvnUtil.isSvnVersioned(vcs, ioFile.getParentFile()) || SvnUtil.isWorkingCopyRoot(ioFile)) {
            return false;
        }
        Status status = SvnFileSystemListener.getFileStatus(vcs, ioFile);
        if (status == null || status.is(StatusType.STATUS_UNVERSIONED, StatusType.STATUS_OBSTRUCTED, StatusType.STATUS_MISSING, StatusType.STATUS_EXTERNAL, StatusType.STATUS_IGNORED)) {
            return false;
        }
        if (status.is(StatusType.STATUS_DELETED)) {
            if (SvnFileSystemListener.isUndo(vcs)) {
                this.moveToUndoStorage(file);
            }
            return true;
        }
        if (this.isAboveSourceOfCopyOrMove(vcs.getProject(), ioFile)) {
            this.myDeletedFiles.putValue((Object)vcs.getProject(), (Object)ioFile);
            return true;
        }
        if (status.is(StatusType.STATUS_ADDED)) {
            try {
                SvnFileSystemListener.createRevertAction(vcs, ioFile, false).execute();
            }
            catch (VcsException vcsException) {}
        } else {
            this.myDeletedFiles.putValue((Object)vcs.getProject(), (Object)ioFile);
            if (file.isDirectory() || SvnFileSystemListener.isUndo(vcs)) {
                return true;
            }
        }
        return false;
    }

    @NotNull
    private static RepeatSvnActionThroughBusy createRevertAction(final @NotNull SvnVcs vcs, final @NotNull File file, final boolean recursive) {
        if (vcs == null) {
            SvnFileSystemListener.$$$reportNull$$$0(26);
        }
        if (file == null) {
            SvnFileSystemListener.$$$reportNull$$$0(27);
        }
        RepeatSvnActionThroughBusy repeatSvnActionThroughBusy = new RepeatSvnActionThroughBusy(){

            @Override
            protected void executeImpl() throws VcsException {
                vcs.getFactory(file).createRevertClient().revert(Collections.singletonList(file), Depth.allOrFiles(recursive), null);
            }
        };
        if (repeatSvnActionThroughBusy == null) {
            SvnFileSystemListener.$$$reportNull$$$0(28);
        }
        return repeatSvnActionThroughBusy;
    }

    @NotNull
    private static RepeatSvnActionThroughBusy createDeleteAction(final @NotNull SvnVcs vcs, final @NotNull File file, final boolean force) {
        if (vcs == null) {
            SvnFileSystemListener.$$$reportNull$$$0(29);
        }
        if (file == null) {
            SvnFileSystemListener.$$$reportNull$$$0(30);
        }
        RepeatSvnActionThroughBusy repeatSvnActionThroughBusy = new RepeatSvnActionThroughBusy(){

            @Override
            protected void executeImpl() throws VcsException {
                vcs.getFactory(file).createDeleteClient().delete(file, force, false, null);
            }
        };
        if (repeatSvnActionThroughBusy == null) {
            SvnFileSystemListener.$$$reportNull$$$0(31);
        }
        return repeatSvnActionThroughBusy;
    }

    private boolean isAboveSourceOfCopyOrMove(Project p, File ioFile) {
        for (MovedFileInfo file : this.myMovedFiles) {
            if (!FileUtil.isAncestor((File)ioFile, (File)file.mySrc, (boolean)false)) continue;
            return true;
        }
        for (AddedFileInfo info2 : this.myAddedFiles.get((Object)p)) {
            if (info2.myCopyFrom == null || !FileUtil.isAncestor((File)ioFile, (File)info2.myCopyFrom, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    private void moveToUndoStorage(VirtualFile file) {
        if (this.myStorageForUndo == null) {
            try {
                this.myStorageForUndo = FileUtil.createTempDirectory((String)"svnUndoStorage", (String)"");
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
                return;
            }
        }
        File tmpFile = FileUtil.findSequentNonexistentFile((File)this.myStorageForUndo, (String)"tmp", (String)"");
        this.myUndoStorageContents.add(0, (Couple<File>)Couple.of((Object)VfsUtilCore.virtualToIoFile((VirtualFile)file), (Object)tmpFile));
        VfsUtilCore.virtualToIoFile((VirtualFile)file).renameTo(tmpFile);
    }

    private boolean createItem(VirtualFile dir, String name, boolean directory, boolean recursive) {
        SvnVcs vcs = SvnFileSystemListener.getVCS(dir);
        if (vcs == null) {
            return false;
        }
        VcsShowConfirmationOption.Value value = vcs.getAddConfirmation().getValue();
        if (VcsShowConfirmationOption.Value.DO_NOTHING_SILENTLY.equals((Object)value)) {
            return false;
        }
        if (SvnFileSystemListener.isUndo(vcs) && SvnUtil.isAdminDirectory(dir, name)) {
            return false;
        }
        File ioDir = SvnFileSystemListener.getIOFile(dir);
        boolean pendingAdd = this.isPendingAdd(vcs.getProject(), dir);
        if (!SvnUtil.isSvnVersioned(vcs, ioDir) && !pendingAdd) {
            return false;
        }
        File targetFile = new File(ioDir, name);
        Status status = SvnFileSystemListener.getFileStatus(vcs, targetFile);
        if (status == null || status.is(StatusType.STATUS_NONE, StatusType.STATUS_UNVERSIONED)) {
            this.myAddedFiles.putValue((Object)vcs.getProject(), (Object)new AddedFileInfo(dir, name, null, recursive));
            return false;
        }
        if (status.is(StatusType.STATUS_MISSING)) {
            return false;
        }
        if (status.is(StatusType.STATUS_DELETED)) {
            NodeKind kind = status.getNodeKind();
            if (directory && !kind.isDirectory() || !directory && !kind.isFile()) {
                return false;
            }
            try {
                if (SvnFileSystemListener.isUndo(vcs)) {
                    SvnFileSystemListener.createRevertAction(vcs, targetFile, false).execute();
                    return true;
                }
                this.myAddedFiles.putValue((Object)vcs.getProject(), (Object)new AddedFileInfo(dir, name, null, recursive));
                return false;
            }
            catch (VcsException e) {
                FileUtil.delete((File)targetFile);
                return false;
            }
        }
        return false;
    }

    private boolean isPendingAdd(Project project, VirtualFile dir) {
        Collection addedFileInfos = this.myAddedFiles.get((Object)project);
        for (AddedFileInfo i : addedFileInfos) {
            if (!Comparing.equal((Object)i.myDir, (Object)dir.getParent()) || !i.myName.equals(dir.getName())) continue;
            return true;
        }
        return false;
    }

    public void commandStarted(@NotNull CommandEvent event) {
        if (event == null) {
            SvnFileSystemListener.$$$reportNull$$$0(32);
        }
        this.myIsInCommand = true;
        this.myUndoingMove = false;
        Project project = event.getProject();
        if (project == null) {
            return;
        }
        this.commandStarted(project);
    }

    void commandStarted(@NotNull Project project) {
        if (project == null) {
            SvnFileSystemListener.$$$reportNull$$$0(33);
        }
        this.myUndoingMove = false;
        this.myMoveExceptions.remove(project);
    }

    public void commandFinished(@NotNull CommandEvent event) {
        if (event == null) {
            SvnFileSystemListener.$$$reportNull$$$0(34);
        }
        this.myIsInCommand = false;
        Project project = event.getProject();
        if (project == null) {
            return;
        }
        this.commandFinished(project);
    }

    void commandFinished(@NotNull Project project) {
        List<VcsException> exceptionList;
        if (project == null) {
            SvnFileSystemListener.$$$reportNull$$$0(35);
        }
        this.checkOverwrites(project);
        if (this.myAddedFiles.containsKey((Object)project)) {
            this.processAddedFiles(project);
        }
        this.processMovedFiles(project);
        if (this.myDeletedFiles.containsKey((Object)project)) {
            this.processDeletedFiles(project);
        }
        if ((exceptionList = this.myMoveExceptions.get(project)) != null && !exceptionList.isEmpty()) {
            AbstractVcsHelper.getInstance((Project)project).showErrors(exceptionList, SvnBundle.message("move.files.errors.title", new Object[0]));
        }
        if (!this.myFilesToRefresh.isEmpty()) {
            this.refreshFiles(project);
        }
    }

    private void checkOverwrites(Project project) {
        Collection addedFileInfos = this.myAddedFiles.get((Object)project);
        Collection deletedFiles = this.myDeletedFiles.get((Object)project);
        if (addedFileInfos.isEmpty() || deletedFiles.isEmpty()) {
            return;
        }
        Iterator iterator = addedFileInfos.iterator();
        while (iterator.hasNext()) {
            AddedFileInfo addedFileInfo = (AddedFileInfo)iterator.next();
            File ioFile = new File(addedFileInfo.myDir.getPath(), addedFileInfo.myName);
            if (!deletedFiles.remove(ioFile)) continue;
            iterator.remove();
        }
    }

    private void refreshFiles(Project project) {
        ArrayList<VirtualFile> toRefreshFiles = new ArrayList<VirtualFile>();
        ArrayList<VirtualFile> toRefreshDirs = new ArrayList<VirtualFile>();
        for (VirtualFile file : this.myFilesToRefresh) {
            if (file == null) continue;
            if (file.isDirectory()) {
                toRefreshDirs.add(file);
                continue;
            }
            toRefreshFiles.add(file);
        }
        SvnFileSystemListener.filterOutInvalid(this.myFilesToRefresh);
        RefreshQueue.getInstance().refresh(true, true, () -> {
            if (project.isDisposed()) {
                return;
            }
            SvnFileSystemListener.filterOutInvalid(toRefreshFiles);
            SvnFileSystemListener.filterOutInvalid(toRefreshDirs);
            VcsDirtyScopeManager vcsDirtyScopeManager = VcsDirtyScopeManager.getInstance((Project)project);
            vcsDirtyScopeManager.filesDirty((Collection)toRefreshFiles, (Collection)toRefreshDirs);
        }, this.myFilesToRefresh);
        this.myFilesToRefresh.clear();
    }

    private static void filterOutInvalid(@NotNull Collection<VirtualFile> files) {
        if (files == null) {
            SvnFileSystemListener.$$$reportNull$$$0(36);
        }
        Iterator<VirtualFile> iterator = files.iterator();
        while (iterator.hasNext()) {
            VirtualFile file = iterator.next();
            if (file == null) {
                iterator.remove();
                continue;
            }
            if (file.isValid() && file.exists()) continue;
            LOG.info("Refresh root is not valid: " + file.getPath());
            iterator.remove();
        }
    }

    private void processAddedFiles(Project project) {
        SvnVcs vcs = SvnVcs.getInstance(project);
        ArrayList addedVFiles = new ArrayList();
        HashMap<VirtualFile, File> copyFromMap = new HashMap<VirtualFile, File>();
        HashSet recursiveItems = new HashSet();
        this.fillAddedFiles(project, vcs, addedVFiles, copyFromMap, recursiveItems);
        if (addedVFiles.isEmpty()) {
            return;
        }
        VcsShowConfirmationOption.Value value = vcs.getAddConfirmation().getValue();
        if (value != VcsShowConfirmationOption.Value.DO_NOTHING_SILENTLY) {
            SvnFileSystemListener.runNotUnderWriteAction(project, () -> {
                AbstractVcsHelper vcsHelper = AbstractVcsHelper.getInstance((Project)project);
                Collection<VirtualFile> filesToProcess = SvnFileSystemListener.promptAboutAddition(vcs, addedVFiles, value, vcsHelper);
                if (filesToProcess != null && !filesToProcess.isEmpty()) {
                    ArrayList exceptions = new ArrayList();
                    SvnFileSystemListener.runInBackground(project, "Adding files to Subversion", SvnFileSystemListener.createAdditionRunnable(project, vcs, copyFromMap, filesToProcess, exceptions));
                    if (!exceptions.isEmpty()) {
                        vcsHelper.showErrors(exceptions, SvnBundle.message("add.files.errors.title", new Object[0]));
                    }
                }
            });
        }
    }

    private static void runNotUnderWriteAction(@NotNull Project project, @NotNull Runnable runnable) {
        Application application;
        if (project == null) {
            SvnFileSystemListener.$$$reportNull$$$0(37);
        }
        if (runnable == null) {
            SvnFileSystemListener.$$$reportNull$$$0(38);
        }
        if ((application = ApplicationManager.getApplication()).isWriteAccessAllowed()) {
            application.invokeLater(runnable, project.getDisposed());
        } else {
            runnable.run();
        }
    }

    private static void runInBackground(Project project, String name, Runnable runnable) {
        if (ApplicationManager.getApplication().isDispatchThread()) {
            ProgressManager.getInstance().runProcessWithProgressSynchronously(runnable, name, false, project);
        } else {
            runnable.run();
        }
    }

    private static Runnable createAdditionRunnable(Project project, final SvnVcs vcs, Map<VirtualFile, File> copyFromMap, Collection<? extends VirtualFile> filesToProcess, List<? super VcsException> exceptions) {
        return () -> {
            for (VirtualFile file : filesToProcess) {
                final File ioFile = VfsUtilCore.virtualToIoFile((VirtualFile)file);
                try {
                    final File copyFrom = (File)copyFromMap.get(file);
                    if (copyFrom != null) {
                        try {
                            new ActionWithTempFile(ioFile){

                                protected void executeInternal() throws VcsException {
                                    new RepeatSvnActionThroughBusy(){

                                        @Override
                                        protected void executeImpl() throws VcsException {
                                            vcs.getFactory(copyFrom).createCopyMoveClient().copy(copyFrom, ioFile, true, false);
                                        }
                                    }.execute();
                                }
                            }.execute();
                        }
                        catch (VcsException e) {
                            exceptions.add(e);
                        }
                    } else {
                        new RepeatSvnActionThroughBusy(){

                            @Override
                            protected void executeImpl() throws VcsException {
                                vcs.getFactory(ioFile).createAddClient().add(ioFile, null, false, false, true, null);
                            }
                        }.execute();
                    }
                    VcsDirtyScopeManager.getInstance((Project)project).fileDirty(file);
                }
                catch (VcsException e) {
                    exceptions.add(e);
                }
            }
        };
    }

    private static Collection<VirtualFile> promptAboutAddition(SvnVcs vcs, List<VirtualFile> addedVFiles, VcsShowConfirmationOption.Value value, AbstractVcsHelper vcsHelper) {
        Collection<Object> filesToProcess;
        if (value == VcsShowConfirmationOption.Value.DO_ACTION_SILENTLY) {
            filesToProcess = addedVFiles;
        } else {
            String singleFilePrompt = addedVFiles.size() == 1 && addedVFiles.get(0).isDirectory() ? SvnBundle.getString("confirmation.text.add.dir") : SvnBundle.getString("confirmation.text.add.file");
            filesToProcess = vcsHelper.selectFilesToProcess(addedVFiles, SvnBundle.message("confirmation.title.add.multiple.files", new Object[0]), null, SvnBundle.message("confirmation.title.add.file", new Object[0]), singleFilePrompt, vcs.getAddConfirmation());
        }
        return filesToProcess;
    }

    private void fillAddedFiles(Project project, SvnVcs vcs, List<? super VirtualFile> addedVFiles, Map<VirtualFile, File> copyFromMap, Set<? super VirtualFile> recursiveItems) {
        Collection addedFileInfos = this.myAddedFiles.remove((Object)project);
        ChangeListManager changeListManager = ChangeListManager.getInstance((Project)project);
        for (AddedFileInfo addedFileInfo : addedFileInfos) {
            boolean isIgnored;
            Status fileStatus;
            File ioFile = new File(SvnFileSystemListener.getIOFile(addedFileInfo.myDir), addedFileInfo.myName);
            VirtualFile addedFile = addedFileInfo.myDir.findChild(addedFileInfo.myName);
            if (addedFile == null) {
                addedFile = this.myLfs.refreshAndFindFileByIoFile(ioFile);
            }
            if (addedFile == null || (fileStatus = SvnFileSystemListener.getFileStatus(vcs, ioFile)) != null && fileStatus.is(StatusType.STATUS_IGNORED) || (isIgnored = changeListManager.isIgnoredFile(addedFile))) continue;
            addedVFiles.add((VirtualFile)addedFile);
            copyFromMap.put(addedFile, addedFileInfo.myCopyFrom);
            if (!addedFileInfo.myRecursive) continue;
            recursiveItems.add((VirtualFile)addedFile);
        }
    }

    private void processDeletedFiles(Project project) {
        ArrayList deletedFiles = new ArrayList();
        ArrayList<FilePath> filesToProcess = new ArrayList<FilePath>();
        ArrayList<VcsException> exceptions = new ArrayList<VcsException>();
        AbstractVcsHelper vcsHelper = AbstractVcsHelper.getInstance((Project)project);
        try {
            this.fillDeletedFiles(project, deletedFiles, filesToProcess);
            if (deletedFiles.isEmpty() && filesToProcess.isEmpty() || this.myUndoingMove) {
                return;
            }
            SvnVcs vcs = SvnVcs.getInstance(project);
            VcsShowConfirmationOption.Value value = vcs.getDeleteConfirmation().getValue();
            if (value != VcsShowConfirmationOption.Value.DO_NOTHING_SILENTLY) {
                Collection<FilePath> confirmed;
                if (!deletedFiles.isEmpty() && (confirmed = SvnFileSystemListener.promptAboutDeletion(deletedFiles, vcs, value, vcsHelper)) != null) {
                    filesToProcess.addAll(confirmed);
                }
                if (!filesToProcess.isEmpty()) {
                    SvnFileSystemListener.runInBackground(project, "Deleting files from Subversion", SvnFileSystemListener.createDeleteRunnable(project, vcs, filesToProcess, exceptions));
                }
                List deletedFilesFiles = ContainerUtil.map(deletedFiles, (Function)Functions.pairFirst());
                for (FilePath file : deletedFilesFiles) {
                    FilePath parent = file.getParentPath();
                    if (parent == null) continue;
                    this.myFilesToRefresh.add(parent.getVirtualFile());
                }
                deletedFilesFiles.removeAll(filesToProcess);
                for (FilePath file : deletedFilesFiles) {
                    FileUtil.delete((File)file.getIOFile());
                }
            }
        }
        catch (VcsException e) {
            exceptions.add(e);
        }
        if (!exceptions.isEmpty()) {
            vcsHelper.showErrors(exceptions, SvnBundle.message("delete.files.errors.title", new Object[0]));
        }
    }

    private static Runnable createDeleteRunnable(Project project, SvnVcs vcs, Collection<? extends FilePath> filesToProcess, List<? super VcsException> exceptions) {
        return () -> {
            for (FilePath file : filesToProcess) {
                VirtualFile vFile = file.getVirtualFile();
                File ioFile = new File(file.getPath());
                try {
                    SvnFileSystemListener.createDeleteAction(vcs, ioFile, true).execute();
                    if (vFile != null && vFile.isValid() && vFile.isDirectory()) {
                        vFile.refresh(true, true);
                        VcsDirtyScopeManager.getInstance((Project)project).dirDirtyRecursively(vFile);
                        continue;
                    }
                    VcsDirtyScopeManager.getInstance((Project)project).fileDirty(file);
                }
                catch (VcsException e) {
                    exceptions.add(e);
                }
            }
        };
    }

    private static Collection<FilePath> promptAboutDeletion(List<? extends Pair<FilePath, WorkingCopyFormat>> deletedFiles, SvnVcs vcs, VcsShowConfirmationOption.Value value, AbstractVcsHelper vcsHelper) {
        List filesToProcess;
        if (value == VcsShowConfirmationOption.Value.DO_ACTION_SILENTLY) {
            filesToProcess = ContainerUtil.map(deletedFiles, (Function)Functions.pairFirst());
        } else {
            String singleFilePrompt = deletedFiles.size() == 1 && ((FilePath)deletedFiles.get(0).getFirst()).isDirectory() ? (((WorkingCopyFormat)((Object)deletedFiles.get(0).getSecond())).isOrGreater(WorkingCopyFormat.ONE_DOT_SEVEN) ? SvnBundle.getString("confirmation.text.delete.dir.17") : SvnBundle.getString("confirmation.text.delete.dir")) : SvnBundle.getString("confirmation.text.delete.file");
            Collection files = vcsHelper.selectFilePathsToProcess(ContainerUtil.map(deletedFiles, (Function)Functions.pairFirst()), SvnBundle.message("confirmation.title.delete.multiple.files", new Object[0]), null, SvnBundle.message("confirmation.title.delete.file", new Object[0]), singleFilePrompt, vcs.getDeleteConfirmation());
            filesToProcess = files == null ? null : new ArrayList(files);
        }
        return filesToProcess;
    }

    private void fillDeletedFiles(Project project, List<? super Pair<FilePath, WorkingCopyFormat>> deletedFiles, Collection<? super FilePath> deleteAnyway) throws VcsException {
        final SvnVcs vcs = SvnVcs.getInstance(project);
        Collection files = this.myDeletedFiles.remove((Object)project);
        for (final File file : files) {
            Status status = (Status)new RepeatSvnActionThroughBusy(){

                @Override
                protected void executeImpl() throws VcsException {
                    this.myT = vcs.getFactory(file).createStatusClient().doStatus(file, false);
                }
            }.compute();
            FilePath filePath = VcsUtil.getFilePath((File)file);
            if (status.is(StatusType.STATUS_ADDED)) {
                deleteAnyway.add((FilePath)filePath);
                continue;
            }
            deletedFiles.add((Pair<FilePath, WorkingCopyFormat>)Pair.create((Object)filePath, (Object)((Object)vcs.getWorkingCopyFormat(file))));
        }
    }

    private void processMovedFiles(Project project) {
        if (this.myMovedFiles.isEmpty()) {
            return;
        }
        Runnable runnable = () -> {
            Iterator<MovedFileInfo> iterator = this.myMovedFiles.iterator();
            while (iterator.hasNext()) {
                MovedFileInfo movedFileInfo = iterator.next();
                if (movedFileInfo.myProject != project) continue;
                this.doMove(SvnVcs.getInstance(project), movedFileInfo.mySrc, movedFileInfo.myDst);
                iterator.remove();
            }
        };
        SvnFileSystemListener.runInBackground(project, "Moving files in Subversion", runnable);
    }

    @Nullable
    private static SvnVcs getVCS(@NotNull VirtualFile file) {
        Project[] projects;
        if (file == null) {
            SvnFileSystemListener.$$$reportNull$$$0(39);
        }
        for (Project project : projects = ProjectManager.getInstance().getOpenProjects()) {
            AbstractVcs vcs = ProjectLevelVcsManager.getInstance((Project)project).getVcsFor(file);
            if (!(vcs instanceof SvnVcs)) continue;
            return (SvnVcs)vcs;
        }
        return null;
    }

    @NotNull
    private static File getIOFile(@NotNull VirtualFile vf) {
        if (vf == null) {
            SvnFileSystemListener.$$$reportNull$$$0(40);
        }
        File file = VfsUtilCore.virtualToIoFile((VirtualFile)vf).getAbsoluteFile();
        if (file == null) {
            SvnFileSystemListener.$$$reportNull$$$0(41);
        }
        return file;
    }

    @Nullable
    private static Status getFileStatus(final @NotNull SvnVcs vcs, final @NotNull File file) {
        if (vcs == null) {
            SvnFileSystemListener.$$$reportNull$$$0(42);
        }
        if (file == null) {
            SvnFileSystemListener.$$$reportNull$$$0(43);
        }
        try {
            return (Status)new RepeatSvnActionThroughBusy(){

                @Override
                protected void executeImpl() throws VcsException {
                    this.myT = vcs.getFactory(file).createStatusClient().doStatus(file, false);
                }
            }.compute();
        }
        catch (VcsException e) {
            return null;
        }
    }

    private static boolean isUndo(@NotNull SvnVcs vcs) {
        if (vcs == null) {
            SvnFileSystemListener.$$$reportNull$$$0(44);
        }
        Project p = vcs.getProject();
        return UndoManager.getInstance((Project)p).isUndoInProgress();
    }

    public void startOperation(@NotNull VirtualFile file) {
        if (file == null) {
            SvnFileSystemListener.$$$reportNull$$$0(45);
        }
        if (!this.myIsInCommand) {
            this.myGuessedProject = ProjectLocator.getInstance().guessProjectForFile(file);
            if (this.myGuessedProject != null) {
                this.commandStarted(this.myGuessedProject);
            }
        }
    }

    public void afterDone(@NotNull ThrowableConsumer<LocalFileOperationsHandler, IOException> invoker) {
        if (invoker == null) {
            SvnFileSystemListener.$$$reportNull$$$0(46);
        }
        if (!this.myIsInCommand && this.myGuessedProject != null) {
            this.commandFinished(this.myGuessedProject);
            this.myGuessedProject = null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 28: 
            case 31: 
            case 41: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 28: 
            case 31: 
            case 41: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: 
            case 5: 
            case 28: 
            case 31: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/svn/SvnFileSystemListener";
                break;
            }
            case 6: 
            case 12: 
            case 14: 
            case 20: 
            case 25: 
            case 27: 
            case 30: 
            case 39: 
            case 43: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toDir";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "copyName";
                break;
            }
            case 9: 
            case 16: 
            case 19: 
            case 26: 
            case 29: 
            case 42: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "srcDir";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dstDir";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "src";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dst";
                break;
            }
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 32: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vf";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "invoker";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/svn/SvnFileSystemListener";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "handleMoveException";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createMoveTargetExistsError";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "createRevertAction";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "createDeleteAction";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getIOFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addToMoveExceptions";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "handleMoveException";
                break;
            }
            case 3: 
            case 5: 
            case 28: 
            case 31: 
            case 41: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createMoveTargetExistsError";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "copy";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "sameRoot";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "move";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "rename";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "doMove";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isUnversioned";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "createFile";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "createDirectory";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "delete";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "createRevertAction";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "createDeleteAction";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "commandStarted";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "commandFinished";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "filterOutInvalid";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "runNotUnderWriteAction";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getVCS";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getIOFile";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getFileStatus";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "isUndo";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "startOperation";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "afterDone";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 28: 
            case 31: 
            case 41: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class UUIDHelper {
        private final SvnVcs myVcs;

        private UUIDHelper(SvnVcs vcs) {
            if (vcs == null) {
                UUIDHelper.$$$reportNull$$$0(0);
            }
            this.myVcs = vcs;
        }

        @Nullable
        public String getRepositoryUUID(@NotNull Project project, final @NotNull VirtualFile dir) {
            block7: {
                if (project == null) {
                    UUIDHelper.$$$reportNull$$$0(1);
                }
                if (dir == null) {
                    UUIDHelper.$$$reportNull$$$0(2);
                }
                try {
                    Info info1 = (Info)new RepeatSvnActionThroughBusy(){

                        @Override
                        protected void executeImpl() {
                            this.myT = UUIDHelper.this.myVcs.getInfo(VfsUtilCore.virtualToIoFile((VirtualFile)dir));
                        }
                    }.compute();
                    if (info1 == null || info1.getRepositoryId() == null) {
                        VirtualFile parent = dir.getParent();
                        if (parent == null) {
                            return null;
                        }
                        if (SvnFileSystemListener.this.isPendingAdd(project, parent)) {
                            return this.getRepositoryUUID(project, parent);
                        }
                        break block7;
                    }
                    return info1.getRepositoryId();
                }
                catch (VcsException vcsException) {
                    // empty catch block
                }
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "vcs";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dir";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/idea/svn/SvnFileSystemListener$UUIDHelper";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getRepositoryUUID";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MovedFileInfo {
        private final Project myProject;
        private final File mySrc;
        private final File myDst;

        private MovedFileInfo(@NotNull Project project, @NotNull File src, @NotNull File dst) {
            if (project == null) {
                MovedFileInfo.$$$reportNull$$$0(0);
            }
            if (src == null) {
                MovedFileInfo.$$$reportNull$$$0(1);
            }
            if (dst == null) {
                MovedFileInfo.$$$reportNull$$$0(2);
            }
            this.myProject = project;
            this.mySrc = src;
            this.myDst = dst;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "src";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "dst";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/idea/svn/SvnFileSystemListener$MovedFileInfo";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class AddedFileInfo {
        private final VirtualFile myDir;
        private final String myName;
        @Nullable
        private final File myCopyFrom;
        private final boolean myRecursive;

        AddedFileInfo(@NotNull VirtualFile dir, @NotNull String name, @Nullable File copyFrom, boolean recursive) {
            if (dir == null) {
                AddedFileInfo.$$$reportNull$$$0(0);
            }
            if (name == null) {
                AddedFileInfo.$$$reportNull$$$0(1);
            }
            this.myDir = dir;
            this.myName = name;
            this.myCopyFrom = copyFrom;
            this.myRecursive = recursive;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "dir";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "name";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/idea/svn/SvnFileSystemListener$AddedFileInfo";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

