/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn;

import com.intellij.openapi.util.ClearableLazyValue;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.RootUrlInfo;
import org.jetbrains.idea.svn.api.Url;

public class SvnMapping {
    private static final Comparator<String> FILE_PATHS_COMPARATOR = (path1, path2) -> FileUtil.comparePaths((String)path1, (String)path2);
    @NotNull
    private final List<VirtualFile> myLonelyRoots = new ArrayList<VirtualFile>();
    @NotNull
    private final TreeMap<String, RootUrlInfo> myFile2UrlMap = new TreeMap(FILE_PATHS_COMPARATOR);
    @NotNull
    private final Map<Url, RootUrlInfo> myUrl2FileMap = new HashMap<Url, RootUrlInfo>();
    @NotNull
    private final ClearableLazyValue<List<VirtualFile>> myPreCalculatedUnderVcsRoots = new ClearableLazyValue<List<VirtualFile>>(){

        @NotNull
        protected List<VirtualFile> compute() {
            List list = ContainerUtil.map(SvnMapping.this.myFile2UrlMap.values(), RootUrlInfo::getVirtualFile);
            if (list == null) {
                1.$$$reportNull$$$0(0);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/SvnMapping$1", "compute"));
        }
    };

    public void copyFrom(@NotNull SvnMapping other) {
        if (other == null) {
            SvnMapping.$$$reportNull$$$0(0);
        }
        this.myFile2UrlMap.clear();
        this.myUrl2FileMap.clear();
        this.myLonelyRoots.clear();
        this.myFile2UrlMap.putAll(other.myFile2UrlMap);
        this.myUrl2FileMap.putAll(other.myUrl2FileMap);
        this.myLonelyRoots.addAll(other.myLonelyRoots);
        this.myPreCalculatedUnderVcsRoots.drop();
    }

    public void addAll(@NotNull Collection<RootUrlInfo> roots) {
        if (roots == null) {
            SvnMapping.$$$reportNull$$$0(1);
        }
        roots.forEach(this::add);
    }

    public void add(@NotNull RootUrlInfo rootInfo) {
        if (rootInfo == null) {
            SvnMapping.$$$reportNull$$$0(2);
        }
        this.myFile2UrlMap.put(rootInfo.getPath(), rootInfo);
        this.myUrl2FileMap.put(rootInfo.getUrl(), rootInfo);
    }

    @NotNull
    public List<VirtualFile> getUnderVcsRoots() {
        List list = (List)this.myPreCalculatedUnderVcsRoots.getValue();
        if (list == null) {
            SvnMapping.$$$reportNull$$$0(3);
        }
        return list;
    }

    @NotNull
    public List<RootUrlInfo> getAllCopies() {
        ArrayList<RootUrlInfo> arrayList = new ArrayList<RootUrlInfo>(this.myFile2UrlMap.values());
        if (arrayList == null) {
            SvnMapping.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    @Nullable
    public String getRootForPath(@NotNull String path) {
        if (path == null) {
            SvnMapping.$$$reportNull$$$0(5);
        }
        return (String)ContainerUtil.find(this.myFile2UrlMap.headMap(path, true).descendingKeySet(), root -> SystemInfo.isFileSystemCaseSensitive ? path.startsWith((String)root) : StringUtil.startsWithIgnoreCase((String)path, (String)root));
    }

    @NotNull
    public Collection<Url> getUrls() {
        Set<Url> set = this.myUrl2FileMap.keySet();
        if (set == null) {
            SvnMapping.$$$reportNull$$$0(6);
        }
        return set;
    }

    @Nullable
    public RootUrlInfo byFile(@NotNull String path) {
        if (path == null) {
            SvnMapping.$$$reportNull$$$0(7);
        }
        return this.myFile2UrlMap.get(path);
    }

    @Nullable
    public RootUrlInfo byUrl(@NotNull Url url) {
        if (url == null) {
            SvnMapping.$$$reportNull$$$0(8);
        }
        return this.myUrl2FileMap.get(url);
    }

    public boolean isEmpty() {
        return this.myUrl2FileMap.isEmpty();
    }

    public void reportLonelyRoots(@NotNull Collection<VirtualFile> roots) {
        if (roots == null) {
            SvnMapping.$$$reportNull$$$0(9);
        }
        this.myLonelyRoots.addAll(roots);
    }

    @NotNull
    public List<VirtualFile> getLonelyRoots() {
        List<VirtualFile> list = this.myLonelyRoots;
        if (list == null) {
            SvnMapping.$$$reportNull$$$0(10);
        }
        return list;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SvnMapping mapping = (SvnMapping)o;
        if (!this.myFile2UrlMap.equals(mapping.myFile2UrlMap)) {
            return false;
        }
        if (!this.myLonelyRoots.equals(mapping.myLonelyRoots)) {
            return false;
        }
        return this.myUrl2FileMap.equals(mapping.myUrl2FileMap);
    }

    public int hashCode() {
        int result = this.myLonelyRoots.hashCode();
        result = 31 * result + this.myFile2UrlMap.hashCode();
        result = 31 * result + this.myUrl2FileMap.hashCode();
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "other";
                break;
            }
            case 1: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootInfo";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/svn/SvnMapping";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/svn/SvnMapping";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnderVcsRoots";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllCopies";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getUrls";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getLonelyRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "copyFrom";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "addAll";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 10: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getRootForPath";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "byFile";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "byUrl";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "reportLonelyRoots";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

