/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.configmanagement.editor;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.hash.HashMap;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.CharUtils;
import org.editorconfig.language.psi.EditorConfigHeader;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="EditorConfigPreviewManager", storages={@Storage(value="$WORKSPACE_FILE$")})
public class EditorConfigPreviewManager
implements PersistentStateComponent<Element> {
    private final Map<String, String> myPreviewMap = new HashMap();
    public static final String PREVIEW_RECORD_TAG = "editorConfig";
    public static final String EDITORCONFIG_FILE_ATTR = "file";
    public static final String PREVIEW_FILE_ATTR = "previewFile";

    @Nullable
    public Element getState() {
        Element state = new Element("previewData");
        for (String key : this.myPreviewMap.keySet()) {
            String value = this.myPreviewMap.get(key);
            if (value == null) continue;
            Element previewRec = new Element(PREVIEW_RECORD_TAG);
            previewRec.setAttribute(EDITORCONFIG_FILE_ATTR, key);
            previewRec.setAttribute(PREVIEW_FILE_ATTR, value);
            state.addContent(previewRec);
        }
        return state;
    }

    public void loadState(@NotNull Element state) {
        if (state == null) {
            EditorConfigPreviewManager.$$$reportNull$$$0(0);
        }
        for (Element previewRec : state.getChildren(PREVIEW_RECORD_TAG)) {
            String key = previewRec.getAttributeValue(EDITORCONFIG_FILE_ATTR);
            String value = previewRec.getAttributeValue(PREVIEW_FILE_ATTR);
            if (key == null || value == null) continue;
            this.myPreviewMap.put(key, value);
        }
    }

    public static EditorConfigPreviewManager getInstance(@NotNull Project project) {
        if (project == null) {
            EditorConfigPreviewManager.$$$reportNull$$$0(1);
        }
        return (EditorConfigPreviewManager)ServiceManager.getService((Project)project, EditorConfigPreviewManager.class);
    }

    @NotNull
    static List<String> extractExtensions(@NotNull EditorConfigHeader header) {
        if (header == null) {
            EditorConfigPreviewManager.$$$reportNull$$$0(2);
        }
        ArrayList<String> extensions = new ArrayList<String>();
        CharSequence headerChars = header.getNode().getChars();
        boolean isInExt = false;
        StringBuilder extBuilder = new StringBuilder();
        for (int i = 0; i < headerChars.length(); ++i) {
            char c = headerChars.charAt(i);
            if (c == '.') {
                isInExt = true;
                continue;
            }
            if ((CharUtils.isAsciiAlpha((char)c) || CharUtils.isAsciiNumeric((char)c)) && isInExt) {
                extBuilder.append(c);
                continue;
            }
            if (isInExt && extBuilder.length() > 0) {
                extensions.add(extBuilder.toString());
                extBuilder = new StringBuilder();
            }
            isInExt = false;
        }
        ArrayList<String> arrayList = extensions;
        if (arrayList == null) {
            EditorConfigPreviewManager.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    public void associateWithPreviewFile(@NotNull VirtualFile editorConfigFile, @Nullable VirtualFile previewFile) {
        if (editorConfigFile == null) {
            EditorConfigPreviewManager.$$$reportNull$$$0(4);
        }
        if (previewFile != null) {
            this.myPreviewMap.put(editorConfigFile.getPath(), previewFile.getPath());
        } else {
            this.myPreviewMap.remove(editorConfigFile.getPath());
        }
    }

    @Nullable
    public VirtualFile getAssociatedPreviewFile(@NotNull VirtualFile editorConfigFile) {
        String editorConfigFilePath;
        String previewPathStr;
        if (editorConfigFile == null) {
            EditorConfigPreviewManager.$$$reportNull$$$0(5);
        }
        if ((previewPathStr = this.myPreviewMap.get(editorConfigFilePath = editorConfigFile.getPath())) != null) {
            Path previewPath = Paths.get(previewPathStr, new String[0]);
            VirtualFile actualFile = VfsUtil.findFile((Path)previewPath, (boolean)true);
            if (actualFile == null) {
                this.myPreviewMap.remove(editorConfigFilePath);
            }
            return actualFile;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "header";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/editorconfig/configmanagement/editor/EditorConfigPreviewManager";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editorConfigFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/editorconfig/configmanagement/editor/EditorConfigPreviewManager";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "extractExtensions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "extractExtensions";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "associateWithPreviewFile";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getAssociatedPreviewFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

