/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.language;

import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.textmate.language.TextMateScopeSelectorOwner;
import org.jetbrains.plugins.textmate.language.syntax.selector.TextMateSelectorCachingWeigher;
import org.jetbrains.plugins.textmate.language.syntax.selector.TextMateSelectorWeigher;
import org.jetbrains.plugins.textmate.language.syntax.selector.TextMateSelectorWeigherImpl;
import org.jetbrains.plugins.textmate.language.syntax.selector.TextMateWeigh;

public class TextMateScopeComparator<T extends TextMateScopeSelectorOwner>
implements Comparator<T> {
    @NotNull
    private static final TextMateSelectorWeigher myWeigher = new TextMateSelectorCachingWeigher(new TextMateSelectorWeigherImpl());
    @NotNull
    private final String myScope;

    public TextMateScopeComparator(@NotNull String scope) {
        if (scope == null) {
            TextMateScopeComparator.$$$reportNull$$$0(0);
        }
        this.myScope = scope;
    }

    @Override
    public int compare(T first, T second) {
        return myWeigher.weigh(first.getScopeSelector(), this.myScope).compareTo(myWeigher.weigh(second.getScopeSelector(), this.myScope));
    }

    @NotNull
    public List<T> sortAndFilter(@NotNull Collection<? extends T> objects) {
        if (objects == null) {
            TextMateScopeComparator.$$$reportNull$$$0(1);
        }
        List list = ContainerUtil.reverse((List)ContainerUtil.sorted((Collection)ContainerUtil.filter(objects, t -> TextMateScopeComparator.myWeigher.weigh((String)t.getScopeSelector(), (String)this.myScope).weigh > 0), (Comparator)this));
        if (list == null) {
            TextMateScopeComparator.$$$reportNull$$$0(2);
        }
        return list;
    }

    @Nullable
    public T max(Collection<T> objects) {
        TextMateWeigh max = TextMateWeigh.ZERO;
        TextMateScopeSelectorOwner result = null;
        for (TextMateScopeSelectorOwner object : objects) {
            TextMateWeigh weigh = myWeigher.weigh(object.getScopeSelector(), this.myScope);
            if (weigh.weigh <= 0 || weigh.compareTo(max) <= 0) continue;
            max = weigh;
            result = object;
        }
        return (T)result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objects";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/textmate/language/TextMateScopeComparator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/textmate/language/TextMateScopeComparator";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "sortAndFilter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "sortAndFilter";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

