/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.language.syntax.highlighting;

import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.TextAttributes;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.textmate.language.PreferencesReadUtil;
import org.jetbrains.plugins.textmate.language.syntax.highlighting.TextMateDefaultColorsProvider;
import org.jetbrains.plugins.textmate.plist.PListValue;
import org.jetbrains.plugins.textmate.plist.Plist;

public class TextMateTheme {
    public static final TextMateDefaultColorsProvider DEFAULT_COLORS_PROVIDER = new TextMateDefaultColorsProvider();
    public static final String DEFAULT_ATTRIBUTES_NAME = "textmate.default";
    public static final TextMateTheme EMPTY_THEME = new TextMateTheme("Unnamed", new HashMap<String, TextAttributes>(), TextAttributes.ERASE_MARKER);
    private final String name;
    private final Map<String, TextAttributes> myTextAttributes;
    @NotNull
    private final TextAttributes myDefaultAttributes;

    protected TextMateTheme(String name, Map<String, TextAttributes> textAttributes, @NotNull TextAttributes defaultAttributes) {
        if (defaultAttributes == null) {
            TextMateTheme.$$$reportNull$$$0(0);
        }
        this.name = name;
        this.myTextAttributes = textAttributes;
        this.myDefaultAttributes = defaultAttributes;
        this.initDefaultColors();
    }

    private void initDefaultColors() {
        for (String key : DEFAULT_COLORS_PROVIDER.getAllDefaultKeys()) {
            if (this.myTextAttributes.containsKey(key)) continue;
            this.myTextAttributes.put(key, DEFAULT_COLORS_PROVIDER.getTextAttributes(key));
        }
    }

    public Color getDefaultBackground() {
        return this.myDefaultAttributes.getBackgroundColor();
    }

    public String getName() {
        return this.name;
    }

    public Set<String> getRules() {
        return this.myTextAttributes.keySet();
    }

    public TextAttributesKey getTextAttributesKey(String highlightingRule) {
        String key = this.getName() + "." + highlightingRule;
        return TextAttributesKey.createTextAttributesKey((String)key, (TextAttributes)this.getTextAttributes(highlightingRule));
    }

    private TextAttributes getTextAttributes(String highlightingRule) {
        return this.myTextAttributes.getOrDefault(highlightingRule, this.myDefaultAttributes);
    }

    @NotNull
    public static TextMateTheme load(Plist plist) {
        String themeName = plist.getPlistValue("name", "Unnamed").getString();
        HashMap<String, TextAttributes> attributes = new HashMap<String, TextAttributes>();
        PListValue settings = plist.getPlistValue("settings");
        if (settings == null) {
            TextMateTheme textMateTheme = EMPTY_THEME;
            if (textMateTheme == null) {
                TextMateTheme.$$$reportNull$$$0(1);
            }
            return textMateTheme;
        }
        TextAttributes defaultAttributes = new TextAttributes();
        for (PListValue colorDefinition : settings.getArray()) {
            Plist colorDefinitionPlist = colorDefinition.getPlist();
            String scope = colorDefinitionPlist.getPlistValue("scope", "").getString();
            Plist colorRuleSettings = colorDefinitionPlist.getPlistValue("settings", Plist.EMPTY_PLIST).getPlist();
            if (scope.isEmpty()) {
                PreferencesReadUtil.fillTextAttributes(defaultAttributes, colorRuleSettings, defaultAttributes.getBackgroundColor());
                continue;
            }
            TextAttributes textAttributes = new TextAttributes();
            PreferencesReadUtil.fillTextAttributes(textAttributes, colorRuleSettings, defaultAttributes.getBackgroundColor());
            attributes.put(scope, textAttributes);
        }
        TextMateTheme textMateTheme = new TextMateTheme(themeName, attributes, defaultAttributes);
        if (textMateTheme == null) {
            TextMateTheme.$$$reportNull$$$0(2);
        }
        return textMateTheme;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultAttributes";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/textmate/language/syntax/highlighting/TextMateTheme";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/textmate/language/syntax/highlighting/TextMateTheme";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "load";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

