/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.command;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.zmlx.hg4idea.HgVcsMessages;
import org.zmlx.hg4idea.action.HgCommandResultNotifier;
import org.zmlx.hg4idea.execution.HgCommandExecutor;
import org.zmlx.hg4idea.execution.HgCommandResult;
import org.zmlx.hg4idea.repo.HgRepository;
import org.zmlx.hg4idea.util.HgErrorUtil;
import org.zmlx.hg4idea.util.HgUtil;

public class HgBookmarkCommand {
    public static void createBookmarkAsynchronously(final @NotNull List<? extends HgRepository> repositories, final @NotNull String name, final boolean isActive) {
        if (repositories == null) {
            HgBookmarkCommand.$$$reportNull$$$0(0);
        }
        if (name == null) {
            HgBookmarkCommand.$$$reportNull$$$0(1);
        }
        final Project project = ((HgRepository)ObjectUtils.assertNotNull((Object)ContainerUtil.getFirstItem(repositories))).getProject();
        if (StringUtil.isEmptyOrSpaces((String)name)) {
            VcsNotifier.getInstance((Project)project).notifyError("Hg Error", "Bookmark name is empty");
            return;
        }
        new Task.Backgroundable(project, HgVcsMessages.message("hg4idea.progress.bookmark", name)){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                for (HgRepository repository : repositories) {
                    HgBookmarkCommand.executeBookmarkCommandSynchronously(project, repository.getRoot(), name, isActive ? ContainerUtil.emptyList() : Collections.singletonList("--inactive"));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/zmlx/hg4idea/command/HgBookmarkCommand$1", "run"));
            }
        }.queue();
    }

    public static void deleteBookmarkSynchronously(@NotNull Project project, @NotNull VirtualFile repo, @NotNull String name) {
        if (project == null) {
            HgBookmarkCommand.$$$reportNull$$$0(2);
        }
        if (repo == null) {
            HgBookmarkCommand.$$$reportNull$$$0(3);
        }
        if (name == null) {
            HgBookmarkCommand.$$$reportNull$$$0(4);
        }
        HgBookmarkCommand.executeBookmarkCommandSynchronously(project, repo, name, Collections.singletonList("-d"));
    }

    private static void executeBookmarkCommandSynchronously(@NotNull Project project, @NotNull VirtualFile repositoryRoot, @NotNull String name, @NotNull List<String> args) {
        if (project == null) {
            HgBookmarkCommand.$$$reportNull$$$0(5);
        }
        if (repositoryRoot == null) {
            HgBookmarkCommand.$$$reportNull$$$0(6);
        }
        if (name == null) {
            HgBookmarkCommand.$$$reportNull$$$0(7);
        }
        if (args == null) {
            HgBookmarkCommand.$$$reportNull$$$0(8);
        }
        ArrayList<String> arguments = new ArrayList<String>(args);
        arguments.add(name);
        HgCommandResult result = new HgCommandExecutor(project).executeInCurrentThread(repositoryRoot, "bookmark", arguments);
        HgUtil.getRepositoryManager(project).updateRepository(repositoryRoot);
        if (HgErrorUtil.hasErrorsInCommandExecution(result)) {
            new HgCommandResultNotifier(project).notifyError(result, "Hg Error", String.format("Hg bookmark command failed for repository %s with name %s ", repositoryRoot.getName(), name));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositories";
                break;
            }
            case 1: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repo";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositoryRoot";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
        }
        objectArray2[1] = "org/zmlx/hg4idea/command/HgBookmarkCommand";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createBookmarkAsynchronously";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "deleteBookmarkSynchronously";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "executeBookmarkCommandSynchronously";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

