/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.intentions;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.codeInsight.intentions.PyBaseIntentionAction;
import com.jetbrains.python.inspections.PyStringFormatParser;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyBinaryExpression;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyParenthesizedExpression;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyStringLiteralUtil;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyCollectionType;
import com.jetbrains.python.psi.types.PyTupleType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyTypeChecker;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConvertFormatOperatorToMethodIntention
extends PyBaseIntentionAction {
    private static final Pattern FORMAT_PATTERN = Pattern.compile("%(?:\\((\\w+)\\))?([-#0+ ]*)((?:\\*|\\d+)?(?:\\.(?:\\*|\\d+))?)?[hlL]?([diouxXeEfFgGcrs%])");
    private static final Pattern BRACE_PATTERN = Pattern.compile("(\\{|\\})");

    private static void appendDoublingBraces(CharSequence source, StringBuilder target) {
        int index = 0;
        Matcher scanner = BRACE_PATTERN.matcher(source);
        boolean skipClosingBrace = false;
        while (scanner.find(index)) {
            if (scanner.start() > 1 && "{".equals(scanner.group(0)) && "\\N".equals(source.subSequence(scanner.start() - 2, scanner.start()).toString())) {
                skipClosingBrace = true;
                target.append(source.subSequence(index, scanner.end()));
                index = scanner.end();
                continue;
            }
            if (skipClosingBrace && "}".equals(scanner.group(0))) {
                skipClosingBrace = false;
                target.append(source.subSequence(index, scanner.end()));
                index = scanner.end();
                continue;
            }
            target.append(source.subSequence(index, scanner.start()));
            if ("{".equals(scanner.group(0))) {
                target.append("{{");
            } else {
                target.append("}}");
            }
            index = scanner.end();
        }
        target.append(source.subSequence(index, source.length()));
    }

    private static Pair<StringBuilder, Boolean> convertFormat(PyStringLiteralExpression stringLiteralExpression, String prefix) {
        int right;
        ArrayList<StringBuilder> constants = new ArrayList<StringBuilder>();
        boolean usesNamedFormat = false;
        List<ASTNode> stringNodes = stringLiteralExpression.getStringNodes();
        PyUtil.sure(stringNodes);
        PyUtil.sure(stringNodes.size() > 0);
        for (ASTNode stringNode : stringNodes) {
            char quote;
            CharSequence text2 = stringNode.getChars();
            int openPos = 0;
            boolean hasPrefix = false;
            int prefixLength = PyStringLiteralUtil.getPrefixLength(String.valueOf(text2));
            if (prefixLength != 0) {
                hasPrefix = true;
            }
            PyUtil.sure("\"'".indexOf(quote = text2.charAt(openPos += prefixLength)) >= 0);
            if (text2.length() - openPos >= 6 && text2.charAt(openPos + 1) == quote && text2.charAt(openPos + 2) == quote) {
                openPos += 2;
            }
            int index = openPos + 1;
            StringBuilder out = new StringBuilder(text2.subSequence(0, openPos + 1));
            if (!hasPrefix) {
                out.insert(0, prefix);
            }
            Matcher scanner = FORMAT_PATTERN.matcher(text2);
            while (scanner.find(index)) {
                ConvertFormatOperatorToMethodIntention.appendDoublingBraces(text2.subSequence(index, scanner.start()), out);
                String f_key = scanner.group(1);
                String f_modifier = scanner.group(2);
                String f_width = scanner.group(3);
                String fConversion = scanner.group(4);
                if ("%%".equals(scanner.group(0))) {
                    out.append("%");
                } else {
                    PyUtil.sure(fConversion);
                    PyUtil.sure(!"%".equals(fConversion));
                    out.append("{");
                    if (f_key != null) {
                        out.append(f_key);
                        usesNamedFormat = true;
                    }
                    if ("r".equals(fConversion)) {
                        out.append("!r");
                    }
                    out.append(":");
                    if (f_modifier != null) {
                        out.append(ConvertFormatOperatorToMethodIntention.convertFormatSpec(f_modifier, f_width, fConversion));
                    }
                    if (f_width != null) {
                        out.append(f_width);
                    }
                    if ("i".equals(fConversion) || "u".equals(fConversion)) {
                        out.append("d");
                    } else if (!"s".equals(fConversion) && !"r".equals(fConversion)) {
                        out.append(fConversion);
                    }
                    int lastIndexOf = out.lastIndexOf(":");
                    if (lastIndexOf == out.length() - 1) {
                        out.deleteCharAt(lastIndexOf);
                    }
                    out.append("}");
                }
                index = scanner.end();
            }
            ConvertFormatOperatorToMethodIntention.appendDoublingBraces(text2.subSequence(index, text2.length()), out);
            constants.add(out);
        }
        TextRange full_range = stringLiteralExpression.getTextRange();
        int full_start = full_range.getStartOffset();
        CharSequence full_text = stringLiteralExpression.getNode().getChars();
        TextRange prev_range = stringNodes.get(0).getTextRange();
        for (int fragment_no = 1; fragment_no < stringNodes.size(); ++fragment_no) {
            int right2;
            TextRange next_range = stringNodes.get(fragment_no).getTextRange();
            int left = prev_range.getEndOffset() - full_start;
            if (left < (right2 = next_range.getStartOffset() - full_start)) {
                ((StringBuilder)constants.get(fragment_no - 1)).append(full_text.subSequence(left, right2));
            }
            prev_range = next_range;
        }
        int left = prev_range.getEndOffset() - full_start;
        if (left < (right = full_range.getEndOffset() - full_start)) {
            ((StringBuilder)constants.get(constants.size() - 1)).append(full_text.subSequence(left, right));
        }
        StringBuilder result = new StringBuilder();
        for (StringBuilder one : constants) {
            result.append((CharSequence)one);
        }
        return new Pair((Object)result, (Object)usesNamedFormat);
    }

    @NotNull
    public static String convertFormatSpec(@NotNull String modifier, @Nullable String widthAndPrecision, @Nullable String conversionChar) {
        if (modifier == null) {
            ConvertFormatOperatorToMethodIntention.$$$reportNull$$$0(0);
        }
        StringBuilder result = new StringBuilder();
        if (ConvertFormatOperatorToMethodIntention.has(modifier, '-')) {
            result.append("<");
        } else if ("s".equals(conversionChar) && !StringUtil.isEmptyOrSpaces((String)widthAndPrecision)) {
            result.append(">");
        }
        if (ConvertFormatOperatorToMethodIntention.has(modifier, '+')) {
            result.append("+");
        } else if (ConvertFormatOperatorToMethodIntention.has(modifier, ' ')) {
            result.append(" ");
        }
        if (ConvertFormatOperatorToMethodIntention.has(modifier, '#')) {
            result.append("#");
        }
        if (ConvertFormatOperatorToMethodIntention.has(modifier, '0')) {
            result.append("0");
        }
        String string = result.toString();
        if (string == null) {
            ConvertFormatOperatorToMethodIntention.$$$reportNull$$$0(1);
        }
        return string;
    }

    private static boolean has(String where, char what) {
        return where.indexOf(what) >= 0;
    }

    @NotNull
    public String getFamilyName() {
        String string = PyBundle.message("INTN.format.operator.to.method", new Object[0]);
        if (string == null) {
            ConvertFormatOperatorToMethodIntention.$$$reportNull$$$0(2);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor2, PsiFile file) {
        if (project == null) {
            ConvertFormatOperatorToMethodIntention.$$$reportNull$$$0(3);
        }
        if (!(file instanceof PyFile)) {
            return false;
        }
        PyBinaryExpression binaryExpression = (PyBinaryExpression)PsiTreeUtil.getParentOfType((PsiElement)file.findElementAt(editor2.getCaretModel().getOffset()), PyBinaryExpression.class, (boolean)false);
        if (binaryExpression == null) {
            return false;
        }
        if (binaryExpression.getLeftExpression() instanceof PyStringLiteralExpression && binaryExpression.getOperator() == PyTokenTypes.PERC) {
            PyStringLiteralExpression str = (PyStringLiteralExpression)binaryExpression.getLeftExpression();
            if (str.getText().length() > 0 && Character.toUpperCase(str.getText().charAt(0)) == 'B') {
                return false;
            }
            List<PyStringFormatParser.SubstitutionChunk> chunks = PyStringFormatParser.filterSubstitutions(PyStringFormatParser.parsePercentFormat(binaryExpression.getLeftExpression().getText()));
            for (PyStringFormatParser.SubstitutionChunk chunk : chunks) {
                if (!"*".equals(chunk.getWidth()) && !"*".equals(chunk.getPrecision())) continue;
                return false;
            }
            this.setText(PyBundle.message("INTN.replace.with.method", new Object[0]));
            return true;
        }
        return false;
    }

    @Override
    public void doInvoke(@NotNull Project project, Editor editor2, PsiFile file) throws IncorrectOperationException {
        PsiElement elementAt;
        PyBinaryExpression element;
        if (project == null) {
            ConvertFormatOperatorToMethodIntention.$$$reportNull$$$0(4);
        }
        if ((element = (PyBinaryExpression)PsiTreeUtil.getParentOfType((PsiElement)(elementAt = file.findElementAt(editor2.getCaretModel().getOffset())), PyBinaryExpression.class, (boolean)false)) == null) {
            return;
        }
        PyElementGenerator elementGenerator = PyElementGenerator.getInstance(project);
        PyExpression rightExpression = PyUtil.sure(element).getRightExpression();
        if (rightExpression == null) {
            return;
        }
        PyExpression rhs = PyPsiUtils.flattenParens(rightExpression);
        if (rhs == null) {
            return;
        }
        String paramText = PyUtil.sure(rhs).getText();
        TypeEvalContext context = TypeEvalContext.userInitiated(file.getProject(), file);
        PyType rhsType = context.getType(rhs);
        String prefix = "";
        LanguageLevel languageLevel = PyUtil.guessLanguageLevel(project);
        PyBuiltinCache builtinCache = PyBuiltinCache.getInstance((PsiElement)rhs);
        if (languageLevel.isPython2() && PyTypeChecker.match((PyType)builtinCache.getUnicodeType(languageLevel), rhsType, context) && !PyTypeChecker.match((PyType)builtinCache.getBytesType(languageLevel), rhsType, context)) {
            prefix = "u";
        }
        PyStringLiteralExpression leftExpression = (PyStringLiteralExpression)element.getLeftExpression();
        Pair<StringBuilder, Boolean> converted = ConvertFormatOperatorToMethodIntention.convertFormat(leftExpression, prefix);
        StringBuilder target = (StringBuilder)converted.getFirst();
        String separator = ConvertFormatOperatorToMethodIntention.getSeparator(leftExpression);
        target.append(separator).append(".format");
        if (rhs instanceof PyReferenceExpression && rhsType instanceof PyTupleType) {
            target.append("(*").append(paramText).append(")");
        } else if (rhs instanceof PyCallExpression) {
            PyCallExpression callExpression = (PyCallExpression)rhs;
            PyExpression callee = callExpression.getCallee();
            PyClassType classType = PyUtil.as(rhsType, PyClassType.class);
            if (classType != null && callee != null && ConvertFormatOperatorToMethodIntention.isDictCall(callee, classType)) {
                target.append(PyUtil.sure(PyUtil.sure(callExpression.getArgumentList()).getNode()).getChars());
            } else {
                target.append("(");
                if (((Boolean)converted.getSecond()).booleanValue()) {
                    target.append("**");
                }
                target.append(paramText).append(")");
            }
        } else if (rhsType instanceof PyCollectionType && "dict".equals(rhsType.getName())) {
            target.append("(**").append(paramText).append(")");
        } else {
            target.append("(").append(paramText).append(")");
        }
        target.insert(0, '(').append(')');
        PyExpression parenthesized = elementGenerator.createExpressionFromText(LanguageLevel.forElement((PsiElement)element), target.toString());
        element.replace((PsiElement)PyUtil.sure(((PyParenthesizedExpression)parenthesized).getContainedExpression()));
    }

    private static boolean isDictCall(@NotNull PyExpression callee, @NotNull PyClassType classType) {
        PsiElement maybeDict;
        PyFunction dictInit;
        PyClassType dictType;
        if (callee == null) {
            ConvertFormatOperatorToMethodIntention.$$$reportNull$$$0(5);
        }
        if (classType == null) {
            ConvertFormatOperatorToMethodIntention.$$$reportNull$$$0(6);
        }
        return (dictType = PyBuiltinCache.getInstance((PsiElement)callee.getContainingFile()).getDictType()) != null && classType.getPyClass() == dictType.getPyClass() && callee instanceof PyReferenceExpression && (dictInit = PyUtil.as(maybeDict = ((PyReferenceExpression)callee).getReference().resolve(), PyFunction.class)) != null && "__init__".equals(dictInit.getName());
    }

    private static String getSeparator(PyStringLiteralExpression leftExpression) {
        String separator = "";
        Pair<String, PsiElement> crop = ConvertFormatOperatorToMethodIntention.collectWhitespace(leftExpression);
        String maybeSeparator = (String)crop.getFirst();
        if (maybeSeparator != null && !maybeSeparator.isEmpty() && !" ".equals(maybeSeparator)) {
            separator = maybeSeparator;
        } else {
            maybeSeparator = (String)(crop = ConvertFormatOperatorToMethodIntention.collectWhitespace((PsiElement)crop.getSecond())).getFirst();
            if (maybeSeparator != null && !maybeSeparator.isEmpty() && !" ".equals(maybeSeparator)) {
                separator = maybeSeparator;
            }
        }
        return separator;
    }

    private static Pair<String, PsiElement> collectWhitespace(PsiElement start) {
        StringBuilder sb = new StringBuilder();
        PsiElement seeker = start;
        while (seeker != null && (seeker = seeker.getNextSibling()) instanceof PsiWhiteSpace) {
            sb.append(seeker.getText());
        }
        return Pair.create((Object)sb.toString(), (Object)seeker);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifier";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/codeInsight/intentions/ConvertFormatOperatorToMethodIntention";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callee";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/codeInsight/intentions/ConvertFormatOperatorToMethodIntention";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "convertFormatSpec";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "convertFormatSpec";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "doInvoke";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isDictCall";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

