/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.stdlib;

import com.google.common.collect.ImmutableSet;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.util.ArrayUtil;
import com.intellij.util.PlatformIcons;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.psi.PyCallSiteExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyQualifiedNameOwner;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyTypedElement;
import com.jetbrains.python.psi.resolve.CompletionVariantsProcessor;
import com.jetbrains.python.psi.types.PyCallableParameter;
import com.jetbrains.python.psi.types.PyCallableParameterImpl;
import com.jetbrains.python.psi.types.PyCallableType;
import com.jetbrains.python.psi.types.PyTupleType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyNamedTupleType
extends PyTupleType
implements PyCallableType {
    @NotNull
    public static final Set<String> NAMEDTUPLE_SPECIAL_ATTRIBUTES = ImmutableSet.of((Object)"_make", (Object)"_asdict", (Object)"_replace", (Object)"_source", (Object)"_fields", (Object)"_field_types", (Object[])new String[]{"_field_defaults"});
    @NotNull
    private final String myName;
    @NotNull
    private final LinkedHashMap<String, FieldTypeAndDefaultValue> myFields;
    @NotNull
    private final DefinitionLevel myDefinitionLevel;
    private final boolean myTyped;
    private final PyTargetExpression myTargetExpression;

    public PyNamedTupleType(@NotNull PyClass tupleClass, @NotNull String name, @NotNull LinkedHashMap<String, FieldTypeAndDefaultValue> fields, @NotNull DefinitionLevel definitionLevel, boolean typed) {
        if (tupleClass == null) {
            PyNamedTupleType.$$$reportNull$$$0(0);
        }
        if (name == null) {
            PyNamedTupleType.$$$reportNull$$$0(1);
        }
        if (fields == null) {
            PyNamedTupleType.$$$reportNull$$$0(2);
        }
        if (definitionLevel == null) {
            PyNamedTupleType.$$$reportNull$$$0(3);
        }
        this(tupleClass, name, fields, definitionLevel, typed, null);
    }

    public PyNamedTupleType(@NotNull PyClass tupleClass, @NotNull String name, @NotNull LinkedHashMap<String, FieldTypeAndDefaultValue> fields, @NotNull DefinitionLevel definitionLevel, boolean typed, @Nullable PyTargetExpression target) {
        if (tupleClass == null) {
            PyNamedTupleType.$$$reportNull$$$0(4);
        }
        if (name == null) {
            PyNamedTupleType.$$$reportNull$$$0(5);
        }
        if (fields == null) {
            PyNamedTupleType.$$$reportNull$$$0(6);
        }
        if (definitionLevel == null) {
            PyNamedTupleType.$$$reportNull$$$0(7);
        }
        super(tupleClass, Collections.unmodifiableList(ContainerUtil.map(fields.values(), typeAndValue -> typeAndValue.getType())), false, definitionLevel != DefinitionLevel.INSTANCE);
        this.myFields = new LinkedHashMap<String, FieldTypeAndDefaultValue>(fields);
        this.myName = name;
        this.myDefinitionLevel = definitionLevel;
        this.myTyped = typed;
        this.myTargetExpression = target;
    }

    @Override
    @NotNull
    public PyQualifiedNameOwner getDeclarationElement() {
        PyTargetExpression pyTargetExpression = this.myTargetExpression;
        if (pyTargetExpression == null) {
            PyNamedTupleType.$$$reportNull$$$0(8);
        }
        return pyTargetExpression;
    }

    @Override
    @NotNull
    public Object[] getCompletionVariants(String completionPrefix, PsiElement location, @NotNull ProcessingContext context) {
        if (context == null) {
            PyNamedTupleType.$$$reportNull$$$0(9);
        }
        ArrayList<Object> result = new ArrayList<Object>();
        Collections.addAll(result, super.getCompletionVariants(completionPrefix, location, context));
        for (String field : this.myFields.keySet()) {
            result.add(LookupElementBuilder.create((String)field).withIcon(PlatformIcons.FIELD_ICON));
        }
        if (completionPrefix == null) {
            Condition nameFilter = NAMEDTUPLE_SPECIAL_ATTRIBUTES::contains;
            CompletionVariantsProcessor processor2 = new CompletionVariantsProcessor(location, null, (Condition<String>)nameFilter, false, context.get(CTX_SUPPRESS_PARENTHESES) != null);
            this.myClass.processClassLevelDeclarations(processor2);
            result.addAll(processor2.getResultList());
        }
        Object[] objectArray = ArrayUtil.toObjectArray(result);
        if (objectArray == null) {
            PyNamedTupleType.$$$reportNull$$$0(10);
        }
        return objectArray;
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            PyNamedTupleType.$$$reportNull$$$0(11);
        }
        return string;
    }

    @Override
    public boolean isBuiltin() {
        return false;
    }

    @Override
    @Nullable
    public PyNamedTupleType getCallType(@NotNull TypeEvalContext context, @NotNull PyCallSiteExpression callSite) {
        if (context == null) {
            PyNamedTupleType.$$$reportNull$$$0(12);
        }
        if (callSite == null) {
            PyNamedTupleType.$$$reportNull$$$0(13);
        }
        if (this.myDefinitionLevel == DefinitionLevel.NT_FUNCTION) {
            return new PyNamedTupleType(this.myClass, this.myName, this.myFields, DefinitionLevel.NEW_TYPE, this.myTyped, this.myTargetExpression);
        }
        if (this.myDefinitionLevel == DefinitionLevel.NEW_TYPE) {
            return this.getCallDefinitionType(callSite, context);
        }
        return null;
    }

    @Override
    @NotNull
    public PyNamedTupleType toInstance() {
        PyNamedTupleType pyNamedTupleType = this.myDefinitionLevel == DefinitionLevel.NEW_TYPE ? new PyNamedTupleType(this.myClass, this.myName, this.myFields, DefinitionLevel.INSTANCE, this.myTyped, this.myTargetExpression) : this;
        if (pyNamedTupleType == null) {
            PyNamedTupleType.$$$reportNull$$$0(14);
        }
        return pyNamedTupleType;
    }

    @Override
    @NotNull
    public PyNamedTupleType toClass() {
        PyNamedTupleType pyNamedTupleType = this.myDefinitionLevel == DefinitionLevel.INSTANCE ? new PyNamedTupleType(this.myClass, this.myName, this.myFields, DefinitionLevel.NEW_TYPE, this.myTyped, this.myTargetExpression) : this;
        if (pyNamedTupleType == null) {
            PyNamedTupleType.$$$reportNull$$$0(15);
        }
        return pyNamedTupleType;
    }

    @Override
    public String toString() {
        return "PyNamedTupleType: " + this.myName;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PyNamedTupleType type = (PyNamedTupleType)o;
        return Objects.equals(this.myName, type.myName) && Objects.equals(this.myFields.keySet(), type.myFields.keySet()) && this.myDefinitionLevel == type.myDefinitionLevel;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.myName, this.myFields.keySet(), this.myDefinitionLevel});
    }

    @Override
    @NotNull
    public Set<String> getMemberNames(boolean inherited, @NotNull TypeEvalContext context) {
        if (context == null) {
            PyNamedTupleType.$$$reportNull$$$0(16);
        }
        Set<String> result = super.getMemberNames(inherited, context);
        result.addAll(this.myFields.keySet());
        Set<String> set = result;
        if (set == null) {
            PyNamedTupleType.$$$reportNull$$$0(17);
        }
        return set;
    }

    @NotNull
    public Map<String, FieldTypeAndDefaultValue> getFields() {
        Map<String, FieldTypeAndDefaultValue> map2 = Collections.unmodifiableMap(this.myFields);
        if (map2 == null) {
            PyNamedTupleType.$$$reportNull$$$0(18);
        }
        return map2;
    }

    @Override
    public boolean isCallable() {
        return this.myDefinitionLevel != DefinitionLevel.INSTANCE;
    }

    @Override
    @Nullable
    public List<PyCallableParameter> getParameters(@NotNull TypeEvalContext context) {
        if (context == null) {
            PyNamedTupleType.$$$reportNull$$$0(19);
        }
        return this.isCallable() ? ContainerUtil.map(this.myFields.entrySet(), field -> PyNamedTupleType.fieldToCallableParameter((String)field.getKey(), (FieldTypeAndDefaultValue)field.getValue())) : null;
    }

    public boolean isTyped() {
        return this.myTyped;
    }

    @NotNull
    public PyNamedTupleType clarifyFields(@NotNull Map<String, PyType> fieldNameToType) {
        if (fieldNameToType == null) {
            PyNamedTupleType.$$$reportNull$$$0(20);
        }
        if (!this.myTyped) {
            LinkedHashMap<String, FieldTypeAndDefaultValue> newFields = new LinkedHashMap<String, FieldTypeAndDefaultValue>(this.myFields);
            for (Map.Entry<String, PyType> entry : fieldNameToType.entrySet()) {
                String fieldName = entry.getKey();
                if (!newFields.containsKey(fieldName)) continue;
                newFields.put(fieldName, new FieldTypeAndDefaultValue(entry.getValue(), null));
            }
            PyNamedTupleType pyNamedTupleType = new PyNamedTupleType(this.myClass, this.myName, newFields, this.myDefinitionLevel, false, this.myTargetExpression);
            if (pyNamedTupleType == null) {
                PyNamedTupleType.$$$reportNull$$$0(21);
            }
            return pyNamedTupleType;
        }
        PyNamedTupleType pyNamedTupleType = this;
        if (pyNamedTupleType == null) {
            PyNamedTupleType.$$$reportNull$$$0(22);
        }
        return pyNamedTupleType;
    }

    @NotNull
    private PyNamedTupleType getCallDefinitionType(@NotNull PyCallSiteExpression callSite, @NotNull TypeEvalContext context) {
        List<PyExpression> arguments;
        if (callSite == null) {
            PyNamedTupleType.$$$reportNull$$$0(23);
        }
        if (context == null) {
            PyNamedTupleType.$$$reportNull$$$0(24);
        }
        if (!this.myTyped && (arguments = callSite.getArguments(null)).size() == this.myFields.size()) {
            HashMap<String, PyType> result = new HashMap<String, PyType>();
            for (Map.Entry entry : StreamEx.ofKeys(this.myFields).zipWith((Stream)StreamEx.of(arguments))) {
                String name = (String)entry.getKey();
                PyType type = context.getType((PyTypedElement)entry.getValue());
                result.put(name, type);
            }
            PyNamedTupleType pyNamedTupleType = this.toInstance().clarifyFields(result);
            if (pyNamedTupleType == null) {
                PyNamedTupleType.$$$reportNull$$$0(25);
            }
            return pyNamedTupleType;
        }
        PyNamedTupleType pyNamedTupleType = this.toInstance();
        if (pyNamedTupleType == null) {
            PyNamedTupleType.$$$reportNull$$$0(26);
        }
        return pyNamedTupleType;
    }

    @NotNull
    private static PyCallableParameter fieldToCallableParameter(@NotNull String name, @NotNull FieldTypeAndDefaultValue typeAndDefaultValue) {
        if (name == null) {
            PyNamedTupleType.$$$reportNull$$$0(27);
        }
        if (typeAndDefaultValue == null) {
            PyNamedTupleType.$$$reportNull$$$0(28);
        }
        PyCallableParameter pyCallableParameter = PyCallableParameterImpl.nonPsi(name, typeAndDefaultValue.getType(), typeAndDefaultValue.getDefaultValue());
        if (pyCallableParameter == null) {
            PyNamedTupleType.$$$reportNull$$$0(29);
        }
        return pyCallableParameter;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 25: 
            case 26: 
            case 29: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 25: 
            case 26: 
            case 29: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tupleClass";
                break;
            }
            case 1: 
            case 5: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fields";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "definitionLevel";
                break;
            }
            case 8: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 25: 
            case 26: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/codeInsight/stdlib/PyNamedTupleType";
                break;
            }
            case 9: 
            case 12: 
            case 16: 
            case 19: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 13: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callSite";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldNameToType";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeAndDefaultValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/codeInsight/stdlib/PyNamedTupleType";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeclarationElement";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompletionVariants";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "toInstance";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "toClass";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getMemberNames";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getFields";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "clarifyFields";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getCallDefinitionType";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "fieldToCallableParameter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 8: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 25: 
            case 26: 
            case 29: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getCompletionVariants";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getCallType";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getMemberNames";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getParameters";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "clarifyFields";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getCallDefinitionType";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "fieldToCallableParameter";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 25: 
            case 26: 
            case 29: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class FieldTypeAndDefaultValue {
        @Nullable
        private final PyType myType;
        @Nullable
        private final PyExpression myDefaultValue;

        public FieldTypeAndDefaultValue(@Nullable PyType type, @Nullable PyExpression defaultValue) {
            this.myType = type;
            this.myDefaultValue = defaultValue;
        }

        @Nullable
        public PyType getType() {
            return this.myType;
        }

        @Nullable
        public PyExpression getDefaultValue() {
            return this.myDefaultValue;
        }
    }

    public static enum DefinitionLevel {
        NT_FUNCTION,
        NEW_TYPE,
        INSTANCE;

    }
}

