/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.console;

import com.intellij.execution.console.DuplexConsoleView;
import com.intellij.execution.filters.TextConsoleBuilderFactory;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.runners.AbstractConsoleRunnerWithHistory;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.console.PyCodeExecutor;
import com.jetbrains.python.console.PyConsoleOptions;
import com.jetbrains.python.console.PyConsoleUtil;
import com.jetbrains.python.console.PythonConsoleView;
import icons.PythonIcons;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PythonDebugLanguageConsoleView
extends DuplexConsoleView<ConsoleView, PythonConsoleView>
implements PyCodeExecutor {
    public static final String DEBUG_CONSOLE_START_COMMAND = "import sys; print('Python %s on %s' % (sys.version, sys.platform))";
    private boolean myDebugConsoleInitialized = false;

    public PythonDebugLanguageConsoleView(Project project, Sdk sdk, ConsoleView consoleView, boolean testMode) {
        super(consoleView, (ConsoleView)new PythonConsoleView(project, "Python Console", sdk, testMode));
        this.enableConsole(!PyConsoleOptions.getInstance(project).isShowDebugConsoleByDefault());
        this.getSwitchConsoleActionPresentation().setIcon(PythonIcons.Python.PythonConsole);
        this.getSwitchConsoleActionPresentation().setText(PyBundle.message("run.configuration.show.command.line.action.name", new Object[0]));
        ArrayList actions = ContainerUtil.newArrayList((Object[])new AnAction[]{PyConsoleUtil.createTabCompletionAction(this.getPydevConsoleView())});
        actions.add(PyConsoleUtil.createInterruptAction(this.getPydevConsoleView()));
        AbstractConsoleRunnerWithHistory.registerActionShortcuts((List)actions, (JComponent)this.getPydevConsoleView().getEditor().getComponent());
    }

    public PythonDebugLanguageConsoleView(Project project, Sdk sdk) {
        this(project, sdk, TextConsoleBuilderFactory.getInstance().createBuilder(project).getConsole(), false);
    }

    @Override
    public void executeCode(@Nullable String code, @Nullable Editor e) {
        this.enableConsole(false);
        if (code != null) {
            this.getPydevConsoleView().executeInConsole(code);
        } else {
            IdeFocusManager.findInstance().doWhenFocusSettlesDown(() -> this.getPydevConsoleView().requestFocus());
        }
    }

    @NotNull
    public PythonConsoleView getPydevConsoleView() {
        PythonConsoleView pythonConsoleView = (PythonConsoleView)this.getSecondaryConsoleView();
        if (pythonConsoleView == null) {
            PythonDebugLanguageConsoleView.$$$reportNull$$$0(0);
        }
        return pythonConsoleView;
    }

    public ConsoleViewImpl getTextConsole() {
        ConsoleView consoleView = this.getPrimaryConsoleView();
        if (consoleView instanceof ConsoleViewImpl) {
            return (ConsoleViewImpl)consoleView;
        }
        return null;
    }

    public void showStartMessageForFirstExecution(String startCommand, PythonConsoleView console) {
        console.setPrompt("");
        console.executeStatement(startCommand + "\n", ProcessOutputTypes.SYSTEM);
    }

    public void enableConsole(boolean primary) {
        super.enableConsole(primary);
        if (!primary && !this.isPrimaryConsoleEnabled()) {
            PythonConsoleView console = this.getPydevConsoleView();
            if (!this.myDebugConsoleInitialized && console.getExecuteActionHandler() != null) {
                if (!console.getExecuteActionHandler().getConsoleCommunication().isWaitingForInput()) {
                    console.addConsoleFolding(true, false);
                    this.showStartMessageForFirstExecution(DEBUG_CONSOLE_START_COMMAND, console);
                }
                this.myDebugConsoleInitialized = true;
                console.initialized();
                IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> console.requestFocus());
            }
        }
    }

    public void initialized() {
        this.myDebugConsoleInitialized = true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/console/PythonDebugLanguageConsoleView", "getPydevConsoleView"));
    }
}

