/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyAugAssignmentStatement;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyForStatement;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyNamedElementContainer;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.psi.PyQualifiedExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyTupleExpression;
import com.jetbrains.python.psi.PyUtil;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyMethodFirstArgAssignmentInspection
extends PyInspection {
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = PyBundle.message("INSP.NAME.first.arg.assign", new Object[0]);
        if (string == null) {
            PyMethodFirstArgAssignmentInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            PyMethodFirstArgAssignmentInspection.$$$reportNull$$$0(1);
        }
        if (session == null) {
            PyMethodFirstArgAssignmentInspection.$$$reportNull$$$0(2);
        }
        Visitor visitor2 = new Visitor(holder, session);
        if (visitor2 == null) {
            PyMethodFirstArgAssignmentInspection.$$$reportNull$$$0(3);
        }
        return visitor2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/inspections/PyMethodFirstArgAssignmentInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/inspections/PyMethodFirstArgAssignmentInspection";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Visitor
    extends PyInspectionVisitor {
        public Visitor(@Nullable ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
            if (session == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            super(holder, session);
        }

        private void complain(PsiElement element, String name) {
            this.registerProblem(element, PyBundle.message("INSP.first.arg.$0.assigned", name));
        }

        private void handleTarget(PyQualifiedExpression target, String name) {
            if (!target.isQualified() && name.equals(target.getText())) {
                this.complain((PsiElement)target, name);
            }
        }

        @Nullable
        private static String extractFirstParamName(PyElement node) {
            List<PsiElement> place = PyUtil.searchForWrappingMethod((PsiElement)node, true);
            if (place == null || place.size() < 2) {
                return null;
            }
            PyFunction method = (PyFunction)place.get(place.size() - 2);
            PyParameter[] params = method.getParameterList().getParameters();
            if (params.length < 1) {
                return null;
            }
            PyNamedParameter first_parm = params[0].getAsNamed();
            if (first_parm == null) {
                return null;
            }
            if (first_parm.isKeywordContainer() || first_parm.isPositionalContainer()) {
                return null;
            }
            String first_param_name = first_parm.getName();
            if (first_param_name == null || first_param_name.length() < 1) {
                return null;
            }
            PyFunction.Modifier modifier = method.getModifier();
            if (modifier == PyFunction.Modifier.STATICMETHOD) {
                return null;
            }
            return first_param_name;
        }

        private void markNameDefiner(PyNamedElementContainer definer) {
            String first_param_name = Visitor.extractFirstParamName((PyElement)((Object)definer));
            if (first_param_name != null) {
                for (PsiNamedElement elt : definer.getNamedElements()) {
                    if (!(elt instanceof PyTargetExpression)) continue;
                    this.handleTarget((PyTargetExpression)elt, first_param_name);
                }
            }
        }

        @Override
        public void visitPyAssignmentStatement(PyAssignmentStatement node) {
            this.markNameDefiner(node);
        }

        @Override
        public void visitPyAugAssignmentStatement(PyAugAssignmentStatement node) {
            String first_param_name = Visitor.extractFirstParamName(node);
            if (first_param_name != null) {
                PyExpression target = node.getTarget();
                if (target instanceof PyQualifiedExpression) {
                    this.handleTarget((PyQualifiedExpression)target, first_param_name);
                } else if (target instanceof PyTupleExpression) {
                    for (PyExpression elt : PyUtil.flattenedParensAndTuples(((PyTupleExpression)target).getElements())) {
                        if (!(elt instanceof PyQualifiedExpression)) continue;
                        this.handleTarget((PyQualifiedExpression)elt, first_param_name);
                    }
                }
            }
        }

        @Override
        public void visitPyForStatement(PyForStatement node) {
            this.markNameDefiner(node);
        }

        private void markDefinition(PyElement definer) {
            String first_param_name = Visitor.extractFirstParamName(definer);
            if (first_param_name != null && first_param_name.equals(definer.getName())) {
                this.complain(definer.getNode().findChildByType((IElementType)PyTokenTypes.IDENTIFIER).getPsi(), first_param_name);
            }
        }

        @Override
        public void visitPyFunction(PyFunction definer) {
            this.markDefinition(definer);
        }

        @Override
        public void visitPyClass(PyClass definer) {
            this.markDefinition(definer);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/jetbrains/python/inspections/PyMethodFirstArgAssignmentInspection$Visitor", "<init>"));
        }
    }
}

