/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections.quickfix;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.usageView.UsageInfo;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.codeInsight.imports.AddImportHelper;
import com.jetbrains.python.inspections.unresolvedReference.PyUnresolvedReferencesInspection;
import com.jetbrains.python.psi.PyArgumentList;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.psi.PyRecursiveElementVisitor;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.refactoring.PyRefactoringUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PyMakeFunctionFromMethodQuickFix
implements LocalQuickFix {
    @NotNull
    public String getFamilyName() {
        String string = PyBundle.message("QFIX.NAME.make.function", new Object[0]);
        if (string == null) {
            PyMakeFunctionFromMethodQuickFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
        PsiElement element;
        PyFunction problemFunction;
        if (project == null) {
            PyMakeFunctionFromMethodQuickFix.$$$reportNull$$$0(1);
        }
        if (descriptor2 == null) {
            PyMakeFunctionFromMethodQuickFix.$$$reportNull$$$0(2);
        }
        if ((problemFunction = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)(element = descriptor2.getPsiElement()), PyFunction.class)) == null) {
            return;
        }
        PyClass containingClass = problemFunction.getContainingClass();
        if (containingClass == null) {
            return;
        }
        List<UsageInfo> usages = PyRefactoringUtil.findUsages(problemFunction, false);
        PyParameter[] parameters = problemFunction.getParameterList().getParameters();
        if (parameters.length > 0) {
            parameters[0].delete();
        }
        PsiElement copy = problemFunction.copy();
        problemFunction.delete();
        PsiElement parent = containingClass.getParent();
        PyClass aClass = (PyClass)PsiTreeUtil.getTopmostParentOfType((PsiElement)containingClass, PyClass.class);
        if (aClass == null) {
            aClass = containingClass;
        }
        copy = parent.addBefore(copy, (PsiElement)aClass);
        for (UsageInfo usage : usages) {
            PsiElement usageElement = usage.getElement();
            if (!(usageElement instanceof PyReferenceExpression)) continue;
            PsiFile usageFile = usageElement.getContainingFile();
            PyMakeFunctionFromMethodQuickFix.updateUsage(copy, (PyReferenceExpression)usageElement, usageFile, !usageFile.equals(parent));
        }
    }

    private static void updateUsage(@NotNull PsiElement finalElement, @NotNull PyReferenceExpression element, @NotNull PsiFile usageFile, boolean addImport) {
        PyExpression qualifier;
        if (finalElement == null) {
            PyMakeFunctionFromMethodQuickFix.$$$reportNull$$$0(3);
        }
        if (element == null) {
            PyMakeFunctionFromMethodQuickFix.$$$reportNull$$$0(4);
        }
        if (usageFile == null) {
            PyMakeFunctionFromMethodQuickFix.$$$reportNull$$$0(5);
        }
        if ((qualifier = element.getQualifier()) == null) {
            return;
        }
        if (qualifier.getText().equals("self")) {
            PyUtil.removeQualifier(element);
            return;
        }
        if (qualifier instanceof PyCallExpression) {
            if (addImport) {
                AddImportHelper.addImport((PsiNamedElement)finalElement, usageFile, element);
            }
            PyUtil.removeQualifier(element);
            PyMakeFunctionFromMethodQuickFix.removeFormerImport(usageFile, addImport);
        } else {
            PsiReference reference = qualifier.getReference();
            if (reference == null) {
                return;
            }
            PsiElement resolved = reference.resolve();
            if (resolved instanceof PyTargetExpression) {
                PyMakeFunctionFromMethodQuickFix.updateAssignment(element, resolved);
            } else if (resolved instanceof PyClass) {
                PyUtil.removeQualifier(element);
                PyMakeFunctionFromMethodQuickFix.updateArgumentList(element);
            }
        }
    }

    private static void removeFormerImport(@NotNull PsiFile usageFile, boolean addImport) {
        if (usageFile == null) {
            PyMakeFunctionFromMethodQuickFix.$$$reportNull$$$0(6);
        }
        if (usageFile instanceof PyFile && addImport) {
            LocalInspectionToolSession session = new LocalInspectionToolSession(usageFile, 0, usageFile.getTextLength());
            final PyUnresolvedReferencesInspection.Visitor visitor2 = new PyUnresolvedReferencesInspection.Visitor(null, session, Collections.emptyList());
            usageFile.accept((PsiElementVisitor)new PyRecursiveElementVisitor(){

                @Override
                public void visitPyElement(PyElement node) {
                    super.visitPyElement(node);
                    node.accept(visitor2);
                }
            });
            visitor2.optimizeImports();
        }
    }

    private static void updateAssignment(PyReferenceExpression element, @NotNull PsiElement resolved) {
        PyExpression callee;
        PyExpression value;
        PsiElement parent;
        if (resolved == null) {
            PyMakeFunctionFromMethodQuickFix.$$$reportNull$$$0(7);
        }
        if ((parent = resolved.getParent()) instanceof PyAssignmentStatement && (value = ((PyAssignmentStatement)parent).getAssignedValue()) instanceof PyCallExpression && (callee = ((PyCallExpression)value).getCallee()) instanceof PyReferenceExpression) {
            PyExpression calleeQualifier = ((PyReferenceExpression)callee).getQualifier();
            if (calleeQualifier != null) {
                value.replace((PsiElement)calleeQualifier);
            } else {
                PyUtil.removeQualifier(element);
            }
        }
    }

    private static void updateArgumentList(@NotNull PyReferenceExpression element) {
        PyCallExpression callExpression;
        if (element == null) {
            PyMakeFunctionFromMethodQuickFix.$$$reportNull$$$0(8);
        }
        if ((callExpression = (PyCallExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PyCallExpression.class)) == null) {
            return;
        }
        PyArgumentList argumentList = callExpression.getArgumentList();
        if (argumentList == null) {
            return;
        }
        PyExpression[] arguments = argumentList.getArguments();
        if (arguments.length > 0) {
            arguments[0].delete();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/inspections/quickfix/PyMakeFunctionFromMethodQuickFix";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "finalElement";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usageFile";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolved";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/inspections/quickfix/PyMakeFunctionFromMethodQuickFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "updateUsage";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "removeFormerImport";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "updateAssignment";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "updateArgumentList";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

