/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections.unresolvedReference;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.intellij.codeInsight.controlflow.ControlFlow;
import com.intellij.codeInsight.controlflow.ControlFlowUtil;
import com.intellij.codeInsight.controlflow.Instruction;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ui.ListEditForm;
import com.intellij.lang.ASTNode;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.Consumer;
import com.intellij.util.PlatformUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.PyCustomType;
import com.jetbrains.python.PyNames;
import com.jetbrains.python.codeInsight.PyCodeInsightSettings;
import com.jetbrains.python.codeInsight.PyCustomMember;
import com.jetbrains.python.codeInsight.PySubstitutionChunkReference;
import com.jetbrains.python.codeInsight.controlflow.ControlFlowCache;
import com.jetbrains.python.codeInsight.controlflow.ReadWriteInstruction;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.codeInsight.imports.AutoImportHintAction;
import com.jetbrains.python.codeInsight.imports.AutoImportQuickFix;
import com.jetbrains.python.codeInsight.imports.OptimizeImportsQuickFix;
import com.jetbrains.python.codeInsight.imports.PythonImportUtils;
import com.jetbrains.python.console.PydevConsoleRunner;
import com.jetbrains.python.documentation.docstrings.DocStringParameterReference;
import com.jetbrains.python.documentation.docstrings.DocStringTypeReference;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionExtension;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.inspections.PyPackageRequirementsInspection;
import com.jetbrains.python.inspections.PyUnreachableCodeInspection;
import com.jetbrains.python.inspections.PyUnresolvedReferenceQuickFixProvider;
import com.jetbrains.python.inspections.quickfix.AddFieldQuickFix;
import com.jetbrains.python.inspections.quickfix.AddFunctionQuickFix;
import com.jetbrains.python.inspections.quickfix.AddIgnoredIdentifierQuickFix;
import com.jetbrains.python.inspections.quickfix.AddMethodQuickFix;
import com.jetbrains.python.inspections.quickfix.CreateClassQuickFix;
import com.jetbrains.python.inspections.quickfix.GenerateBinaryStubsFix;
import com.jetbrains.python.inspections.quickfix.PyRenameUnresolvedRefQuickFix;
import com.jetbrains.python.inspections.quickfix.UnresolvedRefCreateFunctionQuickFix;
import com.jetbrains.python.inspections.quickfix.UnresolvedRefTrueFalseQuickFix;
import com.jetbrains.python.inspections.quickfix.UnresolvedReferenceAddParameterQuickFix;
import com.jetbrains.python.inspections.quickfix.UnresolvedReferenceAddSelfQuickFix;
import com.jetbrains.python.inspections.unresolvedReference.PyPackageAliasesProvider;
import com.jetbrains.python.inspections.unresolvedReference.PyUnresolvedReferenceSkipperExtPoint;
import com.jetbrains.python.packaging.PyPIPackageUtil;
import com.jetbrains.python.packaging.PyPackageUtil;
import com.jetbrains.python.packaging.PyRequirement;
import com.jetbrains.python.packaging.PyRequirementsKt;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PsiReferenceEx;
import com.jetbrains.python.psi.PyAnnotation;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyCallable;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyConditionalExpression;
import com.jetbrains.python.psi.PyConditionalStatementPart;
import com.jetbrains.python.psi.PyDecorator;
import com.jetbrains.python.psi.PyDecoratorList;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyExceptPart;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyExpressionCodeFragment;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFromImportStatement;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyIfStatement;
import com.jetbrains.python.psi.PyImportElement;
import com.jetbrains.python.psi.PyImportStatement;
import com.jetbrains.python.psi.PyImportStatementBase;
import com.jetbrains.python.psi.PyImportedNameDefiner;
import com.jetbrains.python.psi.PyKnownDecoratorUtil;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.psi.PyQualifiedExpression;
import com.jetbrains.python.psi.PyRecursiveElementVisitor;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyReferenceOwner;
import com.jetbrains.python.psi.PyStarImportElement;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyTryExceptStatement;
import com.jetbrains.python.psi.PyTryPart;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import com.jetbrains.python.psi.impl.PyImportStatementNavigator;
import com.jetbrains.python.psi.impl.PyImportedModule;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.impl.references.PyFromImportNameReference;
import com.jetbrains.python.psi.impl.references.PyImportReference;
import com.jetbrains.python.psi.impl.references.PyOperatorReference;
import com.jetbrains.python.psi.resolve.ImportedResolveResult;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.resolve.QualifiedNameFinder;
import com.jetbrains.python.psi.types.PyClassLikeType;
import com.jetbrains.python.psi.types.PyClassMembersProvider;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyClassTypeImpl;
import com.jetbrains.python.psi.types.PyFunctionType;
import com.jetbrains.python.psi.types.PyFunctionTypeImpl;
import com.jetbrains.python.psi.types.PyImportedModuleType;
import com.jetbrains.python.psi.types.PyModuleType;
import com.jetbrains.python.psi.types.PyNoneType;
import com.jetbrains.python.psi.types.PyStructuralType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyTypeChecker;
import com.jetbrains.python.psi.types.PyTypeUtil;
import com.jetbrains.python.psi.types.PyUnionType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import com.jetbrains.python.sdk.PythonSdkType;
import com.jetbrains.python.sdk.skeletons.PySkeletonRefresher;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyUnresolvedReferencesInspection
extends PyInspection {
    private static final Key<Visitor> KEY = Key.create((String)"PyUnresolvedReferencesInspection.Visitor");
    public static final Key<PyUnresolvedReferencesInspection> SHORT_NAME_KEY = Key.create((String)PyUnresolvedReferencesInspection.class.getSimpleName());
    public List<String> ignoredIdentifiers = new ArrayList<String>();

    public static PyUnresolvedReferencesInspection getInstance(PsiElement element) {
        InspectionProfileImpl inspectionProfile = InspectionProjectProfileManager.getInstance((Project)element.getProject()).getCurrentProfile();
        return (PyUnresolvedReferencesInspection)inspectionProfile.getUnwrappedTool(SHORT_NAME_KEY.toString(), element);
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = PyBundle.message("INSP.NAME.unresolved.refs", new Object[0]);
        if (string == null) {
            PyUnresolvedReferencesInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            PyUnresolvedReferencesInspection.$$$reportNull$$$0(1);
        }
        if (session == null) {
            PyUnresolvedReferencesInspection.$$$reportNull$$$0(2);
        }
        Visitor visitor2 = new Visitor(holder, session, this.ignoredIdentifiers);
        Visitor existingVisitor = (Visitor)((Object)session.getUserData(KEY));
        if (existingVisitor == null) {
            session.putUserData(KEY, (Object)visitor2);
        }
        Visitor visitor3 = visitor2;
        if (visitor3 == null) {
            PyUnresolvedReferencesInspection.$$$reportNull$$$0(3);
        }
        return visitor3;
    }

    public void inspectionFinished(@NotNull LocalInspectionToolSession session, @NotNull ProblemsHolder holder) {
        if (session == null) {
            PyUnresolvedReferencesInspection.$$$reportNull$$$0(4);
        }
        if (holder == null) {
            PyUnresolvedReferencesInspection.$$$reportNull$$$0(5);
        }
        Visitor visitor2 = (Visitor)((Object)session.getUserData(KEY));
        assert (visitor2 != null);
        if (PyCodeInsightSettings.getInstance().HIGHLIGHT_UNUSED_IMPORTS) {
            visitor2.highlightUnusedImports();
        }
        visitor2.highlightImportsInsideGuards();
        session.putUserData(KEY, null);
    }

    public JComponent createOptionsPanel() {
        ListEditForm form = new ListEditForm("Ignore references", this.ignoredIdentifiers);
        return form.getContentPanel();
    }

    private static boolean importShouldBeSkippedByExtPoint(@NotNull PyImportedNameDefiner importNameDefiner) {
        if (importNameDefiner == null) {
            PyUnresolvedReferencesInspection.$$$reportNull$$$0(6);
        }
        for (PyUnresolvedReferenceSkipperExtPoint skipper : (PyUnresolvedReferenceSkipperExtPoint[])PyUnresolvedReferenceSkipperExtPoint.EP_NAME.getExtensions()) {
            if (!skipper.unusedImportShouldBeSkipped(importNameDefiner)) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/inspections/unresolvedReference/PyUnresolvedReferencesInspection";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importNameDefiner";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/inspections/unresolvedReference/PyUnresolvedReferencesInspection";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "inspectionFinished";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "importShouldBeSkippedByExtPoint";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Visitor
    extends PyInspectionVisitor {
        private final Set<PyImportedNameDefiner> myImportsInsideGuard;
        private final Set<PyImportedNameDefiner> myUsedImports;
        private final Set<PyImportedNameDefiner> myAllImports;
        private final ImmutableSet<String> myIgnoredIdentifiers;
        private volatile Boolean myIsEnabled;

        public Visitor(@Nullable ProblemsHolder holder, @NotNull LocalInspectionToolSession session, List<String> ignoredIdentifiers) {
            if (session == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            super(holder, session);
            this.myImportsInsideGuard = Collections.synchronizedSet(new HashSet());
            this.myUsedImports = Collections.synchronizedSet(new HashSet());
            this.myAllImports = Collections.synchronizedSet(new HashSet());
            this.myIsEnabled = null;
            this.myIgnoredIdentifiers = ImmutableSet.copyOf(ignoredIdentifiers);
        }

        public boolean isEnabled(@NotNull PsiElement anchor) {
            if (anchor == null) {
                Visitor.$$$reportNull$$$0(1);
            }
            if (this.myIsEnabled == null) {
                boolean isPyCharm = PlatformUtils.isPyCharm();
                this.myIsEnabled = PySkeletonRefresher.isGeneratingSkeletons() ? Boolean.valueOf(false) : (isPyCharm ? Boolean.valueOf(PythonSdkType.findPythonSdk(anchor) != null || PyUtil.isInScratchFile(anchor)) : Boolean.valueOf(true));
            }
            return this.myIsEnabled;
        }

        @Override
        public void visitPyTargetExpression(PyTargetExpression node) {
            this.checkSlotsAndProperties(node);
        }

        private void checkSlotsAndProperties(PyQualifiedExpression node) {
            PyType type;
            PyExpression qualifier = node.getQualifier();
            String attrName = node.getReferencedName();
            if (qualifier != null && attrName != null && (type = this.myTypeEvalContext.getType(qualifier)) instanceof PyClassType && !((PyClassType)type).isAttributeWritable(attrName, this.myTypeEvalContext)) {
                ASTNode nameNode = node.getNameElement();
                PyQualifiedExpression e = nameNode != null ? nameNode.getPsi() : node;
                this.registerProblem((PsiElement)e, "'" + type.getName() + "' object has no attribute '" + attrName + "'");
            }
        }

        @Override
        public void visitPyImportElement(PyImportElement node) {
            super.visitPyImportElement(node);
            PyFromImportStatement fromImport = (PyFromImportStatement)PsiTreeUtil.getParentOfType((PsiElement)node, PyFromImportStatement.class);
            if (this.isEnabled((PsiElement)node) && (fromImport == null || !fromImport.isFromFuture())) {
                this.myAllImports.add(node);
            }
        }

        @Override
        public void visitPyStarImportElement(PyStarImportElement node) {
            super.visitPyStarImportElement(node);
            if (this.isEnabled((PsiElement)node)) {
                this.myAllImports.add(node);
            }
        }

        @Nullable
        private static PyExceptPart getImportErrorGuard(PyElement node) {
            PyTryExceptStatement tryExceptStatement;
            PyTryPart tryPart;
            PyImportStatementBase importStatement = (PyImportStatementBase)PsiTreeUtil.getParentOfType((PsiElement)node, PyImportStatementBase.class);
            if (importStatement != null && (tryPart = (PyTryPart)PsiTreeUtil.getParentOfType((PsiElement)node, PyTryPart.class)) != null && (tryExceptStatement = (PyTryExceptStatement)PsiTreeUtil.getParentOfType((PsiElement)tryPart, PyTryExceptStatement.class)) != null) {
                for (PyExceptPart exceptPart : tryExceptStatement.getExceptParts()) {
                    PyExpression expr = exceptPart.getExceptClass();
                    if (expr == null || !"ImportError".equals(expr.getName())) continue;
                    return exceptPart;
                }
            }
            return null;
        }

        private static boolean isGuardedByHasattr(@NotNull PyElement node, @NotNull String name) {
            String nodeName;
            if (node == null) {
                Visitor.$$$reportNull$$$0(2);
            }
            if (name == null) {
                Visitor.$$$reportNull$$$0(3);
            }
            if ((nodeName = node.getName()) != null) {
                ScopeOwner owner = ScopeUtil.getDeclarationScopeOwner((PsiElement)node, nodeName);
                PyElement e = (PyElement)PsiTreeUtil.getParentOfType((PsiElement)node, (Class[])new Class[]{PyConditionalStatementPart.class, PyConditionalExpression.class});
                while (e != null && PsiTreeUtil.isAncestor((PsiElement)owner, (PsiElement)e, (boolean)true)) {
                    ArrayList<PyCallExpression> calls = new ArrayList<PyCallExpression>();
                    PyExpression cond = null;
                    if (e instanceof PyConditionalStatementPart) {
                        cond = ((PyConditionalStatementPart)e).getCondition();
                    } else if (e instanceof PyConditionalExpression && PsiTreeUtil.isAncestor((PsiElement)((PyConditionalExpression)e).getTruePart(), (PsiElement)node, (boolean)true)) {
                        cond = ((PyConditionalExpression)e).getCondition();
                    }
                    if (cond instanceof PyCallExpression) {
                        calls.add((PyCallExpression)cond);
                    }
                    if (cond != null) {
                        PyCallExpression[] callExpressions = (PyCallExpression[])PsiTreeUtil.getChildrenOfType((PsiElement)cond, PyCallExpression.class);
                        if (callExpressions != null) {
                            calls.addAll(Arrays.asList(callExpressions));
                        }
                        for (PyCallExpression call : calls) {
                            PyExpression callee = call.getCallee();
                            PyExpression[] args = call.getArguments();
                            if (callee == null || !"hasattr".equals(callee.getName()) || args.length != 2 || !nodeName.equals(args[0].getName()) || !(args[1] instanceof PyStringLiteralExpression) || !((PyStringLiteralExpression)args[1]).getStringValue().equals(name)) continue;
                            return true;
                        }
                    }
                    e = (PyElement)PsiTreeUtil.getParentOfType((PsiElement)e, PyConditionalStatementPart.class);
                }
            }
            return false;
        }

        public void visitComment(PsiComment comment) {
            super.visitComment(comment);
            if (comment instanceof PsiLanguageInjectionHost) {
                this.processInjection((PsiLanguageInjectionHost)comment);
            }
        }

        @Override
        public void visitPyElement(PyElement node) {
            super.visitPyElement(node);
            PsiFile file = node.getContainingFile();
            InjectedLanguageManager injectedLanguageManager = InjectedLanguageManager.getInstance((Project)node.getProject());
            if (injectedLanguageManager.isInjectedFragment(file)) {
                PsiLanguageInjectionHost host = injectedLanguageManager.getInjectionHost((PsiElement)node);
                this.processInjection(host);
            }
            if (node instanceof PyReferenceOwner) {
                PyResolveContext resolveContext = PyResolveContext.noImplicits().withTypeEvalContext(this.myTypeEvalContext);
                this.processReference(node, (PsiReference)((PyReferenceOwner)node).getReference(resolveContext));
            } else {
                if (node instanceof PsiLanguageInjectionHost) {
                    this.processInjection((PsiLanguageInjectionHost)node);
                }
                for (PsiReference reference : node.getReferences()) {
                    this.processReference(node, reference);
                }
            }
        }

        private void processInjection(@Nullable PsiLanguageInjectionHost node) {
            if (node == null) {
                return;
            }
            List files = InjectedLanguageManager.getInstance((Project)node.getProject()).getInjectedPsiFiles((PsiElement)node);
            if (files != null) {
                for (Pair pair : files) {
                    new PyRecursiveElementVisitor(){

                        @Override
                        public void visitPyElement(PyElement element) {
                            super.visitPyElement(element);
                            if (element instanceof PyReferenceOwner) {
                                PyResolveContext resolveContext = PyResolveContext.noImplicits().withTypeEvalContext(myTypeEvalContext);
                                PsiPolyVariantReference reference = ((PyReferenceOwner)element).getReference(resolveContext);
                                this.markTargetImportsAsUsed(reference);
                            }
                        }
                    }.visitElement((PsiElement)pair.getFirst());
                }
            }
        }

        private void markTargetImportsAsUsed(@NotNull PsiPolyVariantReference reference) {
            ResolveResult[] resolveResults;
            if (reference == null) {
                Visitor.$$$reportNull$$$0(4);
            }
            for (ResolveResult resolveResult : resolveResults = reference.multiResolve(false)) {
                PyImportedNameDefiner definer;
                if (!(resolveResult instanceof ImportedResolveResult) || (definer = ((ImportedResolveResult)resolveResult).getDefiner()) == null) continue;
                this.myUsedImports.add(definer);
            }
        }

        private void processReference(@NotNull PyElement node, @Nullable PsiReference reference) {
            boolean unresolved;
            if (node == null) {
                Visitor.$$$reportNull$$$0(5);
            }
            if (!this.isEnabled((PsiElement)node) || reference == null || reference.isSoft()) {
                return;
            }
            PyExceptPart guard = Visitor.getImportErrorGuard(node);
            if (guard != null) {
                this.processReferenceInImportGuard(node, guard);
                return;
            }
            if (node instanceof PyQualifiedExpression) {
                PyQualifiedExpression qExpr = (PyQualifiedExpression)node;
                PyExpression qualifier = qExpr.getQualifier();
                String name = node.getName();
                if (qualifier != null && name != null && Visitor.isGuardedByHasattr(qualifier, name)) {
                    return;
                }
            }
            PsiElement target = null;
            if (reference instanceof PsiPolyVariantReference) {
                PsiPolyVariantReference poly = (PsiPolyVariantReference)reference;
                ResolveResult[] resolveResults = poly.multiResolve(false);
                unresolved = resolveResults.length == 0;
                for (ResolveResult resolveResult : resolveResults) {
                    PyImportedNameDefiner definer;
                    if (target == null && resolveResult.isValidResult()) {
                        target = resolveResult.getElement();
                    }
                    if (!(resolveResult instanceof ImportedResolveResult) || (definer = ((ImportedResolveResult)resolveResult).getDefiner()) == null) continue;
                    this.myUsedImports.add(definer);
                }
            } else {
                target = reference.resolve();
                boolean bl = unresolved = target == null;
            }
            if (unresolved) {
                boolean ignoreUnresolved = false;
                for (PyInspectionExtension extension : PyInspectionExtension.EP_NAME.getExtensionList()) {
                    if (!extension.ignoreUnresolvedReference(node, reference, this.myTypeEvalContext)) continue;
                    ignoreUnresolved = true;
                    break;
                }
                if (!ignoreUnresolved) {
                    HighlightSeverity severity;
                    HighlightSeverity highlightSeverity = severity = reference instanceof PsiReferenceEx ? ((PsiReferenceEx)reference).getUnresolvedHighlightSeverity(this.myTypeEvalContext) : HighlightSeverity.ERROR;
                    if (severity == null) {
                        return;
                    }
                    this.registerUnresolvedReferenceProblem(node, reference, severity);
                }
                if (node.getParent() instanceof PyImportElement) {
                    this.myAllImports.remove(node.getParent());
                }
            } else if (reference instanceof PyImportReference && target == reference.getElement().getContainingFile() && !Visitor.isContainingFileImportAllowed(node, (PsiFile)target)) {
                this.registerProblem((PsiElement)node, "Import resolves to its containing file");
            }
        }

        private static boolean isContainingFileImportAllowed(PyElement node, PsiFile target) {
            return PyImportStatementNavigator.getImportStatementByElement((PsiElement)node) == null && target.getName().equals("__init__.py");
        }

        private void processReferenceInImportGuard(@NotNull PyElement node, @NotNull PyExceptPart guard) {
            PyImportElement importElement;
            if (node == null) {
                Visitor.$$$reportNull$$$0(6);
            }
            if (guard == null) {
                Visitor.$$$reportNull$$$0(7);
            }
            if ((importElement = (PyImportElement)PsiTreeUtil.getParentOfType((PsiElement)node, PyImportElement.class)) != null) {
                List<PsiElement> allWrites;
                boolean hasWriteInsideGuard;
                String visibleName = importElement.getVisibleName();
                ScopeOwner owner = ScopeUtil.getScopeOwner((PsiElement)importElement);
                if (visibleName != null && owner != null && !(hasWriteInsideGuard = (allWrites = ScopeUtil.getElementsOfAccessType(visibleName, owner, ReadWriteInstruction.ACCESS.WRITE)).stream().anyMatch(e -> PsiTreeUtil.isAncestor((PsiElement)guard, (PsiElement)e, (boolean)false))) && !Visitor.shouldSkipMissingWriteInsideGuard(guard, visibleName)) {
                    this.myImportsInsideGuard.add(importElement);
                }
            }
        }

        private static boolean shouldSkipMissingWriteInsideGuard(@NotNull PyExceptPart guard, @NotNull String name) {
            if (guard == null) {
                Visitor.$$$reportNull$$$0(8);
            }
            if (name == null) {
                Visitor.$$$reportNull$$$0(9);
            }
            return Visitor.isDefinedInParentScope(name, guard) || PyBuiltinCache.getInstance(guard).getByName(name) != null || Visitor.controlFlowAlwaysTerminatesInsideGuard(guard);
        }

        private static boolean isDefinedInParentScope(@NotNull String name, @NotNull PsiElement anchor) {
            if (name == null) {
                Visitor.$$$reportNull$$$0(10);
            }
            if (anchor == null) {
                Visitor.$$$reportNull$$$0(11);
            }
            return ScopeUtil.getDeclarationScopeOwner((PsiElement)ScopeUtil.getScopeOwner(anchor), name) != null;
        }

        private static boolean controlFlowAlwaysTerminatesInsideGuard(@NotNull PyExceptPart guard) {
            ScopeOwner owner;
            if (guard == null) {
                Visitor.$$$reportNull$$$0(12);
            }
            if ((owner = ScopeUtil.getScopeOwner(guard)) == null) {
                return false;
            }
            ControlFlow flow = ControlFlowCache.getControlFlow(owner);
            Instruction[] instructions = flow.getInstructions();
            int start = ControlFlowUtil.findInstructionNumberByElement((Instruction[])instructions, (PsiElement)guard.getExceptClass());
            if (start <= 0) {
                return false;
            }
            Ref canEscapeGuard = Ref.create((Object)false);
            ControlFlowUtil.process((Instruction[])instructions, (int)start, instruction -> {
                PsiElement e = instruction.getElement();
                if (e != null && !PsiTreeUtil.isAncestor((PsiElement)guard, (PsiElement)e, (boolean)true)) {
                    canEscapeGuard.set((Object)true);
                    return false;
                }
                return true;
            });
            return (Boolean)canEscapeGuard.get() == false;
        }

        private void registerUnresolvedReferenceProblem(@NotNull PyElement node, @NotNull PsiReference reference, @NotNull HighlightSeverity severity) {
            QualifiedName qname;
            List components;
            String refName;
            if (node == null) {
                Visitor.$$$reportNull$$$0(13);
            }
            if (reference == null) {
                Visitor.$$$reportNull$$$0(14);
            }
            if (severity == null) {
                Visitor.$$$reportNull$$$0(15);
            }
            if (reference instanceof DocStringTypeReference) {
                return;
            }
            String description = null;
            PsiElement element = reference.getElement();
            String text2 = element.getText();
            TextRange rangeInElement = reference.getRangeInElement();
            String refText = text2;
            if (rangeInElement.getStartOffset() > 0 && rangeInElement.getEndOffset() > 0) {
                refText = rangeInElement.substring(text2);
            }
            ArrayList<LocalQuickFix> actions = new ArrayList<LocalQuickFix>(2);
            String string = refName = element instanceof PyQualifiedExpression ? ((PyQualifiedExpression)element).getReferencedName() : refText;
            if (refName == null || refName.length() <= 0) {
                return;
            }
            List<QualifiedName> qualifiedNames = Visitor.getCanonicalNames(reference, this.myTypeEvalContext);
            for (QualifiedName name : qualifiedNames) {
                String canonicalName = name.toString();
                for (String ignored : this.myIgnoredIdentifiers) {
                    String prefix;
                    if (!(ignored.endsWith(".*") ? canonicalName.startsWith(prefix = ignored.substring(0, ignored.length() - ".*".length())) : canonicalName.equals(ignored))) continue;
                    return;
                }
            }
            if (this.myIgnoredIdentifiers.contains((Object)refName)) {
                return;
            }
            if (element instanceof PyReferenceExpression) {
                PyReferenceExpression expr = (PyReferenceExpression)element;
                if (PyNames.COMPARISON_OPERATORS.contains((Object)refName)) {
                    return;
                }
                if (!expr.isQualified()) {
                    if (PyUnreachableCodeInspection.hasAnyInterruptedControlFlowPaths((PsiElement)expr)) {
                        return;
                    }
                    if (refText.equals("true") || refText.equals("false")) {
                        actions.add(new UnresolvedRefTrueFalseQuickFix(element));
                    }
                    this.addAddSelfFix(node, expr, actions);
                    PyCallExpression callExpression = (PyCallExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PyCallExpression.class);
                    if (!(callExpression == null || callExpression.getCallee() instanceof PyQualifiedExpression && ((PyQualifiedExpression)callExpression.getCallee()).getQualifier() != null)) {
                        actions.add(new UnresolvedRefCreateFunctionQuickFix(callExpression, expr));
                    }
                    PyFunction parentFunction = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)element, PyFunction.class);
                    PyDecorator decorator = (PyDecorator)PsiTreeUtil.getParentOfType((PsiElement)element, PyDecorator.class);
                    PyAnnotation annotation = (PyAnnotation)PsiTreeUtil.getParentOfType((PsiElement)element, PyAnnotation.class);
                    PyImportStatement importStatement = (PyImportStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PyImportStatement.class);
                    if (parentFunction != null && decorator == null && annotation == null && importStatement == null) {
                        actions.add(new UnresolvedReferenceAddParameterQuickFix(refName));
                    }
                    actions.add(new PyRenameUnresolvedRefQuickFix());
                }
                if (PyModuleType.getPossibleInstanceMembers().contains(refName)) {
                    return;
                }
                if (PsiTreeUtil.getParentOfType((PsiElement)PsiTreeUtil.getParentOfType((PsiElement)node, PyImportElement.class), (Class[])new Class[]{PyTryExceptStatement.class, PyIfStatement.class}) != null) {
                    severity = HighlightSeverity.WEAK_WARNING;
                    description = PyBundle.message("INSP.module.$0.not.found", refText);
                }
            }
            if (reference instanceof PsiReferenceEx && description == null) {
                description = ((PsiReferenceEx)reference).getUnresolvedDescription();
            }
            if (description == null) {
                PyType type;
                PyExpression qualifier;
                boolean markedQualified = false;
                if (element instanceof PyQualifiedExpression) {
                    if ("__qualname__".equals(refText) && !LanguageLevel.forElement(element).isPython2()) {
                        return;
                    }
                    PyQualifiedExpression expr = (PyQualifiedExpression)element;
                    if (PyNames.COMPARISON_OPERATORS.contains((Object)expr.getReferencedName())) {
                        return;
                    }
                }
                if ((qualifier = Visitor.getReferenceQualifier(reference)) != null && (type = this.myTypeEvalContext.getType(qualifier)) != null) {
                    if (this.ignoreUnresolvedMemberForType(type, reference, refName) || this.isDeclaredInSlots(type, refName)) {
                        return;
                    }
                    this.addCreateMemberFromUsageFixes(type, reference, refText, actions);
                    if (type instanceof PyClassType) {
                        PyClassType classType = (PyClassType)type;
                        if (reference instanceof PyOperatorReference) {
                            PyClassLikeType metaClassType;
                            String className = type.getName();
                            if (classType.isDefinition() && (metaClassType = classType.getMetaClassType(this.myTypeEvalContext, true)) != null) {
                                className = metaClassType.getName();
                            }
                            description = PyBundle.message("INSP.unresolved.operator.ref", className, refName, ((PyOperatorReference)reference).getReadableOperatorName());
                        } else {
                            description = PyBundle.message("INSP.unresolved.ref.$0.for.class.$1", refText, type.getName());
                        }
                        markedQualified = true;
                    } else {
                        description = PyBundle.message("INSP.cannot.find.$0.in.$1", refText, type.getName());
                        markedQualified = true;
                    }
                }
                if (!markedQualified) {
                    description = PyBundle.message("INSP.unresolved.ref.$0", refText);
                    if (PythonImportUtils.isImportable(element)) {
                        Visitor.addAutoImportFix(node, reference, actions);
                    }
                    this.addCreateClassFix(refText, element, actions);
                }
            }
            ProblemHighlightType hl_type = severity == HighlightSeverity.WARNING ? ProblemHighlightType.GENERIC_ERROR_OR_WARNING : (severity == HighlightSeverity.ERROR ? ProblemHighlightType.GENERIC_ERROR : ProblemHighlightType.LIKE_UNKNOWN_SYMBOL);
            PyImportStatementBase importStatementBase = (PyImportStatementBase)PsiTreeUtil.getParentOfType((PsiElement)element, PyImportStatementBase.class);
            if (importStatementBase != null && GenerateBinaryStubsFix.isApplicable(importStatementBase)) {
                actions.addAll(GenerateBinaryStubsFix.generateFixes(importStatementBase));
            }
            if (qualifiedNames.size() == 1) {
                QualifiedName qualifiedName = qualifiedNames.get(0);
                actions.add(new AddIgnoredIdentifierQuickFix(qualifiedName, false));
                if (qualifiedName.getComponentCount() > 1) {
                    actions.add(new AddIgnoredIdentifierQuickFix(qualifiedName.removeLastComponent(), true));
                }
            }
            Visitor.addPluginQuickFixes(reference, actions);
            if (reference instanceof PyImportReference && !(components = (qname = QualifiedName.fromDottedString((String)refName)).getComponents()).isEmpty()) {
                String packageName = (String)components.get(0);
                Module module2 = ModuleUtilCore.findModuleForPsiElement((PsiElement)node);
                Sdk sdk = PythonSdkType.findPythonSdk(module2);
                if (module2 != null && sdk != null && PyPackageUtil.packageManagementEnabled(sdk)) {
                    ((StreamEx)StreamEx.of((Object)packageName).append((Collection)PyPIPackageUtil.PACKAGES_TOPLEVEL.getOrDefault((Object)packageName, Collections.emptyList())).filter(PyPIPackageUtil.INSTANCE::isInPyPI)).forEach(pkg -> Visitor.addInstallPackageAction(actions, pkg, module2, sdk));
                }
            }
            if (reference instanceof PySubstitutionChunkReference) {
                return;
            }
            this.registerProblem((PsiElement)node, description, hl_type, null, rangeInElement, actions.toArray(LocalQuickFix.EMPTY_ARRAY));
        }

        @Nullable
        private static PyExpression getReferenceQualifier(@NotNull PsiReference reference) {
            PyReferenceExpression source;
            PyFromImportStatement statement;
            PyExpression qualifier;
            PsiElement element;
            if (reference == null) {
                Visitor.$$$reportNull$$$0(16);
            }
            if ((element = reference.getElement()) instanceof PyQualifiedExpression && (qualifier = ((PyQualifiedExpression)element).getQualifier()) != null) {
                return qualifier;
            }
            if (reference instanceof PyFromImportNameReference && (statement = (PyFromImportStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PyFromImportStatement.class)) != null && (source = statement.getImportSource()) != null) {
                return source;
            }
            return null;
        }

        private boolean isDeclaredInSlots(@NotNull PyType type, @NotNull String attrName) {
            if (type == null) {
                Visitor.$$$reportNull$$$0(17);
            }
            if (attrName == null) {
                Visitor.$$$reportNull$$$0(18);
            }
            return ((StreamEx)PyTypeUtil.toStream(type).select(PyClassType.class).map(PyClassType::getPyClass).flatMap(cls -> StreamEx.of((Object)cls).append(cls.getAncestorClasses(this.myTypeEvalContext))).nonNull().filter(c -> c.isNewStyleClass(this.myTypeEvalContext))).flatCollection(PyClass::getOwnSlots).anyMatch(attrName::equals);
        }

        private static void addInstallPackageAction(List<LocalQuickFix> actions, String packageName, Module module2, Sdk sdk) {
            List<PyRequirement> requirements = Collections.singletonList(PyRequirementsKt.pyRequirement(packageName));
            String name = "Install package " + packageName;
            actions.add(new PyPackageRequirementsInspection.PyInstallRequirementsFix(name, module2, sdk, requirements));
        }

        @NotNull
        private static List<QualifiedName> getCanonicalNames(@NotNull PsiReference reference, @NotNull TypeEvalContext context) {
            if (reference == null) {
                Visitor.$$$reportNull$$$0(19);
            }
            if (context == null) {
                Visitor.$$$reportNull$$$0(20);
            }
            PsiElement element = reference.getElement();
            SmartList result = new SmartList();
            if (reference instanceof PyOperatorReference && element instanceof PyQualifiedExpression) {
                PyType type;
                PyExpression receiver = ((PyOperatorReference)reference).getReceiver();
                if (receiver != null && (type = context.getType(receiver)) instanceof PyClassType) {
                    String methodName = ((PyQualifiedExpression)element).getReferencedName();
                    ContainerUtil.addIfNotNull((Collection)result, (Object)Visitor.extractAttributeQNameFromClassType(methodName, (PyClassType)type));
                }
            } else if (element instanceof PyReferenceExpression) {
                PyReferenceExpression expr = (PyReferenceExpression)element;
                PyExpression qualifier = expr.getQualifier();
                String exprName = expr.getName();
                if (exprName != null) {
                    if (qualifier != null) {
                        PyType type = context.getType(qualifier);
                        if (type instanceof PyClassType) {
                            ContainerUtil.addIfNotNull((Collection)result, (Object)Visitor.extractAttributeQNameFromClassType(exprName, (PyClassType)type));
                        } else if (type instanceof PyModuleType) {
                            PyFile file = ((PyModuleType)type).getModule();
                            QualifiedName name = QualifiedNameFinder.findCanonicalImportPath((PsiElement)file, element);
                            if (name != null) {
                                ContainerUtil.addIfNotNull((Collection)result, (Object)name.append(exprName));
                            }
                        } else if (type instanceof PyImportedModuleType) {
                            QualifiedName path;
                            PyImportedModule module2 = ((PyImportedModuleType)type).getImportedModule();
                            PsiElement resolved = module2.resolve();
                            if (resolved != null && (path = QualifiedNameFinder.findCanonicalImportPath(resolved, element)) != null) {
                                ContainerUtil.addIfNotNull((Collection)result, (Object)path.append(exprName));
                            }
                        } else if (type instanceof PyFunctionType) {
                            QualifiedName path;
                            PyCallable callable = ((PyFunctionType)type).getCallable();
                            String callableName = callable.getName();
                            if (callableName != null && (path = QualifiedNameFinder.findCanonicalImportPath((PsiElement)callable, element)) != null) {
                                result.add(path.append(QualifiedName.fromComponents((String[])new String[]{callableName, exprName})));
                            }
                        } else if (type instanceof PyUnionType) {
                            for (PyType memberType : ((PyUnionType)type).getMembers()) {
                                if (!(memberType instanceof PyClassType)) continue;
                                ContainerUtil.addIfNotNull((Collection)result, (Object)Visitor.extractAttributeQNameFromClassType(exprName, (PyClassType)memberType));
                            }
                        }
                    } else {
                        PsiElement parent = element.getParent();
                        if (parent instanceof PyImportElement) {
                            QualifiedName path;
                            PsiFileSystemItem resolved;
                            PyImportStatementBase importStmt = (PyImportStatementBase)PsiTreeUtil.getParentOfType((PsiElement)parent, PyImportStatementBase.class);
                            if (importStmt instanceof PyImportStatement) {
                                ContainerUtil.addIfNotNull((Collection)result, (Object)QualifiedName.fromComponents((String[])new String[]{exprName}));
                            } else if (importStmt instanceof PyFromImportStatement && (resolved = ((PyFromImportStatement)importStmt).resolveImportSource()) != null && (path = QualifiedNameFinder.findCanonicalImportPath((PsiElement)resolved, element)) != null) {
                                ContainerUtil.addIfNotNull((Collection)result, (Object)path.append(exprName));
                            }
                        } else {
                            QualifiedName path = QualifiedNameFinder.findCanonicalImportPath(element, element);
                            if (path != null) {
                                ContainerUtil.addIfNotNull((Collection)result, (Object)path.append(exprName));
                            }
                        }
                    }
                }
            } else if (reference instanceof DocStringParameterReference) {
                ContainerUtil.addIfNotNull((Collection)result, (Object)QualifiedName.fromDottedString((String)reference.getCanonicalText()));
            }
            SmartList smartList = result;
            if (smartList == null) {
                Visitor.$$$reportNull$$$0(21);
            }
            return smartList;
        }

        private static QualifiedName extractAttributeQNameFromClassType(String exprName, PyClassType type) {
            String name = type.getClassQName();
            if (name != null) {
                return QualifiedName.fromDottedString((String)name).append(exprName);
            }
            return null;
        }

        private boolean ignoreUnresolvedMemberForType(@NotNull PyType type, PsiReference reference, String name) {
            PyCallable callable;
            Object module2;
            if (type == null) {
                Visitor.$$$reportNull$$$0(22);
            }
            if (type instanceof PyNoneType || PyTypeChecker.isUnknown(type, this.myTypeEvalContext)) {
                return true;
            }
            if (type instanceof PyStructuralType && ((PyStructuralType)type).isInferredFromUsages()) {
                return true;
            }
            if (type instanceof PyImportedModuleType && ((PyImportedModule)(module2 = ((PyImportedModuleType)type).getImportedModule())).resolve() == null) {
                return true;
            }
            if (type instanceof PyCustomType) {
                module2 = ((PyCustomType)type).getTypesToMimic().iterator();
                while (module2.hasNext()) {
                    PyClassLikeType mimic = (PyClassLikeType)module2.next();
                    if (!(mimic instanceof PyClassType) || !PyUtil.hasUnresolvedAncestors(((PyClassType)mimic).getPyClass(), this.myTypeEvalContext)) continue;
                    return true;
                }
            }
            if (type instanceof PyClassType) {
                PyClass cls = ((PyClassType)type).getPyClass();
                if (PyTypeChecker.overridesGetAttr(cls, this.myTypeEvalContext)) {
                    return true;
                }
                if (cls.findProperty(name, true, this.myTypeEvalContext) != null) {
                    return true;
                }
                if (PyUtil.hasUnresolvedAncestors(cls, this.myTypeEvalContext)) {
                    return true;
                }
                if (this.isDecoratedAsDynamic(cls, true)) {
                    return true;
                }
                if (Visitor.hasUnresolvedDynamicMember((PyClassType)type, reference, name, this.myTypeEvalContext)) {
                    return true;
                }
                if (this.isAwaitOnGeneratorBasedCoroutine(name, reference, cls)) {
                    return true;
                }
            }
            if (type instanceof PyFunctionTypeImpl && (callable = ((PyFunctionTypeImpl)type).getCallable()) instanceof PyFunction && PyKnownDecoratorUtil.hasUnknownOrUpdatingAttributesDecorator((PyFunction)callable, this.myTypeEvalContext)) {
                return true;
            }
            if (type instanceof PyUnionType) {
                return ContainerUtil.exists(((PyUnionType)type).getMembers(), member -> this.ignoreUnresolvedMemberForType((PyType)member, reference, name));
            }
            if (type instanceof PyModuleType && (module2 = ((PyModuleType)type).getModule()).getLanguageLevel().isAtLeast(LanguageLevel.PYTHON37)) {
                return PyTypeChecker.definesGetAttr((PyFile)module2, this.myTypeEvalContext);
            }
            for (PyInspectionExtension extension : PyInspectionExtension.EP_NAME.getExtensionList()) {
                if (!extension.ignoreUnresolvedMember(type, name, this.myTypeEvalContext)) continue;
                return true;
            }
            return false;
        }

        private static boolean hasUnresolvedDynamicMember(@NotNull PyClassType type, PsiReference reference, @NotNull String name, TypeEvalContext typeEvalContext) {
            if (type == null) {
                Visitor.$$$reportNull$$$0(23);
            }
            if (name == null) {
                Visitor.$$$reportNull$$$0(24);
            }
            ArrayList<PyClassType> types = new ArrayList<PyClassType>(Collections.singletonList(type));
            types.addAll((Collection<PyClassType>)FluentIterable.from(type.getAncestorTypes(typeEvalContext)).filter(PyClassType.class).toList());
            for (PyClassType typeToCheck : types) {
                for (PyClassMembersProvider provider : PyClassMembersProvider.EP_NAME.getExtensionList()) {
                    Collection<PyCustomMember> resolveResult = provider.getMembers(typeToCheck, reference.getElement(), typeEvalContext);
                    for (PyCustomMember member : resolveResult) {
                        if (!member.getName().equals(name)) continue;
                        return true;
                    }
                }
            }
            return false;
        }

        private boolean isDecoratedAsDynamic(@NotNull PyClass cls, boolean inherited) {
            if (cls == null) {
                Visitor.$$$reportNull$$$0(25);
            }
            if (inherited) {
                if (this.isDecoratedAsDynamic(cls, false)) {
                    return true;
                }
                for (PyClass base : cls.getAncestorClasses(this.myTypeEvalContext)) {
                    if (base == null || !this.isDecoratedAsDynamic(base, false)) continue;
                    return true;
                }
            } else {
                if (PyKnownDecoratorUtil.hasUnknownDecorator(cls, this.myTypeEvalContext)) {
                    return true;
                }
                String docString = cls.getDocStringValue();
                if (docString != null && docString.contains("@DynamicAttrs")) {
                    return true;
                }
            }
            return false;
        }

        private boolean isAwaitOnGeneratorBasedCoroutine(@NotNull String name, @NotNull PsiReference reference, @NotNull PyClass cls) {
            PyExpression receiver;
            if (name == null) {
                Visitor.$$$reportNull$$$0(26);
            }
            if (reference == null) {
                Visitor.$$$reportNull$$$0(27);
            }
            if (cls == null) {
                Visitor.$$$reportNull$$$0(28);
            }
            if ("__await__".equals(name) && reference instanceof PyOperatorReference && "typing.Generator".equals(cls.getQualifiedName()) && (receiver = ((PyOperatorReference)reference).getReceiver()) instanceof PyCallExpression) {
                return PyKnownDecoratorUtil.isResolvedToGeneratorBasedCoroutine((PyCallExpression)receiver, this.getResolveContext(), this.myTypeEvalContext);
            }
            return false;
        }

        private void addCreateMemberFromUsageFixes(PyType type, PsiReference reference, String refText, List<LocalQuickFix> actions) {
            PsiElement element = reference.getElement();
            if (type instanceof PyClassTypeImpl) {
                PyClass cls = ((PyClassType)type).getPyClass();
                if (!PyBuiltinCache.getInstance(element).isBuiltin((PsiElement)cls)) {
                    if (element.getParent() instanceof PyCallExpression) {
                        actions.add(new AddMethodQuickFix(refText, cls.getName(), true));
                    } else if (!(reference instanceof PyOperatorReference)) {
                        actions.add(new AddFieldQuickFix(refText, "None", type.getName(), true));
                    }
                }
            } else if (type instanceof PyModuleType) {
                PyFile file = ((PyModuleType)type).getModule();
                actions.add(new AddFunctionQuickFix(refText, file.getName()));
                this.addCreateClassFix(refText, element, actions);
            }
        }

        private void addAddSelfFix(PyElement node, PyReferenceExpression expr, List<LocalQuickFix> actions) {
            PyClass containedClass = (PyClass)PsiTreeUtil.getParentOfType((PsiElement)node, PyClass.class);
            PyFunction function = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)node, PyFunction.class);
            if (containedClass != null && function != null) {
                PyParameter[] parameters = function.getParameterList().getParameters();
                if (parameters.length == 0) {
                    return;
                }
                String qualifier = parameters[0].getText();
                PyDecoratorList decoratorList = function.getDecoratorList();
                boolean isClassMethod = false;
                if (decoratorList != null) {
                    for (PyDecorator decorator : decoratorList.getDecorators()) {
                        PyExpression callee = decorator.getCallee();
                        if (callee == null || !"classmethod".equals(callee.getText())) continue;
                        isClassMethod = true;
                    }
                }
                for (PyTargetExpression target : containedClass.getInstanceAttributes()) {
                    if (isClassMethod || !Comparing.strEqual((String)node.getName(), (String)target.getName())) continue;
                    actions.add(new UnresolvedReferenceAddSelfQuickFix(expr, qualifier));
                }
                for (PyStatement statement : containedClass.getStatementList().getStatements()) {
                    PyType type;
                    PyExpression assignedValue;
                    PyExpression lhsExpression;
                    if (!(statement instanceof PyAssignmentStatement) || (lhsExpression = ((PyAssignmentStatement)statement).getLeftHandSideExpression()) == null || !lhsExpression.getText().equals(expr.getText()) || !((assignedValue = ((PyAssignmentStatement)statement).getAssignedValue()) instanceof PyCallExpression) || !((type = this.myTypeEvalContext.getType(assignedValue)) instanceof PyClassTypeImpl) || !((PyCallExpression)assignedValue).isCalleeText("property")) continue;
                    actions.add(new UnresolvedReferenceAddSelfQuickFix(expr, qualifier));
                }
                for (PyFunction method : containedClass.getMethods()) {
                    if (!expr.getText().equals(method.getName())) continue;
                    actions.add(new UnresolvedReferenceAddSelfQuickFix(expr, qualifier));
                }
            }
        }

        private static void addAutoImportFix(PyElement node, PsiReference reference, List<LocalQuickFix> actions) {
            PsiFile file = InjectedLanguageManager.getInstance((Project)node.getProject()).getTopLevelFile((PsiElement)node);
            if (!(file instanceof PyFile)) {
                return;
            }
            AutoImportQuickFix importFix = PythonImportUtils.proposeImportFix(node, reference);
            if (importFix != null) {
                if (!Visitor.suppressHintForAutoImport(node, importFix) && PyCodeInsightSettings.getInstance().SHOW_IMPORT_POPUP) {
                    AutoImportHintAction autoImportHintAction = new AutoImportHintAction(importFix);
                    actions.add(autoImportHintAction);
                } else {
                    actions.add((LocalQuickFix)importFix);
                }
                if (ScopeUtil.getScopeOwner((PsiElement)node) instanceof PyFunction) {
                    actions.add((LocalQuickFix)importFix.forLocalImport());
                }
            } else {
                String refName;
                String string = refName = node instanceof PyQualifiedExpression ? ((PyQualifiedExpression)node).getReferencedName() : node.getText();
                if (refName == null) {
                    return;
                }
                QualifiedName qname = QualifiedName.fromDottedString((String)refName);
                List components = qname.getComponents();
                if (!components.isEmpty()) {
                    String packageName = (String)components.get(0);
                    Module module2 = ModuleUtilCore.findModuleForPsiElement((PsiElement)node);
                    if (PyPIPackageUtil.INSTANCE.isInPyPI(packageName) && PythonSdkType.findPythonSdk(module2) != null) {
                        actions.add(new PyPackageRequirementsInspection.InstallAndImportQuickFix(packageName, packageName, node));
                    } else {
                        String packageAlias = PyPackageAliasesProvider.commonImportAliases.get(packageName);
                        if (packageAlias != null && PyPIPackageUtil.INSTANCE.isInPyPI(packageName) && PythonSdkType.findPythonSdk(module2) != null) {
                            actions.add(new PyPackageRequirementsInspection.InstallAndImportQuickFix(packageAlias, packageName, node));
                        }
                    }
                }
            }
        }

        private static boolean suppressHintForAutoImport(PyElement node, AutoImportQuickFix importFix) {
            if (!Visitor.isCall(node) && importFix.hasOnlyFunctions()) {
                return true;
            }
            PyClass containingClass = (PyClass)PsiTreeUtil.getParentOfType((PsiElement)node, PyClass.class);
            return containingClass != null && (containingClass.findMethodByName(importFix.getNameToImport(), true, null) != null || containingClass.findInstanceAttribute(importFix.getNameToImport(), true) != null);
        }

        private void addCreateClassFix(@NonNls String refText, PsiElement element, List<LocalQuickFix> actions) {
            if (refText.length() > 2 && Character.isUpperCase(refText.charAt(0)) && !StringUtil.toUpperCase((String)refText).equals(refText) && PsiTreeUtil.getParentOfType((PsiElement)element, PyImportStatementBase.class) == null) {
                Object anchor = element;
                if (element instanceof PyQualifiedExpression) {
                    PyExpression expr = ((PyQualifiedExpression)element).getQualifier();
                    if (expr != null) {
                        PyType type = this.myTypeEvalContext.getType(expr);
                        anchor = type instanceof PyModuleType ? ((PyModuleType)type).getModule() : null;
                    }
                    if (anchor != null) {
                        actions.add(new CreateClassQuickFix(refText, (PsiElement)anchor));
                    }
                }
            }
        }

        private static boolean isCall(PyElement node) {
            PyCallExpression callExpression = (PyCallExpression)PsiTreeUtil.getParentOfType((PsiElement)node, PyCallExpression.class);
            return callExpression != null && node == callExpression.getCallee();
        }

        private static void addPluginQuickFixes(PsiReference reference, List<LocalQuickFix> actions) {
            for (PyUnresolvedReferenceQuickFixProvider provider : PyUnresolvedReferenceQuickFixProvider.EP_NAME.getExtensionList()) {
                provider.registerQuickFixes(reference, (Consumer<LocalQuickFix>)((Consumer)localQuickFix -> actions.add((LocalQuickFix)localQuickFix)));
            }
        }

        public void highlightUnusedImports() {
            List extensions = PyInspectionExtension.EP_NAME.getExtensionList();
            List<PsiElement> unused = this.collectUnusedImportElements();
            for (PsiElement element : unused) {
                if (extensions.stream().anyMatch(extension -> extension.ignoreUnused(element, this.myTypeEvalContext)) || element.getTextLength() <= 0) continue;
                this.registerProblem(element, "Unused import statement", ProblemHighlightType.LIKE_UNUSED_SYMBOL, null, new OptimizeImportsQuickFix());
            }
        }

        public void highlightImportsInsideGuards() {
            HashSet usedImportsInsideImportGuards = Sets.newHashSet(this.myImportsInsideGuard);
            usedImportsInsideImportGuards.retainAll(this.myUsedImports);
            for (PyImportedNameDefiner definer : usedImportsInsideImportGuards) {
                PyImportElement importElement = PyUtil.as(definer, PyImportElement.class);
                if (importElement == null) continue;
                PyTargetExpression asElement = importElement.getAsNameElement();
                PyReferenceOwner toHighlight = asElement != null ? asElement : importElement.getImportReferenceExpression();
                this.registerProblem((PsiElement)toHighlight, PyBundle.message("INSP.try.except.import.error", importElement.getVisibleName()), ProblemHighlightType.LIKE_UNKNOWN_SYMBOL);
            }
        }

        private List<PsiElement> collectUnusedImportElements() {
            if (this.myAllImports.isEmpty()) {
                return Collections.emptyList();
            }
            PyImportedNameDefiner first = this.myAllImports.iterator().next();
            if (first.getContainingFile() instanceof PyExpressionCodeFragment || PydevConsoleRunner.isInPydevConsole((PsiElement)first)) {
                return Collections.emptyList();
            }
            ArrayList<PsiElement> result = new ArrayList<PsiElement>();
            HashSet<PyImportedNameDefiner> unusedImports = new HashSet<PyImportedNameDefiner>(this.myAllImports);
            unusedImports.removeAll(this.myUsedImports);
            HashSet<PyImportedNameDefiner> unusedImportToSkip = new HashSet<PyImportedNameDefiner>();
            for (PyImportedNameDefiner pyImportedNameDefiner : unusedImports) {
                if (!PyUnresolvedReferencesInspection.importShouldBeSkippedByExtPoint(pyImportedNameDefiner)) continue;
                unusedImportToSkip.add(pyImportedNameDefiner);
            }
            unusedImports.removeAll(unusedImportToSkip);
            HashSet<String> usedImportNames = new HashSet<String>();
            for (PyImportedNameDefiner usedImport : this.myUsedImports) {
                for (PyElement e : usedImport.iterateNames()) {
                    usedImportNames.add(e.getName());
                }
            }
            HashSet<PyImportStatementBase> hashSet = new HashSet<PyImportStatementBase>();
            PyUnresolvedReferencesInspection suppressableInspection = new PyUnresolvedReferencesInspection();
            QualifiedName packageQName = null;
            List<String> dunderAll = null;
            block3: for (PyImportedNameDefiner unusedImport : unusedImports) {
                QualifiedName importedQName;
                PsiFileSystemItem importedElement;
                PyImportStatementBase importStatement;
                if (packageQName == null) {
                    PsiFile file = unusedImport.getContainingFile();
                    if (file instanceof PyFile) {
                        dunderAll = ((PyFile)file).getDunderAll();
                    }
                    if (file != null && PyUtil.isPackage(file)) {
                        packageQName = QualifiedNameFinder.findShortestImportableQName((PsiFileSystemItem)file);
                    }
                }
                if ((importStatement = (PyImportStatementBase)PsiTreeUtil.getParentOfType((PsiElement)unusedImport, PyImportStatementBase.class)) == null || hashSet.contains(importStatement) || this.myUsedImports.contains(unusedImport) || suppressableInspection.isSuppressedFor((PsiElement)importStatement) || PsiTreeUtil.getParentOfType((PsiElement)importStatement, PyTryExceptStatement.class) != null) continue;
                if (PsiTreeUtil.getParentOfType((PsiElement)unusedImport, PyIfStatement.class) != null) {
                    for (PyElement e : unusedImport.iterateNames()) {
                        if (!usedImportNames.contains(e.getName())) continue;
                        continue block3;
                    }
                }
                if (unusedImport instanceof PyImportElement) {
                    PyImportElement importElement = (PyImportElement)unusedImport;
                    PsiElement element = importElement.resolve();
                    if (element == null) {
                        if (importElement.getImportedQName() == null) continue;
                        if (Visitor.areAllImportsUnused(importStatement, unusedImports)) {
                            result.add((PsiElement)importStatement);
                            continue;
                        }
                        result.add((PsiElement)importElement);
                        continue;
                    }
                    if (dunderAll != null && dunderAll.contains(importElement.getVisibleName())) continue;
                    importedElement = element.getContainingFile();
                } else {
                    assert (importStatement instanceof PyFromImportStatement);
                    importedElement = ((PyFromImportStatement)importStatement).resolveImportSource();
                    if (importedElement == null) continue;
                }
                if (packageQName != null && importedElement != null && (importedQName = QualifiedNameFinder.findShortestImportableQName(importedElement)) != null && importedQName.matchesPrefix(packageQName)) continue;
                if (unusedImport instanceof PyStarImportElement || Visitor.areAllImportsUnused(importStatement, unusedImports)) {
                    hashSet.add(importStatement);
                    result.add((PsiElement)importStatement);
                    continue;
                }
                result.add((PsiElement)unusedImport);
            }
            return result;
        }

        private static boolean areAllImportsUnused(PyImportStatementBase importStatement, Set<PyImportedNameDefiner> unusedImports) {
            PyImportElement[] elements;
            for (PyImportElement element : elements = importStatement.getImportElements()) {
                if (unusedImports.contains(element)) continue;
                return false;
            }
            return true;
        }

        public void optimizeImports() {
            List<PsiElement> elementsToDelete = this.collectUnusedImportElements();
            for (PsiElement element : elementsToDelete) {
                PyPsiUtils.assertValid(element);
                element.delete();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 21: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 21: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "session";
                    break;
                }
                case 1: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "anchor";
                    break;
                }
                case 2: 
                case 5: 
                case 6: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 3: 
                case 9: 
                case 10: 
                case 24: 
                case 26: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 4: 
                case 14: 
                case 16: 
                case 19: 
                case 27: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "reference";
                    break;
                }
                case 7: 
                case 8: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "guard";
                    break;
                }
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "severity";
                    break;
                }
                case 17: 
                case 22: 
                case 23: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 18: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "attrName";
                    break;
                }
                case 20: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 21: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/inspections/unresolvedReference/PyUnresolvedReferencesInspection$Visitor";
                    break;
                }
                case 25: 
                case 28: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "cls";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/inspections/unresolvedReference/PyUnresolvedReferencesInspection$Visitor";
                    break;
                }
                case 21: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCanonicalNames";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "isEnabled";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "isGuardedByHasattr";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "markTargetImportsAsUsed";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "processReference";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "processReferenceInImportGuard";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "shouldSkipMissingWriteInsideGuard";
                    break;
                }
                case 10: 
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "isDefinedInParentScope";
                    break;
                }
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "controlFlowAlwaysTerminatesInsideGuard";
                    break;
                }
                case 13: 
                case 14: 
                case 15: {
                    objectArray = objectArray;
                    objectArray[2] = "registerUnresolvedReferenceProblem";
                    break;
                }
                case 16: {
                    objectArray = objectArray;
                    objectArray[2] = "getReferenceQualifier";
                    break;
                }
                case 17: 
                case 18: {
                    objectArray = objectArray;
                    objectArray[2] = "isDeclaredInSlots";
                    break;
                }
                case 19: 
                case 20: {
                    objectArray = objectArray;
                    objectArray[2] = "getCanonicalNames";
                    break;
                }
                case 21: {
                    break;
                }
                case 22: {
                    objectArray = objectArray;
                    objectArray[2] = "ignoreUnresolvedMemberForType";
                    break;
                }
                case 23: 
                case 24: {
                    objectArray = objectArray;
                    objectArray[2] = "hasUnresolvedDynamicMember";
                    break;
                }
                case 25: {
                    objectArray = objectArray;
                    objectArray[2] = "isDecoratedAsDynamic";
                    break;
                }
                case 26: 
                case 27: 
                case 28: {
                    objectArray = objectArray;
                    objectArray[2] = "isAwaitOnGeneratorBasedCoroutine";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 21: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

