/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.AutoPopupController;
import com.intellij.ide.GeneratedSourceFileChangeTracker;
import com.intellij.ide.GeneratedSourceFileChangeTrackerImpl;
import com.intellij.ide.startup.impl.StartupManagerImpl;
import com.intellij.idea.IdeaLogger;
import com.intellij.idea.IdeaTestApplication;
import com.intellij.mock.MockApplication;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.application.impl.NonBlockingReadActionImpl;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.command.impl.DocumentReferenceManagerImpl;
import com.intellij.openapi.command.impl.UndoManagerImpl;
import com.intellij.openapi.command.undo.DocumentReferenceManager;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.impl.FileTypeManagerImpl;
import com.intellij.openapi.module.EmptyModuleType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.project.impl.ProjectImpl;
import com.intellij.openapi.project.impl.TooManyProjectLeakedException;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.VirtualFilePointerTracker;
import com.intellij.openapi.vfs.impl.jar.JarFileSystemImpl;
import com.intellij.openapi.vfs.impl.local.LocalFileSystemImpl;
import com.intellij.openapi.vfs.newvfs.impl.VirtualDirectoryImpl;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFS;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFSImpl;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.impl.PsiDocumentManagerBase;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageManagerImpl;
import com.intellij.testFramework.CodeStyleSettingsTracker;
import com.intellij.testFramework.EditorListenerTracker;
import com.intellij.testFramework.EdtTestUtil;
import com.intellij.testFramework.LeakHunter;
import com.intellij.testFramework.LightPlatformTestCase;
import com.intellij.testFramework.PsiTestUtil;
import com.intellij.testFramework.RunAll;
import com.intellij.testFramework.SdkLeakTracker;
import com.intellij.testFramework.TempFiles;
import com.intellij.testFramework.TemporaryDirectoryKt;
import com.intellij.testFramework.TestDataProvider;
import com.intellij.testFramework.TestRunnerUtil;
import com.intellij.testFramework.ThreadTracker;
import com.intellij.testFramework.UsefulTestCase;
import com.intellij.testFramework.VfsTestUtil;
import com.intellij.util.MemoryDumpHelper;
import com.intellij.util.PathUtil;
import com.intellij.util.PathUtilRt;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.indexing.IndexableSetContributor;
import com.intellij.util.ui.UIUtil;
import gnu.trove.THashSet;
import gnu.trove.TIntHashSet;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.swing.SwingUtilities;
import junit.framework.TestCase;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PlatformTestCase
extends UsefulTestCase
implements DataProvider {
    private static IdeaTestApplication ourApplication;
    private static boolean ourReportedLeakedProjects;
    protected ProjectManagerEx myProjectManager;
    protected Project myProject;
    protected Module myModule;
    protected final Collection<File> myFilesToDelete = new THashSet();
    private final TempFiles myTempFiles = new TempFiles(this.myFilesToDelete);
    protected boolean myAssertionsInTestDetected;
    public static Thread ourTestThread;
    private static TestCase ourTestCase;
    private static final long DEFAULT_TEST_TIME = 300L;
    public static long ourTestTime;
    private EditorListenerTracker myEditorListenerTracker;
    private ThreadTracker myThreadTracker;
    private static boolean ourPlatformPrefixInitialized;
    private static Set<VirtualFile> ourEternallyLivingFilesCache;
    private SdkLeakTracker myOldSdks;
    private VirtualFilePointerTracker myVirtualFilePointerTracker;
    @Nullable
    private CodeStyleSettingsTracker myCodeStyleSettingsTracker;
    private static final String[] PREFIX_CANDIDATES;

    @NotNull
    public TempFiles getTempDir() {
        TempFiles tempFiles = this.myTempFiles;
        if (tempFiles == null) {
            PlatformTestCase.$$$reportNull$$$0(0);
        }
        return tempFiles;
    }

    @NotNull
    protected final VirtualFile createTestProjectStructure() throws IOException {
        VirtualFile virtualFile = PsiTestUtil.createTestProjectStructure(this.myProject, this.myModule, this.myFilesToDelete);
        if (virtualFile == null) {
            PlatformTestCase.$$$reportNull$$$0(1);
        }
        return virtualFile;
    }

    @NotNull
    protected final VirtualFile createTestProjectStructure(String rootPath) throws Exception {
        VirtualFile virtualFile = PsiTestUtil.createTestProjectStructure(this.myProject, this.myModule, rootPath, this.myFilesToDelete);
        if (virtualFile == null) {
            PlatformTestCase.$$$reportNull$$$0(2);
        }
        return virtualFile;
    }

    public static void synchronizeTempDirVfs(@NotNull VirtualFile tempDir) {
        if (tempDir == null) {
            PlatformTestCase.$$$reportNull$$$0(3);
        }
        tempDir.getChildren();
        tempDir.refresh(false, true);
    }

    protected void initApplication() throws Exception {
        boolean firstTime = ourApplication == null;
        ourApplication = IdeaTestApplication.getInstance(null);
        ourApplication.setDataProvider(this);
        if (firstTime) {
            PlatformTestCase.cleanPersistedVFSContent();
        }
        this.myOldSdks = new SdkLeakTracker();
    }

    public static void doAutodetectPlatformPrefix() {
        if (ourPlatformPrefixInitialized) {
            return;
        }
        if (System.getProperty("idea.platform.prefix") != null) {
            ourPlatformPrefixInitialized = true;
            return;
        }
        for (String candidate : PREFIX_CANDIDATES) {
            String markerPath = candidate != null ? "META-INF/" + candidate + "Plugin.xml" : "idea/ApplicationInfo.xml";
            URL resource = PlatformTestCase.class.getClassLoader().getResource(markerPath);
            if (resource == null) continue;
            if (candidate == null) break;
            PlatformTestCase.setPlatformPrefix(candidate);
            break;
        }
    }

    private static void cleanPersistedVFSContent() {
        ((PersistentFSImpl)PersistentFS.getInstance()).cleanPersistedContents();
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        File tempDir = new File(FileUtilRt.getTempDirectory());
        this.myFilesToDelete.add(tempDir);
        if (ourTestCase != null) {
            String message = "Previous test " + ourTestCase + " hasn't called tearDown(). Probably overridden without super call.";
            ourTestCase = null;
            PlatformTestCase.fail((String)message);
        }
        IdeaLogger.ourErrorsOccurred = null;
        LOG.debug(((Object)((Object)this)).getClass().getName() + ".setUp()");
        this.initApplication();
        if (this.myOldSdks == null) {
            this.myOldSdks = new SdkLeakTracker();
        }
        this.myEditorListenerTracker = new EditorListenerTracker();
        this.myThreadTracker = new ThreadTracker();
        this.setUpProject();
        boolean isTrackCodeStyleChanges = !this.isStressTest() && ApplicationManager.getApplication() != null && !(ApplicationManager.getApplication() instanceof MockApplication);
        this.myCodeStyleSettingsTracker = isTrackCodeStyleChanges ? new CodeStyleSettingsTracker(() -> CodeStyle.getDefaultSettings()) : null;
        ourTestCase = this;
        if (this.myProject != null) {
            ProjectManagerEx.getInstanceEx().openTestProject(this.myProject);
            CodeStyle.setTemporarySettings((Project)this.myProject, (CodeStyleSettings)new CodeStyleSettings());
            InjectedLanguageManagerImpl.pushInjectors((Project)this.myProject);
            ((PsiDocumentManagerBase)PsiDocumentManager.getInstance((Project)this.myProject)).clearUncommittedDocuments();
        }
        UIUtil.dispatchAllInvocationEvents();
        this.myVirtualFilePointerTracker = new VirtualFilePointerTracker();
    }

    public final Project getProject() {
        return this.myProject;
    }

    @NotNull
    public final PsiManager getPsiManager() {
        PsiManager psiManager = PsiManager.getInstance((Project)this.myProject);
        if (psiManager == null) {
            PlatformTestCase.$$$reportNull$$$0(4);
        }
        return psiManager;
    }

    public Module getModule() {
        return this.myModule;
    }

    protected void setUpProject() throws Exception {
        this.myProjectManager = ProjectManagerEx.getInstanceEx();
        PlatformTestCase.assertNotNull((String)"Cannot instantiate ProjectManager component", (Object)this.myProjectManager);
        this.myProject = this.doCreateProject(this.getProjectDirOrFile());
        this.myProjectManager.openTestProject(this.myProject);
        LocalFileSystem.getInstance().refreshIoFiles(this.myFilesToDelete);
        WriteAction.run(() -> ProjectRootManagerEx.getInstanceEx((Project)this.myProject).mergeRootsChangesDuring(() -> {
            this.setUpModule();
            this.setUpJdk();
        }));
        LightPlatformTestCase.clearUncommittedDocuments(this.getProject());
        this.runStartupActivities();
        ((FileTypeManagerImpl)FileTypeManager.getInstance()).drainReDetectQueue();
    }

    @NotNull
    protected Project doCreateProject(@NotNull Path projectFile) throws Exception {
        if (projectFile == null) {
            PlatformTestCase.$$$reportNull$$$0(5);
        }
        Project project2 = PlatformTestCase.createProject(projectFile.toFile(), ((Object)((Object)this)).getClass().getName() + "." + this.getName());
        if (project2 == null) {
            PlatformTestCase.$$$reportNull$$$0(6);
        }
        return project2;
    }

    @NotNull
    public static Project createProject(@NotNull File projectFile, @NotNull String creationPlace) {
        if (projectFile == null) {
            PlatformTestCase.$$$reportNull$$$0(7);
        }
        if (creationPlace == null) {
            PlatformTestCase.$$$reportNull$$$0(8);
        }
        Project project2 = PlatformTestCase.createProject(projectFile.getPath(), creationPlace);
        if (project2 == null) {
            PlatformTestCase.$$$reportNull$$$0(9);
        }
        return project2;
    }

    @NotNull
    public static Project createProject(@NotNull String path, @NotNull String creationPlace) {
        Project project2;
        if (path == null) {
            PlatformTestCase.$$$reportNull$$$0(10);
        }
        if (creationPlace == null) {
            PlatformTestCase.$$$reportNull$$$0(11);
        }
        String fileName = PathUtilRt.getFileName((String)path);
        try {
            String projectName = FileUtilRt.getNameWithoutExtension((String)fileName);
            project2 = ProjectManagerEx.getInstanceEx().newProject(projectName, path);
        }
        catch (TooManyProjectLeakedException e) {
            if (ourReportedLeakedProjects) {
                PlatformTestCase.fail((String)"Too many projects leaked, again.");
                if (null == null) {
                    PlatformTestCase.$$$reportNull$$$0(13);
                }
                return null;
            }
            ourReportedLeakedProjects = true;
            PlatformTestCase.reportLeakedProjects(e);
            if (null == null) {
                PlatformTestCase.$$$reportNull$$$0(14);
            }
            return null;
        }
        if (project2 == null) {
            PlatformTestCase.$$$reportNull$$$0(12);
        }
        return project2;
    }

    @NotNull
    public static String publishHeapDump(@NotNull String fileNamePrefix) {
        if (fileNamePrefix == null) {
            PlatformTestCase.$$$reportNull$$$0(15);
        }
        String fileName = fileNamePrefix + ".hprof.zip";
        File dumpFile = new File(System.getProperty("teamcity.build.tempDir", System.getProperty("java.io.tmpdir")), fileName);
        try {
            FileUtil.delete((File)dumpFile);
            MemoryDumpHelper.captureMemoryDumpZipped((File)dumpFile);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        String dumpPath = dumpFile.getAbsolutePath();
        System.out.println("##teamcity[publishArtifacts '" + dumpPath + "']");
        String string = dumpPath;
        if (string == null) {
            PlatformTestCase.$$$reportNull$$$0(16);
        }
        return string;
    }

    @Contract(value="_ -> fail")
    public static void reportLeakedProjects(@NotNull TooManyProjectLeakedException e) {
        if (e == null) {
            PlatformTestCase.$$$reportNull$$$0(17);
        }
        TIntHashSet hashCodes = new TIntHashSet();
        for (Project project2 : e.getLeakedProjects()) {
            hashCodes.add(System.identityHashCode(project2));
        }
        String dumpPath = PlatformTestCase.publishHeapDump("leakedProjects");
        StringBuilder leakers = new StringBuilder();
        leakers.append("Too many projects leaked: \n");
        LeakHunter.processLeaks(LeakHunter.allRoots(), ProjectImpl.class, p -> hashCodes.contains(System.identityHashCode(p)), (leaked, backLink) -> {
            int hashCode = System.identityHashCode(leaked);
            leakers.append("Leaked project found:").append(leaked).append("; hash: ").append(hashCode).append("; place: ").append(PlatformTestCase.getCreationPlace((Project)leaked)).append("\n");
            leakers.append(backLink).append("\n");
            leakers.append(";-----\n");
            hashCodes.remove(hashCode);
            return !hashCodes.isEmpty();
        });
        PlatformTestCase.fail((String)(leakers + "\nPlease see '" + dumpPath + "' for a memory dump"));
    }

    @NotNull
    public static String getCreationPlace(@NotNull Project project2) {
        String base;
        if (project2 == null) {
            PlatformTestCase.$$$reportNull$$$0(18);
        }
        try {
            base = project2.isDisposed() ? "" : project2.getBaseDir();
        }
        catch (Exception e) {
            base = " (" + e + " while getting base dir)";
        }
        String place = project2 instanceof ProjectImpl ? ((ProjectImpl)project2).getCreationTrace() : null;
        String string = project2 + " " + (place == null ? "" : place) + base;
        if (string == null) {
            PlatformTestCase.$$$reportNull$$$0(19);
        }
        return string;
    }

    protected void runStartupActivities() {
        StartupManagerImpl startupManager = (StartupManagerImpl)StartupManager.getInstance((Project)this.myProject);
        startupManager.runStartupActivities();
        startupManager.startCacheUpdate();
        startupManager.runPostStartupActivities();
    }

    @NotNull
    protected Path getProjectDirOrFile() {
        Path path = this.getProjectDirOrFile(false);
        if (path == null) {
            PlatformTestCase.$$$reportNull$$$0(20);
        }
        return path;
    }

    protected boolean isCreateProjectFileExplicitly() {
        return true;
    }

    @NotNull
    protected final Path getProjectDirOrFile(boolean isDirectoryBasedProject) {
        if (!isDirectoryBasedProject && this.isCreateProjectFileExplicitly()) {
            Path path;
            try {
                File tempFile = FileUtil.createTempFile((String)this.getName(), (String)".ipr");
                this.myFilesToDelete.add(tempFile);
                path = tempFile.toPath();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            if (path == null) {
                PlatformTestCase.$$$reportNull$$$0(21);
            }
            return path;
        }
        Path tempFile = TemporaryDirectoryKt.generateTemporaryPath(FileUtil.sanitizeFileName((String)this.getName(), (boolean)false) + (isDirectoryBasedProject ? "" : ".ipr"));
        this.myFilesToDelete.add(tempFile.toFile());
        Path path = tempFile;
        if (path == null) {
            PlatformTestCase.$$$reportNull$$$0(22);
        }
        return path;
    }

    protected void setUpModule() {
        try {
            WriteCommandAction.writeCommandAction((Project)this.getProject()).run(() -> {
                this.myModule = this.createMainModule();
            });
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    protected Module createMainModule() throws IOException {
        Module module2 = this.createModule(this.myProject.getName());
        if (module2 == null) {
            PlatformTestCase.$$$reportNull$$$0(23);
        }
        return module2;
    }

    @NotNull
    protected Module createModule(@NonNls @NotNull String moduleName) {
        if (moduleName == null) {
            PlatformTestCase.$$$reportNull$$$0(24);
        }
        Module module2 = this.doCreateRealModule(moduleName);
        if (module2 == null) {
            PlatformTestCase.$$$reportNull$$$0(25);
        }
        return module2;
    }

    @NotNull
    protected Module doCreateRealModule(@NotNull String moduleName) {
        if (moduleName == null) {
            PlatformTestCase.$$$reportNull$$$0(26);
        }
        Module module2 = this.doCreateRealModuleIn(moduleName, this.myProject, this.getModuleType());
        if (module2 == null) {
            PlatformTestCase.$$$reportNull$$$0(27);
        }
        return module2;
    }

    @NotNull
    protected Module doCreateRealModuleIn(@NotNull String moduleName, @NotNull Project project2, @NotNull ModuleType moduleType) {
        if (moduleName == null) {
            PlatformTestCase.$$$reportNull$$$0(28);
        }
        if (project2 == null) {
            PlatformTestCase.$$$reportNull$$$0(29);
        }
        if (moduleType == null) {
            PlatformTestCase.$$$reportNull$$$0(30);
        }
        Module module2 = this.createModuleAt(moduleName, project2, moduleType, Objects.requireNonNull(project2.getBasePath()));
        if (module2 == null) {
            PlatformTestCase.$$$reportNull$$$0(31);
        }
        return module2;
    }

    @NotNull
    protected Module createModuleAt(@NotNull String moduleName, @NotNull Project project2, @NotNull ModuleType moduleType, @NotNull String path) {
        if (moduleName == null) {
            PlatformTestCase.$$$reportNull$$$0(32);
        }
        if (project2 == null) {
            PlatformTestCase.$$$reportNull$$$0(33);
        }
        if (moduleType == null) {
            PlatformTestCase.$$$reportNull$$$0(34);
        }
        if (path == null) {
            PlatformTestCase.$$$reportNull$$$0(35);
        }
        if (this.isCreateProjectFileExplicitly()) {
            File moduleFile = new File(FileUtil.toSystemDependentName((String)path), moduleName + ".iml");
            FileUtil.createIfDoesntExist((File)moduleFile);
            this.myFilesToDelete.add(moduleFile);
            Module module2 = (Module)WriteAction.computeAndWait(() -> {
                VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(moduleFile);
                PlatformTestCase.assertNotNull((Object)virtualFile);
                Module module2 = ModuleManager.getInstance((Project)project2).newModule(virtualFile.getPath(), moduleType.getId());
                module2.getModuleFile();
                return module2;
            });
            if (module2 == null) {
                PlatformTestCase.$$$reportNull$$$0(36);
            }
            return module2;
        }
        ModuleManager moduleManager = ModuleManager.getInstance((Project)project2);
        Module module3 = (Module)WriteAction.computeAndWait(() -> moduleManager.newModule(path + File.separatorChar + moduleName + ".iml", moduleType.getId()));
        if (module3 == null) {
            PlatformTestCase.$$$reportNull$$$0(37);
        }
        return module3;
    }

    @NotNull
    protected ModuleType getModuleType() {
        EmptyModuleType emptyModuleType = EmptyModuleType.getInstance();
        if (emptyModuleType == null) {
            PlatformTestCase.$$$reportNull$$$0(38);
        }
        return emptyModuleType;
    }

    public static void cleanupApplicationCaches(@Nullable Project project2) {
        if (ApplicationManager.getApplication() == null) {
            return;
        }
        UndoManagerImpl globalInstance = (UndoManagerImpl)UndoManager.getGlobalInstance();
        if (globalInstance != null) {
            globalInstance.dropHistoryInTests();
        }
        if (project2 != null && !project2.isDisposed()) {
            ((UndoManagerImpl)UndoManager.getInstance((Project)project2)).dropHistoryInTests();
            ((DocumentReferenceManagerImpl)DocumentReferenceManager.getInstance()).cleanupForNextTest();
            ((PsiManagerImpl)PsiManager.getInstance((Project)project2)).cleanupForNextTest();
        }
        ProjectManagerEx projectManager = ProjectManagerEx.getInstanceEx();
        assert (projectManager != null) : "The ProjectManager is not initialized yet";
        if (projectManager.isDefaultProjectInitialized()) {
            Project defaultProject = projectManager.getDefaultProject();
            ((PsiManagerImpl)PsiManager.getInstance((Project)defaultProject)).cleanupForNextTest();
        }
        NonBlockingReadActionImpl.cancelAllTasks();
        ((FileBasedIndexImpl)FileBasedIndex.getInstance()).cleanupForNextTest();
        LocalFileSystemImpl localFileSystem = (LocalFileSystemImpl)LocalFileSystem.getInstance();
        if (localFileSystem != null) {
            localFileSystem.cleanupForNextTest();
        }
    }

    @NotNull
    private static Set<VirtualFile> eternallyLivingFiles() {
        if (ourEternallyLivingFilesCache != null) {
            Set<VirtualFile> set = ourEternallyLivingFilesCache;
            if (set == null) {
                PlatformTestCase.$$$reportNull$$$0(39);
            }
            return set;
        }
        HashSet<VirtualFile> survivors = new HashSet<VirtualFile>();
        for (IndexableSetContributor contributor : (IndexableSetContributor[])IndexableSetContributor.EP_NAME.getExtensions()) {
            for (VirtualFile file : IndexableSetContributor.getRootsToIndex((IndexableSetContributor)contributor)) {
                PlatformTestCase.registerSurvivor(survivors, file);
            }
        }
        ourEternallyLivingFilesCache = survivors;
        HashSet<VirtualFile> hashSet = survivors;
        if (hashSet == null) {
            PlatformTestCase.$$$reportNull$$$0(40);
        }
        return hashSet;
    }

    public static void addSurvivingFiles(@NotNull Collection<? extends VirtualFile> files) {
        if (files == null) {
            PlatformTestCase.$$$reportNull$$$0(41);
        }
        for (VirtualFile virtualFile : files) {
            PlatformTestCase.registerSurvivor(PlatformTestCase.eternallyLivingFiles(), virtualFile);
        }
    }

    private static void registerSurvivor(@NotNull Set<? super VirtualFile> survivors, @NotNull VirtualFile file) {
        if (survivors == null) {
            PlatformTestCase.$$$reportNull$$$0(42);
        }
        if (file == null) {
            PlatformTestCase.$$$reportNull$$$0(43);
        }
        PlatformTestCase.addSubTree(file, survivors);
        while (file != null && survivors.add((VirtualFile)file)) {
            file = file.getParent();
        }
    }

    private static void addSubTree(@NotNull VirtualFile root, @NotNull Set<? super VirtualFile> to) {
        if (root == null) {
            PlatformTestCase.$$$reportNull$$$0(44);
        }
        if (to == null) {
            PlatformTestCase.$$$reportNull$$$0(45);
        }
        if (root instanceof VirtualDirectoryImpl) {
            for (VirtualFile child : ((VirtualDirectoryImpl)root).getCachedChildren()) {
                if (!(child instanceof VirtualDirectoryImpl)) continue;
                to.add((VirtualFile)child);
                PlatformTestCase.addSubTree(child, to);
            }
        }
    }

    @Override
    protected void tearDown() throws Exception {
        Project project2 = this.myProject;
        if (project2 != null && !project2.isDisposed()) {
            AutoPopupController.getInstance((Project)project2).cancelAllRequests();
            PlatformTestCase.waitForProjectLeakingThreads(project2, 10L, TimeUnit.SECONDS);
        }
        new RunAll(new ThrowableRunnable[0]).append(() -> this.disposeRootDisposable()).append(() -> {
            if (project2 != null) {
                LightPlatformTestCase.doTearDown(project2, ourApplication);
            }
        }).append(() -> this.disposeProject()).append(() -> UIUtil.dispatchAllInvocationEvents()).append(() -> {
            if (this.myCodeStyleSettingsTracker != null) {
                this.myCodeStyleSettingsTracker.checkForSettingsDamage();
            }
        }).append(() -> {
            if (project2 != null) {
                InjectedLanguageManagerImpl.checkInjectorsAreDisposed((Project)project2);
            }
        }).append(() -> {
            JarFileSystemImpl.cleanupForNextTest();
            this.getTempDir().deleteAll();
            LocalFileSystem.getInstance().refreshIoFiles(this.myFilesToDelete);
            LaterInvocator.dispatchPendingFlushes();
        }).append(() -> {
            if (!this.myAssertionsInTestDetected && IdeaLogger.ourErrorsOccurred != null) {
                throw IdeaLogger.ourErrorsOccurred;
            }
        }).append(() -> super.tearDown()).append(() -> {
            if (this.myEditorListenerTracker != null) {
                this.myEditorListenerTracker.checkListenersLeak();
            }
        }).append(() -> {
            if (this.myThreadTracker != null) {
                this.myThreadTracker.checkLeak();
            }
        }).append(() -> LightPlatformTestCase.checkEditorsReleased()).append(() -> this.myOldSdks.checkForJdkTableLeaks()).append(() -> this.myVirtualFilePointerTracker.assertPointersAreDisposed()).append(() -> {
            this.myProjectManager = null;
            this.myProject = null;
            this.myModule = null;
            this.myFilesToDelete.clear();
            this.myEditorListenerTracker = null;
            this.myThreadTracker = null;
            ourTestCase = null;
        }).run();
    }

    private void disposeProject() {
        if (this.myProject != null) {
            PlatformTestCase.closeAndDisposeProjectAndCheckThatNoOpenProjects(this.myProject);
            this.myProject = null;
        }
    }

    public static void closeAndDisposeProjectAndCheckThatNoOpenProjects(@NotNull Project projectToClose) {
        if (projectToClose == null) {
            PlatformTestCase.$$$reportNull$$$0(46);
        }
        RunAll runAll = new RunAll(new ThrowableRunnable[0]);
        ProjectManagerEx projectManager = ProjectManagerEx.getInstanceEx();
        for (Project project2 : projectManager.closeTestProject(projectToClose)) {
            runAll = runAll.append(() -> {
                throw new IllegalStateException("Test project is not disposed: " + project2 + ";\n created in: " + PlatformTestCase.getCreationPlace(project2));
            }).append(() -> projectManager.forceCloseProject(project2, true));
        }
        runAll.append(() -> WriteAction.run(() -> Disposer.dispose((Disposable)projectToClose))).run();
    }

    protected void resetAllFields() {
        this.resetClassFields(((Object)((Object)this)).getClass());
    }

    @Override
    @NotNull
    protected final <T extends Disposable> T disposeOnTearDown(@NotNull T disposable) {
        if (disposable == null) {
            PlatformTestCase.$$$reportNull$$$0(47);
        }
        Disposer.register((Disposable)this.myProject, disposable);
        T t = disposable;
        if (t == null) {
            PlatformTestCase.$$$reportNull$$$0(48);
        }
        return t;
    }

    private void resetClassFields(@NotNull Class<?> aClass) {
        if (aClass == null) {
            PlatformTestCase.$$$reportNull$$$0(49);
        }
        try {
            PlatformTestCase.clearDeclaredFields((Object)this, aClass);
        }
        catch (IllegalAccessException e) {
            LOG.error((Throwable)e);
        }
        if (aClass == PlatformTestCase.class) {
            return;
        }
        this.resetClassFields(aClass.getSuperclass());
    }

    protected void setUpJdk() {
        Module[] modules;
        Sdk jdk = this.getTestProjectJdk();
        for (Module module2 : modules = ModuleManager.getInstance((Project)this.myProject).getModules()) {
            ModuleRootModificationUtil.setModuleSdk((Module)module2, (Sdk)jdk);
        }
    }

    @Nullable
    protected Sdk getTestProjectJdk() {
        return null;
    }

    @Override
    public void runBare() throws Throwable {
        if (!this.shouldRunTest()) {
            return;
        }
        TestRunnerUtil.replaceIdeEventQueueSafely();
        try {
            this.runBareImpl();
        }
        finally {
            try {
                EdtTestUtil.runInEdtAndWait((ThrowableRunnable<Throwable>)((ThrowableRunnable)() -> {
                    PlatformTestCase.cleanupApplicationCaches(this.getProject());
                    this.resetAllFields();
                }));
            }
            catch (Throwable throwable) {}
        }
    }

    private void runBareImpl() throws Throwable {
        ThrowableRunnable runnable = () -> {
            ourTestThread = Thread.currentThread();
            ourTestTime = 300L;
            try {
                try {
                    this.myAssertionsInTestDetected = true;
                    this.setUp();
                    this.myAssertionsInTestDetected = false;
                }
                catch (Throwable e) {
                    try {
                        this.tearDown();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    throw e;
                }
                Throwable exception = null;
                try {
                    this.myAssertionsInTestDetected = true;
                    this.runTest();
                    this.myAssertionsInTestDetected = false;
                }
                catch (Throwable e) {
                    exception = e;
                }
                finally {
                    block20: {
                        try {
                            this.tearDown();
                        }
                        catch (Throwable e) {
                            if (exception != null) break block20;
                            exception = e;
                        }
                    }
                }
                if (exception != null) {
                    throw exception;
                }
            }
            finally {
                ourTestThread = null;
            }
        };
        this.runBareRunnable((ThrowableRunnable<Throwable>)runnable);
        if (IdeaLogger.ourErrorsOccurred != null) {
            throw IdeaLogger.ourErrorsOccurred;
        }
        PlatformTestCase.waitForAllLaters();
        if (IdeaLogger.ourErrorsOccurred != null) {
            throw IdeaLogger.ourErrorsOccurred;
        }
    }

    private static void waitForAllLaters() throws InterruptedException, InvocationTargetException {
        for (int i = 0; i < 3; ++i) {
            SwingUtilities.invokeAndWait(EmptyRunnable.getInstance());
        }
    }

    protected void runBareRunnable(@NotNull ThrowableRunnable<Throwable> runnable) throws Throwable {
        if (runnable == null) {
            PlatformTestCase.$$$reportNull$$$0(50);
        }
        if (this.runInDispatchThread()) {
            EdtTestUtil.runInEdtAndWait(runnable);
        } else {
            runnable.run();
        }
    }

    protected boolean isRunInWriteAction() {
        return false;
    }

    @Override
    protected void invokeTestRunnable(@NotNull Runnable runnable) throws Exception {
        if (runnable == null) {
            PlatformTestCase.$$$reportNull$$$0(51);
        }
        Exception[] e = new Exception[1];
        Runnable runnable1 = () -> {
            try {
                if (ApplicationManager.getApplication().isDispatchThread() && this.isRunInWriteAction()) {
                    ApplicationManager.getApplication().runWriteAction(runnable);
                } else {
                    runnable.run();
                }
            }
            catch (Exception e1) {
                e[0] = e1;
            }
        };
        if (this.annotatedWith(WrapInCommand.class)) {
            CommandProcessor.getInstance().executeCommand(this.myProject, runnable1, "", null);
        } else {
            runnable1.run();
        }
        if (e[0] != null) {
            throw e[0];
        }
    }

    public Object getData(@NotNull String dataId) {
        if (dataId == null) {
            PlatformTestCase.$$$reportNull$$$0(52);
        }
        return this.myProject == null || this.myProject.isDisposed() ? null : new TestDataProvider(this.myProject).getData(dataId);
    }

    @NotNull
    public File createTempDir(@NonNls @NotNull String prefix) throws IOException {
        if (prefix == null) {
            PlatformTestCase.$$$reportNull$$$0(53);
        }
        File file = this.createTempDir(prefix, true);
        if (file == null) {
            PlatformTestCase.$$$reportNull$$$0(54);
        }
        return file;
    }

    @NotNull
    public File createTempDir(@NonNls @NotNull String prefix, boolean refresh) throws IOException {
        if (prefix == null) {
            PlatformTestCase.$$$reportNull$$$0(55);
        }
        File tempDirectory = FileUtilRt.createTempDirectory((String)("idea_test_" + prefix), null, (boolean)false);
        this.myFilesToDelete.add(tempDirectory);
        if (refresh) {
            PlatformTestCase.getVirtualFile(tempDirectory);
        }
        File file = tempDirectory;
        if (file == null) {
            PlatformTestCase.$$$reportNull$$$0(56);
        }
        return file;
    }

    protected static VirtualFile getVirtualFile(@NotNull File file) {
        if (file == null) {
            PlatformTestCase.$$$reportNull$$$0(57);
        }
        return LocalFileSystem.getInstance().refreshAndFindFileByIoFile(file);
    }

    @NotNull
    protected File createTempDirectory() throws IOException {
        File file = this.createTempDir("");
        if (file == null) {
            PlatformTestCase.$$$reportNull$$$0(58);
        }
        return file;
    }

    @NotNull
    protected File createTempDirectory(boolean refresh) throws IOException {
        File file = this.createTempDir("", refresh);
        if (file == null) {
            PlatformTestCase.$$$reportNull$$$0(59);
        }
        return file;
    }

    @NotNull
    protected File createTempFile(@NotNull String name, @Nullable String text) throws IOException {
        File directory;
        File file;
        if (name == null) {
            PlatformTestCase.$$$reportNull$$$0(60);
        }
        if (!(file = new File(directory = this.createTempDirectory(), name)).createNewFile()) {
            throw new IOException("Can't create " + file);
        }
        if (text != null) {
            FileUtil.writeToFile((File)file, (String)text);
        }
        File file2 = file;
        if (file2 == null) {
            PlatformTestCase.$$$reportNull$$$0(61);
        }
        return file2;
    }

    public static void setContentOnDisk(@NotNull File file, @Nullable byte[] bom, @NotNull String content, @NotNull Charset charset) throws IOException {
        if (file == null) {
            PlatformTestCase.$$$reportNull$$$0(62);
        }
        if (content == null) {
            PlatformTestCase.$$$reportNull$$$0(63);
        }
        if (charset == null) {
            PlatformTestCase.$$$reportNull$$$0(64);
        }
        FileOutputStream stream = new FileOutputStream(file);
        if (bom != null) {
            stream.write(bom);
        }
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)stream, charset);){
            writer.write(content);
        }
    }

    @NotNull
    public VirtualFile createTempFile(@NonNls @NotNull String ext, @Nullable byte[] bom, @NonNls @NotNull String content, @NotNull Charset charset) throws IOException {
        if (ext == null) {
            PlatformTestCase.$$$reportNull$$$0(65);
        }
        if (content == null) {
            PlatformTestCase.$$$reportNull$$$0(66);
        }
        if (charset == null) {
            PlatformTestCase.$$$reportNull$$$0(67);
        }
        File temp = FileUtil.createTempFile((String)"copy", (String)("." + ext));
        PlatformTestCase.setContentOnDisk(temp, bom, content, charset);
        this.myFilesToDelete.add(temp);
        VirtualFile file = PlatformTestCase.getVirtualFile(temp);
        assert (file != null) : temp;
        VirtualFile virtualFile = file;
        if (virtualFile == null) {
            PlatformTestCase.$$$reportNull$$$0(68);
        }
        return virtualFile;
    }

    @Nullable
    protected PsiFile getPsiFile(@NotNull Document document) {
        if (document == null) {
            PlatformTestCase.$$$reportNull$$$0(69);
        }
        return PsiDocumentManager.getInstance((Project)this.getProject()).getPsiFile(document);
    }

    private static void setPlatformPrefix(@NotNull String prefix) {
        if (prefix == null) {
            PlatformTestCase.$$$reportNull$$$0(70);
        }
        System.setProperty("idea.platform.prefix", prefix);
        ourPlatformPrefixInitialized = true;
    }

    @NotNull
    protected static VirtualFile createChildData(@NotNull VirtualFile dir, @NotNull @NonNls String name) {
        VirtualFile virtualFile;
        if (dir == null) {
            PlatformTestCase.$$$reportNull$$$0(71);
        }
        if (name == null) {
            PlatformTestCase.$$$reportNull$$$0(72);
        }
        try {
            virtualFile = (VirtualFile)WriteAction.computeAndWait(() -> dir.createChildData(null, name));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (virtualFile == null) {
            PlatformTestCase.$$$reportNull$$$0(73);
        }
        return virtualFile;
    }

    @NotNull
    protected static VirtualFile createChildDirectory(@NotNull VirtualFile dir, @NotNull @NonNls String name) {
        VirtualFile virtualFile;
        if (dir == null) {
            PlatformTestCase.$$$reportNull$$$0(74);
        }
        if (name == null) {
            PlatformTestCase.$$$reportNull$$$0(75);
        }
        try {
            virtualFile = (VirtualFile)WriteAction.computeAndWait(() -> dir.createChildDirectory(null, name));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (virtualFile == null) {
            PlatformTestCase.$$$reportNull$$$0(76);
        }
        return virtualFile;
    }

    protected static void rename(@NotNull VirtualFile vFile1, @NotNull String newName) {
        if (vFile1 == null) {
            PlatformTestCase.$$$reportNull$$$0(77);
        }
        if (newName == null) {
            PlatformTestCase.$$$reportNull$$$0(78);
        }
        try {
            WriteCommandAction.writeCommandAction(null).run(() -> vFile1.rename((Object)vFile1, newName));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected static void delete(@NotNull VirtualFile vFile1) {
        if (vFile1 == null) {
            PlatformTestCase.$$$reportNull$$$0(79);
        }
        VfsTestUtil.deleteFile(vFile1);
    }

    public static void move(@NotNull VirtualFile vFile1, @NotNull VirtualFile newFile) {
        if (vFile1 == null) {
            PlatformTestCase.$$$reportNull$$$0(80);
        }
        if (newFile == null) {
            PlatformTestCase.$$$reportNull$$$0(81);
        }
        try {
            WriteCommandAction.writeCommandAction(null).run(() -> vFile1.move((Object)vFile1, newFile));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    protected static VirtualFile copy(@NotNull VirtualFile file, @NotNull VirtualFile newParent, @NotNull String copyName) {
        if (file == null) {
            PlatformTestCase.$$$reportNull$$$0(82);
        }
        if (newParent == null) {
            PlatformTestCase.$$$reportNull$$$0(83);
        }
        if (copyName == null) {
            PlatformTestCase.$$$reportNull$$$0(84);
        }
        VirtualFile[] copy = new VirtualFile[1];
        try {
            WriteCommandAction.writeCommandAction(null).run(() -> {
                copy[0] = file.copy((Object)file, newParent, copyName);
            });
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        VirtualFile virtualFile = copy[0];
        if (virtualFile == null) {
            PlatformTestCase.$$$reportNull$$$0(85);
        }
        return virtualFile;
    }

    public static void copyDirContentsTo(@NotNull VirtualFile vTestRoot, @NotNull VirtualFile toDir) {
        if (vTestRoot == null) {
            PlatformTestCase.$$$reportNull$$$0(86);
        }
        if (toDir == null) {
            PlatformTestCase.$$$reportNull$$$0(87);
        }
        try {
            WriteCommandAction.writeCommandAction(null).run(() -> {
                for (VirtualFile file : vTestRoot.getChildren()) {
                    VfsUtil.copy((Object)file, (VirtualFile)file, (VirtualFile)toDir);
                }
            });
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void setFileText(@NotNull VirtualFile file, @NotNull String text) {
        if (file == null) {
            PlatformTestCase.$$$reportNull$$$0(88);
        }
        if (text == null) {
            PlatformTestCase.$$$reportNull$$$0(89);
        }
        try {
            WriteAction.runAndWait(() -> VfsUtil.saveText((VirtualFile)file, (String)text));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void setBinaryContent(@NotNull VirtualFile file, @NotNull byte[] content) {
        if (file == null) {
            PlatformTestCase.$$$reportNull$$$0(90);
        }
        if (content == null) {
            PlatformTestCase.$$$reportNull$$$0(91);
        }
        try {
            WriteAction.runAndWait(() -> file.setBinaryContent(content));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void setBinaryContent(@NotNull VirtualFile file, @NotNull byte[] content, long newModificationStamp, long newTimeStamp, Object object) {
        if (file == null) {
            PlatformTestCase.$$$reportNull$$$0(92);
        }
        if (content == null) {
            PlatformTestCase.$$$reportNull$$$0(93);
        }
        try {
            void requestor;
            WriteAction.runAndWait(() -> file.setBinaryContent(content, newModificationStamp, newTimeStamp, requestor));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    protected VirtualFile getOrCreateProjectBaseDir() {
        String basePath = this.myProject.getBasePath();
        VirtualFile baseDir = LocalFileSystem.getInstance().findFileByPath(Objects.requireNonNull(basePath));
        if (baseDir == null) {
            try {
                Files.createDirectories(Paths.get(basePath, new String[0]), new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            VirtualFile virtualFile = Objects.requireNonNull(LocalFileSystem.getInstance().refreshAndFindFileByPath(basePath));
            if (virtualFile == null) {
                PlatformTestCase.$$$reportNull$$$0(94);
            }
            return virtualFile;
        }
        VirtualFile virtualFile = baseDir;
        if (virtualFile == null) {
            PlatformTestCase.$$$reportNull$$$0(95);
        }
        return virtualFile;
    }

    @NotNull
    protected static VirtualFile getOrCreateModuleDir(@NotNull Module module2) throws IOException {
        if (module2 == null) {
            PlatformTestCase.$$$reportNull$$$0(96);
        }
        File moduleDir = new File(PathUtil.getParentPath((String)module2.getModuleFilePath()));
        FileUtil.ensureExists((File)moduleDir);
        VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(moduleDir);
        if (virtualFile == null) {
            PlatformTestCase.$$$reportNull$$$0(97);
        }
        return virtualFile;
    }

    /*
     * WARNING - void declaration
     */
    public static void waitForProjectLeakingThreads(@NotNull Project project2, long timeout, @NotNull TimeUnit timeUnit) throws Exception {
        if (project2 == null) {
            PlatformTestCase.$$$reportNull$$$0(98);
        }
        if (timeUnit == null) {
            PlatformTestCase.$$$reportNull$$$0(99);
        }
        NonBlockingReadActionImpl.cancelAllTasks();
        GeneratedSourceFileChangeTrackerImpl tracker = (GeneratedSourceFileChangeTrackerImpl)project2.getComponent(GeneratedSourceFileChangeTracker.class);
        if (tracker != null) {
            void timeUnit2;
            tracker.cancelAllAndWait(timeout, (TimeUnit)timeUnit2);
        }
    }

    static {
        ourTestTime = 300L;
        PREFIX_CANDIDATES = new String[]{"Rider", "GoLand", null, "AppCode", "CLion", "CidrCommonTests", "DataGrip", "Python", "PyCharmCore", "Ruby", "PhpStorm", "UltimateLangXml", "Idea", "PlatformLangXml"};
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 15: 
            case 17: 
            case 18: 
            case 24: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 55: 
            case 57: 
            case 60: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 74: 
            case 75: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 96: 
            case 98: 
            case 99: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 15: 
            case 17: 
            case 18: 
            case 24: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 55: 
            case 57: 
            case 60: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 74: 
            case 75: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 96: 
            case 98: 
            case 99: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/testFramework/PlatformTestCase";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tempDir";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectFile";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "creationPlace";
                break;
            }
            case 10: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileNamePrefix";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 18: 
            case 29: 
            case 33: 
            case 98: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 24: 
            case 26: 
            case 28: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleName";
                break;
            }
            case 30: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleType";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "survivors";
                break;
            }
            case 43: 
            case 57: 
            case 62: 
            case 82: 
            case 88: 
            case 90: 
            case 92: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectToClose";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 50: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 53: 
            case 55: 
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 60: 
            case 72: 
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 63: 
            case 66: 
            case 91: 
            case 93: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 64: 
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "charset";
                break;
            }
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ext";
                break;
            }
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 71: 
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 77: 
            case 79: 
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vFile1";
                break;
            }
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newFile";
                break;
            }
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newParent";
                break;
            }
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "copyName";
                break;
            }
            case 86: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vTestRoot";
                break;
            }
            case 87: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toDir";
                break;
            }
            case 89: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 96: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 99: {
                objectArray2 = objectArray3;
                objectArray3[0] = "timeUnit";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTempDir";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createTestProjectStructure";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 15: 
            case 17: 
            case 18: 
            case 24: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 55: 
            case 57: 
            case 60: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 74: 
            case 75: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 96: 
            case 98: 
            case 99: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/testFramework/PlatformTestCase";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPsiManager";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "doCreateProject";
                break;
            }
            case 9: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createProject";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "publishHeapDump";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getCreationPlace";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectDirOrFile";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "createMainModule";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "createModule";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "doCreateRealModule";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "doCreateRealModuleIn";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "createModuleAt";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleType";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "eternallyLivingFiles";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "disposeOnTearDown";
                break;
            }
            case 54: 
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "createTempDir";
                break;
            }
            case 58: 
            case 59: {
                objectArray = objectArray2;
                objectArray2[1] = "createTempDirectory";
                break;
            }
            case 61: 
            case 68: {
                objectArray = objectArray2;
                objectArray2[1] = "createTempFile";
                break;
            }
            case 73: {
                objectArray = objectArray2;
                objectArray2[1] = "createChildData";
                break;
            }
            case 76: {
                objectArray = objectArray2;
                objectArray2[1] = "createChildDirectory";
                break;
            }
            case 85: {
                objectArray = objectArray2;
                objectArray2[1] = "copy";
                break;
            }
            case 94: 
            case 95: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateProjectBaseDir";
                break;
            }
            case 97: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateModuleDir";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "synchronizeTempDirVfs";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "doCreateProject";
                break;
            }
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createProject";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "publishHeapDump";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "reportLeakedProjects";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getCreationPlace";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "createModule";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "doCreateRealModule";
                break;
            }
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "doCreateRealModuleIn";
                break;
            }
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "createModuleAt";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "addSurvivingFiles";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "registerSurvivor";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "addSubTree";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "closeAndDisposeProjectAndCheckThatNoOpenProjects";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "disposeOnTearDown";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "resetClassFields";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "runBareRunnable";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "invokeTestRunnable";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 53: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "createTempDir";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "getVirtualFile";
                break;
            }
            case 60: 
            case 65: 
            case 66: 
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "createTempFile";
                break;
            }
            case 62: 
            case 63: 
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "setContentOnDisk";
                break;
            }
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "getPsiFile";
                break;
            }
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "setPlatformPrefix";
                break;
            }
            case 71: 
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "createChildData";
                break;
            }
            case 74: 
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "createChildDirectory";
                break;
            }
            case 77: 
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "rename";
                break;
            }
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "delete";
                break;
            }
            case 80: 
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "move";
                break;
            }
            case 82: 
            case 83: 
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "copy";
                break;
            }
            case 86: 
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "copyDirContentsTo";
                break;
            }
            case 88: 
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "setFileText";
                break;
            }
            case 90: 
            case 91: 
            case 92: 
            case 93: {
                objectArray = objectArray;
                objectArray[2] = "setBinaryContent";
                break;
            }
            case 96: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateModuleDir";
                break;
            }
            case 98: 
            case 99: {
                objectArray = objectArray;
                objectArray[2] = "waitForProjectLeakingThreads";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 15: 
            case 17: 
            case 18: 
            case 24: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 55: 
            case 57: 
            case 60: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 74: 
            case 75: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 96: 
            case 98: 
            case 99: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD, ElementType.TYPE})
    public static @interface WrapInCommand {
    }
}

