/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.prometheus.exporter;

import java.util.List;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.util.DOMUtil;
import org.w3c.dom.Node;

public class PrometheusExporterSettings {
    private final int httpConnectionTimeout;
    private final int httpReadTimeout;

    public static Builder builder() {
        return new Builder();
    }

    public static PrometheusExporterSettings from(Node settings) {
        NamedList config = DOMUtil.childNodesToNamedList((Node)settings);
        Builder builder = PrometheusExporterSettings.builder();
        List httpClientSettings = config.getAll("httpClients");
        for (NamedList entry : httpClientSettings) {
            Integer readTimeout;
            Integer connectionTimeout = (Integer)entry.get("connectionTimeout");
            if (connectionTimeout != null) {
                builder.withConnectionHttpTimeout(connectionTimeout);
            }
            if ((readTimeout = (Integer)entry.get("readTimeout")) == null) continue;
            builder.witReadHttpTimeout(readTimeout);
        }
        return builder.build();
    }

    private PrometheusExporterSettings(int httpConnectionTimeout, int httpReadTimeout) {
        this.httpConnectionTimeout = httpConnectionTimeout;
        this.httpReadTimeout = httpReadTimeout;
    }

    public int getHttpConnectionTimeout() {
        return this.httpConnectionTimeout;
    }

    public int getHttpReadTimeout() {
        return this.httpReadTimeout;
    }

    public static class Builder {
        private int httpConnectionTimeout = 10000;
        private int httpReadTimeout = 60000;

        private Builder() {
        }

        public Builder withConnectionHttpTimeout(int httpConnectionTimeout) {
            this.httpConnectionTimeout = httpConnectionTimeout;
            return this;
        }

        public Builder witReadHttpTimeout(int httpReadTimeout) {
            this.httpReadTimeout = httpReadTimeout;
            return this;
        }

        public PrometheusExporterSettings build() {
            return new PrometheusExporterSettings(this.httpConnectionTimeout, this.httpReadTimeout);
        }
    }
}

