/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common.cloud;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.common.util.Utils;

public class Aliases {
    public static final Aliases EMPTY = new Aliases(Collections.emptyMap(), Collections.emptyMap(), -1);
    private static final String COLLECTION = "collection";
    private static final String COLLECTION_METADATA = "collection_metadata";
    private final Map<String, List<String>> collectionAliases;
    private final Map<String, Map<String, String>> collectionAliasProperties;
    private final int zNodeVersion;

    private Aliases(Map<String, List<String>> collectionAliases, Map<String, Map<String, String>> collectionAliasProperties, int zNodeVersion) {
        this.collectionAliases = Objects.requireNonNull(collectionAliases);
        this.collectionAliasProperties = Objects.requireNonNull(collectionAliasProperties);
        this.zNodeVersion = zNodeVersion;
    }

    public static Aliases fromJSON(byte[] bytes, int zNodeVersion) {
        Map aliasMap = bytes == null || bytes.length == 0 ? Collections.emptyMap() : (Map)Utils.fromJSON(bytes);
        Map<String, Object> colAliases = aliasMap.getOrDefault(COLLECTION, Collections.emptyMap());
        colAliases = Aliases.convertMapOfCommaDelimitedToMapOfList(colAliases);
        Map<String, Map<String, String>> colMeta = aliasMap.getOrDefault(COLLECTION_METADATA, Collections.emptyMap());
        colMeta.replaceAll((k, metaMap) -> Collections.unmodifiableMap(metaMap));
        return new Aliases(colAliases, colMeta, zNodeVersion);
    }

    public byte[] toJSON() {
        if (this.collectionAliases.isEmpty()) {
            assert (this.collectionAliasProperties.isEmpty());
            return null;
        }
        LinkedHashMap<String, Map<String, Object>> tmp = new LinkedHashMap<String, Map<String, Object>>();
        tmp.put(COLLECTION, Aliases.convertMapOfListToMapOfCommaDelimited(this.collectionAliases));
        if (!this.collectionAliasProperties.isEmpty()) {
            tmp.put(COLLECTION_METADATA, this.collectionAliasProperties);
        }
        return Utils.toJSON(tmp);
    }

    public static Map<String, List<String>> convertMapOfCommaDelimitedToMapOfList(Map<String, String> collectionAliasMap) {
        return collectionAliasMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> Aliases.splitCollections((String)e.getValue()), (a, b) -> {
            throw new IllegalStateException(String.format(Locale.ROOT, "Duplicate key %s", b));
        }, LinkedHashMap::new));
    }

    private static List<String> splitCollections(String collections) {
        return Collections.unmodifiableList(StrUtils.splitSmart(collections, ",", true));
    }

    public static Map<String, String> convertMapOfListToMapOfCommaDelimited(Map<String, List<String>> collectionAliasMap) {
        return collectionAliasMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> String.join((CharSequence)",", (Iterable)e.getValue()), (a, b) -> {
            throw new IllegalStateException(String.format(Locale.ROOT, "Duplicate key %s", b));
        }, LinkedHashMap::new));
    }

    public int getZNodeVersion() {
        return this.zNodeVersion;
    }

    public Map<String, String> getCollectionAliasMap() {
        return Collections.unmodifiableMap(Aliases.convertMapOfListToMapOfCommaDelimited(this.collectionAliases));
    }

    public Map<String, List<String>> getCollectionAliasListMap() {
        return Collections.unmodifiableMap(this.collectionAliases);
    }

    public Map<String, String> getCollectionAliasProperties(String alias) {
        return this.collectionAliasProperties.getOrDefault(alias, Collections.emptyMap());
    }

    public List<String> resolveAliases(String aliasName) {
        return Aliases.resolveAliasesGivenAliasMap(this.collectionAliases, aliasName);
    }

    public boolean hasAlias(String aliasName) {
        return this.collectionAliases.containsKey(aliasName);
    }

    public boolean isRoutedAlias(String aliasName) {
        if (!this.collectionAliases.containsKey(aliasName)) {
            return false;
        }
        Map<String, String> props = this.collectionAliasProperties.get(aliasName);
        if (props == null) {
            return false;
        }
        return props.entrySet().stream().anyMatch(e -> ((String)e.getKey()).startsWith("router."));
    }

    public String resolveSimpleAlias(String aliasName) throws SolrException {
        return Aliases.resolveSimpleAliasGivenAliasMap(this.collectionAliases, aliasName);
    }

    public static String resolveSimpleAliasGivenAliasMap(Map<String, List<String>> collectionAliasListMap, String aliasName) throws SolrException {
        List<String> level1 = collectionAliasListMap.get(aliasName);
        if (level1 == null || level1.isEmpty()) {
            return aliasName;
        }
        if (level1.size() > 1) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Simple alias '" + aliasName + "' points to more than 1 collection: " + level1);
        }
        List<String> level2 = collectionAliasListMap.get(level1.get(0));
        if (level2 == null || level2.isEmpty()) {
            return level1.get(0);
        }
        if (level2.size() > 1) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Simple alias '" + aliasName + "' resolves to '" + level1.get(0) + "' which points to more than 1 collection: " + level2);
        }
        return level2.get(0);
    }

    public static List<String> resolveAliasesGivenAliasMap(Map<String, List<String>> collectionAliasListMap, String aliasName) {
        List<String> level1 = collectionAliasListMap.get(aliasName);
        if (level1 == null) {
            return Collections.singletonList(aliasName);
        }
        LinkedHashSet<String> uniqueResult = null;
        for (int i = 0; i < level1.size(); ++i) {
            String level1Alias = level1.get(i);
            List<String> level2 = collectionAliasListMap.get(level1Alias);
            if (level2 == null) {
                if (uniqueResult == null) continue;
                uniqueResult.add(level1Alias);
                continue;
            }
            if (uniqueResult == null) {
                uniqueResult = new LinkedHashSet<String>(level1.size());
                uniqueResult.addAll(level1.subList(0, i));
            }
            uniqueResult.addAll(level2);
        }
        if (uniqueResult == null) {
            return level1;
        }
        return Collections.unmodifiableList(new ArrayList(uniqueResult));
    }

    public Aliases cloneWithCollectionAlias(String alias, String collections) {
        Map<String, Map<String, String>> newColProperties;
        if (alias == null) {
            throw new NullPointerException("Alias name cannot be null");
        }
        LinkedHashMap<String, List<String>> newColAliases = new LinkedHashMap<String, List<String>>(this.collectionAliases);
        if (collections == null) {
            newColProperties = new LinkedHashMap<String, Map<String, String>>(this.collectionAliasProperties);
            newColProperties.remove(alias);
            newColAliases.remove(alias);
            for (Map.Entry entry2 : newColAliases.entrySet()) {
                ArrayList list = (ArrayList)entry2.getValue();
                if (!list.contains(alias)) continue;
                list = new ArrayList(list);
                list.remove(alias);
                entry2.setValue(Collections.unmodifiableList(list));
            }
            newColAliases.entrySet().removeIf(entry -> ((List)entry.getValue()).isEmpty());
        } else {
            newColProperties = this.collectionAliasProperties;
            newColAliases.put(alias, Aliases.splitCollections(collections));
        }
        return new Aliases(newColAliases, newColProperties, this.zNodeVersion);
    }

    public Aliases cloneWithRename(String before, String after) throws SolrException {
        if (before == null) {
            throw new NullPointerException("'before' and 'after' cannot be null");
        }
        if (after == null) {
            return this.cloneWithCollectionAlias(before, after);
        }
        if (before.isEmpty() || after.isEmpty()) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "'before' and 'after' cannot be empty");
        }
        if (before.equals(after)) {
            return this;
        }
        Map props = this.collectionAliasProperties.get(before);
        if (props != null && props.keySet().stream().anyMatch(k -> k.startsWith("router."))) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "source name '" + before + "' is a routed alias.");
        }
        LinkedHashMap<String, Map<String, String>> newColProperties = new LinkedHashMap<String, Map<String, String>>(this.collectionAliasProperties);
        LinkedHashMap<String, List<String>> newColAliases = new LinkedHashMap<String, List<String>>(this.collectionAliases);
        List level1 = (List)newColAliases.remove(before);
        props = (Map)newColProperties.remove(before);
        if (level1 != null) {
            newColAliases.put(after, level1);
        }
        if (props != null) {
            newColProperties.put(after, props);
        }
        for (Map.Entry entry : newColAliases.entrySet()) {
            List collections = (List)entry.getValue();
            if (!collections.contains(before)) continue;
            LinkedHashSet<String> newCollections = new LinkedHashSet<String>(collections.size());
            for (String coll : collections) {
                if (coll.equals(before)) {
                    newCollections.add(after);
                    continue;
                }
                newCollections.add(coll);
            }
            entry.setValue(Collections.unmodifiableList(new ArrayList(newCollections)));
        }
        if (level1 == null) {
            newColAliases.put(before, Collections.singletonList(after));
        }
        return new Aliases(newColAliases, newColProperties, this.zNodeVersion);
    }

    public Aliases cloneWithCollectionAliasProperties(String alias, String propertiesKey, String propertiesValue) {
        return this.cloneWithCollectionAliasProperties(alias, Collections.singletonMap(propertiesKey, propertiesValue));
    }

    public Aliases cloneWithCollectionAliasProperties(String alias, Map<String, String> properties) throws SolrException {
        if (!this.collectionAliases.containsKey(alias)) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, alias + " is not a valid alias");
        }
        if (properties == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Null is not a valid properties map");
        }
        LinkedHashMap<String, Map<String, String>> newColProperties = new LinkedHashMap<String, Map<String, String>>(this.collectionAliasProperties);
        LinkedHashMap<String, String> newMetaMap = new LinkedHashMap<String, String>(newColProperties.getOrDefault(alias, Collections.emptyMap()));
        for (Map.Entry<String, String> metaEntry : properties.entrySet()) {
            if (metaEntry.getValue() != null) {
                newMetaMap.put(metaEntry.getKey(), metaEntry.getValue());
                continue;
            }
            newMetaMap.remove(metaEntry.getKey());
        }
        newColProperties.put(alias, Collections.unmodifiableMap(newMetaMap));
        return new Aliases(this.collectionAliases, newColProperties, this.zNodeVersion);
    }

    public String toString() {
        return "Aliases{collectionAliases=" + this.collectionAliases + ", collectionAliasProperties=" + this.collectionAliasProperties + ", zNodeVersion=" + this.zNodeVersion + '}';
    }
}

