/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud.api.collections;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.solr.cloud.OverseerSolrResponse;
import org.apache.solr.cloud.api.collections.OverseerCollectionMessageHandler;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.CollectionProperties;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.params.CollectionParams;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.handler.admin.CollectionsHandler;
import org.apache.solr.request.LocalSolrQueryRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AliasCmd
implements OverseerCollectionMessageHandler.Cmd {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    AliasCmd() {
    }

    static NamedList createCollectionAndWait(ClusterState clusterState, String aliasName, Map<String, String> aliasMetadata, String createCollName, OverseerCollectionMessageHandler ocmh) throws Exception {
        NamedList results;
        block5: {
            ModifiableSolrParams createReqParams = new ModifiableSolrParams();
            for (Map.Entry<String, String> e : aliasMetadata.entrySet()) {
                if (!e.getKey().startsWith("create-collection.")) continue;
                createReqParams.set(e.getKey().substring("create-collection.".length()), new String[]{e.getValue()});
            }
            if (createReqParams.get("collection.configName") == null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "We require an explicit collection.configName");
            }
            createReqParams.set("name", new String[]{createCollName});
            Map<String, Object> createMsgMap = CollectionsHandler.CollectionOperation.CREATE_OP.execute(new LocalSolrQueryRequest(null, (SolrParams)createReqParams), null, ocmh.overseer.getCoreContainer().getCollectionsHandler());
            createMsgMap.put("operation", "create");
            results = new NamedList();
            try {
                ocmh.commandMap.get(CollectionParams.CollectionAction.CREATE).call(clusterState, new ZkNodeProps(createMsgMap), results);
            }
            catch (SolrException e) {
                if (e.getMessage().contains("collection already exists")) break block5;
                throw e;
            }
        }
        CollectionsHandler.waitForActiveCollection(createCollName, ocmh.overseer.getCoreContainer(), new OverseerSolrResponse(results));
        CollectionProperties collectionProperties = new CollectionProperties(ocmh.zkStateReader.getZkClient());
        collectionProperties.setCollectionProperty(createCollName, "routedAliasName", aliasName);
        while (!ocmh.zkStateReader.getCollectionProperties(createCollName, 1000L).containsKey("routedAliasName")) {
            Thread.sleep(50L);
        }
        return results;
    }

    void updateAlias(String aliasName, ZkStateReader.AliasesManager aliasesManager, String createCollName) {
        aliasesManager.applyModificationAndExportToZk(curAliases -> {
            List curTargetCollections = (List)curAliases.getCollectionAliasListMap().get(aliasName);
            if (curTargetCollections.contains(createCollName)) {
                return curAliases;
            }
            ArrayList<String> newTargetCollections = new ArrayList<String>(curTargetCollections.size() + 1);
            newTargetCollections.add(createCollName);
            newTargetCollections.addAll(curTargetCollections);
            return curAliases.cloneWithCollectionAlias(aliasName, StrUtils.join(newTargetCollections, (char)','));
        });
    }
}

