/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud.autoscaling;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.solr.client.solrj.cloud.SolrCloudManager;
import org.apache.solr.client.solrj.cloud.autoscaling.ReplicaInfo;
import org.apache.solr.client.solrj.cloud.autoscaling.Suggester;
import org.apache.solr.client.solrj.cloud.autoscaling.TriggerEventType;
import org.apache.solr.client.solrj.cloud.autoscaling.Variable;
import org.apache.solr.cloud.autoscaling.AutoScaling;
import org.apache.solr.cloud.autoscaling.TriggerBase;
import org.apache.solr.cloud.autoscaling.TriggerEvent;
import org.apache.solr.cloud.autoscaling.TriggerUtils;
import org.apache.solr.cloud.autoscaling.TriggerValidationException;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.params.CollectionParams;
import org.apache.solr.common.util.Pair;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.common.util.Utils;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.metrics.SolrCoreMetricManager;
import org.apache.solr.update.SolrIndexSplitter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexSizeTrigger
extends TriggerBase {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String ABOVE_BYTES_PROP = "aboveBytes";
    public static final String ABOVE_DOCS_PROP = "aboveDocs";
    public static final String ABOVE_OP_PROP = "aboveOp";
    public static final String BELOW_BYTES_PROP = "belowBytes";
    public static final String BELOW_DOCS_PROP = "belowDocs";
    public static final String BELOW_OP_PROP = "belowOp";
    public static final String COLLECTIONS_PROP = "collections";
    public static final String MAX_OPS_PROP = "maxOps";
    public static final String SPLIT_FUZZ_PROP = "splitFuzz";
    public static final String SPLIT_METHOD_PROP = "splitMethod";
    public static final String BYTES_SIZE_PROP = "__bytes__";
    public static final String TOTAL_BYTES_SIZE_PROP = "__total_bytes__";
    public static final String DOCS_SIZE_PROP = "__docs__";
    public static final String MAX_DOC_PROP = "__maxDoc__";
    public static final String COMMIT_SIZE_PROP = "__commitBytes__";
    public static final String ABOVE_SIZE_PROP = "aboveSize";
    public static final String BELOW_SIZE_PROP = "belowSize";
    public static final String VIOLATION_PROP = "violationType";
    public static final int DEFAULT_MAX_OPS = 10;
    private long aboveBytes;
    private long aboveDocs;
    private long belowBytes;
    private long belowDocs;
    private int maxOps;
    private SolrIndexSplitter.SplitMethod splitMethod;
    private float splitFuzz;
    private CollectionParams.CollectionAction aboveOp;
    private CollectionParams.CollectionAction belowOp;
    private final Set<String> collections = new HashSet<String>();
    private final Map<String, Long> lastAboveEventMap = new ConcurrentHashMap<String, Long>();
    private final Map<String, Long> lastBelowEventMap = new ConcurrentHashMap<String, Long>();

    public IndexSizeTrigger(String name) {
        super(TriggerEventType.INDEXSIZE, name);
        TriggerUtils.validProperties(this.validProperties, ABOVE_BYTES_PROP, ABOVE_DOCS_PROP, BELOW_BYTES_PROP, BELOW_DOCS_PROP, COLLECTIONS_PROP, MAX_OPS_PROP, SPLIT_METHOD_PROP, SPLIT_FUZZ_PROP);
    }

    @Override
    public void configure(SolrResourceLoader loader, SolrCloudManager cloudManager, Map<String, Object> properties) throws TriggerValidationException {
        super.configure(loader, cloudManager, properties);
        String aboveStr = String.valueOf(properties.getOrDefault(ABOVE_BYTES_PROP, Long.MAX_VALUE));
        String belowStr = String.valueOf(properties.getOrDefault(BELOW_BYTES_PROP, -1));
        try {
            this.aboveBytes = Long.parseLong(aboveStr);
            if (this.aboveBytes <= 0L) {
                throw new Exception("value must be > 0");
            }
        }
        catch (Exception e) {
            throw new TriggerValidationException(this.getName(), ABOVE_BYTES_PROP, "invalid value '" + aboveStr + "': " + e.toString());
        }
        try {
            this.belowBytes = Long.parseLong(belowStr);
            if (this.belowBytes < 0L) {
                this.belowBytes = -1L;
            }
        }
        catch (Exception e) {
            throw new TriggerValidationException(this.getName(), BELOW_BYTES_PROP, "invalid value '" + belowStr + "': " + e.toString());
        }
        if (this.belowBytes > 0L && this.belowBytes * 2L > this.aboveBytes) {
            throw new TriggerValidationException(this.getName(), BELOW_BYTES_PROP, "invalid value " + this.belowBytes + ", should be less than half of '" + ABOVE_BYTES_PROP + "' value, which is " + this.aboveBytes);
        }
        aboveStr = String.valueOf(properties.getOrDefault(ABOVE_DOCS_PROP, Long.MAX_VALUE));
        belowStr = String.valueOf(properties.getOrDefault(BELOW_DOCS_PROP, -1));
        try {
            this.aboveDocs = Long.parseLong(aboveStr);
            if (this.aboveDocs <= 0L) {
                throw new Exception("value must be > 0");
            }
        }
        catch (Exception e) {
            throw new TriggerValidationException(this.getName(), ABOVE_DOCS_PROP, "invalid value '" + aboveStr + "': " + e.toString());
        }
        try {
            this.belowDocs = Long.parseLong(belowStr);
            if (this.belowDocs < 0L) {
                this.belowDocs = -1L;
            }
        }
        catch (Exception e) {
            throw new TriggerValidationException(this.getName(), BELOW_DOCS_PROP, "invalid value '" + belowStr + "': " + e.toString());
        }
        if (this.belowDocs > 0L && this.belowDocs * 2L > this.aboveDocs) {
            throw new TriggerValidationException(this.getName(), BELOW_DOCS_PROP, "invalid value " + this.belowDocs + ", should be less than half of '" + ABOVE_DOCS_PROP + "' value, which is " + this.aboveDocs);
        }
        String collectionsString = (String)properties.get(COLLECTIONS_PROP);
        if (collectionsString != null && !collectionsString.isEmpty()) {
            this.collections.addAll(StrUtils.splitSmart((String)collectionsString, (char)','));
        }
        String aboveOpStr = String.valueOf(properties.getOrDefault(ABOVE_OP_PROP, CollectionParams.CollectionAction.SPLITSHARD.toLower()));
        String belowOpStr = String.valueOf(properties.getOrDefault(BELOW_OP_PROP, CollectionParams.CollectionAction.MERGESHARDS.toLower()));
        this.aboveOp = CollectionParams.CollectionAction.get((String)aboveOpStr);
        if (this.aboveOp == null) {
            throw new TriggerValidationException(this.getName(), ABOVE_OP_PROP, "unrecognized value of: '" + aboveOpStr + "'");
        }
        this.belowOp = CollectionParams.CollectionAction.get((String)belowOpStr);
        if (this.belowOp == null) {
            throw new TriggerValidationException(this.getName(), BELOW_OP_PROP, "unrecognized value of: '" + belowOpStr + "'");
        }
        String maxOpsStr = String.valueOf(properties.getOrDefault(MAX_OPS_PROP, 10));
        try {
            this.maxOps = Integer.parseInt(maxOpsStr);
            if (this.maxOps < 1) {
                throw new Exception("must be > 1");
            }
        }
        catch (Exception e) {
            throw new TriggerValidationException(this.getName(), MAX_OPS_PROP, "invalid value: '" + maxOpsStr + "': " + e.getMessage());
        }
        String methodStr = (String)properties.getOrDefault(SPLIT_METHOD_PROP, SolrIndexSplitter.SplitMethod.LINK.toLower());
        this.splitMethod = SolrIndexSplitter.SplitMethod.get(methodStr);
        if (this.splitMethod == null) {
            throw new TriggerValidationException(this.getName(), SPLIT_METHOD_PROP, "Unknown value 'splitMethod: " + methodStr);
        }
        String fuzzStr = String.valueOf(properties.getOrDefault(SPLIT_FUZZ_PROP, Float.valueOf(0.0f)));
        try {
            this.splitFuzz = Float.parseFloat(fuzzStr);
        }
        catch (Exception e) {
            throw new TriggerValidationException(this.getName(), SPLIT_FUZZ_PROP, "invalid value: '" + fuzzStr + "': " + e.getMessage());
        }
    }

    @Override
    protected Map<String, Object> getState() {
        HashMap<String, Object> state = new HashMap<String, Object>();
        state.put("lastAboveEventMap", this.lastAboveEventMap);
        state.put("lastBelowEventMap", this.lastBelowEventMap);
        return state;
    }

    @Override
    protected void setState(Map<String, Object> state) {
        this.lastAboveEventMap.clear();
        this.lastBelowEventMap.clear();
        Map replicaVsTime = (Map)state.get("lastAboveEventMap");
        if (replicaVsTime != null) {
            this.lastAboveEventMap.putAll(replicaVsTime);
        }
        if ((replicaVsTime = (Map)state.get("lastBelowEventMap")) != null) {
            this.lastBelowEventMap.putAll(replicaVsTime);
        }
    }

    @Override
    public void restoreState(AutoScaling.Trigger old) {
        IndexSizeTrigger that;
        assert (old.isClosed());
        if (old instanceof IndexSizeTrigger) {
            that = (IndexSizeTrigger)old;
            assert (this.name.equals(that.name));
        } else {
            throw new SolrException(SolrException.ErrorCode.INVALID_STATE, "Unable to restore state from an unknown type of trigger");
        }
        this.lastAboveEventMap.clear();
        this.lastBelowEventMap.clear();
        this.lastAboveEventMap.putAll(that.lastAboveEventMap);
        this.lastBelowEventMap.putAll(that.lastBelowEventMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        IndexSizeTrigger indexSizeTrigger = this;
        synchronized (indexSizeTrigger) {
            if (this.isClosed) {
                log.warn(this.getName() + " ran but was already closed");
                return;
            }
        }
        AutoScaling.TriggerEventProcessor processor = (AutoScaling.TriggerEventProcessor)this.processorRef.get();
        if (processor == null) {
            return;
        }
        HashMap<String, ReplicaInfo> currentSizes = new HashMap<String, ReplicaInfo>();
        try {
            ClusterState clusterState = this.cloudManager.getClusterStateProvider().getClusterState();
            for (String node : clusterState.getLiveNodes()) {
                HashMap metricTags = new HashMap();
                Map infos = this.cloudManager.getNodeStateProvider().getReplicaInfo(node, Collections.emptyList());
                infos.forEach((coll, shards) -> {
                    if (!this.collections.isEmpty() && !this.collections.contains(coll)) {
                        return;
                    }
                    DocCollection docCollection = clusterState.getCollection(coll);
                    shards.forEach((sh, replicas) -> {
                        Slice s = docCollection.getSlice(sh);
                        if (s.getState() != Slice.State.ACTIVE) {
                            return;
                        }
                        Replica r = s.getLeader();
                        if (r == null) {
                            return;
                        }
                        if (!r.getNodeName().equals(node)) {
                            return;
                        }
                        ReplicaInfo info = null;
                        for (ReplicaInfo ri : replicas) {
                            if (!r.getCoreName().equals(ri.getCore())) continue;
                            info = ri;
                            break;
                        }
                        if (info == null) {
                            return;
                        }
                        String replicaName = Utils.parseMetricsReplicaName((String)coll, (String)info.getCore());
                        if (replicaName == null) {
                            replicaName = info.getName();
                        }
                        String registry = SolrCoreMetricManager.createRegistryName(true, coll, sh, replicaName, null);
                        String tag = "metrics:" + registry + ":" + Variable.Type.CORE_IDX.metricsAttribute;
                        metricTags.put(tag, info);
                        tag = "metrics:" + registry + ":SEARCHER.searcher.numDocs";
                        metricTags.put(tag, info);
                        tag = "metrics:" + registry + ":SEARCHER.searcher.maxDoc";
                        metricTags.put(tag, info);
                        tag = "metrics:" + registry + ":SEARCHER.searcher.indexCommitSize";
                        metricTags.put(tag, info);
                    });
                });
                if (metricTags.isEmpty()) continue;
                Map sizes = this.cloudManager.getNodeStateProvider().getNodeValues(node, metricTags.keySet());
                sizes.forEach((tag, size) -> {
                    ReplicaInfo info = (ReplicaInfo)metricTags.get(tag);
                    if (info == null) {
                        log.warn("Missing replica info for response tag " + tag);
                    } else {
                        if (!(size instanceof Number)) {
                            log.warn("invalid size value for tag " + tag + " - not a number: '" + size + "' is " + size.getClass().getName());
                            return;
                        }
                        ReplicaInfo currentInfo = currentSizes.computeIfAbsent(info.getCore(), k -> (ReplicaInfo)info.clone());
                        if (tag.contains("INDEX")) {
                            currentInfo.getVariables().put(TOTAL_BYTES_SIZE_PROP, ((Number)size).longValue());
                        } else if (tag.endsWith("SEARCHER.searcher.numDocs")) {
                            currentInfo.getVariables().put(DOCS_SIZE_PROP, ((Number)size).longValue());
                        } else if (tag.endsWith("SEARCHER.searcher.maxDoc")) {
                            currentInfo.getVariables().put(MAX_DOC_PROP, ((Number)size).longValue());
                        } else if (tag.endsWith("SEARCHER.searcher.indexCommitSize")) {
                            currentInfo.getVariables().put(COMMIT_SIZE_PROP, ((Number)size).longValue());
                        }
                    }
                });
            }
        }
        catch (IOException e) {
            log.warn("Error running trigger " + this.getName(), (Throwable)e);
            return;
        }
        long now = this.cloudManager.getTimeSource().getTimeNs();
        HashMap<String, List<ReplicaInfo>> aboveSize = new HashMap<String, List<ReplicaInfo>>();
        HashSet splittable = new HashSet();
        currentSizes.forEach((coreName, info) -> {
            long maxDoc = (Long)info.getVariable(MAX_DOC_PROP);
            long numDocs = (Long)info.getVariable(DOCS_SIZE_PROP);
            long commitSize = (Long)info.getVariable(COMMIT_SIZE_PROP, (Object)0L);
            if (commitSize <= 0L) {
                commitSize = (Long)info.getVariable(TOTAL_BYTES_SIZE_PROP);
            }
            commitSize = IndexSizeTrigger.estimatedSize(maxDoc, numDocs, commitSize);
            info.getVariables().put(BYTES_SIZE_PROP, commitSize);
            if ((Long)info.getVariable(BYTES_SIZE_PROP) > this.aboveBytes || (Long)info.getVariable(DOCS_SIZE_PROP) > this.aboveDocs) {
                List infos;
                if (this.waitForElapsed((String)coreName, now, this.lastAboveEventMap) && !(infos = aboveSize.computeIfAbsent(info.getCollection(), c -> new ArrayList())).contains(info)) {
                    if ((Long)info.getVariable(BYTES_SIZE_PROP) > this.aboveBytes) {
                        info.getVariables().put(VIOLATION_PROP, ABOVE_BYTES_PROP);
                    } else {
                        info.getVariables().put(VIOLATION_PROP, ABOVE_DOCS_PROP);
                    }
                    infos.add(info);
                    splittable.add(info.getName());
                }
            } else {
                this.lastAboveEventMap.remove(coreName);
            }
        });
        HashMap<String, List<ReplicaInfo>> belowSize = new HashMap<String, List<ReplicaInfo>>();
        currentSizes.forEach((coreName, info) -> {
            if (!((Long)info.getVariable(BYTES_SIZE_PROP) >= this.belowBytes && (Long)info.getVariable(DOCS_SIZE_PROP) >= this.belowDocs || splittable.contains(info.getName()))) {
                List infos;
                if (this.waitForElapsed((String)coreName, now, this.lastBelowEventMap) && !(infos = belowSize.computeIfAbsent(info.getCollection(), c -> new ArrayList())).contains(info)) {
                    if ((Long)info.getVariable(BYTES_SIZE_PROP) < this.belowBytes) {
                        info.getVariables().put(VIOLATION_PROP, BELOW_BYTES_PROP);
                    } else {
                        info.getVariables().put(VIOLATION_PROP, BELOW_DOCS_PROP);
                    }
                    infos.add(info);
                }
            } else {
                this.lastBelowEventMap.remove(coreName);
            }
        });
        if (aboveSize.isEmpty() && belowSize.isEmpty()) {
            log.trace("NO VIOLATIONS: Now={}", (Object)now);
            log.trace("lastAbove={}", this.lastAboveEventMap);
            log.trace("lastBelow={}", this.lastBelowEventMap);
            return;
        }
        AtomicLong eventTime = new AtomicLong(now);
        ArrayList<TriggerEvent.Op> ops = new ArrayList<TriggerEvent.Op>();
        aboveSize.forEach((coll, replicas) -> {
            replicas.sort((r1, r2) -> {
                long delta = (Long)r1.getVariable(DOCS_SIZE_PROP) - (Long)r2.getVariable(DOCS_SIZE_PROP);
                if (delta > 0L) {
                    return -1;
                }
                if (delta < 0L) {
                    return 1;
                }
                return 0;
            });
            replicas.forEach(r -> {
                if (ops.size() >= this.maxOps) {
                    return;
                }
                TriggerEvent.Op op = new TriggerEvent.Op(this.aboveOp);
                op.addHint(Suggester.Hint.COLL_SHARD, new Pair(coll, (Object)r.getShard()));
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put(SPLIT_METHOD_PROP, this.splitMethod.toLower());
                if (this.splitFuzz > 0.0f) {
                    params.put(SPLIT_FUZZ_PROP, Float.valueOf(this.splitFuzz));
                }
                op.addHint(Suggester.Hint.PARAMS, params);
                ops.add(op);
                Long time = this.lastAboveEventMap.get(r.getCore());
                if (time != null && eventTime.get() > time) {
                    eventTime.set(time);
                }
            });
        });
        belowSize.forEach((coll, replicas) -> {
            if (replicas.size() < 2) {
                return;
            }
            if (ops.size() >= this.maxOps) {
                return;
            }
            replicas.sort((r1, r2) -> {
                long delta = (Long)r1.getVariable(DOCS_SIZE_PROP) - (Long)r2.getVariable(DOCS_SIZE_PROP);
                if (delta > 0L) {
                    return 1;
                }
                if (delta < 0L) {
                    return -1;
                }
                return 0;
            });
            TriggerEvent.Op op = new TriggerEvent.Op(this.belowOp);
            op.addHint(Suggester.Hint.COLL_SHARD, new Pair(coll, (Object)((ReplicaInfo)replicas.get(0)).getShard()));
            op.addHint(Suggester.Hint.COLL_SHARD, new Pair(coll, (Object)((ReplicaInfo)replicas.get(1)).getShard()));
            ops.add(op);
            Long time = this.lastBelowEventMap.get(((ReplicaInfo)replicas.get(0)).getCore());
            if (time != null && eventTime.get() > time) {
                eventTime.set(time);
            }
            if ((time = this.lastBelowEventMap.get(((ReplicaInfo)replicas.get(1)).getCore())) != null && eventTime.get() > time) {
                eventTime.set(time);
            }
        });
        if (ops.isEmpty()) {
            return;
        }
        if (processor.process(new IndexSizeEvent(this.getName(), eventTime.get(), ops, aboveSize, belowSize))) {
            aboveSize.forEach((coll, replicas) -> replicas.forEach(r -> this.lastAboveEventMap.put(r.getCore(), now)));
            belowSize.forEach((coll, replicas) -> {
                if (replicas.size() < 2) {
                    return;
                }
                this.lastBelowEventMap.put(((ReplicaInfo)replicas.get(0)).getCore(), now);
                this.lastBelowEventMap.put(((ReplicaInfo)replicas.get(1)).getCore(), now);
            });
        }
    }

    public static long estimatedSize(long maxDoc, long numDocs, long commitSize) {
        if (maxDoc == 0L) {
            return 0L;
        }
        if (maxDoc == numDocs) {
            return commitSize;
        }
        return commitSize * numDocs / maxDoc;
    }

    private boolean waitForElapsed(String name, long now, Map<String, Long> lastEventMap) {
        Long lastTime = lastEventMap.computeIfAbsent(name, s -> now);
        long elapsed = TimeUnit.SECONDS.convert(now - lastTime, TimeUnit.NANOSECONDS);
        log.trace("name={}, lastTime={}, elapsed={}", new Object[]{name, lastTime, elapsed});
        return TimeUnit.SECONDS.convert(now - lastTime, TimeUnit.NANOSECONDS) >= (long)this.getWaitForSecond();
    }

    public static class IndexSizeEvent
    extends TriggerEvent {
        public IndexSizeEvent(String source, long eventTime, List<TriggerEvent.Op> ops, Map<String, List<ReplicaInfo>> aboveSize, Map<String, List<ReplicaInfo>> belowSize) {
            super(TriggerEventType.INDEXSIZE, source, eventTime, null);
            this.properties.put("requestedOps", ops);
            TreeMap above = new TreeMap();
            aboveSize.forEach((coll, replicas) -> replicas.forEach(r -> above.put(r.getCore(), "docs=" + r.getVariable(IndexSizeTrigger.DOCS_SIZE_PROP) + ", bytes=" + r.getVariable(IndexSizeTrigger.BYTES_SIZE_PROP))));
            this.properties.put(IndexSizeTrigger.ABOVE_SIZE_PROP, above);
            TreeMap below = new TreeMap();
            belowSize.forEach((coll, replicas) -> replicas.forEach(r -> below.put(r.getCore(), "docs=" + r.getVariable(IndexSizeTrigger.DOCS_SIZE_PROP) + ", bytes=" + r.getVariable(IndexSizeTrigger.BYTES_SIZE_PROP))));
            this.properties.put(IndexSizeTrigger.BELOW_SIZE_PROP, below);
        }
    }

    public static enum Unit {
        bytes,
        docs;

    }
}

