/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.metrics.reporters;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.ScheduledReporter;
import com.codahale.metrics.Slf4jReporter;
import com.codahale.metrics.Timer;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.TimeUnit;
import org.apache.solr.metrics.FilteringSolrMetricReporter;
import org.apache.solr.metrics.SolrMetricManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class SolrSlf4jReporter
extends FilteringSolrMetricReporter {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private String instancePrefix = null;
    private String logger = null;
    private Map<String, String> mdcContext;
    private Slf4jReporterWrapper reporter;
    private boolean active;

    public SolrSlf4jReporter(SolrMetricManager metricManager, String registryName) {
        super(metricManager, registryName);
    }

    public void setPrefix(String prefix) {
        this.instancePrefix = prefix;
    }

    public void setLogger(String logger) {
        this.logger = logger;
    }

    @Override
    protected void doInit() {
        this.mdcContext = MDC.getCopyOfContextMap();
        this.mdcContext.put("registry", "m:" + this.registryName);
        Slf4jReporter.Builder builder = Slf4jReporter.forRegistry((MetricRegistry)this.metricManager.registry(this.registryName)).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS);
        MetricFilter filter = this.newMetricFilter();
        builder = builder.filter(filter);
        if (this.instancePrefix != null) {
            builder = builder.prefixedWith(this.instancePrefix);
        }
        if (this.logger == null || this.logger.isEmpty()) {
            if (this.pluginInfo.attributes.containsKey("group")) {
                this.logger = SolrMetricManager.enforcePrefix(this.pluginInfo.attributes.get("group"));
            } else if (this.pluginInfo.attributes.containsKey("registry")) {
                String reg = SolrMetricManager.enforcePrefix(this.pluginInfo.attributes.get("registry"));
                String[] names = reg.split("\\.");
                this.logger = names.length < 2 ? reg : names[0] + "." + names[1];
            }
        }
        builder = builder.outputTo(LoggerFactory.getLogger((String)this.logger));
        Slf4jReporter delegate = builder.build();
        this.reporter = new Slf4jReporterWrapper(this.logger, this.mdcContext, delegate, TimeUnit.SECONDS, TimeUnit.MILLISECONDS);
        this.reporter.start(this.period, TimeUnit.SECONDS);
        this.active = true;
    }

    @Override
    protected void validate() throws IllegalStateException {
        if (this.period < 1) {
            throw new IllegalStateException("Init argument 'period' is in time unit 'seconds' and must be at least 1.");
        }
    }

    @Override
    public void close() throws IOException {
        if (this.reporter != null) {
            this.reporter.close();
        }
        this.active = false;
    }

    boolean isActive() {
        return this.active;
    }

    private class Slf4jReporterWrapper
    extends ScheduledReporter {
        final Slf4jReporter delegate;
        final Map<String, String> mdcContext;

        Slf4jReporterWrapper(String logger, Map<String, String> mdcContext, Slf4jReporter delegate, TimeUnit rateUnit, TimeUnit durationUnit) {
            super(null, logger, null, rateUnit, durationUnit);
            this.delegate = delegate;
            this.mdcContext = mdcContext;
        }

        public void report() {
            MDC.setContextMap(this.mdcContext);
            try {
                this.delegate.report();
            }
            finally {
                MDC.clear();
            }
        }

        public void report(SortedMap<String, Gauge> gauges, SortedMap<String, Counter> counters, SortedMap<String, Histogram> histograms, SortedMap<String, Meter> meters, SortedMap<String, Timer> timers) {
            throw new UnsupportedOperationException("this method should never be called here!");
        }

        public void close() {
            super.close();
            this.delegate.close();
        }
    }
}

