/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.metrics;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.MetricSet;
import com.codahale.metrics.SharedMetricRegistries;
import com.codahale.metrics.Timer;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.MetricsConfig;
import org.apache.solr.core.PluginInfo;
import org.apache.solr.core.SolrCore;
import org.apache.solr.core.SolrInfoBean;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.logging.MDCLoggingContext;
import org.apache.solr.metrics.MetricSuppliers;
import org.apache.solr.metrics.SolrCoreContainerReporter;
import org.apache.solr.metrics.SolrCoreReporter;
import org.apache.solr.metrics.SolrMetricReporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class SolrMetricManager {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String REGISTRY_NAME_PREFIX = "solr.";
    public static final String JETTY_REGISTRY = "solr." + SolrInfoBean.Group.jetty.toString();
    public static final String JVM_REGISTRY = "solr." + SolrInfoBean.Group.jvm.toString();
    private final ConcurrentMap<String, MetricRegistry> registries = new ConcurrentHashMap<String, MetricRegistry>();
    private final Map<String, Map<String, SolrMetricReporter>> reporters = new HashMap<String, Map<String, SolrMetricReporter>>();
    private final Lock reportersLock = new ReentrantLock();
    private final Lock swapLock = new ReentrantLock();
    public static final int DEFAULT_CLOUD_REPORTER_PERIOD = 60;
    private MetricRegistry.MetricSupplier<Counter> counterSupplier;
    private MetricRegistry.MetricSupplier<Meter> meterSupplier;
    private MetricRegistry.MetricSupplier<Timer> timerSupplier;
    private MetricRegistry.MetricSupplier<Histogram> histogramSupplier;

    public SolrMetricManager() {
        this.counterSupplier = MetricSuppliers.counterSupplier(null, null);
        this.meterSupplier = MetricSuppliers.meterSupplier(null, null);
        this.timerSupplier = MetricSuppliers.timerSupplier(null, null);
        this.histogramSupplier = MetricSuppliers.histogramSupplier(null, null);
    }

    public SolrMetricManager(SolrResourceLoader loader, MetricsConfig metricsConfig) {
        this.counterSupplier = MetricSuppliers.counterSupplier(loader, metricsConfig.getCounterSupplier());
        this.meterSupplier = MetricSuppliers.meterSupplier(loader, metricsConfig.getMeterSupplier());
        this.timerSupplier = MetricSuppliers.timerSupplier(loader, metricsConfig.getTimerSupplier());
        this.histogramSupplier = MetricSuppliers.histogramSupplier(loader, metricsConfig.getHistogramSupplier());
    }

    public MetricRegistry.MetricSupplier<Counter> getCounterSupplier() {
        return this.counterSupplier;
    }

    public MetricRegistry.MetricSupplier<Meter> getMeterSupplier() {
        return this.meterSupplier;
    }

    public MetricRegistry.MetricSupplier<Timer> getTimerSupplier() {
        return this.timerSupplier;
    }

    public MetricRegistry.MetricSupplier<Histogram> getHistogramSupplier() {
        return this.histogramSupplier;
    }

    public Set<String> registryNames() {
        HashSet<String> set = new HashSet<String>();
        set.addAll(this.registries.keySet());
        set.addAll(SharedMetricRegistries.names());
        return set;
    }

    public boolean hasRegistry(String name) {
        Set<String> names = this.registryNames();
        name = SolrMetricManager.enforcePrefix(name);
        return names.contains(name);
    }

    public Set<String> registryNames(String ... patterns) throws PatternSyntaxException {
        if (patterns == null || patterns.length == 0) {
            return this.registryNames();
        }
        ArrayList<Pattern> compiled = new ArrayList<Pattern>();
        for (String pattern : patterns) {
            compiled.add(Pattern.compile(pattern));
        }
        return this.registryNames(compiled.toArray(new Pattern[compiled.size()]));
    }

    public Set<String> registryNames(Pattern ... patterns) {
        Set<String> allNames = this.registryNames();
        if (patterns == null || patterns.length == 0) {
            return allNames;
        }
        return allNames.stream().filter(s -> {
            for (Pattern p : patterns) {
                if (!p.matcher((CharSequence)s).matches()) continue;
                return true;
            }
            return false;
        }).collect(Collectors.toSet());
    }

    private static boolean isSharedRegistry(String registry) {
        return JETTY_REGISTRY.equals(registry) || JVM_REGISTRY.equals(registry);
    }

    public MetricRegistry registry(String registry) {
        if (SolrMetricManager.isSharedRegistry(registry = SolrMetricManager.enforcePrefix(registry))) {
            return SharedMetricRegistries.getOrCreate((String)registry);
        }
        this.swapLock.lock();
        try {
            MetricRegistry metricRegistry = SolrMetricManager.getOrCreateRegistry(this.registries, registry);
            return metricRegistry;
        }
        finally {
            this.swapLock.unlock();
        }
    }

    private static MetricRegistry getOrCreateRegistry(ConcurrentMap<String, MetricRegistry> map, String registry) {
        MetricRegistry existing = (MetricRegistry)map.get(registry);
        if (existing == null) {
            MetricRegistry created = new MetricRegistry();
            MetricRegistry raced = map.putIfAbsent(registry, created);
            if (raced == null) {
                return created;
            }
            return raced;
        }
        return existing;
    }

    public void removeRegistry(String registry) {
        this.closeReporters(registry, null);
        registry = SolrMetricManager.enforcePrefix(registry);
        if (SolrMetricManager.isSharedRegistry(registry)) {
            SharedMetricRegistries.remove((String)registry);
        } else {
            this.swapLock.lock();
            try {
                this.registries.remove(registry);
            }
            finally {
                this.swapLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void swapRegistries(String registry1, String registry2) {
        registry1 = SolrMetricManager.enforcePrefix(registry1);
        registry2 = SolrMetricManager.enforcePrefix(registry2);
        if (SolrMetricManager.isSharedRegistry(registry1) || SolrMetricManager.isSharedRegistry(registry2)) {
            throw new UnsupportedOperationException("Cannot swap shared registry: " + registry1 + ", " + registry2);
        }
        this.swapLock.lock();
        try {
            MetricRegistry from = (MetricRegistry)this.registries.get(registry1);
            MetricRegistry to = (MetricRegistry)this.registries.get(registry2);
            if (from == to) {
                return;
            }
            MetricRegistry reg1 = (MetricRegistry)this.registries.remove(registry1);
            MetricRegistry reg2 = (MetricRegistry)this.registries.remove(registry2);
            if (reg2 != null) {
                this.registries.put(registry1, reg2);
            }
            if (reg1 != null) {
                this.registries.put(registry2, reg1);
            }
        }
        finally {
            this.swapLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerAll(String registry, MetricSet metrics, boolean force, String ... metricPath) throws Exception {
        MetricRegistry metricRegistry;
        MetricRegistry metricRegistry2 = metricRegistry = this.registry(registry);
        synchronized (metricRegistry2) {
            Map existingMetrics = metricRegistry.getMetrics();
            for (Map.Entry entry : metrics.getMetrics().entrySet()) {
                String fullName = SolrMetricManager.mkName((String)entry.getKey(), metricPath);
                if (force && existingMetrics.containsKey(fullName)) {
                    metricRegistry.remove(fullName);
                }
                metricRegistry.register(fullName, (Metric)entry.getValue());
            }
        }
    }

    public void clearRegistry(String registry) {
        this.registry(registry).removeMatching(MetricFilter.ALL);
    }

    public Set<String> clearMetrics(String registry, String ... metricPath) {
        PrefixFilter filter;
        if (metricPath == null || metricPath.length == 0) {
            filter = new PrefixFilter("");
        } else {
            String prefix = MetricRegistry.name((String)"", (String[])metricPath);
            filter = new PrefixFilter(prefix);
        }
        this.registry(registry).removeMatching((MetricFilter)filter);
        return filter.getMatched();
    }

    public Map<String, Metric> getMetrics(String registry, MetricFilter metricFilter) {
        if (metricFilter == null || metricFilter == MetricFilter.ALL) {
            return this.registry(registry).getMetrics();
        }
        return this.registry(registry).getMetrics().entrySet().stream().filter(entry -> metricFilter.matches((String)entry.getKey(), (Metric)entry.getValue())).collect(Collectors.toMap(entry -> (String)entry.getKey(), entry -> (Metric)entry.getValue()));
    }

    public Meter meter(SolrInfoBean info, String registry, String metricName, String ... metricPath) {
        String name = SolrMetricManager.mkName(metricName, metricPath);
        if (info != null) {
            info.registerMetricName(name);
        }
        return this.registry(registry).meter(name, this.meterSupplier);
    }

    public Timer timer(SolrInfoBean info, String registry, String metricName, String ... metricPath) {
        String name = SolrMetricManager.mkName(metricName, metricPath);
        if (info != null) {
            info.registerMetricName(name);
        }
        return this.registry(registry).timer(name, this.timerSupplier);
    }

    public Counter counter(SolrInfoBean info, String registry, String metricName, String ... metricPath) {
        String name = SolrMetricManager.mkName(metricName, metricPath);
        if (info != null) {
            info.registerMetricName(name);
        }
        return this.registry(registry).counter(name, this.counterSupplier);
    }

    public Histogram histogram(SolrInfoBean info, String registry, String metricName, String ... metricPath) {
        String name = SolrMetricManager.mkName(metricName, metricPath);
        if (info != null) {
            info.registerMetricName(name);
        }
        return this.registry(registry).histogram(name, this.histogramSupplier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerMetric(SolrInfoBean info, String registry, Metric metric, boolean force, String metricName, String ... metricPath) {
        MetricRegistry metricRegistry = this.registry(registry);
        String fullName = SolrMetricManager.mkName(metricName, metricPath);
        if (info != null) {
            info.registerMetricName(fullName);
        }
        MetricRegistry metricRegistry2 = metricRegistry;
        synchronized (metricRegistry2) {
            if (force && metricRegistry.getMetrics().containsKey(fullName)) {
                metricRegistry.remove(fullName);
            }
            metricRegistry.register(fullName, metric);
        }
    }

    public void registerGauge(SolrInfoBean info, String registry, Gauge<?> gauge, String tag, boolean force, String metricName, String ... metricPath) {
        this.registerMetric(info, registry, (Metric)new GaugeWrapper(gauge, tag), force, metricName, metricPath);
    }

    public int unregisterGauges(String registryName, String tag) {
        if (tag == null) {
            return 0;
        }
        MetricRegistry registry = this.registry(registryName);
        AtomicInteger removed = new AtomicInteger();
        registry.removeMatching((name, metric) -> {
            if (metric instanceof GaugeWrapper && tag.equals(((GaugeWrapper)metric).getTag())) {
                removed.incrementAndGet();
                return true;
            }
            return false;
        });
        return removed.get();
    }

    public static String mkName(String name, String ... path) {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("name must not be empty");
        }
        if (path == null || path.length == 0) {
            return name;
        }
        StringBuilder sb = new StringBuilder();
        for (String s : path) {
            if (s == null || s.isEmpty()) continue;
            if (sb.length() > 0) {
                sb.append('.');
            }
            sb.append(s);
        }
        if (sb.length() > 0) {
            sb.append('.');
        }
        sb.append(name);
        return sb.toString();
    }

    public static String enforcePrefix(String name) {
        if (name.startsWith(REGISTRY_NAME_PREFIX)) {
            return name;
        }
        return REGISTRY_NAME_PREFIX + name;
    }

    public static String getRegistryName(SolrInfoBean.Group group, String ... names) {
        String fullName;
        String prefix = REGISTRY_NAME_PREFIX + group.name() + '.';
        if (names != null && names.length > 0 && names[0] != null && names[0].startsWith(prefix)) {
            if (names.length > 1) {
                String[] newNames = new String[names.length - 1];
                System.arraycopy(names, 1, newNames, 0, newNames.length);
                fullName = MetricRegistry.name((String)names[0], (String[])newNames);
            } else {
                fullName = MetricRegistry.name((String)names[0], (String[])new String[0]);
            }
        } else {
            fullName = MetricRegistry.name((String)group.toString(), (String[])names);
        }
        return SolrMetricManager.enforcePrefix(fullName);
    }

    public void loadReporters(PluginInfo[] pluginInfos, SolrResourceLoader loader, CoreContainer coreContainer, SolrCore solrCore, String tag, SolrInfoBean.Group group, String ... registryNames) {
        if (pluginInfos == null || pluginInfos.length == 0) {
            return;
        }
        String registryName = SolrMetricManager.getRegistryName(group, registryNames);
        for (PluginInfo info : pluginInfos) {
            boolean found;
            String[] targets;
            String target = info.attributes.get("group");
            if (target == null) {
                target = info.attributes.get("registry");
                if (target != null) {
                    targets = target.split("[\\s,]+");
                    found = false;
                    for (String t : targets) {
                        if (!registryName.equals(t = SolrMetricManager.enforcePrefix(t))) continue;
                        found = true;
                        break;
                    }
                    if (!found) {
                        continue;
                    }
                }
            } else {
                targets = target.split("[\\s,]+");
                found = false;
                for (String t : targets) {
                    if (!group.toString().equals(t)) continue;
                    found = true;
                    break;
                }
                if (!found) continue;
            }
            try {
                this.loadReporter(registryName, loader, coreContainer, solrCore, info, tag);
            }
            catch (Exception e) {
                log.warn("Error loading metrics reporter, plugin info: " + info, (Throwable)e);
            }
        }
    }

    public void loadReporter(String registry, SolrCore solrCore, PluginInfo pluginInfo, String tag) throws Exception {
        this.loadReporter(registry, solrCore.getResourceLoader(), solrCore.getCoreContainer(), solrCore, pluginInfo, tag);
    }

    public void loadReporter(String registry, CoreContainer coreContainer, PluginInfo pluginInfo) throws Exception {
        this.loadReporter(registry, coreContainer.getResourceLoader(), coreContainer, null, pluginInfo, null);
    }

    public void loadReporter(String registry, SolrResourceLoader loader, CoreContainer coreContainer, SolrCore solrCore, PluginInfo pluginInfo, String tag) throws Exception {
        if (registry == null || pluginInfo == null || pluginInfo.name == null || pluginInfo.className == null) {
            throw new IllegalArgumentException("loadReporter called with missing arguments: registry=" + registry + ", loader=" + loader + ", pluginInfo=" + pluginInfo);
        }
        registry = SolrMetricManager.enforcePrefix(registry);
        SolrMetricReporter reporter = loader.newInstance(pluginInfo.className, SolrMetricReporter.class, new String[0], new Class[]{SolrMetricManager.class, String.class}, new Object[]{this, registry});
        MDCLoggingContext.setNode(coreContainer);
        if (solrCore != null) {
            MDCLoggingContext.setCore(solrCore);
        }
        if (tag != null) {
            MDC.put((String)"tag", (String)("t:" + tag));
        }
        try {
            if (reporter instanceof SolrCoreReporter) {
                ((SolrCoreReporter)reporter).init(pluginInfo, solrCore);
            } else if (reporter instanceof SolrCoreContainerReporter) {
                ((SolrCoreContainerReporter)reporter).init(pluginInfo, coreContainer);
            } else {
                reporter.init(pluginInfo);
            }
        }
        catch (IllegalStateException e) {
            throw new IllegalArgumentException("reporter init failed: " + pluginInfo, e);
        }
        finally {
            MDCLoggingContext.clear();
            MDC.remove((String)"tag");
        }
        this.registerReporter(registry, pluginInfo.name, tag, reporter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerReporter(String registry, String name, String tag, SolrMetricReporter reporter) throws Exception {
        try {
            if (!this.reportersLock.tryLock(10L, TimeUnit.SECONDS)) {
                throw new Exception("Could not obtain lock to modify reporters registry: " + registry);
            }
        }
        catch (InterruptedException e) {
            throw new Exception("Interrupted while trying to obtain lock to modify reporters registry: " + registry);
        }
        try {
            SolrMetricReporter oldReporter;
            Map<String, SolrMetricReporter> perRegistry = this.reporters.get(registry);
            if (perRegistry == null) {
                perRegistry = new HashMap<String, SolrMetricReporter>();
                this.reporters.put(registry, perRegistry);
            }
            if (tag != null && !tag.isEmpty()) {
                name = name + "@" + tag;
            }
            if ((oldReporter = perRegistry.get(name)) != null) {
                log.info("Replacing existing reporter '" + name + "' in registry '" + registry + "': " + oldReporter.toString());
                oldReporter.close();
            }
            perRegistry.put(name, reporter);
        }
        finally {
            this.reportersLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean closeReporter(String registry, String name, String tag) {
        registry = SolrMetricManager.enforcePrefix(registry);
        try {
            if (!this.reportersLock.tryLock(10L, TimeUnit.SECONDS)) {
                log.warn("Could not obtain lock to modify reporters registry: " + registry);
                return false;
            }
        }
        catch (InterruptedException e) {
            log.warn("Interrupted while trying to obtain lock to modify reporters registry: " + registry);
            return false;
        }
        try {
            SolrMetricReporter reporter;
            Map<String, SolrMetricReporter> perRegistry = this.reporters.get(registry);
            if (perRegistry == null) {
                boolean bl = false;
                return bl;
            }
            if (tag != null && !tag.isEmpty()) {
                name = name + "@" + tag;
            }
            if ((reporter = perRegistry.remove(name)) == null) {
                boolean bl = false;
                return bl;
            }
            try {
                reporter.close();
            }
            catch (Exception e) {
                log.warn("Error closing metric reporter, registry=" + registry + ", name=" + name, (Throwable)e);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.reportersLock.unlock();
        }
    }

    public Set<String> closeReporters(String registry) {
        return this.closeReporters(registry, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> closeReporters(String registry, String tag) {
        registry = SolrMetricManager.enforcePrefix(registry);
        try {
            if (!this.reportersLock.tryLock(10L, TimeUnit.SECONDS)) {
                log.warn("Could not obtain lock to modify reporters registry: " + registry);
                return Collections.emptySet();
            }
        }
        catch (InterruptedException e) {
            log.warn("Interrupted while trying to obtain lock to modify reporters registry: " + registry);
            return Collections.emptySet();
        }
        log.info("Closing metric reporters for registry=" + registry + ", tag=" + tag);
        try {
            Map<String, SolrMetricReporter> perRegistry = this.reporters.get(registry);
            if (perRegistry != null) {
                HashSet<String> names = new HashSet<String>(perRegistry.keySet());
                HashSet<String> removed = new HashSet<String>();
                names.forEach(name -> {
                    if (tag != null && !tag.isEmpty() && !name.endsWith("@" + tag)) {
                        return;
                    }
                    SolrMetricReporter reporter = (SolrMetricReporter)perRegistry.remove(name);
                    try {
                        reporter.close();
                    }
                    catch (IOException ioe) {
                        log.warn("Exception closing reporter " + reporter, (Throwable)ioe);
                    }
                    removed.add((String)name);
                });
                if (removed.size() == names.size()) {
                    this.reporters.remove(registry);
                }
                HashSet<String> hashSet = removed;
                return hashSet;
            }
            Set<String> set = Collections.emptySet();
            return set;
        }
        finally {
            this.reportersLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, SolrMetricReporter> getReporters(String registry) {
        registry = SolrMetricManager.enforcePrefix(registry);
        try {
            if (!this.reportersLock.tryLock(10L, TimeUnit.SECONDS)) {
                log.warn("Could not obtain lock to modify reporters registry: " + registry);
                return Collections.emptyMap();
            }
        }
        catch (InterruptedException e) {
            log.warn("Interrupted while trying to obtain lock to modify reporters registry: " + registry);
            return Collections.emptyMap();
        }
        try {
            Map<String, SolrMetricReporter> perRegistry = this.reporters.get(registry);
            if (perRegistry == null) {
                Map<String, SolrMetricReporter> map = Collections.emptyMap();
                return map;
            }
            Map<String, SolrMetricReporter> map = Collections.unmodifiableMap(new HashMap<String, SolrMetricReporter>(perRegistry));
            return map;
        }
        finally {
            this.reportersLock.unlock();
        }
    }

    private List<PluginInfo> prepareCloudPlugins(PluginInfo[] pluginInfos, String group, Map<String, String> defaultAttributes, Map<String, Object> defaultInitArgs) {
        ArrayList<PluginInfo> result = new ArrayList<PluginInfo>();
        if (pluginInfos == null) {
            pluginInfos = new PluginInfo[]{};
        }
        for (PluginInfo info : pluginInfos) {
            String groupAttr = info.attributes.get("group");
            if (!group.equals(groupAttr) || (info = this.preparePlugin(info, defaultAttributes, defaultInitArgs)) == null) continue;
            result.add(info);
        }
        return result;
    }

    private PluginInfo preparePlugin(PluginInfo info, Map<String, String> defaultAttributes, Map<String, Object> defaultInitArgs) {
        if (info == null) {
            return null;
        }
        String classNameAttr = info.attributes.get("class");
        HashMap<String, String> attrs = new HashMap<String, String>(info.attributes);
        defaultAttributes.forEach((k, v) -> {
            if (!attrs.containsKey(k)) {
                attrs.put((String)k, (String)v);
            }
        });
        attrs.put("class", classNameAttr);
        HashMap initArgs = new HashMap();
        if (info.initArgs != null) {
            initArgs.putAll(info.initArgs.asMap(10));
        }
        defaultInitArgs.forEach((k, v) -> {
            if (!initArgs.containsKey(k)) {
                initArgs.put(k, v);
            }
        });
        return new PluginInfo(info.type, attrs, new NamedList(initArgs), null);
    }

    public void loadShardReporters(PluginInfo[] pluginInfos, SolrCore core) {
        if (core.getCoreDescriptor().getCloudDescriptor() == null) {
            return;
        }
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("name", "shardDefault");
        attrs.put("group", SolrInfoBean.Group.shard.toString());
        HashMap<String, Object> initArgs = new HashMap<String, Object>();
        initArgs.put("period", 60);
        String registryName = core.getCoreMetricManager().getRegistryName();
        List<PluginInfo> infos = this.prepareCloudPlugins(pluginInfos, SolrInfoBean.Group.shard.toString(), attrs, initArgs);
        for (PluginInfo info : infos) {
            try {
                this.loadReporter(registryName, core, info, core.getMetricTag());
            }
            catch (Exception e) {
                log.warn("Could not load shard reporter, pluginInfo=" + info, (Throwable)e);
            }
        }
    }

    public void loadClusterReporters(PluginInfo[] pluginInfos, CoreContainer cc) {
        if (!cc.isZooKeeperAware()) {
            return;
        }
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("name", "clusterDefault");
        attrs.put("group", SolrInfoBean.Group.cluster.toString());
        HashMap<String, Object> initArgs = new HashMap<String, Object>();
        initArgs.put("period", 60);
        List<PluginInfo> infos = this.prepareCloudPlugins(pluginInfos, SolrInfoBean.Group.cluster.toString(), attrs, initArgs);
        String registryName = SolrMetricManager.getRegistryName(SolrInfoBean.Group.cluster, new String[0]);
        for (PluginInfo info : infos) {
            try {
                this.loadReporter(registryName, cc, info);
            }
            catch (Exception e) {
                log.warn("Could not load cluster reporter, pluginInfo=" + info, (Throwable)e);
            }
        }
    }

    public static class GaugeWrapper<T>
    implements Gauge<T> {
        private final Gauge<T> gauge;
        private final String tag;

        public GaugeWrapper(Gauge<T> gauge, String tag) {
            this.gauge = gauge;
            this.tag = tag;
        }

        public T getValue() {
            return (T)this.gauge.getValue();
        }

        public String getTag() {
            return this.tag;
        }

        public Gauge<T> getGauge() {
            return this.gauge;
        }
    }

    public static class AndFilter
    implements MetricFilter {
        List<MetricFilter> filters = new ArrayList<MetricFilter>();

        public AndFilter(Collection<MetricFilter> filters) {
            if (filters != null) {
                this.filters.addAll(filters);
            }
        }

        public AndFilter(MetricFilter ... filters) {
            if (filters != null) {
                for (MetricFilter filter : filters) {
                    if (filter == null) continue;
                    this.filters.add(filter);
                }
            }
        }

        public boolean matches(String s, Metric metric) {
            for (MetricFilter filter : this.filters) {
                if (filter.matches(s, metric)) continue;
                return false;
            }
            return true;
        }
    }

    public static class OrFilter
    implements MetricFilter {
        List<MetricFilter> filters = new ArrayList<MetricFilter>();

        public OrFilter(Collection<MetricFilter> filters) {
            if (filters != null) {
                this.filters.addAll(filters);
            }
        }

        public OrFilter(MetricFilter ... filters) {
            if (filters != null) {
                for (MetricFilter filter : filters) {
                    if (filter == null) continue;
                    this.filters.add(filter);
                }
            }
        }

        public boolean matches(String s, Metric metric) {
            for (MetricFilter filter : this.filters) {
                if (!filter.matches(s, metric)) continue;
                return true;
            }
            return false;
        }
    }

    public static class RegexFilter
    implements MetricFilter {
        private final Set<Pattern> compiledPatterns = new HashSet<Pattern>();
        private final Set<String> matched = new HashSet<String>();
        private boolean allMatch = false;

        public RegexFilter(String ... patterns) throws PatternSyntaxException {
            this(patterns != null ? Arrays.asList(patterns) : Collections.emptyList());
        }

        public RegexFilter(Collection<String> patterns) throws PatternSyntaxException {
            Objects.requireNonNull(patterns);
            if (patterns.isEmpty()) {
                this.allMatch = true;
                return;
            }
            patterns.forEach(p -> {
                Pattern pattern = Pattern.compile(p);
                this.compiledPatterns.add(pattern);
            });
            if (patterns.isEmpty()) {
                this.allMatch = true;
            }
        }

        public boolean matches(String name, Metric metric) {
            if (this.allMatch) {
                this.matched.add(name);
                return true;
            }
            for (Pattern p : this.compiledPatterns) {
                if (!p.matcher(name).matches()) continue;
                this.matched.add(name);
                return true;
            }
            return false;
        }

        public Set<String> getMatched() {
            return Collections.unmodifiableSet(this.matched);
        }

        public void reset() {
            this.matched.clear();
        }

        public String toString() {
            return "RegexFilter{compiledPatterns=" + this.compiledPatterns + '}';
        }
    }

    public static class PrefixFilter
    implements MetricFilter {
        private final Set<String> prefixes = new HashSet<String>();
        private final Set<String> matched = new HashSet<String>();
        private boolean allMatch = false;

        public PrefixFilter(String ... prefixes) {
            Objects.requireNonNull(prefixes);
            if (prefixes.length > 0) {
                this.prefixes.addAll(Arrays.asList(prefixes));
            }
            if (this.prefixes.isEmpty()) {
                this.allMatch = true;
            }
        }

        public PrefixFilter(Collection<String> prefixes) {
            Objects.requireNonNull(prefixes);
            this.prefixes.addAll(prefixes);
            if (this.prefixes.isEmpty()) {
                this.allMatch = true;
            }
        }

        public boolean matches(String name, Metric metric) {
            if (this.allMatch) {
                this.matched.add(name);
                return true;
            }
            for (String prefix : this.prefixes) {
                if (!name.startsWith(prefix)) continue;
                this.matched.add(name);
                return true;
            }
            return false;
        }

        public Set<String> getMatched() {
            return Collections.unmodifiableSet(this.matched);
        }

        public void reset() {
            this.matched.clear();
        }

        public String toString() {
            return "PrefixFilter{prefixes=" + this.prefixes + '}';
        }
    }
}

