/*
 * Decompiled with CFR 0.152.
 */
package au.com.trgtd.email.task;

import au.com.trgtd.email.task.FetchEmailThread;
import java.util.Timer;
import java.util.TimerTask;

public class FetchEmailScheduler {
    private static FetchEmailScheduler instance;
    private Timer timerSingle;
    private Timer timerRepeat;

    public static FetchEmailScheduler instance() {
        if (instance == null) {
            instance = new FetchEmailScheduler();
        }
        return instance;
    }

    private FetchEmailScheduler() {
    }

    public void schedule(long delay) {
        this.cancelSingle();
        this.timerSingle = new Timer();
        this.timerSingle.schedule((TimerTask)new Task(), delay);
    }

    public void schedule(long delay, long interval) {
        this.cancelRepeat();
        this.timerRepeat = new Timer();
        this.timerRepeat.schedule((TimerTask)new Task(), delay, interval);
    }

    public void cancel() {
        this.cancelSingle();
        this.cancelRepeat();
    }

    private void cancelSingle() {
        if (this.timerSingle != null) {
            this.timerSingle.cancel();
            this.timerSingle = null;
        }
    }

    private void cancelRepeat() {
        if (this.timerRepeat != null) {
            this.timerRepeat.cancel();
            this.timerRepeat = null;
        }
    }

    private static class Task
    extends TimerTask {
        private Task() {
        }

        public void run() {
            new FetchEmailThread().start();
        }
    }
}

