/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging.core;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.core.DestinationResolutionException;
import org.springframework.messaging.core.DestinationResolver;
import org.springframework.util.Assert;

public class BeanFactoryMessageChannelDestinationResolver
implements DestinationResolver<MessageChannel>,
BeanFactoryAware {
    private BeanFactory beanFactory;

    public BeanFactoryMessageChannelDestinationResolver() {
    }

    public BeanFactoryMessageChannelDestinationResolver(BeanFactory beanFactory) {
        Assert.notNull(beanFactory, "beanFactory must not be null");
        this.beanFactory = beanFactory;
    }

    @Override
    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    @Override
    public MessageChannel resolveDestination(String name) {
        Assert.state(this.beanFactory != null, "No BeanFactory configured");
        try {
            return this.beanFactory.getBean(name, MessageChannel.class);
        }
        catch (BeansException ex) {
            throw new DestinationResolutionException("Failed to find MessageChannel bean with name '" + name + "'", (Throwable)ex);
        }
    }
}

