/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.laf;

import java.util.HashSet;
import java.util.Iterator;
import org.pentaho.di.laf.Handler;
import org.pentaho.di.laf.LAFChangeListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LAFDelegate<E extends Handler> {
    E handler;
    Class<E> handlerClass;
    Class<E> defaultHandlerClass = null;
    private HashSet<LAFChangeListener<E>> registry = new HashSet();

    public LAFDelegate(Class<E> handler, Class<E> defaultHandler) {
        this.handlerClass = handler;
        this.defaultHandlerClass = defaultHandler;
        this.init();
    }

    private void init() {
        this.handler = this.handler != null ? this.loadHandler(this.handlerClass) : this.loadHandler(this.defaultHandlerClass);
    }

    public E newHandlerInstance(String classname) throws ClassNotFoundException {
        E h = null;
        Class<?> c = null;
        c = Class.forName(classname);
        h = (E)this.loadHandler(c);
        return h;
    }

    private E loadHandler(Class<E> c) {
        Handler h = null;
        try {
            if (c.isAssignableFrom(this.handlerClass.getClass())) {
                // empty if block
            }
            h = (Handler)c.newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (h != null) {
            this.changeHandler(h);
        }
        return (E)h;
    }

    public E registerChangeListener(LAFChangeListener<E> listener) {
        this.registry.add(listener);
        return this.handler;
    }

    public void unregisterChangeListener(LAFChangeListener<E> listener) {
        this.registry.remove(listener);
    }

    public HashSet<LAFChangeListener<E>> getListeners() {
        return this.registry;
    }

    public void loadListeners(HashSet<LAFChangeListener<E>> listeners) {
        this.registry = listeners;
    }

    public void changeHandler(E handler) {
        this.handler = handler;
        this.notifyListeners();
    }

    protected void notifyListeners() {
        Iterator<LAFChangeListener<E>> iterator = this.registry.iterator();
        while (iterator.hasNext()) {
            iterator.next().notify(this.handler);
        }
    }

    public E getHandler() {
        return this.handler;
    }
}

