/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.actions;

import docking.ActionContext;
import docking.action.DockingAction;
import docking.action.MenuData;
import docking.action.ToolBarData;
import docking.wizard.PanelManager;
import docking.wizard.WizardManager;
import ghidra.feature.vt.gui.plugin.VTController;
import ghidra.feature.vt.gui.plugin.VTPlugin;
import ghidra.feature.vt.gui.wizard.VTAddToSessionWizardManager;
import ghidra.util.HelpLocation;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import resources.ResourceManager;

public class AddToVersionTrackingSessionAction
extends DockingAction {
    private final VTController controller;

    public AddToVersionTrackingSessionAction(VTController controller) {
        super("Add To Session", VTPlugin.OWNER);
        this.controller = controller;
        String[] menuPath = new String[]{"&File", "Add to Session..."};
        ImageIcon plusIcon = ResourceManager.loadImage((String)"images/Plus.png");
        this.setMenuBarData(new MenuData(menuPath, (Icon)plusIcon, "AAA"));
        this.setToolBarData(new ToolBarData((Icon)plusIcon, "View"));
        this.setDescription("Add additional correlations to the current version tracking session");
        this.setHelpLocation(new HelpLocation("VersionTrackingPlugin", "Add_To_Session"));
    }

    public void actionPerformed(ActionContext context) {
        VTAddToSessionWizardManager vtWizardManager = new VTAddToSessionWizardManager(this.controller);
        WizardManager wizardManager = new WizardManager("Version Tracking Wizard", true, (PanelManager)vtWizardManager);
        wizardManager.showWizard(this.controller.getParentComponent());
    }

    public boolean isEnabledForContext(ActionContext context) {
        return this.controller.getSession() != null;
    }
}

