/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.provider.markuptable;

import ghidra.feature.vt.gui.editors.DisplayableAddress;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Parameter;
import ghidra.program.model.listing.Program;

public class DisplayableParameterAddress
implements DisplayableAddress {
    protected final Function function;
    protected Address parameterAddress;

    public DisplayableParameterAddress(Function function, Address parameterAddress) {
        this.function = function;
        this.parameterAddress = parameterAddress;
    }

    @Override
    public Program getProgram() {
        return this.function.getProgram();
    }

    @Override
    public Address getAddress() {
        return this.parameterAddress;
    }

    @Override
    public String getDisplayString() {
        Parameter parameter = this.getParameter(this.function, this.parameterAddress);
        return this.getDisplayValue(parameter);
    }

    public String getDisplayValue(Parameter parameter) {
        if (parameter == null) {
            return "No Address";
        }
        return this.getOrdinalString(parameter) + parameter.getVariableStorage().toString();
    }

    private Parameter getParameter(Function functionToUse, Address parameterAddressToGet) {
        Parameter[] parameters;
        if (functionToUse == null || parameterAddressToGet == null) {
            return null;
        }
        for (Parameter parameter : parameters = functionToUse.getParameters()) {
            if (!parameter.getMinAddress().equals((Object)parameterAddressToGet)) continue;
            return parameter;
        }
        return null;
    }

    private String getOrdinalString(Parameter parameter) {
        return parameter != null ? "Parameter " + (parameter.getOrdinal() + 1) + " @ " : "";
    }

    public String toString() {
        return this.getDisplayString();
    }

    @Override
    public int compareTo(DisplayableAddress otherDisplayableAddress) {
        if (otherDisplayableAddress == null) {
            return 1;
        }
        Address otherAddress = otherDisplayableAddress.getAddress();
        if (this.parameterAddress == null) {
            return otherAddress == null ? 0 : -1;
        }
        if (otherAddress == null) {
            return 1;
        }
        return this.parameterAddress.compareTo((Object)otherAddress);
    }
}

