/*
 * Decompiled with CFR 0.152.
 */
package docking;

import docking.ComponentPlaceholder;
import docking.ComponentProvider;
import docking.DockingWindowManager;
import docking.Node;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JSeparator;

public abstract class WindowNode
extends Node {
    private JPanel toolBarPanel;
    private ComponentPlaceholder lastFocusedProviderInWindow;
    private Set<Class<?>> contextTypes;

    WindowNode(DockingWindowManager winMgr) {
        super(winMgr);
    }

    abstract void setMenuBar(JMenuBar var1);

    abstract String getTitle();

    abstract void validate();

    abstract Container getContentPane();

    void setToolBar(JComponent toolBar) {
        Container rootPane = this.getContentPane();
        if (rootPane == null) {
            return;
        }
        if (this.toolBarPanel != null) {
            rootPane.remove(this.toolBarPanel);
            this.toolBarPanel = null;
        }
        if (toolBar != null) {
            this.toolBarPanel = new JPanel(new BorderLayout());
            this.toolBarPanel.add((Component)toolBar, "North");
            this.toolBarPanel.add((Component)new JSeparator(0), "South");
            rootPane.add((Component)this.toolBarPanel, "North");
        }
    }

    public void setLastFocusedProviderInWindow(ComponentPlaceholder lastFocusedInWindow) {
        this.lastFocusedProviderInWindow = lastFocusedInWindow;
    }

    public ComponentPlaceholder getLastFocusedProviderInWindow() {
        List<ComponentPlaceholder> activeComponents;
        if (this.lastFocusedProviderInWindow == null && (activeComponents = this.getActiveComponents()).size() != 0) {
            this.lastFocusedProviderInWindow = activeComponents.get(0);
        }
        return this.lastFocusedProviderInWindow;
    }

    public Set<Class<?>> getContextTypes() {
        if (this.contextTypes == null) {
            this.contextTypes = new HashSet();
            List<ComponentPlaceholder> activeComponents = this.getActiveComponents();
            for (ComponentPlaceholder placeholder : activeComponents) {
                ComponentProvider provider = placeholder.getProvider();
                Class<?> contextType = provider.getContextType();
                if (contextType == null) continue;
                this.contextTypes.add(contextType);
            }
        }
        return this.contextTypes;
    }

    List<ComponentPlaceholder> getActiveComponents() {
        ArrayList<ComponentPlaceholder> activeComponents = new ArrayList<ComponentPlaceholder>();
        this.populateActiveComponents(activeComponents);
        return activeComponents;
    }

    protected void clearContextTypes() {
        this.contextTypes = null;
    }

    @Override
    void dispose() {
        this.toolBarPanel = null;
    }

    public void componentRemoved(ComponentPlaceholder placeholder) {
        if (this.lastFocusedProviderInWindow == placeholder) {
            this.lastFocusedProviderInWindow = null;
        }
    }

    public void componentAdded(ComponentPlaceholder placeholder) {
    }
}

