/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.combobox;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.ComboBoxUI;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;

public class GhidraComboBox<E>
extends JComboBox<E> {
    private ArrayList<ActionListener> listeners = new ArrayList();
    private ArrayList<DocumentListener> docListeners = new ArrayList();
    private boolean setSelectedFlag = false;
    private boolean forwardEnter;
    private Action defaultSystemEnterForwardingAction;

    public GhidraComboBox() {
    }

    public GhidraComboBox(ComboBoxModel<E> aModel) {
        super(aModel);
    }

    public GhidraComboBox(E[] items) {
        super(items);
    }

    public GhidraComboBox(Vector<E> items) {
        super(items);
    }

    @Override
    public void setUI(ComboBoxUI ui) {
        ActionMap am;
        super.setUI(ui);
        Component object = this.getEditor().getEditorComponent();
        if (object instanceof JTextField) {
            JTextField textField = (JTextField)object;
            textField.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GhidraComboBox.this.notifyActionListeners(e);
                }
            });
            textField.setDocument(new InterceptedInputDocument());
            textField.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void removeUpdate(DocumentEvent e) {
                    GhidraComboBox.this.notifyRemove(e);
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    GhidraComboBox.this.notifyInsert(e);
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    GhidraComboBox.this.notifyChanged(e);
                }
            });
        }
        if ((am = this.getActionMap()) != null) {
            this.defaultSystemEnterForwardingAction = am.get("enterPressed");
            am.put("enterPressed", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (GhidraComboBox.this.forwardEnter) {
                        GhidraComboBox.this.defaultSystemEnterForwardingAction.actionPerformed(e);
                    }
                }
            });
        }
    }

    public void setEnterKeyForwarding(boolean forwardEnter) {
        this.forwardEnter = forwardEnter;
    }

    public String getText() {
        Component comp = this.getEditor().getEditorComponent();
        if (comp instanceof JTextField) {
            JTextField textField = (JTextField)comp;
            return textField.getText();
        }
        return null;
    }

    @Override
    public void setSelectedItem(Object obj) {
        this.setSelectedFlag = true;
        super.setSelectedItem(obj);
        Component comp = this.getEditor().getEditorComponent();
        if (comp instanceof JTextField) {
            JTextField textField = (JTextField)comp;
            this.updateTextFieldTextForClearedSelection(textField, obj);
            textField.selectAll();
        }
        this.setSelectedFlag = false;
    }

    public void setColumnCount(int columnCount) {
        Component comp = this.getEditor().getEditorComponent();
        if (comp instanceof JTextField) {
            ((JTextField)comp).setColumns(columnCount);
        }
    }

    private void updateTextFieldTextForClearedSelection(JTextField comboBoxTextField, Object selectedItem) {
        String newText;
        if (selectedItem == null) {
            return;
        }
        String text = comboBoxTextField.getText();
        if (!text.equals(newText = selectedItem.toString())) {
            comboBoxTextField.setText(newText);
        }
    }

    public void selectAll() {
        Component comp = this.getEditor().getEditorComponent();
        if (comp instanceof JTextField) {
            JTextField textField = (JTextField)comp;
            textField.selectAll();
        }
    }

    public void clearModel() {
        DefaultComboBoxModel model = (DefaultComboBoxModel)this.getModel();
        model.removeAllElements();
    }

    public void addToModel(E obj) {
        DefaultComboBoxModel model = (DefaultComboBoxModel)this.getModel();
        model.addElement(obj);
    }

    public boolean containsItem(E obj) {
        DefaultComboBoxModel model = (DefaultComboBoxModel)this.getModel();
        return model.getIndexOf(obj) != -1;
    }

    @Override
    public void addActionListener(ActionListener l) {
        this.listeners.add(l);
    }

    @Override
    public void removeActionListener(ActionListener l) {
        this.listeners.remove(l);
    }

    public void addDocumentListener(DocumentListener l) {
        this.docListeners.add(l);
    }

    public void removeDocumentListener(DocumentListener l) {
        this.docListeners.remove(l);
    }

    private void notifyActionListeners(ActionEvent e) {
        Iterator<ActionListener> iter = this.listeners.iterator();
        while (iter.hasNext()) {
            iter.next().actionPerformed(e);
        }
    }

    private void notifyInsert(DocumentEvent e) {
        Iterator<DocumentListener> iter = this.docListeners.iterator();
        while (iter.hasNext()) {
            iter.next().insertUpdate(e);
        }
    }

    private void notifyChanged(DocumentEvent e) {
        Iterator<DocumentListener> iter = this.docListeners.iterator();
        while (iter.hasNext()) {
            iter.next().changedUpdate(e);
        }
    }

    private void notifyRemove(DocumentEvent e) {
        Iterator<DocumentListener> iter = this.docListeners.iterator();
        while (iter.hasNext()) {
            iter.next().removeUpdate(e);
        }
    }

    private String matchHistory(String input) {
        if (this.setSelectedFlag) {
            return null;
        }
        if (input == null) {
            return null;
        }
        int count = this.getItemCount();
        for (int i = 0; i < count; ++i) {
            String cur = this.getItemAt(i).toString();
            if (!cur.startsWith(input)) continue;
            return cur;
        }
        return null;
    }

    public class InterceptedInputDocument
    extends DefaultStyledDocument {
        private boolean automated = false;

        @Override
        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            super.insertString(offs, str, a);
            if (this.automated) {
                this.automated = false;
            } else {
                JTextField textField = (JTextField)GhidraComboBox.this.getEditor().getEditorComponent();
                String input = textField.getText();
                String match = GhidraComboBox.this.matchHistory(input);
                if (match != null && match.length() > input.length()) {
                    this.automated = true;
                    textField.setText(match);
                    textField.setSelectionStart(input.length());
                    textField.setSelectionEnd(match.length());
                }
            }
        }
    }
}

