/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.fieldpanel.internal;

import docking.widgets.fieldpanel.internal.FieldBackgroundColorManager;
import docking.widgets.fieldpanel.internal.LayoutBackgroundColorManager;
import docking.widgets.fieldpanel.support.FieldLocation;
import java.awt.Color;

public class LayoutBackgroundColorManagerAdapter
implements LayoutBackgroundColorManager {
    private final LayoutBackgroundColorManager layoutSelectionMap;
    private int start;
    private int end;
    private boolean isLastRow;

    public LayoutBackgroundColorManagerAdapter(LayoutBackgroundColorManager layoutColorMap) {
        this.layoutSelectionMap = layoutColorMap;
    }

    @Override
    public Color getBackgroundColor() {
        return this.layoutSelectionMap.getBackgroundColor();
    }

    @Override
    public FieldBackgroundColorManager getFieldBackgroundColorManager(int fieldNum) {
        return this.layoutSelectionMap.getFieldBackgroundColorManager(fieldNum + this.start);
    }

    public void setRange(int start, int end, boolean isLastRow) {
        this.start = start;
        this.end = end;
        this.isLastRow = isLastRow;
    }

    @Override
    public Color getPaddingColor(int gap) {
        if (gap == -1) {
            if (this.isLastRow) {
                return this.layoutSelectionMap.getPaddingColor(-1);
            }
            gap = this.end - this.start;
        }
        return this.layoutSelectionMap.getPaddingColor(gap + this.start);
    }

    @Override
    public Color getBackgroundColor(FieldLocation location) {
        return this.layoutSelectionMap.getBackgroundColor(location);
    }
}

