/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.filter;

import docking.widgets.filter.TextFilter;
import java.util.regex.Pattern;

public abstract class AbstractPatternTextFilter
implements TextFilter {
    protected final String filterText;
    private Pattern filterPattern;

    protected AbstractPatternTextFilter(String filterText) {
        this.filterText = filterText;
    }

    protected abstract Pattern createPattern();

    public abstract boolean matches(String var1, Pattern var2);

    @Override
    public String getFilterText() {
        return this.filterText;
    }

    @Override
    public boolean matches(String text) {
        if (text == null) {
            return false;
        }
        Pattern pattern = this.getFilterPattern();
        if (pattern == null) {
            return false;
        }
        return this.matches(text, pattern);
    }

    private Pattern getFilterPattern() {
        if (this.filterPattern == null) {
            this.filterPattern = this.createPattern();
        }
        return this.filterPattern;
    }

    public String toString() {
        return "{\n\tfilter: " + this.filterText + ",\n\tpattern: " + this.getFilterPattern() + ",\n}";
    }
}

