/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.task;

import docking.ToolTipManager;
import docking.util.AnimatedIcon;
import docking.widgets.EmptyBorderButton;
import docking.widgets.OptionDialog;
import ghidra.util.Issue;
import ghidra.util.SystemUtilities;
import ghidra.util.datastruct.WeakDataStructureFactory;
import ghidra.util.datastruct.WeakSet;
import ghidra.util.exception.CancelledException;
import ghidra.util.layout.VerticalLayout;
import ghidra.util.task.CancelledListener;
import ghidra.util.task.IssueListener;
import ghidra.util.task.TaskMonitor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import resources.Icons;
import resources.ResourceManager;

public class TaskMonitorComponent
extends JPanel
implements TaskMonitor {
    private WeakSet<CancelledListener> listeners = WeakDataStructureFactory.createCopyOnReadWeakSet();
    private WeakSet<IssueListener> issueListeners;
    private JButton cancelButton;
    private JPanel eastButtonPanel;
    private JProgressBar progressBar;
    private JPanel progressPanel;
    private JPanel activeProgressPanel;
    private JLabel imageLabel;
    private String taskName;
    private volatile boolean isCancelled;
    private String message;
    private long lastProgress = -1L;
    private long progress;
    private long lastMax = -1L;
    private long max;
    private Runnable updateProgressPanelRunnable;
    private Runnable updateCancelButtonRunnable;
    private Runnable updateToolTipRunnable;
    private JLabel messageLabel;
    private boolean showingProgress = true;
    private boolean showingIcon = true;
    private boolean showingCancelButton = true;
    private boolean cancelEnabled = true;
    private AtomicBoolean isIndeterminate = new AtomicBoolean(false);
    private AtomicInteger taskID = new AtomicInteger();
    private Timer updateTimer;
    private Runnable shouldCancelRunnable;
    private boolean paintProgressValue = true;
    private NumberFormat percentFormat = NumberFormat.getPercentInstance();
    private long scaleFactor = 1L;

    public TaskMonitorComponent() {
        this(true, true);
    }

    public TaskMonitorComponent(boolean includeTextField, boolean includeCancelButton) {
        this.updateProgressPanelRunnable = () -> this.updateProgressPanel();
        this.updateCancelButtonRunnable = () -> this.updateCancelButton();
        this.updateToolTipRunnable = () -> this.updateToolTip();
        this.updateTimer = new Timer(250, e -> this.update());
        this.updateTimer.setRepeats(false);
        this.shouldCancelRunnable = () -> {
            boolean userSaysYes;
            int currentTaskID = this.taskID.get();
            boolean bl = userSaysYes = OptionDialog.showYesNoDialog(this, "Cancel?", "Do you really want to cancel " + this.getTaskName() + "?") == 1;
            if (userSaysYes && currentTaskID == this.taskID.get()) {
                this.cancel();
            }
        };
        this.buildProgressPanel(includeTextField, includeCancelButton);
    }

    public synchronized void reset() {
        this.isCancelled = false;
        this.taskID.incrementAndGet();
    }

    public boolean isCancelled() {
        return this.isCancelled;
    }

    public void checkCanceled() throws CancelledException {
        if (this.isCancelled) {
            throw new CancelledException();
        }
    }

    public synchronized void setMessage(String message) {
        this.message = message;
        this.startUpdateTimer();
    }

    public synchronized void setProgress(long value) {
        if (this.progress == value) {
            return;
        }
        this.progress = value;
        this.startUpdateTimer();
    }

    private synchronized void startUpdateTimer() {
        if (!this.updateTimer.isRunning()) {
            this.updateTimer.start();
        }
    }

    public void initialize(long maxValue) {
        this.setMaximum(maxValue);
        this.setProgress(0L);
    }

    public void setMaximum(long max) {
        this.max = max;
        if (this.progress > this.max) {
            this.progress = max;
        }
        this.startUpdateTimer();
    }

    public void setIndeterminate(boolean indeterminate) {
        this.isIndeterminate.set(indeterminate);
        SystemUtilities.runIfSwingOrPostSwingLater(() -> {
            boolean newValue = this.isIndeterminate.get();
            this.progressBar.setIndeterminate(newValue);
            this.progressBar.setStringPainted(!newValue);
        });
    }

    public boolean isIndeterminate() {
        return this.isIndeterminate.get();
    }

    public synchronized void setCancelEnabled(boolean enable) {
        if (this.cancelEnabled != enable) {
            this.cancelEnabled = enable;
            SystemUtilities.runSwingLater((Runnable)this.updateCancelButtonRunnable);
        }
    }

    public synchronized boolean isCancelEnabled() {
        return this.cancelEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        TaskMonitorComponent taskMonitorComponent = this;
        synchronized (taskMonitorComponent) {
            if (this.isCancelled) {
                return;
            }
            this.isCancelled = true;
        }
        this.notifyChangeListeners();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCanceled() {
        TaskMonitorComponent taskMonitorComponent = this;
        synchronized (taskMonitorComponent) {
            this.isCancelled = false;
        }
    }

    public synchronized void showProgress(boolean b) {
        if (b != this.showingProgress) {
            this.showingProgress = b;
            SystemUtilities.runSwingLater((Runnable)this.updateProgressPanelRunnable);
        }
    }

    public void setTaskName(String name) {
        this.taskName = name;
        SystemUtilities.runSwingLater((Runnable)this.updateToolTipRunnable);
    }

    public void showCancelButton(boolean showCancel) {
        if (showCancel == this.showingCancelButton) {
            return;
        }
        if (showCancel) {
            this.add((Component)this.eastButtonPanel, "East");
        } else {
            this.remove(this.eastButtonPanel);
        }
        this.showingCancelButton = showCancel;
    }

    public void showProgressIcon(boolean showIcon) {
        if (showIcon == this.showingIcon) {
            return;
        }
        Runnable r = () -> {
            if (showIcon) {
                this.activeProgressPanel.add((Component)this.imageLabel, "East");
            } else {
                this.activeProgressPanel.remove(this.imageLabel);
            }
            this.showingIcon = showIcon;
        };
        SystemUtilities.runSwingNow((Runnable)r);
    }

    public void setShowProgressValue(boolean showProgressValue) {
        this.paintProgressValue = showProgressValue;
        this.startUpdateTimer();
    }

    public long getMaximum() {
        return this.max;
    }

    private synchronized void update() {
        if (this.message != null) {
            this.messageLabel.setText(this.message);
            this.message = null;
        }
        if (this.max != this.lastMax) {
            this.setMaxValueInProgressBar(this.max);
            this.lastMax = this.max;
        }
        if (this.progress != this.lastProgress) {
            this.setValueInProgressBar(this.progress);
            this.lastProgress = this.progress;
        }
    }

    private void setValueInProgressBar(long value) {
        this.progressBar.setValue((int)(value / this.scaleFactor));
        if (this.progressBar.isIndeterminate()) {
            return;
        }
        this.progressBar.setString(this.createProgressString());
    }

    private void setMaxValueInProgressBar(long max) {
        this.scaleFactor = this.computeScaleFactor(max);
        this.progressBar.setMaximum((int)(max / this.scaleFactor));
    }

    private long computeScaleFactor(long value) {
        long scale = 1L;
        while (value > Integer.MAX_VALUE) {
            value /= 10L;
            scale *= 10L;
        }
        return scale;
    }

    private String createProgressString() {
        long currentProgress = this.getProgress();
        if (currentProgress <= 0L) {
            return "0%";
        }
        long maximum = this.getMaximum();
        if (currentProgress >= maximum) {
            return "100%";
        }
        float percent = (float)currentProgress / (float)maximum;
        String formattedPercent = this.percentFormat.format(percent);
        if (!this.paintProgressValue) {
            return formattedPercent;
        }
        return formattedPercent + " (" + currentProgress + " of " + maximum + ")";
    }

    private synchronized void updateProgressPanel() {
        if (this.showingProgress) {
            this.progressPanel.add((Component)this.progressBar, "North");
        } else {
            this.progressPanel.remove(this.progressBar);
        }
    }

    private void updateToolTip() {
        ToolTipManager.setToolTipText(this.cancelButton, "Cancel " + this.getTaskName());
    }

    private String getTaskName() {
        return this.taskName == null ? "" : "\"" + this.taskName + "\"";
    }

    private synchronized void updateCancelButton() {
        this.cancelButton.setEnabled(this.cancelEnabled);
    }

    private void buildProgressPanel(boolean includeTextField, boolean includeCancelButton) {
        this.setLayout(new BorderLayout(5, 1));
        this.messageLabel = new JLabel("               "){

            @Override
            public void invalidate() {
            }
        };
        this.messageLabel.setFont(this.messageLabel.getFont().deriveFont(10.0f));
        Dimension d = this.messageLabel.getPreferredSize();
        d.width = 180;
        this.messageLabel.setPreferredSize(d);
        this.progressBar = new JProgressBar(){

            @Override
            public String getToolTipText() {
                if (this.isStringPainted()) {
                    return this.getString();
                }
                return TaskMonitorComponent.this.createProgressString();
            }
        };
        this.progressBar.setStringPainted(true);
        ToolTipManager.sharedInstance().registerComponent(this.progressBar);
        this.createAnimatedIcon();
        this.progressPanel = new JPanel((LayoutManager)new VerticalLayout(0));
        this.progressPanel.add(this.progressBar);
        if (includeTextField) {
            this.progressPanel.add(this.messageLabel);
            this.progressBar.setPreferredSize(new Dimension(180, 12));
        } else {
            this.progressBar.setBorderPainted(true);
            Dimension size = this.progressBar.getPreferredSize();
            this.progressPanel.setBorder(BorderFactory.createEmptyBorder((this.imageLabel.getPreferredSize().height - size.height) / 2, 0, 0, 8));
        }
        this.activeProgressPanel = new JPanel(new BorderLayout());
        this.activeProgressPanel.add((Component)this.progressPanel, "Center");
        this.activeProgressPanel.add((Component)this.imageLabel, "East");
        ImageIcon icon = Icons.STOP_ICON;
        this.cancelButton = new EmptyBorderButton(icon);
        this.cancelButton.setName("CANCEL_TASK");
        this.cancelButton.setPreferredSize(new Dimension(icon.getIconWidth(), icon.getIconHeight()));
        this.cancelButton.addActionListener(e -> SwingUtilities.invokeLater(this.shouldCancelRunnable));
        this.cancelButton.setFocusable(false);
        this.cancelButton.setRolloverEnabled(true);
        this.add((Component)this.activeProgressPanel, "Center");
        if (includeCancelButton) {
            this.eastButtonPanel = new JPanel();
            this.eastButtonPanel.setLayout(new BoxLayout(this.eastButtonPanel, 1));
            this.eastButtonPanel.add(Box.createVerticalGlue());
            this.eastButtonPanel.add(this.cancelButton);
            this.eastButtonPanel.add(Box.createVerticalGlue());
            this.add((Component)this.eastButtonPanel, "East");
        }
    }

    private void createAnimatedIcon() {
        ArrayList<Icon> iconList = new ArrayList<Icon>();
        iconList.add(ResourceManager.loadImage((String)"images/hourglass24_01.png"));
        iconList.add(ResourceManager.loadImage((String)"images/hourglass24_02.png"));
        iconList.add(ResourceManager.loadImage((String)"images/hourglass24_02.png"));
        iconList.add(ResourceManager.loadImage((String)"images/hourglass24_03.png"));
        iconList.add(ResourceManager.loadImage((String)"images/hourglass24_03.png"));
        iconList.add(ResourceManager.loadImage((String)"images/hourglass24_04.png"));
        iconList.add(ResourceManager.loadImage((String)"images/hourglass24_04.png"));
        iconList.add(ResourceManager.loadImage((String)"images/hourglass24_05.png"));
        iconList.add(ResourceManager.loadImage((String)"images/hourglass24_05.png"));
        iconList.add(ResourceManager.loadImage((String)"images/hourglass24_06.png"));
        iconList.add(ResourceManager.loadImage((String)"images/hourglass24_06.png"));
        iconList.add(ResourceManager.loadImage((String)"images/hourglass24_07.png"));
        iconList.add(ResourceManager.loadImage((String)"images/hourglass24_07.png"));
        iconList.add(ResourceManager.loadImage((String)"images/hourglass24_08.png"));
        iconList.add(ResourceManager.loadImage((String)"images/hourglass24_08.png"));
        iconList.add(ResourceManager.loadImage((String)"images/hourglass24_09.png"));
        iconList.add(ResourceManager.loadImage((String)"images/hourglass24_10.png"));
        iconList.add(ResourceManager.loadImage((String)"images/hourglass24_11.png"));
        AnimatedIcon progressIcon = new AnimatedIcon(iconList, 150, 0);
        this.imageLabel = new JLabel(progressIcon);
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        JFrame f = new JFrame();
        f.setDefaultCloseOperation(3);
        f.getContentPane().setLayout(new BorderLayout());
        TaskMonitorComponent tm = new TaskMonitorComponent();
        f.getContentPane().add(tm);
        tm.showCancelButton(true);
        f.pack();
        f.setVisible(true);
    }

    public void incrementProgress(long incrementAmount) {
        this.setProgress(this.progress + incrementAmount);
    }

    public long getProgress() {
        return this.progress;
    }

    protected void notifyChangeListeners() {
        Runnable r = () -> {
            WeakSet<CancelledListener> weakSet = this.listeners;
            synchronized (weakSet) {
                for (CancelledListener mcl : this.listeners) {
                    mcl.cancelled();
                }
            }
        };
        SwingUtilities.invokeLater(r);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCancelledListener(CancelledListener mcl) {
        WeakSet<CancelledListener> weakSet = this.listeners;
        synchronized (weakSet) {
            this.listeners.add((Object)mcl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCancelledListener(CancelledListener mcl) {
        WeakSet<CancelledListener> weakSet = this.listeners;
        synchronized (weakSet) {
            this.listeners.remove((Object)mcl);
        }
    }

    public void addIssueListener(IssueListener listener) {
        if (this.issueListeners == null) {
            this.issueListeners = WeakDataStructureFactory.createCopyOnWriteWeakSet();
        }
    }

    public void removeIssueListener(IssueListener listener) {
        if (this.issueListeners != null) {
            this.issueListeners.remove((Object)listener);
        }
    }

    public void reportIssue(Issue issue) {
        if (this.issueListeners != null) {
            for (IssueListener listener : this.issueListeners) {
                listener.issueReported(issue);
            }
        }
    }
}

