/*
 * Decompiled with CFR 0.152.
 */
package functioncalls.graph;

import docking.widgets.EmptyBorderButton;
import functioncalls.graph.FcgDirection;
import functioncalls.graph.FcgLevel;
import functioncalls.graph.FcgVertexExpansionListener;
import ghidra.graph.viewer.vertex.AbstractVisualVertex;
import ghidra.graph.viewer.vertex.VertexShapeProvider;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Function;
import ghidra.util.StringUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.image.BufferedImage;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import resources.Icons;
import resources.ResourceManager;

public class FcgVertex
extends AbstractVisualVertex
implements VertexShapeProvider {
    public static final Color DEFAULT_VERTEX_SHAPE_COLOR = new Color(110, 197, 174);
    private static final Color TOO_BIG_VERTEX_SHAPE_COLOR = Color.LIGHT_GRAY;
    public static final Icon NOT_ALLOWED_ICON = Icons.ERROR_ICON;
    private static final Icon EXPAND_ICON = ResourceManager.getScaledIcon((Icon)Icons.EXPAND_ALL_ICON, (int)10, (int)10);
    private static final Icon COLLAPSE_ICON = ResourceManager.getScaledIcon((Icon)Icons.COLLAPSE_ALL_ICON, (int)10, (int)10);
    private static final Integer VERTEX_SHAPE_LAYER = new Integer(100);
    private static final Integer TOGGLE_BUTTON_LAYER = new Integer(200);
    private static final Integer LABEL_LAYER = new Integer(300);
    private static final int GAP = 2;
    private static final int VERTEX_SHAPE_SIZE = 50;
    private static final int MAX_NAME_LENGTH = 30;
    private Function function;
    private JLayeredPane layeredPane;
    private JButton toggleInsButton = new EmptyBorderButton(EXPAND_ICON);
    private JButton toggleOutsButton = new EmptyBorderButton(EXPAND_ICON);
    private JLabel nameLabel = new JLabel();
    private JLabel vertexImageLabel = new JLabel();
    private Ellipse2D.Double vertexShape;
    private Ellipse2D.Double compactShape;
    private Shape fullShape;
    private boolean hasIncomingReferences;
    private boolean hasOutgoingReferences;
    private boolean tooManyIncomingReferences;
    private boolean tooManyOutgoingReferences;
    private boolean incomingExpanded;
    private boolean outgoingExpanded;
    private boolean useDebugBorders = false;
    private Paint inPaint;
    private Paint outPaint;
    private FcgLevel level;

    public FcgVertex(Function function, FcgLevel level, FcgVertexExpansionListener expansionListener) {
        this.function = function;
        this.level = level;
        Objects.requireNonNull(expansionListener);
        this.toggleInsButton.addActionListener(e -> {
            if (this.tooManyIncomingReferences) {
                return;
            }
            expansionListener.toggleIncomingVertices(this);
        });
        this.toggleOutsButton.addActionListener(e -> {
            if (this.tooManyOutgoingReferences) {
                return;
            }
            expansionListener.toggleOutgoingVertices(this);
        });
        this.buildUi();
        this.setTogglesVisible(false);
    }

    private void createPaints() {
        Color vertexShapeColor;
        Color lightColor = vertexShapeColor = this.getVertexShapeColor();
        Color darkColor = vertexShapeColor.darker();
        Color darkestColor = darkColor.darker();
        int offset = 5 * this.level.getDistance();
        int half = 25;
        int start = 0;
        int end = half + offset;
        this.inPaint = new LinearGradientPaint(new Point(0, start), new Point(0, end), new float[]{0.0f, 0.2f, 1.0f}, new Color[]{darkestColor, darkColor, lightColor});
        start = half - offset;
        end = 50;
        this.outPaint = new LinearGradientPaint(new Point(0, start), new Point(0, end), new float[]{0.0f, 0.8f, 1.0f}, new Color[]{lightColor, darkColor, darkestColor});
    }

    private void buildUi() {
        this.createPaints();
        String truncated = StringUtilities.trimMiddle((String)this.getName(), (int)30);
        this.nameLabel.setText(truncated);
        this.buildVertexShape();
        this.layeredPane = new JLayeredPane();
        Border border = this.createDebugBorder(new LineBorder(Color.YELLOW.darker(), 1));
        this.layeredPane.setBorder(border);
        this.updateLayeredPaneSize();
        this.addVertexShape();
        this.addToggleButtons();
        this.addNameLabel();
        this.buildFullShape();
    }

    private Border createDebugBorder(Border border) {
        if (this.useDebugBorders) {
            return border;
        }
        return BorderFactory.createEmptyBorder();
    }

    private void buildFullShape() {
        Area parent = new Area();
        Area v = new Area(this.vertexShape);
        Area name = new Area(this.nameLabel.getBounds());
        parent.add(v);
        parent.add(name);
        Area in = new Area(this.toggleInsButton.getBounds());
        Area out = new Area(this.toggleOutsButton.getBounds());
        parent.add(in);
        parent.add(out);
        this.fullShape = parent;
    }

    private void updateLayeredPaneSize() {
        Dimension shapeSize = this.vertexImageLabel.getPreferredSize();
        Dimension nameLabelSize = this.nameLabel.getPreferredSize();
        int height = shapeSize.height + 2 + nameLabelSize.height;
        Dimension insSize = this.toggleInsButton.getPreferredSize();
        Dimension outsSize = this.toggleOutsButton.getPreferredSize();
        int buttonWidth = Math.max(insSize.width, outsSize.width);
        int offset = buttonWidth / 3;
        int width = offset + shapeSize.width;
        width = Math.max(width, nameLabelSize.width);
        this.layeredPane.setPreferredSize(new Dimension(width, height));
    }

    private void buildVertexShape() {
        int w = 50;
        int h = 50;
        Ellipse2D.Double circle = new Ellipse2D.Double(0.0, 0.0, w, h);
        BufferedImage image = new BufferedImage(w, h, 2);
        Graphics2D g2 = (Graphics2D)image.getGraphics();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        FcgDirection direction = this.level.getDirection();
        if (direction.isSource()) {
            g2.setColor(this.getVertexShapeColor());
        } else if (direction.isIn()) {
            g2.setPaint(this.inPaint);
        } else {
            g2.setPaint(this.outPaint);
        }
        g2.fill(circle);
        g2.dispose();
        this.vertexShape = circle;
        this.compactShape = (Ellipse2D.Double)this.vertexShape.clone();
        this.vertexImageLabel.setIcon(new ImageIcon(image));
        Border border = this.createDebugBorder(new LineBorder(Color.PINK, 1));
        this.vertexImageLabel.setBorder(border);
    }

    private Color getVertexShapeColor() {
        if (this.isInDirection() && this.tooManyIncomingReferences) {
            return TOO_BIG_VERTEX_SHAPE_COLOR;
        }
        if (this.isOutDirection() && this.tooManyOutgoingReferences) {
            return TOO_BIG_VERTEX_SHAPE_COLOR;
        }
        return DEFAULT_VERTEX_SHAPE_COLOR;
    }

    private boolean isInDirection() {
        FcgDirection direction = this.level.getDirection();
        boolean isIn = direction.isIn() || direction.isSource();
        return isIn;
    }

    private boolean isOutDirection() {
        FcgDirection direction = this.level.getDirection();
        boolean isOut = direction.isOut() || direction.isSource();
        return isOut;
    }

    private void addVertexShape() {
        Dimension parentSize = this.layeredPane.getPreferredSize();
        Dimension size = this.vertexImageLabel.getPreferredSize();
        int x = parentSize.width / 2 - size.width / 2;
        int y = 0;
        this.vertexImageLabel.setBounds(x, y, size.width, size.height);
        Dimension shapeSize = this.vertexShape.getBounds().getSize();
        this.vertexShape.setFrame(x, y, shapeSize.width, shapeSize.height);
        this.layeredPane.add((Component)this.vertexImageLabel, VERTEX_SHAPE_LAYER);
    }

    private void addNameLabel() {
        Border border = this.createDebugBorder(new LineBorder(Color.GREEN, 1));
        this.nameLabel.setBorder(border);
        Rectangle parentBounds = this.vertexImageLabel.getBounds();
        Dimension size = this.nameLabel.getPreferredSize();
        int x = parentBounds.x + parentBounds.width / 2 - size.width / 2;
        int y = parentBounds.y + parentBounds.height + 2;
        this.nameLabel.setBounds(x, y, size.width, size.height);
        this.layeredPane.add((Component)this.nameLabel, LABEL_LAYER);
    }

    private void addToggleButtons() {
        this.toggleInsButton.setBackground(new Color(255, 255, 255, 0));
        this.toggleOutsButton.setBackground(new Color(255, 255, 255, 0));
        Rectangle parentBounds = this.vertexImageLabel.getBounds();
        Dimension size = this.toggleInsButton.getPreferredSize();
        int x = parentBounds.x - size.width / 3;
        int y = 0;
        this.toggleInsButton.setBounds(x, y, size.width, size.height);
        this.layeredPane.add((Component)this.toggleInsButton, TOGGLE_BUTTON_LAYER);
        size = this.toggleOutsButton.getPreferredSize();
        Dimension vertexSize = parentBounds.getSize();
        y = vertexSize.height - size.height;
        this.toggleOutsButton.setBounds(x, y, size.width, size.height);
        this.layeredPane.add((Component)this.toggleOutsButton, TOGGLE_BUTTON_LAYER);
    }

    public String getName() {
        return this.function.getName();
    }

    public Function getFunction() {
        return this.function;
    }

    public Address getAddress() {
        return this.function.getEntryPoint();
    }

    public FcgLevel getLevel() {
        return this.level;
    }

    public int getDegree() {
        return this.level.getRow();
    }

    public FcgDirection getDirection() {
        return this.level.getDirection();
    }

    public JButton getIncomingToggleButton() {
        return this.toggleInsButton;
    }

    public JButton getOutgoingToggleButton() {
        return this.toggleOutsButton;
    }

    public void setIncomingExpanded(boolean setExpanded) {
        this.validateIncomingExpandedState(setExpanded);
        this.incomingExpanded = setExpanded;
        this.toggleInsButton.setIcon(setExpanded ? COLLAPSE_ICON : EXPAND_ICON);
        String hideShow = setExpanded ? "hide" : "show";
        this.toggleInsButton.setToolTipText("Click to " + hideShow + " incoming edges");
    }

    private void validateOutgoingExpandedState(boolean isExpanding) {
        if (isExpanding) {
            if (!this.canExpandOutgoingReferences()) {
                throw new IllegalStateException("Vertex cannot be expanded: " + this);
            }
            return;
        }
        if (!this.isOutgoingExpanded()) {
            throw new IllegalStateException("Vertex cannot be collapsed: " + this);
        }
    }

    private void validateIncomingExpandedState(boolean expanding) {
        if (expanding) {
            if (!this.canExpandIncomingReferences()) {
                throw new IllegalStateException("Vertex cannot be expanded: " + this);
            }
            return;
        }
        if (!this.isIncomingExpanded()) {
            throw new IllegalStateException("Vertex cannot be collapsed: " + this);
        }
    }

    public boolean isIncomingExpanded() {
        return this.incomingExpanded;
    }

    public void setOutgoingExpanded(boolean setExpanded) {
        this.validateOutgoingExpandedState(setExpanded);
        this.outgoingExpanded = setExpanded;
        this.toggleOutsButton.setIcon(setExpanded ? COLLAPSE_ICON : EXPAND_ICON);
        String hideShow = setExpanded ? "hide" : "show";
        this.toggleInsButton.setToolTipText("Click to " + hideShow + " outgoing edges");
    }

    public boolean isOutgoingExpanded() {
        return this.outgoingExpanded;
    }

    public boolean isExpanded() {
        FcgDirection direction = this.level.getDirection();
        if (direction.isSource()) {
            return this.isIncomingExpanded() && this.isOutgoingExpanded();
        }
        if (direction.isIn()) {
            return this.isIncomingExpanded();
        }
        return this.isOutgoingExpanded();
    }

    public void setTooManyIncomingReferences(boolean tooMany) {
        this.tooManyIncomingReferences = tooMany;
        this.toggleInsButton.setIcon(NOT_ALLOWED_ICON);
        this.toggleInsButton.setToolTipText("Too many incoming references to show");
        this.buildUi();
    }

    public void setTooManyOutgoingReferences(boolean tooMany) {
        this.tooManyOutgoingReferences = tooMany;
        this.toggleOutsButton.setIcon(NOT_ALLOWED_ICON);
        this.toggleOutsButton.setToolTipText("Too many outgoing references to show");
        this.buildUi();
    }

    public boolean hasTooManyIncomingReferences() {
        return this.tooManyIncomingReferences;
    }

    public boolean hasTooManyOutgoingReferences() {
        return this.tooManyOutgoingReferences;
    }

    public boolean canExpand() {
        FcgDirection direction = this.level.getDirection();
        if (direction.isSource()) {
            return this.canExpandIncomingReferences() || this.canExpandOutgoingReferences();
        }
        if (direction.isIn()) {
            return this.canExpandIncomingReferences();
        }
        return this.canExpandOutgoingReferences();
    }

    public boolean canExpandIncomingReferences() {
        return this.hasIncomingReferences && !this.tooManyIncomingReferences && !this.incomingExpanded;
    }

    public boolean canExpandOutgoingReferences() {
        return this.hasOutgoingReferences && !this.tooManyOutgoingReferences && !this.outgoingExpanded;
    }

    public void setHasIncomingReferences(boolean hasIncoming) {
        this.hasIncomingReferences = hasIncoming;
    }

    public void setHasOutgoingReferences(boolean hasOutgoing) {
        this.hasOutgoingReferences = hasOutgoing;
    }

    public void setHovered(boolean hovered) {
        super.setHovered(hovered);
        this.setTogglesVisible(hovered);
    }

    private void setTogglesVisible(boolean visible) {
        boolean isIn = this.isInDirection();
        boolean turnOn = isIn && this.hasIncomingReferences && visible;
        this.toggleInsButton.setVisible(turnOn);
        boolean isOut = this.isOutDirection();
        turnOn = isOut && this.hasOutgoingReferences && visible;
        this.toggleOutsButton.setVisible(turnOn);
    }

    public JComponent getComponent() {
        return this.layeredPane;
    }

    public Shape getCompactShape() {
        return this.compactShape;
    }

    public Shape getFullShape() {
        return this.fullShape;
    }

    public String toString() {
        return this.getName();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.function == null ? 0 : this.function.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        FcgVertex other = (FcgVertex)((Object)obj);
        return Objects.equals(this.function, other.function);
    }

    public void dispose() {
    }
}

