/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.decompiler.component;

import ghidra.app.decompiler.DecompInterface;
import ghidra.app.decompiler.DecompileException;
import ghidra.app.decompiler.DecompileOptions;
import ghidra.app.decompiler.DecompileResults;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.util.task.TaskMonitor;
import java.io.File;

class Decompiler {
    private DecompInterface cachedDecompInterface;
    private DecompileOptions options;
    private int timeout;
    private volatile boolean optionsChanged = false;

    Decompiler(DecompileOptions options, int timeout) {
        this.options = options;
        this.timeout = timeout;
    }

    void setOptions(DecompileOptions options) {
        this.options = options;
        this.optionsChanged = true;
    }

    DecompileResults decompile(Program program, Function function, File debugFile, TaskMonitor monitor) throws DecompileException {
        DecompInterface ifc = this.getDecompilerInterface(program);
        if (debugFile != null) {
            ifc.enableDebug(debugFile);
        }
        if (this.optionsChanged) {
            ifc.setOptions(this.options);
            this.optionsChanged = false;
        }
        return ifc.decompileFunction(function, this.timeout, monitor);
    }

    synchronized void cancelCurrentAction() {
        if (this.cachedDecompInterface != null) {
            this.cachedDecompInterface.stopProcess();
            this.cachedDecompInterface.dispose();
            this.cachedDecompInterface = null;
        }
    }

    synchronized DecompInterface getDecompilerInterface(Program program) throws DecompileException {
        if (this.cachedDecompInterface != null) {
            if (this.cachedDecompInterface.getProgram() == program) {
                return this.cachedDecompInterface;
            }
            this.cachedDecompInterface.dispose();
        }
        DecompInterface newInterface = new DecompInterface();
        newInterface.setOptions(this.options);
        this.optionsChanged = false;
        if (!newInterface.openProgram(program)) {
            String errorMessage = newInterface.getLastMessage();
            throw new DecompileException("Decompiler", "Unable to initialize the DecompilerInterface: " + errorMessage);
        }
        this.cachedDecompInterface = newInterface;
        return newInterface;
    }

    synchronized void dispose() {
        this.cancelCurrentAction();
    }
}

