/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.decompiler.component.hover;

import docking.widgets.fieldpanel.field.Field;
import docking.widgets.fieldpanel.support.FieldLocation;
import ghidra.app.decompiler.ClangToken;
import ghidra.app.decompiler.ClangVariableToken;
import ghidra.app.decompiler.component.ClangTextField;
import ghidra.app.decompiler.component.hover.DecompilerHoverService;
import ghidra.app.plugin.core.hover.AbstractScalarOperandHover;
import ghidra.framework.options.Options;
import ghidra.framework.options.OptionsChangeListener;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.AbstractIntegerDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.listing.Program;
import ghidra.program.model.pcode.HighConstant;
import ghidra.program.model.pcode.HighVariable;
import ghidra.program.model.pcode.Varnode;
import ghidra.program.model.scalar.Scalar;
import ghidra.program.util.ProgramLocation;
import javax.swing.JComponent;

public class ScalarValueDecompilerHover
extends AbstractScalarOperandHover
implements DecompilerHoverService {
    private static final int PRIORITY = 20;
    protected static final String NAME = "Scalar Operand Display";
    protected static final String DESCRIPTION = "Scalars are shown as 1-, 2-, 4-, and 8-byte values, each in decimal, hexadecimal, and as ASCII character sequences.";

    public ScalarValueDecompilerHover(PluginTool tool) {
        super(tool, 20);
    }

    public void initializeOptions() {
        this.options = this.tool.getOptions("Decompiler Popups");
        this.options.registerOption(NAME, (Object)true, null, DESCRIPTION);
        this.setOptions((Options)this.options, NAME);
        this.options.addOptionsChangeListener((OptionsChangeListener)this);
    }

    public void setOptions(Options options, String optionName) {
        if (optionName.equals(NAME)) {
            this.enabled = options.getBoolean(NAME, true);
        }
    }

    public JComponent getHoverComponent(Program program, ProgramLocation programLocation, FieldLocation fieldLocation, Field field) {
        if (!this.enabled || programLocation == null) {
            return null;
        }
        if (!(field instanceof ClangTextField)) {
            return null;
        }
        ClangToken token = ((ClangTextField)field).getToken(fieldLocation);
        if (!(token instanceof ClangVariableToken)) {
            return null;
        }
        Varnode vn = ((ClangVariableToken)token).getVarnode();
        if (vn == null) {
            return null;
        }
        long offset = vn.getOffset();
        int sz = vn.getSize();
        HighVariable high = vn.getHigh();
        if (!(high instanceof HighConstant)) {
            return null;
        }
        HighConstant constant = (HighConstant)high;
        boolean isSigned = true;
        DataType dt = constant.getDataType();
        if (dt instanceof AbstractIntegerDataType) {
            isSigned = ((AbstractIntegerDataType)dt).isSigned();
        }
        if (sz > 8) {
            return null;
        }
        Scalar scalar = new Scalar(sz * 8, offset, isSigned);
        Address addr = token.getMinAddress();
        String formatted = this.formatScalar(program, addr, scalar);
        return this.createTooltipComponent(formatted);
    }
}

