/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.nodetype;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.ConstraintViolationException;
import org.apache.jackrabbit.core.nodetype.InvalidConstraintException;
import org.apache.jackrabbit.core.nodetype.ValueConstraint;
import org.apache.jackrabbit.core.value.InternalValue;

class StringConstraint
extends ValueConstraint {
    final Pattern pattern;

    StringConstraint(String definition) throws InvalidConstraintException {
        super(definition);
        try {
            this.pattern = Pattern.compile(definition);
        }
        catch (PatternSyntaxException pse) {
            String msg = "'" + definition + "' is not valid regular expression syntax";
            log.debug(msg);
            throw new InvalidConstraintException(msg, pse);
        }
    }

    void check(String text) throws ConstraintViolationException {
        if (text == null) {
            throw new ConstraintViolationException("null value does not satisfy the constraint '" + this.definition + "'");
        }
        Matcher matcher = this.pattern.matcher(text);
        if (!matcher.matches()) {
            throw new ConstraintViolationException("'" + text + "' does not satisfy the constraint '" + this.definition + "'");
        }
    }

    void check(InternalValue value) throws ConstraintViolationException, RepositoryException {
        if (value == null) {
            throw new ConstraintViolationException("null value does not satisfy the constraint '" + this.definition + "'");
        }
        switch (value.getType()) {
            case 1: {
                this.check(value.toString());
                return;
            }
        }
        String msg = "STRING constraint can not be applied to value of type: " + PropertyType.nameFromValue((int)value.getType());
        log.debug(msg);
        throw new RepositoryException(msg);
    }
}

