/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.byteviewer;

import docking.ActionContext;
import docking.ComponentProvider;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.ToolBarData;
import ghidra.app.events.ProgramActivatedPluginEvent;
import ghidra.app.events.ProgramClosedPluginEvent;
import ghidra.app.events.ProgramHighlightPluginEvent;
import ghidra.app.events.ProgramLocationPluginEvent;
import ghidra.app.events.ProgramSelectionPluginEvent;
import ghidra.app.plugin.core.byteviewer.ByteBlockChangePluginEvent;
import ghidra.app.plugin.core.byteviewer.ProgramByteViewerComponentProvider;
import ghidra.app.services.ClipboardService;
import ghidra.app.services.GoToService;
import ghidra.app.services.NavigationHistoryService;
import ghidra.app.services.ProgramManager;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainObject;
import ghidra.framework.options.SaveState;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginEvent;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.ProgramSelection;
import ghidra.util.SystemUtilities;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jdom.Element;
import resources.ResourceManager;

@PluginInfo(status=PluginStatus.RELEASED, packageName="Ghidra Core", category="Byte Viewer", shortDescription="Displays bytes in memory", description="Provides a component for showing the bytes in memory.  Additional plugins provide capabilites for this plugin to show the bytes in various formats (e.g., hex, octal, decimal).  The hex format plugin is loaded by default when this plugin is loaded.", servicesRequired={ProgramManager.class, GoToService.class, NavigationHistoryService.class, ClipboardService.class}, eventsConsumed={ProgramLocationPluginEvent.class, ProgramActivatedPluginEvent.class, ProgramSelectionPluginEvent.class, ProgramHighlightPluginEvent.class, ProgramClosedPluginEvent.class, ByteBlockChangePluginEvent.class}, eventsProduced={ProgramLocationPluginEvent.class, ProgramSelectionPluginEvent.class, ByteBlockChangePluginEvent.class})
public class ByteViewerPlugin
extends Plugin {
    private Program currentProgram;
    private boolean restoringTransientState;
    private ProgramLocation currentLocation;
    private ProgramByteViewerComponentProvider connectedProvider;
    private List<ProgramByteViewerComponentProvider> disconnectedProviders = new ArrayList<ProgramByteViewerComponentProvider>();

    public ByteViewerPlugin(PluginTool tool) {
        super(tool);
        this.connectedProvider = new ProgramByteViewerComponentProvider(tool, this, true);
        this.createActions();
    }

    private void createActions() {
        DockingAction action = new DockingAction("Byte Viewer", this.getName()){

            public void actionPerformed(ActionContext context) {
                ByteViewerPlugin.this.showConnectedProvider();
            }
        };
        action.setToolBarData(new ToolBarData((Icon)ResourceManager.loadImage((String)"images/binaryData.gif"), "View"));
        action.setDescription("Display Bytes");
        action.setEnabled(true);
        this.tool.addAction((DockingActionIf)action);
    }

    protected void showConnectedProvider() {
        this.tool.showComponentProvider((ComponentProvider)this.connectedProvider, true);
    }

    protected void init() {
        ClipboardService clipboardService = (ClipboardService)this.tool.getService(ClipboardService.class);
        if (clipboardService != null) {
            this.connectedProvider.setClipboardService(clipboardService);
            for (ProgramByteViewerComponentProvider provider : this.disconnectedProviders) {
                provider.setClipboardService(clipboardService);
            }
        }
    }

    public void dispose() {
        this.removeProvider(this.connectedProvider);
        for (ProgramByteViewerComponentProvider provider : this.disconnectedProviders) {
            this.removeProvider(provider);
        }
        this.disconnectedProviders.clear();
    }

    public void processEvent(PluginEvent event) {
        if (event instanceof ProgramClosedPluginEvent) {
            Program program = ((ProgramClosedPluginEvent)event).getProgram();
            this.programClosed(program);
            return;
        }
        if (event instanceof ProgramActivatedPluginEvent) {
            this.currentProgram = ((ProgramActivatedPluginEvent)event).getActiveProgram();
        } else if (event instanceof ProgramLocationPluginEvent) {
            this.currentLocation = ((ProgramLocationPluginEvent)event).getLocation();
        }
        this.connectedProvider.doHandleEvent(event);
    }

    void programClosed(Program closedProgram) {
        Iterator<ProgramByteViewerComponentProvider> iterator = this.disconnectedProviders.iterator();
        while (iterator.hasNext()) {
            ProgramByteViewerComponentProvider provider = iterator.next();
            if (provider.getProgram() != closedProgram) continue;
            iterator.remove();
            this.removeProvider(provider);
        }
    }

    public void fireProgramLocationPluginEvent(ProgramByteViewerComponentProvider provider, ProgramLocationPluginEvent event) {
        if (SystemUtilities.isEqual((Object)event.getLocation(), (Object)this.currentLocation)) {
            return;
        }
        this.currentLocation = event.getLocation();
        if (provider == this.connectedProvider) {
            this.firePluginEvent((PluginEvent)event);
        }
    }

    public void writeConfigState(SaveState saveState) {
        this.connectedProvider.writeConfigState(saveState);
    }

    public void readConfigState(SaveState saveState) {
        this.connectedProvider.readConfigState(saveState);
    }

    public void readDataState(SaveState saveState) {
        ProgramManager programManagerService = (ProgramManager)this.tool.getService(ProgramManager.class);
        this.connectedProvider.readDataState(saveState);
        int numDisconnected = saveState.getInt("Num Disconnected", 0);
        for (int i = 0; i < numDisconnected; ++i) {
            Program program;
            Element xmlElement = saveState.getXmlElement("Provider" + i);
            SaveState providerSaveState = new SaveState(xmlElement);
            String programPath = providerSaveState.getString("Program Path", "");
            DomainFile file = this.tool.getProject().getProjectData().getFile(programPath);
            if (file == null || (program = programManagerService.openProgram(file)) == null) continue;
            ProgramByteViewerComponentProvider provider = new ProgramByteViewerComponentProvider(this.tool, this, false);
            provider.doSetProgram(program);
            provider.readConfigState(providerSaveState);
            provider.readDataState(providerSaveState);
            this.tool.showComponentProvider((ComponentProvider)provider, true);
            this.addProvider(provider);
        }
    }

    public void writeDataState(SaveState saveState) {
        this.connectedProvider.writeDataState(saveState);
        saveState.putInt("Num Disconnected", this.disconnectedProviders.size());
        int i = 0;
        for (ProgramByteViewerComponentProvider provider : this.disconnectedProviders) {
            SaveState providerSaveState = new SaveState();
            DomainFile df = provider.getProgram().getDomainFile();
            if (df.getParent() == null) continue;
            String programPathname = df.getPathname();
            providerSaveState.putString("Program Path", programPathname);
            provider.writeConfigState(providerSaveState);
            provider.writeDataState(providerSaveState);
            String elementName = "Provider" + i;
            saveState.putXmlElement(elementName, providerSaveState.saveToXml());
            ++i;
        }
    }

    public Object getUndoRedoState(DomainObject domainObject) {
        HashMap<Long, Object> stateMap = new HashMap<Long, Object>();
        this.addUndoRedoState(stateMap, domainObject, this.connectedProvider);
        for (ProgramByteViewerComponentProvider provider : this.disconnectedProviders) {
            this.addUndoRedoState(stateMap, domainObject, provider);
        }
        if (stateMap.isEmpty()) {
            return null;
        }
        return stateMap;
    }

    private void addUndoRedoState(Map<Long, Object> stateMap, DomainObject domainObject, ProgramByteViewerComponentProvider provider) {
        if (provider == null) {
            return;
        }
        Object state = provider.getUndoRedoState(domainObject);
        if (state != null) {
            stateMap.put(provider.getInstanceID(), state);
        }
    }

    public void restoreUndoRedoState(DomainObject domainObject, Object state) {
        Map stateMap = (Map)state;
        this.restoreUndoRedoState(stateMap, domainObject, this.connectedProvider);
        for (ProgramByteViewerComponentProvider provider : this.disconnectedProviders) {
            this.restoreUndoRedoState(stateMap, domainObject, provider);
        }
    }

    private void restoreUndoRedoState(Map<Long, Object> stateMap, DomainObject domainObject, ProgramByteViewerComponentProvider provider) {
        if (provider == null) {
            return;
        }
        Object state = stateMap.get(provider.getInstanceID());
        if (state != null) {
            provider.restoreUndoRedoState(domainObject, state);
        }
    }

    public Object getTransientState() {
        Object[] state = new Object[2];
        SaveState ss = new SaveState();
        this.connectedProvider.writeDataState(ss);
        state[0] = ss;
        state[1] = this.connectedProvider.getCurrentSelection();
        return state;
    }

    public void restoreTransientState(Object objectState) {
        this.restoringTransientState = true;
        try {
            Object[] state = (Object[])objectState;
            this.connectedProvider.restoreLocation((SaveState)state[0]);
            this.connectedProvider.setSelection((ProgramSelection)state[1]);
        }
        finally {
            this.restoringTransientState = false;
        }
    }

    boolean isRestoringTransientState() {
        return this.restoringTransientState;
    }

    void setStatusMessage(String msg, ComponentProvider provider) {
        this.tool.setStatusInfo(msg);
    }

    void addProvider(ProgramByteViewerComponentProvider provider) {
        this.disconnectedProviders.add(provider);
        provider.setClipboardService((ClipboardService)this.tool.getService(ClipboardService.class));
    }

    Program getProgram() {
        return this.currentProgram;
    }

    public ProgramByteViewerComponentProvider getProvider() {
        return this.connectedProvider;
    }

    public void updateSelection(ProgramByteViewerComponentProvider provider, ProgramSelectionPluginEvent event, Program program) {
        if (provider == this.connectedProvider) {
            this.firePluginEvent((PluginEvent)event);
        }
    }

    public void highlightChanged(ProgramByteViewerComponentProvider provider, ProgramSelection highlight) {
        if (provider == this.connectedProvider) {
            this.tool.firePluginEvent((PluginEvent)new ProgramHighlightPluginEvent(this.getName(), highlight, this.connectedProvider.getProgram()));
        }
    }

    public void closeProvider(ProgramByteViewerComponentProvider provider) {
        if (provider == this.connectedProvider) {
            this.tool.showComponentProvider((ComponentProvider)provider, false);
        } else {
            this.disconnectedProviders.remove((Object)provider);
            this.removeProvider(provider);
        }
    }

    public void updateLocation(ProgramByteViewerComponentProvider provider, ProgramLocationPluginEvent event, boolean export) {
        if (this.isRestoringTransientState()) {
            return;
        }
        if (provider == this.connectedProvider) {
            this.fireProgramLocationPluginEvent(provider, event);
        } else if (export) {
            this.exportLocation(provider.getProgram(), event.getLocation());
        }
    }

    private void exportLocation(Program program, ProgramLocation location) {
        GoToService service = (GoToService)this.tool.getService(GoToService.class);
        if (service != null) {
            service.goTo(location, program);
        }
    }

    private void removeProvider(ProgramByteViewerComponentProvider provider) {
        this.tool.removeComponentProvider((ComponentProvider)provider);
        provider.dispose();
    }
}

