/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.pcodeInject;

import ghidra.app.util.pcodeInject.PcodeTextEmitter;
import ghidra.javaclass.format.constantpool.AbstractConstantPoolInfoJava;
import ghidra.javaclass.format.constantpool.ConstantPoolFieldReferenceInfo;
import ghidra.javaclass.format.constantpool.ConstantPoolNameAndTypeInfo;
import ghidra.javaclass.format.constantpool.ConstantPoolUtf8Info;

public class ReferenceMethods {
    static final String VALUE = "value";
    static final String TEMP = "temp";
    static final String NEW_VALUE = "newValue";
    static final String OBJECT_REF = "objectRef";
    static final String FIELD_OFFSET = "fieldOffset";
    static final String STATIC_OFFSET = "staticOffset";

    private ReferenceMethods() {
        throw new AssertionError();
    }

    public static String getPcodeForGetStatic(int index, AbstractConstantPoolInfoJava[] constantPool) {
        StringBuilder pCode = new StringBuilder();
        String descriptor = ReferenceMethods.getDescriptorForFieldRef(constantPool, index);
        switch (descriptor.charAt(0)) {
            case 'B': {
                PcodeTextEmitter.emitAssignVarnodeFromPcodeOpCall(pCode, TEMP, 1, "cpool", "0", Integer.toString(index), "3");
                PcodeTextEmitter.emitSignExtension(pCode, VALUE, 4, TEMP);
                PcodeTextEmitter.emitPushCat1Value(pCode, VALUE);
                break;
            }
            case 'Z': {
                PcodeTextEmitter.emitAssignVarnodeFromPcodeOpCall(pCode, TEMP, 1, "cpool", "0", Integer.toString(index), "3");
                PcodeTextEmitter.emitZeroExtension(pCode, VALUE, 4, TEMP);
                PcodeTextEmitter.emitPushCat1Value(pCode, VALUE);
                break;
            }
            case 'C': {
                PcodeTextEmitter.emitAssignVarnodeFromPcodeOpCall(pCode, TEMP, 2, "cpool", "0", Integer.toString(index), "3");
                PcodeTextEmitter.emitZeroExtension(pCode, VALUE, 4, TEMP);
                PcodeTextEmitter.emitPushCat1Value(pCode, VALUE);
                break;
            }
            case 'S': {
                PcodeTextEmitter.emitAssignVarnodeFromPcodeOpCall(pCode, TEMP, 2, "cpool", "0", Integer.toString(index), "3");
                PcodeTextEmitter.emitSignExtension(pCode, VALUE, 4, TEMP);
                PcodeTextEmitter.emitPushCat1Value(pCode, VALUE);
                break;
            }
            case 'F': 
            case 'I': 
            case 'L': 
            case '[': {
                PcodeTextEmitter.emitAssignVarnodeFromPcodeOpCall(pCode, VALUE, 4, "cpool", "0", Integer.toString(index), "3");
                PcodeTextEmitter.emitPushCat1Value(pCode, VALUE);
                break;
            }
            case 'D': 
            case 'J': {
                PcodeTextEmitter.emitAssignVarnodeFromPcodeOpCall(pCode, VALUE, 8, "cpool", "0", Integer.toString(index), "3");
                PcodeTextEmitter.emitPushCat2Value(pCode, VALUE);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid descriptor: " + descriptor);
            }
        }
        return pCode.toString();
    }

    public static String getPcodeForPutStatic(int index, AbstractConstantPoolInfoJava[] constantPool) {
        StringBuilder pCode = new StringBuilder();
        String descriptor = ReferenceMethods.getDescriptorForFieldRef(constantPool, index);
        switch (descriptor.charAt(0)) {
            case 'B': {
                PcodeTextEmitter.emitPopCat1Value(pCode, NEW_VALUE);
                PcodeTextEmitter.emitAssignVarnodeFromPcodeOpCall(pCode, STATIC_OFFSET, 4, "cpool", "0", Integer.toString(index), "15");
                PcodeTextEmitter.emitTruncate(pCode, TEMP, 1, NEW_VALUE);
                PcodeTextEmitter.emitWriteToMemory(pCode, "ram", 1, STATIC_OFFSET, TEMP);
                break;
            }
            case 'Z': {
                PcodeTextEmitter.emitPopCat1Value(pCode, NEW_VALUE);
                PcodeTextEmitter.emitAssignVarnodeFromPcodeOpCall(pCode, STATIC_OFFSET, 4, "cpool", "0", Integer.toString(index), "15");
                PcodeTextEmitter.emitTruncate(pCode, TEMP, 1, NEW_VALUE);
                PcodeTextEmitter.emitWriteToMemory(pCode, "ram", 1, STATIC_OFFSET, TEMP);
                break;
            }
            case 'C': {
                PcodeTextEmitter.emitPopCat1Value(pCode, NEW_VALUE);
                PcodeTextEmitter.emitAssignVarnodeFromPcodeOpCall(pCode, STATIC_OFFSET, 4, "cpool", "0", Integer.toString(index), "15");
                PcodeTextEmitter.emitTruncate(pCode, TEMP, 2, NEW_VALUE);
                PcodeTextEmitter.emitWriteToMemory(pCode, "ram", 2, STATIC_OFFSET, TEMP);
                break;
            }
            case 'S': {
                PcodeTextEmitter.emitPopCat1Value(pCode, NEW_VALUE);
                PcodeTextEmitter.emitAssignVarnodeFromPcodeOpCall(pCode, STATIC_OFFSET, 4, "cpool", "0", Integer.toString(index), "15");
                PcodeTextEmitter.emitTruncate(pCode, TEMP, 2, NEW_VALUE);
                PcodeTextEmitter.emitWriteToMemory(pCode, "ram", 2, STATIC_OFFSET, TEMP);
                break;
            }
            case 'F': 
            case 'I': 
            case 'L': 
            case '[': {
                PcodeTextEmitter.emitPopCat1Value(pCode, NEW_VALUE);
                PcodeTextEmitter.emitAssignVarnodeFromPcodeOpCall(pCode, STATIC_OFFSET, 4, "cpool", "0", Integer.toString(index), "15");
                PcodeTextEmitter.emitWriteToMemory(pCode, "ram", 4, STATIC_OFFSET, NEW_VALUE);
                break;
            }
            case 'D': 
            case 'J': {
                PcodeTextEmitter.emitPopCat2Value(pCode, NEW_VALUE);
                PcodeTextEmitter.emitAssignVarnodeFromPcodeOpCall(pCode, STATIC_OFFSET, 4, "cpool", "0", Integer.toString(index), "15");
                PcodeTextEmitter.emitWriteToMemory(pCode, "ram", 8, STATIC_OFFSET, NEW_VALUE);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid descriptor: " + descriptor);
            }
        }
        return pCode.toString();
    }

    public static String getPcodeForGetField(int index, AbstractConstantPoolInfoJava[] constantPool) {
        StringBuilder pCode = new StringBuilder();
        String descriptor = ReferenceMethods.getDescriptorForFieldRef(constantPool, index);
        switch (descriptor.charAt(0)) {
            case 'B': {
                PcodeTextEmitter.emitPopCat1Value(pCode, OBJECT_REF);
                PcodeTextEmitter.emitAssignVarnodeFromPcodeOpCall(pCode, TEMP, 1, "cpool", OBJECT_REF, Integer.toString(index), "2");
                PcodeTextEmitter.emitSignExtension(pCode, VALUE, 4, TEMP);
                PcodeTextEmitter.emitPushCat1Value(pCode, VALUE);
                break;
            }
            case 'Z': {
                PcodeTextEmitter.emitPopCat1Value(pCode, OBJECT_REF);
                PcodeTextEmitter.emitAssignVarnodeFromPcodeOpCall(pCode, TEMP, 1, "cpool", OBJECT_REF, Integer.toString(index), "2");
                PcodeTextEmitter.emitZeroExtension(pCode, VALUE, 4, TEMP);
                PcodeTextEmitter.emitPushCat1Value(pCode, VALUE);
                break;
            }
            case 'C': {
                PcodeTextEmitter.emitPopCat1Value(pCode, OBJECT_REF);
                PcodeTextEmitter.emitAssignVarnodeFromPcodeOpCall(pCode, TEMP, 2, "cpool", OBJECT_REF, Integer.toString(index), "2");
                PcodeTextEmitter.emitZeroExtension(pCode, VALUE, 4, TEMP);
                PcodeTextEmitter.emitPushCat1Value(pCode, VALUE);
                break;
            }
            case 'S': {
                PcodeTextEmitter.emitPopCat1Value(pCode, OBJECT_REF);
                PcodeTextEmitter.emitAssignVarnodeFromPcodeOpCall(pCode, TEMP, 2, "cpool", OBJECT_REF, Integer.toString(index), "2");
                PcodeTextEmitter.emitSignExtension(pCode, VALUE, 4, TEMP);
                PcodeTextEmitter.emitPushCat1Value(pCode, VALUE);
                break;
            }
            case 'F': 
            case 'I': 
            case 'L': 
            case '[': {
                PcodeTextEmitter.emitPopCat1Value(pCode, OBJECT_REF);
                PcodeTextEmitter.emitAssignVarnodeFromPcodeOpCall(pCode, VALUE, 4, "cpool", OBJECT_REF, Integer.toString(index), "2");
                PcodeTextEmitter.emitPushCat1Value(pCode, VALUE);
                break;
            }
            case 'D': 
            case 'J': {
                PcodeTextEmitter.emitPopCat1Value(pCode, OBJECT_REF);
                PcodeTextEmitter.emitAssignVarnodeFromPcodeOpCall(pCode, VALUE, 8, "cpool", OBJECT_REF, Integer.toString(index), "2");
                PcodeTextEmitter.emitPushCat2Value(pCode, VALUE);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid descriptor: " + descriptor);
            }
        }
        return pCode.toString();
    }

    public static String getPcodeForPutField(int index, AbstractConstantPoolInfoJava[] constantPool) {
        StringBuilder pCode = new StringBuilder();
        String descriptor = ReferenceMethods.getDescriptorForFieldRef(constantPool, index);
        switch (descriptor.charAt(0)) {
            case 'B': {
                PcodeTextEmitter.emitPopCat1Value(pCode, NEW_VALUE);
                PcodeTextEmitter.emitPopCat1Value(pCode, OBJECT_REF);
                PcodeTextEmitter.emitAssignVarnodeFromPcodeOpCall(pCode, FIELD_OFFSET, 4, "cpool", OBJECT_REF, Integer.toString(index), "16");
                PcodeTextEmitter.emitTruncate(pCode, TEMP, 1, NEW_VALUE);
                PcodeTextEmitter.emitWriteToMemory(pCode, "ram", 1, FIELD_OFFSET, TEMP);
                break;
            }
            case 'Z': {
                PcodeTextEmitter.emitPopCat1Value(pCode, NEW_VALUE);
                PcodeTextEmitter.emitPopCat1Value(pCode, OBJECT_REF);
                PcodeTextEmitter.emitAssignVarnodeFromPcodeOpCall(pCode, FIELD_OFFSET, 4, "cpool", OBJECT_REF, Integer.toString(index), "16");
                PcodeTextEmitter.emitTruncate(pCode, TEMP, 1, NEW_VALUE);
                PcodeTextEmitter.emitWriteToMemory(pCode, "ram", 1, FIELD_OFFSET, TEMP);
                break;
            }
            case 'C': {
                PcodeTextEmitter.emitPopCat1Value(pCode, NEW_VALUE);
                PcodeTextEmitter.emitPopCat1Value(pCode, OBJECT_REF);
                PcodeTextEmitter.emitAssignVarnodeFromPcodeOpCall(pCode, FIELD_OFFSET, 4, "cpool", OBJECT_REF, Integer.toString(index), "16");
                PcodeTextEmitter.emitTruncate(pCode, TEMP, 2, NEW_VALUE);
                PcodeTextEmitter.emitWriteToMemory(pCode, "ram", 2, FIELD_OFFSET, TEMP);
                break;
            }
            case 'S': {
                PcodeTextEmitter.emitPopCat1Value(pCode, NEW_VALUE);
                PcodeTextEmitter.emitPopCat1Value(pCode, OBJECT_REF);
                PcodeTextEmitter.emitAssignVarnodeFromPcodeOpCall(pCode, FIELD_OFFSET, 4, "cpool", OBJECT_REF, Integer.toString(index), "16");
                PcodeTextEmitter.emitTruncate(pCode, TEMP, 2, NEW_VALUE);
                PcodeTextEmitter.emitWriteToMemory(pCode, "ram", 2, FIELD_OFFSET, TEMP);
                break;
            }
            case 'F': 
            case 'I': 
            case 'L': 
            case '[': {
                PcodeTextEmitter.emitPopCat1Value(pCode, NEW_VALUE);
                PcodeTextEmitter.emitPopCat1Value(pCode, OBJECT_REF);
                PcodeTextEmitter.emitAssignVarnodeFromPcodeOpCall(pCode, FIELD_OFFSET, 4, "cpool", OBJECT_REF, Integer.toString(index), "16");
                PcodeTextEmitter.emitWriteToMemory(pCode, "ram", 4, FIELD_OFFSET, NEW_VALUE);
                break;
            }
            case 'D': 
            case 'J': {
                PcodeTextEmitter.emitPopCat2Value(pCode, NEW_VALUE);
                PcodeTextEmitter.emitPopCat1Value(pCode, OBJECT_REF);
                PcodeTextEmitter.emitAssignVarnodeFromPcodeOpCall(pCode, FIELD_OFFSET, 4, "cpool", OBJECT_REF, Integer.toString(index), "16");
                PcodeTextEmitter.emitWriteToMemory(pCode, "ram", 8, FIELD_OFFSET, NEW_VALUE);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid descriptor: " + descriptor);
            }
        }
        return pCode.toString();
    }

    static String getDescriptorForFieldRef(AbstractConstantPoolInfoJava[] constantPool, int index) {
        ConstantPoolFieldReferenceInfo fieldRef = (ConstantPoolFieldReferenceInfo)constantPool[index];
        short nameAndTypeIndex = fieldRef.getNameAndTypeIndex();
        ConstantPoolNameAndTypeInfo nameAndTypeInfo = (ConstantPoolNameAndTypeInfo)constantPool[nameAndTypeIndex];
        ConstantPoolUtf8Info descriptorInfo = (ConstantPoolUtf8Info)constantPool[nameAndTypeInfo.getDescriptorIndex()];
        return descriptorInfo.getString();
    }
}

