/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.main.logviewer.ui;

import ghidra.framework.main.logviewer.model.Chunk;
import ghidra.framework.main.logviewer.model.ChunkModel;
import ghidra.framework.main.logviewer.model.ChunkReader;
import ghidra.util.Msg;
import java.io.IOException;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTable;
import javax.swing.plaf.basic.BasicSliderUI;

public class FVSliderUI
extends BasicSliderUI {
    private JScrollPane scrollPane;
    private JTable table;
    private ChunkReader reader;
    private ChunkModel model;
    private int MINIMUM_THUMB_HEIGHT = 20;
    private int THUMB_WIDTH = 10;

    public FVSliderUI(JSlider slider, JScrollPane scrollPane, JTable table, ChunkReader reader, ChunkModel model) {
        super(slider);
        this.scrollPane = scrollPane;
        this.table = table;
        this.reader = reader;
        this.model = model;
    }

    @Override
    protected void calculateThumbSize() {
        long fileSize;
        super.calculateThumbSize();
        try {
            fileSize = this.reader.getFileSize();
        }
        catch (IOException e) {
            Msg.error((Object)this, (Object)("error reading file size: " + e));
            return;
        }
        int rows = this.table.getRowCount();
        if (rows == 0) {
            return;
        }
        long bytesInView = 0L;
        for (Chunk chunk : this.model) {
            bytesInView += chunk.end - chunk.start;
        }
        long bytesPerLine = bytesInView / (long)rows;
        long totalLinesInFile = fileSize / bytesPerLine;
        if (this.scrollPane.getViewport() != null) {
            float viewableRatio = (float)this.scrollPane.getViewport().getHeight() / (float)totalLinesInFile;
            float thumbHeight = viewableRatio * (float)this.table.getRowHeight();
            this.thumbRect.setSize(this.THUMB_WIDTH, this.MINIMUM_THUMB_HEIGHT + (int)thumbHeight);
        }
    }
}

