/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.datastruct;

import ghidra.util.datastruct.ShortKeySet;
import java.io.Serializable;

public class FullKeySet
implements ShortKeySet,
Serializable {
    private int numKeys;

    public FullKeySet(int numKeys) {
        this.numKeys = numKeys;
    }

    @Override
    public int size() {
        return this.numKeys;
    }

    @Override
    public boolean containsKey(short key) {
        return key >= 0 && key < this.numKeys;
    }

    @Override
    public short getFirst() {
        return 0;
    }

    @Override
    public short getLast() {
        return (short)(this.numKeys - 1);
    }

    @Override
    public void put(short key) {
        if (key < 0 || key >= this.numKeys) {
            throw new IndexOutOfBoundsException();
        }
    }

    @Override
    public boolean remove(short key) {
        if (key < 0 || key >= this.numKeys) {
            throw new IndexOutOfBoundsException();
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeAll() {
        throw new UnsupportedOperationException();
    }

    @Override
    public short getNext(short key) {
        if (key < 0 || key >= this.numKeys) {
            throw new IndexOutOfBoundsException();
        }
        if (key == this.numKeys - 1) {
            return -1;
        }
        return (short)(key + 1);
    }

    @Override
    public short getPrevious(short key) {
        if (key < 0 || key >= this.numKeys) {
            throw new IndexOutOfBoundsException();
        }
        if (key == 0) {
            return -1;
        }
        return (short)(key - 1);
    }

    @Override
    public boolean isEmpty() {
        return false;
    }
}

