/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sevenzipjbinding.impl;

import java.io.IOException;
import java.io.PrintStream;
import net.sf.sevenzipjbinding.ArchiveFormat;
import net.sf.sevenzipjbinding.IInArchive;
import net.sf.sevenzipjbinding.IOutArchive;
import net.sf.sevenzipjbinding.IOutCreateCallback;
import net.sf.sevenzipjbinding.IOutItemBase;
import net.sf.sevenzipjbinding.ISequentialOutStream;
import net.sf.sevenzipjbinding.SevenZipException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OutArchiveImpl<T extends IOutItemBase>
implements IOutArchive<T> {
    private long jbindingSession;
    private long sevenZipArchiveInstance;
    private IInArchive inArchive;
    private ArchiveFormat archiveFormat;
    private int compressionLevel = -1;
    private int threadCount = -1;
    private PrintStream tracePrintStream;
    private boolean trace;

    protected void setInArchive(IInArchive iInArchive) {
        this.inArchive = iInArchive;
    }

    protected void featureSetLevel(int n) {
        this.compressionLevel = n;
    }

    protected void featureSetThreadCount(int n) {
        this.threadCount = n;
    }

    protected void applyFeatures() throws SevenZipException {
        if (this.compressionLevel != -1) {
            this.nativeSetLevel(this.compressionLevel);
        }
        if (this.threadCount >= 0) {
            this.nativeSetMultithreading(this.threadCount);
        }
    }

    @Override
    public ArchiveFormat getArchiveFormat() {
        return this.archiveFormat;
    }

    protected void setArchiveFormat(ArchiveFormat archiveFormat) {
        this.archiveFormat = archiveFormat;
    }

    protected native void nativeSetLevel(int var1) throws SevenZipException;

    protected native void nativeSetSolidSpec(String var1) throws SevenZipException;

    protected native void nativeSetMultithreading(int var1) throws SevenZipException;

    private native void nativeUpdateItems(ISequentialOutStream var1, int var2, Object var3) throws SevenZipException;

    @Override
    public void close() throws IOException {
        if (this.inArchive != null) {
            return;
        }
        this.nativeClose();
    }

    private native void nativeClose() throws SevenZipException;

    @Override
    public void updateItems(ISequentialOutStream iSequentialOutStream, int n, IOutCreateCallback<T> iOutCreateCallback) throws SevenZipException {
        this.doUpdateItems(iSequentialOutStream, n, iOutCreateCallback);
    }

    private void doUpdateItems(ISequentialOutStream iSequentialOutStream, int n, IOutCreateCallback<?> iOutCreateCallback) throws SevenZipException {
        this.applyFeatures();
        this.nativeUpdateItems(iSequentialOutStream, n, iOutCreateCallback);
    }

    @Override
    public void createArchive(ISequentialOutStream iSequentialOutStream, int n, IOutCreateCallback<? extends T> iOutCreateCallback) throws SevenZipException {
        this.doUpdateItems(iSequentialOutStream, n, iOutCreateCallback);
    }

    @Override
    public IInArchive getConnectedInArchive() {
        return this.inArchive;
    }

    private final void traceMessage(String string) {
        if (this.trace) {
            if (this.tracePrintStream == null) {
                System.out.println(string);
            } else {
                this.tracePrintStream.println(string);
            }
        }
    }

    @Override
    public void setTracePrintStream(PrintStream printStream) {
        this.tracePrintStream = printStream;
    }

    @Override
    public PrintStream getTracePrintStream() {
        return this.tracePrintStream;
    }

    @Override
    public void setTrace(boolean bl) {
        this.trace = bl;
    }

    @Override
    public boolean isTrace() {
        return this.trace;
    }
}

