/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.functiongraph.graph.layout;

import edu.uci.ics.jung.algorithms.layout.Layout;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.util.Context;
import edu.uci.ics.jung.graph.util.Pair;
import edu.uci.ics.jung.visualization.Layer;
import edu.uci.ics.jung.visualization.MultiLayerTransformer;
import edu.uci.ics.jung.visualization.RenderContext;
import edu.uci.ics.jung.visualization.renderers.EdgeLabelRenderer;
import edu.uci.ics.jung.visualization.renderers.Renderer;
import edu.uci.ics.jung.visualization.transform.shape.GraphicsDecorator;
import ghidra.app.plugin.core.functiongraph.graph.FGEdge;
import ghidra.app.plugin.core.functiongraph.graph.vertex.FGVertex;
import ghidra.graph.viewer.VisualVertex;
import ghidra.graph.viewer.vertex.VisualGraphVertexShapeTransformer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.List;

class CodeFlowEdgeLabelRenderer<V extends FGVertex, E extends FGEdge>
implements Renderer.EdgeLabel<V, E> {
    private static final int EDGE_OFFSET = 20;
    VisualGraphVertexShapeTransformer vertexShapeTransformer = new VisualGraphVertexShapeTransformer();

    CodeFlowEdgeLabelRenderer() {
    }

    public void labelEdge(RenderContext<V, E> rc, Layout<V, E> layout, E e, String text) {
        if (text == null || text.isEmpty()) {
            return;
        }
        Graph jungGraph = layout.getGraph();
        Pair endpoints = jungGraph.getEndpoints(e);
        FGVertex v1 = (FGVertex)endpoints.getFirst();
        FGVertex v2 = (FGVertex)endpoints.getSecond();
        if (!rc.getEdgeIncludePredicate().apply((Object)Context.getInstance((Object)jungGraph, e))) {
            return;
        }
        if (!rc.getVertexIncludePredicate().apply((Object)Context.getInstance((Object)jungGraph, (Object)v1)) || !rc.getVertexIncludePredicate().apply((Object)Context.getInstance((Object)jungGraph, (Object)v2))) {
            return;
        }
        Point2D p1 = (Point2D)layout.apply((Object)v1);
        MultiLayerTransformer multiLayerTransformer = rc.getMultiLayerTransformer();
        p1 = multiLayerTransformer.transform(Layer.LAYOUT, p1);
        Shape vertexShape = this.vertexShapeTransformer.apply((VisualVertex)v1);
        Rectangle vertexBounds = vertexShape.getBounds();
        int xDisplacement = rc.getLabelOffset();
        Point2D.Double labelPointOffset = new Point2D.Double();
        List articulationPoints = e.getArticulationPoints();
        if (articulationPoints.isEmpty()) {
            double vertexBottom = p1.getY() + (double)(vertexBounds.height >> 1);
            int textY = (int)(vertexBottom + 20.0);
            int textX = (int)(p1.getX() + (double)xDisplacement);
            ((Point2D)labelPointOffset).setLocation(textX, textY);
        } else {
            int textX;
            int textY;
            double vertexBottom;
            if (articulationPoints.size() == 1) {
                return;
            }
            Point2D bend1 = (Point2D)articulationPoints.get(0);
            bend1 = multiLayerTransformer.transform(Layer.LAYOUT, bend1);
            Point2D bend2 = (Point2D)articulationPoints.get(1);
            bend2 = multiLayerTransformer.transform(Layer.LAYOUT, bend2);
            double bx1 = bend1.getX();
            if (articulationPoints.size() == 2) {
                double vertexSide = p1.getX() + (double)(vertexBounds.width >> 1);
                int textX2 = (int)(vertexSide + 20.0);
                int textY2 = (int)(p1.getY() + 20.0);
                ((Point2D)labelPointOffset).setLocation(textX2, textY2);
            } else if (articulationPoints.size() == 3) {
                vertexBottom = p1.getY() + (double)(vertexBounds.height >> 1);
                textY = (int)(vertexBottom + 20.0);
                textX = (int)(bx1 + (double)xDisplacement);
                ((Point2D)labelPointOffset).setLocation(textX, textY);
            } else if (articulationPoints.size() == 4) {
                vertexBottom = p1.getY() + (double)(vertexBounds.height >> 1);
                textY = (int)(vertexBottom + 20.0);
                textX = (int)(bx1 + (double)xDisplacement);
                ((Point2D)labelPointOffset).setLocation(textX, textY);
            }
        }
        EdgeLabelRenderer labelRenderer = rc.getEdgeLabelRenderer();
        Font font = (Font)rc.getEdgeFontTransformer().apply(e);
        boolean isSelected = rc.getPickedEdgeState().isPicked(e);
        Component component = labelRenderer.getEdgeLabelRendererComponent(rc.getScreenDevice(), (Object)text, font, isSelected, e);
        Dimension d = component.getPreferredSize();
        GraphicsDecorator g = rc.getGraphicsContext();
        AffineTransform old = g.getTransform();
        AffineTransform xform = new AffineTransform(old);
        xform.translate(((Point2D)labelPointOffset).getX(), ((Point2D)labelPointOffset).getY());
        g.setTransform(xform);
        g.draw(component, rc.getRendererPane(), 0, 0, d.width, d.height, true);
        g.setTransform(old);
    }
}

