/*
 * Decompiled with CFR 0.152.
 */
package ghidra.graph.graphs;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterators;
import edu.uci.ics.jung.graph.util.EdgeType;
import edu.uci.ics.jung.graph.util.Pair;
import ghidra.generic.function.Callback;
import ghidra.graph.GraphAlgorithms;
import ghidra.graph.graphs.DefaultVisualGraph;
import ghidra.graph.viewer.VisualEdge;
import ghidra.graph.viewer.VisualVertex;
import ghidra.graph.viewer.layout.VisualGraphLayout;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import util.CollectionUtils;

public abstract class FilteringVisualGraph<V extends VisualVertex, E extends VisualEdge<V>>
extends DefaultVisualGraph<V, E> {
    private UnfilteredGraph completeGraph = new UnfilteredGraph();
    private int internalCallCount;

    public void filterVertices(Collection<V> toFilter) {
        for (VisualVertex v : toFilter) {
            this.removeVertexFromView(v);
        }
    }

    public void filterEdges(Collection<E> toFilter) {
        for (VisualEdge e : toFilter) {
            this.removeEdgeFromView(e);
        }
    }

    public void unfilterVertices(Collection<V> toUnfilter) {
        this.maybeRestoreVertices(toUnfilter);
        this.maybeRestoreRelatedEdges(toUnfilter);
    }

    public void unfilterEdges(Collection<E> toUnfilter) {
        this.maybeRestoreEdges(toUnfilter);
    }

    public Iterator<V> getAllVertices() {
        return this.completeGraph.getVertices().iterator();
    }

    public Iterator<E> getAllEdges() {
        return this.completeGraph.getEdges().iterator();
    }

    public Iterator<V> getFilteredVertices() {
        Predicate isFiltered = v -> !this.containsVertex(v) && this.completeGraph.containsVertex(v);
        return Iterators.filter(this.getAllVertices(), (Predicate)isFiltered);
    }

    public Iterator<E> getFilteredEdges() {
        Predicate isFiltered = e -> !this.containsEdge(e) && this.completeGraph.containsEdge(e);
        return Iterators.filter(this.getAllEdges(), (Predicate)isFiltered);
    }

    public Iterator<V> getUnfilteredVertices() {
        return this.getVertices().iterator();
    }

    public Iterator<E> getUnfilteredEdges() {
        return this.getEdges().iterator();
    }

    public boolean isFiltered() {
        if (this.completeGraph.getVertexCount() != this.getVertexCount()) {
            return true;
        }
        return this.completeGraph.getEdgeCount() != this.getEdgeCount();
    }

    public void clearFilter() {
        this.vertices.clear();
        this.edges.clear();
        this.restoreAllVertices();
        this.restoreAllEdges();
    }

    public Set<V> getAllReachableVertices(Set<V> sourceVertices) {
        HashSet relatedEdges = new HashSet();
        for (VisualVertex v : sourceVertices) {
            relatedEdges.addAll(GraphAlgorithms.getEdgesFrom(this.completeGraph, CollectionUtils.asList((Object[])new VisualVertex[]{v}), true));
            relatedEdges.addAll(GraphAlgorithms.getEdgesFrom(this.completeGraph, CollectionUtils.asList((Object[])new VisualVertex[]{v}), false));
        }
        return GraphAlgorithms.toVertices(relatedEdges);
    }

    @Override
    public Set<E> getAllEdges(Set<V> sourceVertices) {
        HashSet connectedEdges = new HashSet();
        for (VisualVertex vertex : sourceVertices) {
            connectedEdges.addAll(CollectionUtils.nonNull((Collection)this.completeGraph.getIncidentEdges(vertex)));
        }
        return connectedEdges;
    }

    private void restoreAllVertices() {
        Collection allVertices = this.completeGraph.getVertices();
        this.performInternalUpdate(() -> allVertices.forEach(v -> this.addVertex((V)v)));
    }

    private void restoreAllEdges() {
        Collection allEdges = this.completeGraph.getEdges();
        this.performInternalUpdate(() -> allEdges.forEach(e -> this.addEdge((E)e)));
    }

    private void maybeRestoreVertices(Collection<V> toRestore) {
        for (VisualVertex v : toRestore) {
            if (!this.completeGraph.containsVertex(v)) continue;
            this.performInternalUpdate(() -> super.addVertex(v));
        }
    }

    private void maybeRestoreEdges(Collection<E> toUnfilter) {
        for (VisualEdge e : toUnfilter) {
            if (!this.completeGraph.containsEdge(e)) continue;
            VisualVertex start = (VisualVertex)e.getStart();
            VisualVertex end = (VisualVertex)e.getEnd();
            if (!this.containsVertex(start) || !this.containsVertex(end)) continue;
            this.performInternalUpdate(() -> super.addEdge(e));
        }
    }

    private void maybeRestoreRelatedEdges(Collection<V> toUnfilter) {
        for (VisualVertex v : toUnfilter) {
            Collection vertexEdges = this.completeGraph.getIncidentEdges(v);
            if (vertexEdges == null) continue;
            for (VisualEdge e : vertexEdges) {
                VisualVertex start = (VisualVertex)e.getStart();
                VisualVertex end = (VisualVertex)e.getEnd();
                if (!this.containsVertex(start) || !this.containsVertex(end)) continue;
                this.performInternalUpdate(() -> super.addEdge(e));
            }
        }
    }

    private void removeVertexFromView(V v) {
        this.performInternalUpdate(() -> super.removeVertex(v));
    }

    private void removeEdgeFromView(E e) {
        this.performInternalUpdate(() -> super.removeEdge(e));
    }

    private void performInternalUpdate(Callback c) {
        ++this.internalCallCount;
        try {
            c.call();
        }
        finally {
            --this.internalCallCount;
        }
    }

    private void maybePerformRemove(Callback c) {
        if (this.isInternalUpdate()) {
            return;
        }
        c.call();
    }

    private boolean isInternalUpdate() {
        return this.internalCallCount > 0;
    }

    private void maybePerformAdd(Callback c) {
        if (this.isInternalUpdate()) {
            c.call();
            return;
        }
        if (this.isFiltered()) {
            return;
        }
        this.performInternalUpdate(c);
    }

    @Override
    public boolean removeVertex(V v) {
        boolean removed = super.removeVertex(v);
        this.maybePerformRemove(() -> this.completeGraph.removeVertex(v));
        return removed;
    }

    @Override
    public void removeVertices(Iterable<V> verticesToRemove) {
        LinkedList edgesToRemove = new LinkedList();
        LinkedList<VisualVertex> removed = new LinkedList<VisualVertex>();
        for (VisualVertex v : verticesToRemove) {
            if (!super.containsVertex((Object)v)) continue;
            edgesToRemove.addAll(this.getIncidentEdges(v));
            removed.add(v);
            super.removeVertex(v);
        }
        this.maybePerformRemove(() -> {
            this.completeGraph.removeVertices(verticesToRemove);
            this.completeGraph.removeEdges(edgesToRemove);
        });
        this.verticesRemoved(removed);
    }

    @Override
    public boolean removeEdge(E e) {
        boolean removed = super.removeEdge(e);
        List<VisualEdge> asList = Arrays.asList(e);
        if (removed) {
            this.fireEdgesRemoved(asList);
        }
        this.maybePerformRemove(() -> this.completeGraph.removeEdge(e));
        return removed;
    }

    @Override
    public void removeEdges(Iterable<E> toRemove) {
        toRemove.forEach(e -> super.removeEdge(e));
        super.removeEdges(toRemove);
        this.maybePerformRemove(() -> this.completeGraph.removeEdges(toRemove));
        this.fireEdgesRemoved(toRemove);
    }

    @Override
    public boolean addVertex(V v) {
        this.maybePerformAdd(() -> super.addVertex(v));
        return this.completeGraph.addVertex(v);
    }

    @Override
    public void addEdge(E e) {
        this.maybePerformAdd(() -> super.addEdge(e));
        this.completeGraph.addEdge(e);
    }

    @Override
    public boolean addEdge(E e, Pair<? extends V> endpoints, EdgeType type) {
        this.maybePerformAdd(() -> super.addEdge(e, endpoints, type));
        return this.completeGraph.addEdge(e, endpoints, type);
    }

    public boolean addEdge(E e, Collection<? extends V> edgeVertices) {
        this.maybePerformAdd(() -> super.addEdge((Object)e, edgeVertices));
        return this.completeGraph.addEdge(e, edgeVertices);
    }

    @Override
    public boolean addEdge(E e, Collection<? extends V> edgeVertices, EdgeType type) {
        this.maybePerformAdd(() -> super.addEdge((Object)e, edgeVertices, type));
        return this.completeGraph.addEdge(e, edgeVertices, type);
    }

    public boolean addEdge(E e, V v1, V v2) {
        this.maybePerformAdd(() -> super.addEdge((Object)e, (Object)v1, (Object)v2));
        return this.completeGraph.addEdge(e, v1, v2);
    }

    public boolean addEdge(E e, V v1, V v2, EdgeType edgeType) {
        this.maybePerformAdd(() -> super.addEdge((Object)e, (Object)v1, (Object)v2, edgeType));
        return this.completeGraph.addEdge(e, v1, v2, edgeType);
    }

    public boolean addEdge(E e, Pair<? extends V> endpoints) {
        this.maybePerformAdd(() -> super.addEdge((Object)e, endpoints));
        return this.completeGraph.addEdge(e, endpoints);
    }

    @Override
    public void dispose() {
        this.completeGraph.dispose();
        this.vertices.clear();
        this.edges.clear();
    }

    private class UnfilteredGraph
    extends DefaultVisualGraph<V, E> {
        private UnfilteredGraph() {
        }

        @Override
        public VisualGraphLayout<V, E> getLayout() {
            return null;
        }

        @Override
        public DefaultVisualGraph<V, E> copy() {
            return null;
        }

        @Override
        public void dispose() {
            this.vertices.clear();
            this.edges.clear();
        }
    }
}

