/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.compositeeditor;

import docking.ActionContext;
import docking.action.KeyBindingData;
import ghidra.app.plugin.core.compositeeditor.CompositeEditorProvider;
import ghidra.app.plugin.core.compositeeditor.CompositeEditorTableAction;
import ghidra.util.exception.UsrException;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;
import resources.ResourceManager;

public class DuplicateAction
extends CompositeEditorTableAction {
    private static final ImageIcon duplicateDataIcon = ResourceManager.loadImage((String)"images/DuplicateData.png");
    private static final String ACTION_NAME = "Duplicate Component";
    private static final String GROUP_NAME = "4_COMPONENT_EDITOR_ACTION";
    private static final String DESCRIPTION = "Duplicate the selected component";
    private KeyStroke keyStroke = KeyStroke.getKeyStroke(68, 8);
    private static String[] popupPath = new String[]{"Duplicate Component"};

    public DuplicateAction(CompositeEditorProvider provider) {
        super(provider, "Editor: Duplicate Component", GROUP_NAME, popupPath, null, duplicateDataIcon);
        this.setDescription(DESCRIPTION);
        this.setKeyBindingData(new KeyBindingData(this.keyStroke));
        this.adjustEnablement();
    }

    public void actionPerformed(ActionContext context) {
        int max;
        int[] indices = this.model.getSelectedComponentRows();
        if (indices.length == 1 && (max = this.model.getMaxDuplicates(indices[0])) != 0) {
            try {
                this.model.duplicateMultiple(indices[0], 1);
            }
            catch (UsrException e1) {
                this.model.setStatus(e1.getMessage(), true);
            }
        }
        this.requestTableFocus();
    }

    @Override
    public void adjustEnablement() {
        this.setEnabled(this.model.isDuplicateAllowed());
    }
}

