/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.hover;

import ghidra.app.plugin.core.hover.AbstractConfigurableHover;
import ghidra.docking.settings.FormatSettingsDefinition;
import ghidra.docking.settings.Settings;
import ghidra.docking.settings.SettingsImpl;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressOutOfBoundsException;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.data.AbstractIntegerDataType;
import ghidra.program.model.data.ByteDataType;
import ghidra.program.model.data.DWordDataType;
import ghidra.program.model.data.QWordDataType;
import ghidra.program.model.data.SignedDWordDataType;
import ghidra.program.model.data.SignedQWordDataType;
import ghidra.program.model.data.SignedWordDataType;
import ghidra.program.model.data.WordDataType;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.ByteMemBufferImpl;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.scalar.Scalar;
import ghidra.program.model.symbol.Symbol;
import ghidra.util.HTMLUtilities;
import java.util.ArrayList;
import java.util.Arrays;

public abstract class AbstractScalarOperandHover
extends AbstractConfigurableHover {
    private static final FormatSettingsDefinition FORMAT = FormatSettingsDefinition.DEF;
    private static final Settings[] INTEGER_SETTINGS = new Settings[]{AbstractScalarOperandHover.getSettingsForRadix("hex"), AbstractScalarOperandHover.getSettingsForRadix("decimal"), AbstractScalarOperandHover.getSettingsForRadix("char")};
    private static final AbstractIntegerDataType[] DISPLAY_TYPES = new AbstractIntegerDataType[]{new ByteDataType(), new WordDataType(), new SignedWordDataType(), new DWordDataType(), new SignedDWordDataType(), new QWordDataType(), new SignedQWordDataType()};

    private static Settings getSettingsForRadix(String radix) {
        SettingsImpl s = new SettingsImpl();
        FORMAT.setDisplayChoice((Settings)s, radix);
        return s;
    }

    public AbstractScalarOperandHover(PluginTool tool, int priority) {
        super(tool, priority);
    }

    protected String formatScalar(Program program, Address addr, Scalar scalar) {
        Address asAddress;
        StringBuilder sb = new StringBuilder("<HTML>");
        byte[] opBytes = this.getOperandBytes(scalar);
        int opSize = opBytes.length;
        Memory memory = program.getMemory();
        ByteMemBufferImpl memBuffer = new ByteMemBufferImpl(addr, opBytes, !memory.isBigEndian());
        AbstractScalarOperandHover.buildTableHeader(sb);
        for (AbstractIntegerDataType type : DISPLAY_TYPES) {
            if (type.getLength() != opSize) continue;
            ArrayList<String> reprs = new ArrayList<String>();
            for (Settings setting : INTEGER_SETTINGS) {
                String repr = type.getRepresentation((MemBuffer)memBuffer, setting, type.getLength());
                if (repr.equals("??")) {
                    repr = HTMLUtilities.HTML_SPACE;
                }
                reprs.add(repr);
            }
            AbstractScalarOperandHover.addReprRow(sb, type.getDisplayName(), reprs);
        }
        sb.append("</table>");
        long scalarLong = scalar.getValue();
        AddressFactory factory = program.getAddressFactory();
        AddressSpace space = factory.getDefaultAddressSpace();
        try {
            asAddress = factory.getAddress(space.getBaseSpaceID(), scalarLong);
        }
        catch (AddressOutOfBoundsException ex) {
            asAddress = null;
        }
        if (asAddress != null && memory.contains(asAddress)) {
            Symbol primary;
            sb.append("<hr>");
            sb.append("<table>");
            AbstractScalarOperandHover.addReprRow(sb, "Address", asAddress.toString());
            Data data = program.getListing().getDataContaining(asAddress);
            if (data != null && (primary = data.getPrimarySymbol()) != null) {
                AbstractScalarOperandHover.addReprRow(sb, "Symbol", HTMLUtilities.italic((String)primary.getName()));
            }
            sb.append("</table>");
        }
        return sb.toString();
    }

    private byte[] getOperandBytes(Scalar scalar) {
        byte[] operandBytes = scalar.byteArrayValue();
        byte[] trimmed = AbstractScalarOperandHover.trimLeadingZeros(operandBytes);
        return trimmed;
    }

    private static byte[] trimLeadingZeros(byte[] bytes) {
        int fullLength = bytes.length;
        for (int i = 0; i < fullLength; ++i) {
            if (bytes[i] == 0) continue;
            if (i == 0) break;
            int toCopy = fullLength - i;
            int len = toCopy;
            if (len < 2) {
                len = 2;
            } else if (len < 4) {
                len = 4;
            } else if (len < 8) {
                len = 8;
            }
            byte[] newBytes = new byte[len];
            int offset = len - toCopy;
            System.arraycopy(bytes, i, newBytes, offset, toCopy);
            return newBytes;
        }
        return bytes;
    }

    private static void buildTableHeader(StringBuilder sb) {
        sb.append("<table><tr><th></th>");
        for (Settings setting : INTEGER_SETTINGS) {
            Object radixName = FORMAT.getDisplayChoice(setting);
            radixName = Character.toTitleCase(((String)radixName).charAt(0)) + ((String)radixName).substring(1);
            sb.append("<th>").append((String)radixName).append("</th>");
        }
        sb.append("</tr>");
    }

    private static void addReprRow(StringBuilder sb, String typeName, String repr) {
        AbstractScalarOperandHover.addReprRow(sb, typeName, Arrays.asList(repr));
    }

    private static void addReprRow(StringBuilder sb, String typeName, Iterable<String> reprs) {
        sb.append("<tr><td style=\"text-align: left;\">").append(typeName).append("</td>");
        for (String repr : reprs) {
            sb.append("<td style=\"text-align: right;\">").append(repr).append("</td>");
        }
        sb.append("</tr>");
    }

    @Override
    protected boolean isValidTooltipContent(String content) {
        return content != null && content.length() >= "<HTML>".length();
    }
}

