/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.instructionsearch.ui;

import docking.ActionContext;
import docking.action.DockingActionIf;
import ghidra.app.plugin.core.instructionsearch.model.InstructionSearchData;
import ghidra.app.plugin.core.instructionsearch.model.InstructionTableDataObject;
import ghidra.app.plugin.core.instructionsearch.model.InstructionTableModel;
import ghidra.app.plugin.core.instructionsearch.ui.InstructionSearchDialog;
import ghidra.app.plugin.core.instructionsearch.ui.InstructionTableCellRenderer;
import ghidra.util.table.GhidraTable;
import java.awt.Font;
import java.util.List;
import javax.swing.JToolBar;
import javax.swing.table.TableCellRenderer;

public abstract class AbstractInstructionTable
extends GhidraTable {
    private int CELL_HEIGHT_PADDING = 6;
    protected InstructionTableDataObject[][] tableContentsDO = null;
    protected int numColumns;
    protected Object[] columnNames;
    protected InstructionSearchDialog dialog;
    protected JToolBar toolbar;
    protected InstructionTableCellRenderer renderer = new InstructionTableCellRenderer(new Font("Courier", 0, 14));
    protected InstructionSearchData searchData;
    protected static InstructionTableModel tableModel;

    public AbstractInstructionTable(int columns, InstructionSearchDialog dialog) {
        this.numColumns = columns;
        this.dialog = dialog;
        this.searchData = dialog.getSearchData();
        this.columnNames = this.createColumnHeaders();
        this.tableContentsDO = this.createDataObjects();
        tableModel = new InstructionTableModel(this.tableContentsDO, this.columnNames);
        this.setModel(tableModel);
        this.toolbar = this.createToolbar();
        this.getTableHeader().setReorderingAllowed(false);
        this.setRowHeight(this.getRowHeight() + this.CELL_HEIGHT_PADDING);
    }

    public InstructionTableDataObject getCellData(int row, int col) {
        if (this.getModel() == null) {
            return null;
        }
        if (row < 0 || col < 0) {
            return null;
        }
        if (this.getModel().getRowCount() <= row || this.getModel().getColumnCount() <= col) {
            return null;
        }
        return (InstructionTableDataObject)this.getModel().getValueAt(row, col);
    }

    public List<DockingActionIf> getDockingActions(ActionContext context) {
        List list = super.getDockingActions(context);
        return list;
    }

    public TableCellRenderer getDefaultRenderer(Class<?> columnClass) {
        return this.renderer;
    }

    public JToolBar getToolbar() {
        return this.toolbar;
    }

    @Override
    protected void initDefaultRenderers() {
        this.setDefaultRenderer(InstructionTableDataObject.class, (TableCellRenderer)((Object)this.renderer));
        this.defaultGTableRendererList.add(this.renderer);
    }

    protected String getColumnValue(int row, String colName) {
        for (int i = 0; i < this.getColumnCount(); ++i) {
            if (!this.getColumnName(i).equals(colName)) continue;
            return this.getCellData(row, i).getData();
        }
        return null;
    }

    protected abstract Object[] createColumnHeaders();

    protected abstract InstructionTableDataObject[][] createDataObjects();

    protected abstract JToolBar createToolbar();

    public static enum OperandState {
        MASKED,
        NOT_MASKED,
        NA,
        PREVIEW;

    }
}

