/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.marker;

import ghidra.app.events.ProgramActivatedPluginEvent;
import ghidra.app.events.ProgramClosedPluginEvent;
import ghidra.app.plugin.core.marker.MarkerManager;
import ghidra.app.services.CodeViewerService;
import ghidra.app.services.GoToService;
import ghidra.app.services.MarkerService;
import ghidra.framework.options.ToolOptions;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginEvent;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.program.model.listing.Program;
import ghidra.util.HelpLocation;

@PluginInfo(status=PluginStatus.RELEASED, packageName="Ghidra Core", category="Support", shortDescription="Provides the marker display", description="This plugin extends the code browser to include left and right markercomponents.  The left margin shows marks related to the address being shown at that location.  The right margin shows marks at a position that is relative to an addresses within the overall program (Overview).  This plugin also provides a service that other plugins can use to display markers.  Two types of markers are supported; point markers and area markers.  Area markers are used to indicate a range value such as selection.  Point markers are used to represent individual addresses such as bookmarks.", servicesRequired={CodeViewerService.class, GoToService.class}, servicesProvided={MarkerService.class}, eventsConsumed={ProgramActivatedPluginEvent.class, ProgramClosedPluginEvent.class})
public class MarkerManagerPlugin
extends Plugin {
    private CodeViewerService codeViewerService;
    private MarkerManager markerManager = new MarkerManager(this);
    private Program program;

    public MarkerManagerPlugin(PluginTool tool) {
        super(tool);
        ToolOptions options = tool.getOptions("Navigation Markers");
        options.setOptionsHelpLocation(new HelpLocation("CodeBrowserPlugin", "Navigation Markers"));
        this.registerServiceProvided(MarkerService.class, this.markerManager);
    }

    protected void dispose() {
        if (this.codeViewerService != null) {
            this.codeViewerService.removeMarginProvider(this.markerManager.getMarginProvider());
            this.codeViewerService.removeOverviewProvider(this.markerManager.getOverviewProvider());
        }
        this.markerManager.dispose();
    }

    protected void init() {
        this.codeViewerService = (CodeViewerService)this.tool.getService(CodeViewerService.class);
        this.codeViewerService.addMarginProvider(this.markerManager.getMarginProvider());
        this.codeViewerService.addOverviewProvider(this.markerManager.getOverviewProvider());
    }

    public void processEvent(PluginEvent event) {
        if (event instanceof ProgramActivatedPluginEvent) {
            ProgramActivatedPluginEvent ev = (ProgramActivatedPluginEvent)event;
            Program oldProgram = this.program;
            this.program = ev.getActiveProgram();
            if (oldProgram != null) {
                this.markerManager.setProgram(null);
            }
            if (this.program != null) {
                this.markerManager.setProgram(this.program);
            }
        } else if (event instanceof ProgramClosedPluginEvent) {
            this.markerManager.programClosed(((ProgramClosedPluginEvent)event).getProgram());
        }
    }
}

