/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.memory;

import docking.widgets.OptionDialog;
import docking.widgets.dialogs.NumberInputDialog;
import docking.widgets.table.AbstractSortedTableModel;
import ghidra.app.plugin.core.memory.MemoryMapProvider;
import ghidra.app.plugin.core.memory.UninitializedBlockCmd;
import ghidra.framework.cmd.BackgroundCommand;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.UndoableDomainObject;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.address.OverlayAddressSpace;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MappedMemoryBlock;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.mem.MemoryBlockType;
import ghidra.util.Msg;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.List;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellEditor;

class MemoryMapModel
extends AbstractSortedTableModel<MemoryBlock> {
    static final byte NAME = 0;
    static final byte START = 1;
    static final byte END = 2;
    static final byte LENGTH = 3;
    static final byte READ = 4;
    static final byte WRITE = 5;
    static final byte EXECUTE = 6;
    static final byte VOLATILE = 7;
    static final byte BLOCK_TYPE = 8;
    static final byte INIT = 9;
    static final byte SOURCE = 10;
    static final byte COMMENT = 11;
    static final String NAME_COL = "Name";
    static final String START_COL = "Start";
    static final String END_COL = "End";
    static final String LENGTH_COL = "Length";
    static final String READ_COL = "R";
    static final String WRITE_COL = "W";
    static final String EXECUTE_COL = "X";
    static final String VOLATILE_COL = "Volatile";
    static final String BLOCK_TYPE_COL = "Type";
    static final String INIT_COL = "Initialized";
    static final String SOURCE_COL = "Source";
    static final String COMMENT_COL = "Comment";
    private Program program;
    private ArrayList<MemoryBlock> memList;
    private MemoryMapProvider provider;
    private static final String[] COLUMN_NAMES = new String[]{"Name", "Start", "End", "Length", "R", "W", "X", "Volatile", "Type", "Initialized", "Source", "Comment"};

    MemoryMapModel(MemoryMapProvider provider, Program program) {
        super(1);
        this.program = program;
        this.provider = provider;
        this.populateMap();
    }

    private void populateMap() {
        MemoryBlock[] blocks;
        this.memList = new ArrayList();
        if (this.program == null) {
            return;
        }
        Memory mem = this.program.getMemory();
        for (MemoryBlock block : blocks = mem.getBlocks()) {
            this.memList.add(block);
        }
        this.fireTableDataChanged();
    }

    void update() {
        JTable table = this.provider.getTable();
        TableCellEditor cellEditor = table.getCellEditor();
        if (cellEditor != null) {
            cellEditor.cancelCellEditing();
        }
        this.populateMap();
    }

    public boolean isSortable(int columnIndex) {
        return columnIndex != 4 && columnIndex != 5 && columnIndex != 6 && columnIndex != 7 && columnIndex != 9;
    }

    public String getName() {
        return "Memory Map";
    }

    public int getColumnCount() {
        return COLUMN_NAMES.length;
    }

    public String getColumnName(int column) {
        if (column < 0 || column >= COLUMN_NAMES.length) {
            return "UNKNOWN";
        }
        return COLUMN_NAMES[column];
    }

    public int findColumn(String columnName) {
        if (columnName.equals(NAME_COL)) {
            return 0;
        }
        if (columnName.equals(START_COL)) {
            return 1;
        }
        if (columnName.equals(END_COL)) {
            return 2;
        }
        if (columnName.equals(LENGTH_COL)) {
            return 3;
        }
        if (columnName.equals(READ_COL)) {
            return 4;
        }
        if (columnName.equals(WRITE_COL)) {
            return 5;
        }
        if (columnName.equals(EXECUTE_COL)) {
            return 6;
        }
        if (columnName.equals(VOLATILE_COL)) {
            return 7;
        }
        if (columnName.equals(SOURCE_COL)) {
            return 10;
        }
        if (columnName.equals(COMMENT_COL)) {
            return 11;
        }
        if (columnName.equals(BLOCK_TYPE_COL)) {
            return 8;
        }
        return 0;
    }

    public Class<?> getColumnClass(int columnIndex) {
        if (columnIndex == 4 || columnIndex == 5 || columnIndex == 6 || columnIndex == 7 || columnIndex == 9) {
            return Boolean.class;
        }
        return String.class;
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 0: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: {
                return true;
            }
            case 9: {
                MemoryBlock block = this.memList.get(rowIndex);
                MemoryBlockType blockType = block.getType();
                if (blockType == MemoryBlockType.BIT_MAPPED || blockType == MemoryBlockType.BYTE_MAPPED) break;
                return true;
            }
        }
        return false;
    }

    public int getRowCount() {
        return this.memList.size();
    }

    private String getAddressString(Address address) {
        AddressSpace space = address.getAddressSpace();
        if (space.isOverlaySpace()) {
            OverlayAddressSpace ovSpace = (OverlayAddressSpace)space;
            AddressSpace baseSpace = ovSpace.getOverlayedSpace();
            address = baseSpace.getAddress(address.getOffset());
        }
        return address.toString();
    }

    public MemoryBlock getBlockAt(int rowIndex) {
        if (this.memList == null) {
            return null;
        }
        if (rowIndex < 0 || rowIndex >= this.memList.size()) {
            return null;
        }
        MemoryBlock block = this.memList.get(rowIndex);
        try {
            block.getStart();
        }
        catch (ConcurrentModificationException e) {
            this.update();
        }
        return this.memList.get(rowIndex);
    }

    /*
     * Exception decompiling
     */
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 13[SWITCH]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void revertBlockToUnitialized(MemoryBlock block) {
        int result = OptionDialog.showYesNoDialog((Component)this.provider.getComponent(), (String)"Confirm Setting Block To Unitialized", (String)"Are you sure you want to remove the bytes from this block? \n\nThis will result in removing all functions, instructions, data,\nand outgoing references from the block!");
        if (result == 2) {
            return;
        }
        UninitializedBlockCmd cmd = new UninitializedBlockCmd(this.program, block);
        this.provider.getTool().executeBackgroundCommand((BackgroundCommand)cmd, (UndoableDomainObject)this.program);
    }

    private boolean verifyRenameAllowed(MemoryBlock block, String newName) {
        if (block.getType() != MemoryBlockType.OVERLAY || block.getName().equals(newName)) {
            return true;
        }
        if (!this.program.hasExclusiveAccess()) {
            String msg = "Close the file and undo your checkout,\nthen do a checkout with the exclusive lock.";
            DomainFile df = this.program.getDomainFile();
            if (df.modifiedSinceCheckout() || df.isChanged()) {
                msg = "Check in this file, then do a checkout with the\nexclusive lock.";
            }
            Msg.showInfo(((Object)((Object)this)).getClass(), (Component)this.provider.getComponent(), (String)"Exclusive Checkout Required", (Object)("An exclusive checkout is required in order to\nrename an overlay memory block.\n" + msg));
            return false;
        }
        return true;
    }

    private void initializeBlock(MemoryBlock block) {
        NumberInputDialog dialog = new NumberInputDialog("Initialize Memory Block", "Enter fill byte value for block: ", Integer.valueOf(0), 0, 255, true);
        if (!dialog.show()) {
            return;
        }
        byte value = (byte)dialog.getValue();
        int id = this.program.startTransaction("Initialize Memory Block");
        try {
            Memory mem = this.program.getMemory();
            int index = this.memList.indexOf(block);
            MemoryBlock newBlock = mem.convertToInitialized(block, value);
            this.memList.set(index, newBlock);
            this.program.endTransaction(id, true);
        }
        catch (Throwable t) {
            this.program.endTransaction(id, false);
            String msg = t.getMessage();
            msg = msg == null ? t.toString() : msg;
            Msg.showError((Object)((Object)this), (Component)this.provider.getComponent(), (String)"Block Initialization Failed", (Object)msg, (Throwable)t);
        }
    }

    private void showMessage(String msg) {
        SwingUtilities.invokeLater(() -> this.provider.setStatusText(msg));
    }

    public Object getColumnValueForRow(MemoryBlock block, int columnIndex) {
        try {
            switch (columnIndex) {
                case 0: {
                    return block.getName();
                }
                case 1: {
                    return this.getAddressString(block.getStart());
                }
                case 2: {
                    return this.getAddressString(block.getEnd());
                }
                case 3: {
                    long len = block.getEnd().subtract(block.getStart()) + 1L;
                    return "0x" + Long.toHexString(len);
                }
                case 4: {
                    return block.isRead() ? Boolean.TRUE : Boolean.FALSE;
                }
                case 5: {
                    return block.isWrite() ? Boolean.TRUE : Boolean.FALSE;
                }
                case 6: {
                    return block.isExecute() ? Boolean.TRUE : Boolean.FALSE;
                }
                case 7: {
                    return block.isVolatile() ? Boolean.TRUE : Boolean.FALSE;
                }
                case 9: {
                    MemoryBlockType blockType = block.getType();
                    if (blockType == MemoryBlockType.BIT_MAPPED) {
                        return null;
                    }
                    return block.isInitialized() ? Boolean.TRUE : Boolean.FALSE;
                }
                case 10: {
                    if (block.getType() == MemoryBlockType.BIT_MAPPED || block.getType() == MemoryBlockType.BYTE_MAPPED) {
                        return ((MappedMemoryBlock)block).getOverlayedMinAddress().toString();
                    }
                    return block.getSourceName();
                }
                case 11: {
                    return block.getComment();
                }
                case 8: {
                    return block.getType().toString();
                }
            }
            return "UNKNOWN";
        }
        catch (ConcurrentModificationException e) {
            this.update();
            return null;
        }
    }

    public List<MemoryBlock> getModelData() {
        return this.memList;
    }

    protected Comparator<MemoryBlock> createSortComparator(int columnIndex) {
        return new MemoryMapComparator(columnIndex);
    }

    private class MemoryMapComparator
    implements Comparator<MemoryBlock> {
        private final int sortColumn;

        public MemoryMapComparator(int sortColumn) {
            this.sortColumn = sortColumn;
        }

        @Override
        public int compare(MemoryBlock b1, MemoryBlock b2) {
            switch (this.sortColumn) {
                case 0: {
                    return b1.getName().compareToIgnoreCase(b2.getName());
                }
                case 1: {
                    return b1.getStart().compareTo((Object)b2.getStart());
                }
                case 2: {
                    return b1.getEnd().compareTo((Object)b2.getEnd());
                }
                case 3: {
                    return (int)(b1.getSize() - b2.getSize());
                }
                case 4: {
                    int b1r = b1.isRead() ? 1 : -1;
                    int b2r = b2.isRead() ? 1 : -1;
                    return b1r - b2r;
                }
                case 5: {
                    int b1w = b1.isWrite() ? 1 : -1;
                    int b2w = b2.isWrite() ? 1 : -1;
                    return b1w - b2w;
                }
                case 6: {
                    int b1x = b1.isExecute() ? 1 : -1;
                    int b2x = b2.isExecute() ? 1 : -1;
                    return b1x - b2x;
                }
                case 7: {
                    int b1v = b1.isVolatile() ? 1 : -1;
                    int b2v = b2.isVolatile() ? 1 : -1;
                    return b1v - b2v;
                }
                case 9: {
                    int b1init = b1.isInitialized() ? 1 : -1;
                    int b2init = b2.isInitialized() ? 1 : -1;
                    return b1init - b2init;
                }
                case 10: {
                    String b1src = b1.getSourceName();
                    String b2src = b2.getSourceName();
                    if (b1src == null) {
                        b1src = "";
                    }
                    if (b2src == null) {
                        b2src = "";
                    }
                    return b1src.compareToIgnoreCase(b2src);
                }
                case 11: {
                    String comment1 = b1.getComment();
                    String comment2 = b2.getComment();
                    if (comment1 == null) {
                        comment1 = "";
                    }
                    if (comment2 == null) {
                        comment2 = "";
                    }
                    return comment1.compareToIgnoreCase(comment2);
                }
                case 8: {
                    String bt1 = b1.getType().toString();
                    String bt2 = b2.getType().toString();
                    return bt1.compareToIgnoreCase(bt2);
                }
            }
            return 0;
        }
    }
}

